/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.solarisprovider.logsvc.LogFilter;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogService;
import com.sun.wbem.solarisprovider.logsvc.ServiceProps;
import java.util.Vector;

public class LogServiceWrapper {
    private String log_file = "wbem_log";
    private String log_dir = "/var/sadm/wbem/log";
    private String file_size = "5";
    private String file_num = "5";
    private String syslog_switch = "on";
    public static LogServiceWrapper theOnlyWrapper = null;
    public static boolean stop_service = false;
    public LogService logsvc = null;
    public ServiceProps props = new ServiceProps("propdir", "WbemServices.properties", 1);
    public CIMOMHandle cimomhandle = null;

    public LogServiceWrapper(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.log_dir = this.props.getServiceProp("wbem.logging.file.dir");
        this.file_size = this.props.getServiceProp("wbem.logging.file.size");
        if (this.file_size == null) {
            this.file_size = String.valueOf(5);
        }
        this.file_num = this.props.getServiceProp("wbem.logging.file.num");
        if (this.file_num == null) {
            this.file_num = String.valueOf(5);
        }
        this.syslog_switch = this.props.getServiceProp("wbem.logging.syslog");
        if (this.syslog_switch == null) {
            this.syslog_switch = "on";
        }
        try {
            this.logsvc = new LogService(this.log_file, this.log_dir, this.file_size, this.file_num, this.syslog_switch);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }

    public synchronized Integer clearLog(String string) throws CIMException {
        try {
            this.logsvc.clearLog(string);
            return new Integer(0);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }

    public synchronized Integer getCurrentLogFileName(Vector vector) throws CIMException {
        String string = this.logsvc.getCurrentLogFileName();
        if (string != null) {
            vector.addElement(new CIMValue((Object)string));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    public synchronized String getCurrentLogfname() throws CIMException {
        return this.logsvc.getCurrentLogFileName();
    }

    public static LogServiceWrapper getInstance(CIMOMHandle cIMOMHandle) throws CIMException {
        if (theOnlyWrapper == null) {
            theOnlyWrapper = new LogServiceWrapper(cIMOMHandle);
        }
        if (!stop_service) {
            return theOnlyWrapper;
        }
        return null;
    }

    public synchronized String getLogFileDir() throws CIMException {
        return this.logsvc.getLogFileDir();
    }

    public synchronized Integer getLogFileDir(Vector vector) throws CIMException {
        String string = this.logsvc.getLogFileDir();
        if (string != null) {
            vector.addElement(new CIMValue((Object)string));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    public synchronized String getLogFileSize() throws CIMException {
        return String.valueOf(this.logsvc.getLogFileSize());
    }

    public synchronized Long getLogFileSize(Vector vector) throws CIMException {
        Long l = new Long(this.logsvc.getLogFileSize());
        vector.addElement(new CIMValue((Object)l));
        return l;
    }

    public synchronized String getLogStorageName() throws CIMException {
        return this.logsvc.getLogStorageName();
    }

    public synchronized Integer getLogStorageName(Vector vector) throws CIMException {
        String string = this.logsvc.getLogStorageName();
        if (string != null) {
            vector.addElement(new CIMValue((Object)string));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    public synchronized String getNumLogFiles() throws CIMException {
        return String.valueOf(this.logsvc.getNumLogFiles());
    }

    public synchronized Integer getNumLogFiles(Vector vector) throws CIMException {
        Integer n = new Integer(this.logsvc.getNumLogFiles());
        vector.addElement(new CIMValue((Object)n));
        return n;
    }

    public synchronized Long getNumRecords(String string, Vector vector) throws CIMException {
        try {
            long l = 0L;
            l = this.logsvc.getNumRecords(string);
            Long l2 = new Long(l);
            vector.addElement(new CIMValue((Object)l2));
            return l2;
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }

    public synchronized String getSyslogSwitch() throws CIMException {
        return this.logsvc.getSyslogSwitch();
    }

    public synchronized Integer getSyslogSwitch(Vector vector) throws CIMException {
        String string = this.logsvc.getSyslogSwitch();
        if (string != null) {
            vector.addElement(new CIMValue((Object)string));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    public synchronized boolean isStarted() {
        return stop_service ^ true;
    }

    public synchronized Integer listLogFiles(Vector vector) throws CIMException {
        try {
            String[] stringArray = null;
            stringArray = this.logsvc.listLogFiles();
            Vector<String> vector2 = new Vector<String>();
            if (stringArray == null) {
                return new Integer(-1);
            }
            int n = 0;
            while (n < stringArray.length) {
                vector2.addElement(stringArray[n]);
                ++n;
            }
            vector.addElement(new CIMValue(vector2));
            return new Integer(0);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }

    public synchronized Vector listRecords() throws CIMException {
        LogFilter logFilter = new LogFilter();
        long l = 0L;
        long l2 = 0L;
        String string = "";
        try {
            String[] stringArray = this.logsvc.listLogFiles();
            int n = 0;
            while (n < stringArray.length) {
                l += this.logsvc.getNumRecords(stringArray[n]);
                ++n;
            }
            Vector<Vector> vector = new Vector<Vector>();
            int n2 = 0;
            while (n2 < stringArray.length) {
                Vector vector2 = this.logsvc.getList(l, logFilter, l2, stringArray[n2]);
                if (vector2 != null) {
                    vector2.addElement(stringArray[n2]);
                    vector.addElement(vector2);
                }
                ++n2;
            }
            return vector;
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }

    public synchronized Vector listRecords(String string) throws CIMException {
        LogFilter logFilter = new LogFilter();
        long l = 0L;
        long l2 = 0L;
        l += this.logsvc.getNumRecords(string);
        try {
            Vector vector = new Vector();
            vector = this.logsvc.getList(l, logFilter, l2, string);
            if (vector != null) {
                return vector;
            }
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
        return null;
    }

    public synchronized LogRecord readRecord(long l, int n, String string) throws CIMException {
        String string2 = "";
        try {
            return this.logsvc.readRecord(l, n, string);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }

    public synchronized Integer setProperties(CIMInstance cIMInstance) throws CIMException {
        this.log_dir = (String)cIMInstance.getProperty("Directory").getValue().getValue();
        this.file_size = (String)cIMInstance.getProperty("FileSize").getValue().getValue();
        this.file_num = (String)cIMInstance.getProperty("NumFiles").getValue().getValue();
        this.syslog_switch = (String)cIMInstance.getProperty("SyslogSwitch").getValue().getValue();
        try {
            this.logsvc.setProperties(Integer.parseInt(this.file_size), Integer.parseInt(this.file_num), this.syslog_switch, this.log_dir);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
        try {
            this.props.putServiceProp("wbem.logging.file.size", this.file_size);
            this.props.putServiceProp("wbem.logging.file.num", this.file_num);
            this.props.putServiceProp("wbem.logging.file.dir", this.log_dir);
            this.props.putServiceProp("wbem.logging.syslog", this.syslog_switch);
            this.props.saveServiceProps("Wbem Services properties file");
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
        return new Integer(0);
    }

    public static synchronized void startService(CIMOMHandle cIMOMHandle) throws CIMException {
        stop_service = false;
        if (theOnlyWrapper == null) {
            theOnlyWrapper = new LogServiceWrapper(cIMOMHandle);
        }
    }

    public static synchronized void stopService() {
        stop_service = true;
    }

    public synchronized void writeRecord(LogRecord logRecord, boolean bl) throws CIMException {
        try {
            this.logsvc.writeRecord(logRecord, bl);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }
}

