/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.Buffer;
import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import com.sun.wbem.solarisprovider.logsvc.DataRecord;
import com.sun.wbem.solarisprovider.logsvc.DataStore;
import com.sun.wbem.solarisprovider.logsvc.InvalidRecordException;
import com.sun.wbem.solarisprovider.logsvc.LogFileNotFoundException;
import com.sun.wbem.solarisprovider.logsvc.LogFilter;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogRecordNotFoundException;
import com.sun.wbem.solarisprovider.logsvc.LogSvcNative;
import com.sun.wbem.solarisprovider.logsvc.ReadThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LogService {
    private Hashtable logFilesHash = new Hashtable();
    private DataStore storage;
    private long fileSize = 0L;
    private int numOfLogFiles = 0;
    private String dirName = "";
    private String fileName = "";
    private String logFileName = "";
    private long currentFileSize = 0L;
    private String currentViewerFileName = "";
    private boolean serverSyslogSwitch = true;
    public static final String LOGSVC_APPNAME = "Log Viewer";

    public LogService(String string, String string2, String string3, String string4, String string5) throws AdminLogException, CIMException {
        File file;
        this.dirName = string2;
        if (this.dirName == null) {
            this.dirName = "/var/sadm/wbem/log";
        }
        this.fileName = string;
        if (this.fileName == null) {
            this.fileName = "wbem_log";
        }
        if (!(file = new File(this.dirName)).exists() && !file.mkdirs()) {
            throw new AdminLogException("EXLOG_DIR", this.dirName);
        }
        this.logFileName = String.valueOf(this.dirName) + File.separator + this.fileName;
        String string6 = string3;
        this.fileSize = string6 == null ? 5L : Long.parseLong(string6);
        this.fileSize = this.fileSize * 1024L * 1024L;
        string6 = null;
        string6 = string4;
        this.numOfLogFiles = string6 == null ? 5 : Integer.parseInt(string6);
        this.initHash();
        String string7 = string5;
        if (string7 == null) {
            string7 = "on";
        }
        this.serverSyslogSwitch = string7.equalsIgnoreCase("on");
    }

    public void clearLog(String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        this.synchronizedClearLog(string);
    }

    private synchronized void do_cascaded_backup() throws AdminLogException {
        File file;
        File file2;
        int n = 0;
        boolean bl = false;
        Enumeration enumeration = this.logFilesHash.elements();
        while (enumeration.hasMoreElements()) {
            DataStore dataStore;
            Vector vector = (Vector)enumeration.nextElement();
            if (vector == null || (dataStore = (DataStore)vector.elementAt(1)) == null) continue;
            dataStore.close();
        }
        n = this.numOfLogFiles;
        while (n > 1) {
            file2 = new File(String.valueOf(this.logFileName) + "." + String.valueOf(n));
            file = new File(String.valueOf(this.logFileName) + "." + String.valueOf(n - 1));
            try {
                if (file.exists()) {
                    file.renameTo(file2);
                }
            }
            catch (SecurityException securityException) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            --n;
        }
        file2 = new File(this.logFileName);
        file = new File(String.valueOf(this.logFileName) + ".1");
        try {
            if (file2.exists()) {
                file2.renameTo(file);
            }
        }
        catch (SecurityException securityException) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        this.initHash();
    }

    private boolean do_copy(File file, File file2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        byte[] byArray = new byte[8192];
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 8192);
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        }
        catch (Exception exception) {
            return false;
        }
        try {
            int n;
            while ((n = bufferedInputStream.read(byArray, 0, 8192)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void flush_dir(String string, int n) {
        File file = null;
        int n2 = 0;
        int n3 = this.numOfLogFiles;
        if (n == -1) {
            file = new File(string);
        } else if (n == 0) {
            file = new File(String.valueOf(string) + "." + String.valueOf(1));
        } else {
            file = new File(String.valueOf(string) + "." + String.valueOf(1));
            n3 = n - 1;
        }
        while (n2 <= n3) {
            try {
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {}
            file = new File(String.valueOf(string) + "." + String.valueOf(++n2));
        }
    }

    public String getCurrentLogFileName() {
        return this.synchronizedGetCurrentLogFileName();
    }

    public Vector getList(long l, LogFilter logFilter, long l2, String string) throws LogFileNotFoundException, AdminLogException {
        return this.synchronizedGetList(l, logFilter, l2, string);
    }

    public String getLogFileDir() {
        return this.synchronizedGetLogFileDir();
    }

    public int getLogFileSize() {
        return this.synchronizedGetLogFileSize();
    }

    public String getLogStorageName() {
        return this.synchronizedGetLogStorageName();
    }

    public int getNumLogFiles() {
        return this.synchronizedGetNumLogFiles();
    }

    public long getNumRecords(String string) throws AdminLogException {
        return this.synchronizedGetNumRecords(string);
    }

    public String getSyslogSwitch() {
        return this.synchronizedGetSyslogSwitch();
    }

    private void initHash() throws AdminLogException {
        Comparable<File> comparable;
        Vector<Object> vector = new Vector<Object>();
        this.logFilesHash.clear();
        try {
            this.storage = new DataStore(this.logFileName);
        }
        catch (EOFException eOFException) {
            comparable = new File(this.logFileName);
            try {
                if (comparable.exists()) {
                    comparable.renameTo(new File(String.valueOf(this.logFileName) + ".corrupted"));
                }
                this.storage = new DataStore(this.logFileName);
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", this.logFileName);
        }
        long l = this.storage.getFileDate();
        if (l <= 0L) {
            throw new AdminLogException("EXLOG_COR", this.logFileName);
        }
        comparable = new Date(l);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(1);
        simpleDateFormat.applyPattern("MM/dd/yyyy.HH:mm:ss");
        String string = simpleDateFormat.format((Date)comparable);
        if (string == null) {
            string = String.valueOf(l);
        }
        vector.addElement(this.logFileName);
        vector.addElement(this.storage);
        this.currentViewerFileName = "Log." + string;
        this.logFilesHash.put(this.currentViewerFileName, vector.clone());
        vector.removeAllElements();
        int n = 0;
        DataStore dataStore = null;
        n = 1;
        while (n <= this.numOfLogFiles) {
            block21: {
                block20: {
                    File file = new File(String.valueOf(this.logFileName) + "." + String.valueOf(n));
                    try {
                        if (file.exists()) {
                            try {
                                dataStore = new DataStore(String.valueOf(this.logFileName) + "." + String.valueOf(n));
                            }
                            catch (EOFException eOFException) {
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Exception exception) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                    if (dataStore == null) break block20;
                    l = dataStore.getFileDate();
                    if (l <= 0L) break block21;
                    comparable = new Date(l);
                    simpleDateFormat.applyPattern("MM/dd/yyyy.HH:mm:ss");
                    string = simpleDateFormat.format((Date)comparable);
                    if (string == null) {
                        string = String.valueOf(l);
                    }
                    vector.addElement(String.valueOf(this.logFileName) + "." + String.valueOf(n));
                    vector.addElement(dataStore);
                    this.logFilesHash.put("Log." + string, vector.clone());
                }
                dataStore = null;
                vector.removeAllElements();
            }
            ++n;
        }
    }

    public String[] listLogFiles() throws AdminLogException {
        return this.synchronizedListLogFiles();
    }

    public LogRecord readRecord(long l, int n, String string) throws AdminLogException {
        return this.synchronizedReadRecord(l, n, string);
    }

    public void setProperties(int n, int n2, String string, String string2) throws AdminLogException {
        this.synchronizedSetProperties(n, n2, string, string2);
    }

    private synchronized void synchronizedClearLog(String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if (!this.logFilesHash.containsKey(string)) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        Vector vector = (Vector)this.logFilesHash.get(string);
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new AdminLogException("EXLOG_ACT", (Object)string2, string);
        }
        if (string2.compareTo(this.logFileName) == 0) {
            this.do_cascaded_backup();
        } else {
            try {
                File file = new File(string2);
                if (file.exists()) {
                    vector = (Vector)this.logFilesHash.get(string);
                    if (vector == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore != null) {
                        dataStore.close();
                    }
                    this.logFilesHash.remove(string);
                    file.delete();
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    private String synchronizedGetCurrentLogFileName() {
        return this.currentViewerFileName;
    }

    private synchronized Vector synchronizedGetList(long l, LogFilter logFilter, long l2, String string) throws LogFileNotFoundException, AdminLogException {
        Vector vector;
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        Buffer buffer = new Buffer();
        ReadThread readThread = new ReadThread(buffer, l2, l, logFilter.getDirection(), dataStore);
        Thread thread = new Thread(readThread);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {}
        AdminLogException adminLogException = buffer.getException();
        if (adminLogException != null) {
            throw adminLogException;
        }
        return buffer.getVect();
    }

    private String synchronizedGetLogFileDir() {
        return this.dirName;
    }

    private int synchronizedGetLogFileSize() {
        return (int)(this.fileSize / 0x100000L);
    }

    private String synchronizedGetLogStorageName() {
        return this.fileName;
    }

    private int synchronizedGetNumLogFiles() {
        return this.numOfLogFiles;
    }

    private synchronized long synchronizedGetNumRecords(String string) throws AdminLogException {
        Vector vector;
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        return dataStore.getNumRecords();
    }

    private String synchronizedGetSyslogSwitch() {
        if (this.serverSyslogSwitch) {
            return "on";
        }
        return "off";
    }

    private synchronized String[] synchronizedListLogFiles() {
        String[] stringArray = new String[this.logFilesHash.size()];
        Enumeration enumeration = this.logFilesHash.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    private synchronized LogRecord synchronizedReadRecord(long l, int n, String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        DataRecord dataRecord = null;
        Vector vector = (Vector)this.logFilesHash.get(string);
        if (vector == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        try {
            dataRecord = dataStore.readSpecificRecordAsStr(l, n);
        }
        catch (InvalidRecordException invalidRecordException) {
            throw new LogRecordNotFoundException(((Throwable)((Object)invalidRecordException)).getMessage());
        }
        catch (EOFException eOFException) {
            throw new CorruptDataException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", string);
        }
        if (dataRecord == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        LogRecord logRecord = (LogRecord)dataRecord.getRecord();
        logRecord.setRecordId(dataRecord.getOffset());
        logRecord.setHashCode(dataRecord.getHash());
        return logRecord;
    }

    /*
     * Unable to fully structure code
     */
    private void synchronizedSetProperties(int var1_1, int var2_2, String var3_3, String var4_4) throws AdminLogException {
        var5_5 = false;
        if (var3_3 == null) {
            var3_3 = "on";
        } else if (var3_3.equalsIgnoreCase("on")) {
            this.serverSyslogSwitch = true;
        } else if (var3_3.equalsIgnoreCase("off")) {
            this.serverSyslogSwitch = false;
        } else {
            var3_3 = "on";
        }
        if (var4_4 != null) {
            var6_6 = new File(var4_4);
            if (!var6_6.exists() && !var6_6.mkdirs()) {
                var5_5 = true;
            }
            if (var6_6.isDirectory()) {
                var9_7 = this.logFilesHash.elements();
                while (var9_7.hasMoreElements()) {
                    var7_8 = (Vector)var9_7.nextElement();
                    if (var7_8 == null || (var8_9 = (DataStore)var7_8.elementAt(1)) == null) continue;
                    var8_9.close();
                }
                var10_10 = 1;
                while (var10_10 <= this.numOfLogFiles) {
                    var11_11 = String.valueOf(var4_4) + File.separator + this.fileName;
                    var12_12 = this.logFileName;
                    var13_13 = new File(String.valueOf(var11_11) + "." + String.valueOf(var10_10));
                    var14_14 = new File(String.valueOf(var12_12) + "." + String.valueOf(var10_10));
                    try {
                        if (var14_14.exists() && !var14_14.renameTo(var13_13) && !this.do_copy(var14_14, var13_13)) {
                            this.flush_dir((String)var11_11, var10_10);
                            var5_5 = true;
                        }
                    }
                    catch (SecurityException v0) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                    ++var10_10;
                }
                if (!var5_5) {
                    var11_11 = new File(this.logFileName);
                    var12_12 = String.valueOf(var4_4) + File.separator + this.fileName;
                    var13_13 = new File(var12_12);
                    try {
                        if (!var11_11.exists()) ** GOTO lbl60
                        if (!var11_11.renameTo(var13_13)) {
                            if (!this.do_copy((File)var11_11, var13_13)) {
                                this.flush_dir(var12_12, 0);
                                var5_5 = true;
                            }
                            this.flush_dir(this.logFileName, -1);
                            this.logFileName = String.valueOf(var4_4) + File.separator + this.fileName;
                            this.dirName = var4_4;
                        }
                        this.logFileName = String.valueOf(var4_4) + File.separator + this.fileName;
                        this.dirName = var4_4;
                    }
                    catch (SecurityException v1) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                }
            } else {
                var5_5 = true;
            }
        }
lbl60:
        // 8 sources

        if (var1_1 > 0) {
            this.fileSize = var1_1 * 1024 * 1024;
        }
        if (var2_2 > 0) {
            this.numOfLogFiles = var2_2;
        }
        if (var4_4 != null) {
            this.initHash();
        }
        if (var5_5) {
            throw new AdminLogException("EXLOG_PROP_DIR", (Object)this.dirName, var4_4);
        }
    }

    public synchronized void writeRecord(LogRecord logRecord, boolean bl) throws AdminLogException {
        block16: {
            int n;
            try {
                this.currentFileSize = this.storage.writeRecord(logRecord.formatRecord(), this.fileSize);
            }
            catch (InvalidRecordException invalidRecordException) {
            }
            catch (IOException iOException) {
                throw new AdminLogException("EXLOG_IO", this.logFileName);
            }
            if (this.currentFileSize < 0L) {
                try {
                    this.synchronizedClearLog(this.currentViewerFileName);
                }
                catch (AdminLogException adminLogException) {
                    throw new AdminLogException("EXLOG_WR", this.logFileName);
                }
                try {
                    this.currentFileSize = this.storage.writeRecord(logRecord.formatRecord(), this.fileSize);
                }
                catch (InvalidRecordException invalidRecordException) {
                    throw new AdminLogException("EXLOG_IO", this.logFileName);
                }
                catch (IOException iOException) {
                    throw new AdminLogException("EXLOG_IO", this.logFileName);
                }
            }
            if (this.currentFileSize == this.fileSize) {
                try {
                    this.synchronizedClearLog(this.currentViewerFileName);
                }
                catch (AdminLogException adminLogException) {
                    throw new AdminLogException("EXLOG_WR", this.logFileName);
                }
            }
            if (!bl || !this.serverSyslogSwitch) break block16;
            String string = logRecord.getDetailedMesg(true);
            if (string == null) {
                string = logRecord.getSummaryMesg(true);
            }
            if ((n = logRecord.getSeverity()) == -1) {
                n = 0;
            }
            try {
                LogSvcNative.writeToSyslog(string, "Wbem Logging Service", n);
            }
            catch (AdminLogException adminLogException) {}
        }
    }
}

