/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

class LogRecordHeader
implements Serializable {
    private static final String MARKER = "@#@";
    private int category = -1;
    private int severity = -1;
    private Date date = null;
    private String appName = "";
    private String eventId = "";
    private String userName = "";
    private String clientHostName = "";
    private String agentHostName = "";
    private String summaryMesgId = "";
    private long recordId = -1L;
    private int hashCode = -1;

    public LogRecordHeader() {
        this.date = new Date();
    }

    public LogRecordHeader(String string) throws CorruptDataException {
        String string2 = "";
        Object var3_3 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n = string.indexOf(MARKER, n2);
        this.appName = string.substring(n2, n);
        n2 = n + MARKER.length();
        n = string.indexOf(MARKER, n2);
        try {
            this.category = Integer.parseInt(string.substring(n2, n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n2 = n + MARKER.length();
        n = string.indexOf(MARKER, n2);
        try {
            this.severity = Integer.parseInt(string.substring(n2, n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n2 = n + MARKER.length();
        n = string.indexOf(MARKER, n2);
        this.userName = string.substring(n2, n);
        if (this.userName == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n2 = n + MARKER.length();
        n = string.indexOf(MARKER, n2);
        this.clientHostName = string.substring(n2, n);
        if (this.clientHostName == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n2 = n + MARKER.length();
        n = string.indexOf(MARKER, n2);
        this.agentHostName = string.substring(n2, n);
        if (this.agentHostName == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n2 = n + MARKER.length();
        n = string.indexOf(MARKER, n2);
        String string3 = string.substring(n2, n);
        n2 = n + MARKER.length();
        if (string3 == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        long l = Long.parseLong(string3);
        this.date = new Date(l);
        n = string.indexOf(MARKER, n2);
        this.summaryMesgId = string.substring(n2, n);
        if (this.summaryMesgId == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n2 = n + MARKER.length();
        n = string.indexOf(MARKER, n2);
        this.eventId = string.substring(n2, n);
        if (this.eventId == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n2 = n + MARKER.length();
        n = string.indexOf(MARKER, n2);
        try {
            this.recordId = Long.parseLong(string.substring(n2, n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n2 = n + MARKER.length();
        n = string.indexOf(MARKER, n2);
        try {
            this.hashCode = Integer.parseInt(string.substring(n2, n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n2 = n + MARKER.length();
    }

    public LogRecordHeader(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6) {
        this.category = n;
        this.severity = n2;
        this.date = new Date();
        if (string != null) {
            this.appName = string;
        }
        if (string3 != null) {
            this.eventId = string3;
        }
        if (string2 != null) {
            this.userName = string2;
        }
        if (string4 != null) {
            this.clientHostName = string4;
        }
        if (string5 != null) {
            this.agentHostName = string5;
        }
        if (string6 != null) {
            this.summaryMesgId = string6;
        }
    }

    public String formatHeader() {
        boolean bl = false;
        boolean bl2 = false;
        Date date = this.getDate();
        long l = date.getTime();
        String string = String.valueOf(this.getAppKey()) + MARKER + String.valueOf(this.getCategory()) + MARKER + String.valueOf(this.getSeverity()) + MARKER + this.getUserName() + MARKER + this.getClientHostName() + MARKER + this.getAgentHostName() + MARKER + String.valueOf(l) + MARKER + this.getSummaryMesgId() + MARKER + this.getEventId() + MARKER + String.valueOf(this.recordId) + MARKER + String.valueOf(this.hashCode) + MARKER;
        return string;
    }

    public String getAgentHostName() {
        return this.agentHostName;
    }

    public String getAppKey() {
        return this.appName;
    }

    public String getAppName() {
        return LogRecordHeader.getPattern(this.appName, null);
    }

    protected static String getBundleName() {
        return "com.sun.wbem.logsvc.Messages";
    }

    public int getCategory() {
        return this.category;
    }

    public String getCategoryString() {
        String string = "N/A";
        switch (this.category) {
            case -1: {
                string = LogRecordHeader.getPattern("LM_CAT_INV", null);
                break;
            }
            case 0: {
                string = LogRecordHeader.getPattern("LM_CAT_APP", null);
                break;
            }
            case 1: {
                string = LogRecordHeader.getPattern("LM_CAT_SEC", null);
                break;
            }
            case 2: {
                string = LogRecordHeader.getPattern("LM_CAT_SYS", null);
            }
        }
        return string;
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDateString() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(1);
        simpleDateFormat.applyPattern("MM/dd/yyyy");
        return simpleDateFormat.format(this.date);
    }

    public String getEventId() {
        return this.eventId;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    private static String getPattern(String string, Locale locale) {
        PropertyResourceBundle propertyResourceBundle = null;
        String string2 = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string3 = LogRecordHeader.getBundleName();
        try {
            propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(string3, locale);
            string2 = propertyResourceBundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    public long getRecordId() {
        return this.recordId;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSeverityString() {
        String string = "N/A";
        switch (this.severity) {
            case -1: {
                string = LogRecordHeader.getPattern("LM_SEV_INV", null);
                break;
            }
            case 0: {
                string = LogRecordHeader.getPattern("LM_SEV_INF", null);
                break;
            }
            case 1: {
                string = LogRecordHeader.getPattern("LM_SEV_WAR", null);
                break;
            }
            case 2: {
                string = LogRecordHeader.getPattern("LM_SEV_ERR", null);
            }
        }
        return string;
    }

    public static String getSeverityString(int n) {
        String string = "N/A";
        switch (n) {
            case -1: {
                string = LogRecordHeader.getPattern("LM_SEV_INV", null);
                break;
            }
            case 0: {
                string = LogRecordHeader.getPattern("LM_SEV_INF", null);
                break;
            }
            case 1: {
                string = LogRecordHeader.getPattern("LM_SEV_WAR", null);
                break;
            }
            case 2: {
                string = LogRecordHeader.getPattern("LM_SEV_ERR", null);
            }
        }
        return string;
    }

    public String getSummaryMesg(boolean bl) {
        String string = "";
        Locale locale = bl ? Locale.getDefault() : new Locale("", "");
        string = LogRecordHeader.getPattern(this.summaryMesgId, locale);
        if (string != null) {
            return string;
        }
        return "";
    }

    protected String getSummaryMesgId() {
        return this.summaryMesgId;
    }

    public String getTimeString() {
        return DateFormat.getTimeInstance().format(this.date);
    }

    public String getUserName() {
        return this.userName;
    }

    protected void setAgentHostName(String string) {
        if (string != null) {
            this.agentHostName = string;
        }
    }

    protected void setAppName(String string) {
        if (string != null) {
            this.appName = string;
        }
    }

    protected void setBasicInfo(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6) {
        this.category = n;
        this.severity = n2;
        this.date = new Date();
        if (string != null) {
            this.appName = string;
        }
        if (string2 != null) {
            this.eventId = string2;
        }
        if (string3 != null) {
            this.userName = string3;
        }
        if (string4 != null) {
            this.clientHostName = string4;
        }
        if (string5 != null) {
            this.agentHostName = string5;
        }
        if (string6 != null) {
            this.summaryMesgId = string6;
        }
    }

    protected void setCategory(int n) {
        this.category = n;
    }

    protected void setClientHostName(String string) {
        if (string != null) {
            this.clientHostName = string;
        }
    }

    protected void setDate(Date date) {
        if (date != null) {
            this.date = date;
        }
    }

    protected void setEventId(String string) {
        if (string != null) {
            this.eventId = string;
        }
    }

    public void setHashCode(int n) {
        this.hashCode = n;
    }

    public void setRecordId(long l) {
        this.recordId = l;
    }

    protected void setSeverity(int n) {
        this.severity = n;
    }

    protected void setSummaryMesgId(String string) {
        if (string != null) {
            this.summaryMesgId = string;
        }
    }

    protected void setUserName(String string) {
        if (string != null) {
            this.userName = string;
        }
    }

    public String toString() {
        String string = "    Category: " + this.getCategoryString() + "\n";
        string = String.valueOf(string) + "    Severity: " + this.getSeverityString() + "\n";
        string = String.valueOf(string) + "    EventId:  " + this.eventId + "\n";
        string = String.valueOf(string) + "    User:     " + this.userName + "\n";
        string = String.valueOf(string) + "    AppName:  " + LogRecordHeader.getPattern(this.appName, null) + "\n";
        string = String.valueOf(string) + "    Date:     " + this.getDateString() + "\n";
        string = String.valueOf(string) + "    Time:     " + this.getTimeString() + "\n";
        string = String.valueOf(string) + "    Client:   " + this.clientHostName + "\n";
        string = String.valueOf(string) + "    Agent:    " + this.agentHostName + "\n";
        string = String.valueOf(string) + "    Message:  " + this.getSummaryMesg(true) + "\n";
        return string;
    }
}

