/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import com.sun.wbem.solarisprovider.logsvc.LabelValuePairs;
import com.sun.wbem.solarisprovider.logsvc.LogRecordHeader;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogRecord
implements Serializable {
    public static final int CATEGORY_INVALID = -1;
    public static final int APPLICATION_LOG = 0;
    public static final int SECURITY_LOG = 1;
    public static final int SYSTEM_LOG = 2;
    public static final int SEVERITY_INVALID = -1;
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final String HOST_APP_NAME = "LM_HOST_APP_NAME";
    public static final String USER_APP_NAME = "LM_USER_APP_NAME";
    public static final String FSMGR_APP_NAME = "LM_FSMGR_APP_NAME";
    public static final String CIS_APP_NAME = "LM_SYS_APP_NAME";
    public static final String SECURITY_APP_NAME = "LM_SECURITY_APP_NAME";
    public static final String DIRTABLE_APP_NAME = "LM_DIRTABLE_APP_NAME";
    public static final String SERIAL_APP_NAME = "LM_SERIAL_APP_NAME";
    public static final String LOGSVC_APP_NAME = "LM_LOGSVC_APP_NAME";
    public static final String EXM_STR = "EXM_STR";
    private static final String MARKER = "@#@";
    private static final int LABEL_SIZE = 25;
    private LogRecordHeader logHeader;
    private String detailedMesgId = "LM_DETAIL";
    private Vector substArgs;
    private LabelValuePairs data;
    private String logdata = "";
    private boolean was_syslogged = false;
    private String version_str = "";
    private String fileName = "";

    public LogRecord() {
        this.logHeader = new LogRecordHeader();
        this.data = new LabelValuePairs();
        this.substArgs = new Vector();
    }

    public LogRecord(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6, Vector vector) {
        String string7 = "";
        if (string6 != null) {
            this.detailedMesgId = string6;
            string7 = this.parseEventId(string6);
        } else if (string5 != null) {
            string7 = this.parseEventId(string5);
        }
        this.logHeader = new LogRecordHeader(string, n, n2, string2, string7, string3, string4, string5);
        this.substArgs = vector != null ? vector : new Vector();
        this.data = new LabelValuePairs();
    }

    public LogRecord(String string, String string2) throws CorruptDataException {
        this.version_str = string2;
        this.data = new LabelValuePairs();
        this.substArgs = new Vector();
        String string3 = "";
        String string4 = "";
        int n = -1;
        int n2 = -1;
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        Date date = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (string == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n3 = string.indexOf(MARKER, n4);
        string4 = string.substring(n4, n3);
        n4 = n3 + MARKER.length();
        n3 = string.indexOf(MARKER, n4);
        try {
            n = Integer.parseInt(string.substring(n4, n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n4 = n3 + MARKER.length();
        n3 = string.indexOf(MARKER, n4);
        try {
            n2 = Integer.parseInt(string.substring(n4, n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n4 = n3 + MARKER.length();
        n3 = string.indexOf(MARKER, n4);
        string5 = string.substring(n4, n3);
        if (string5 == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n4 = n3 + MARKER.length();
        string6 = string.substring(n4, n3 = string.indexOf(MARKER, n4));
        if (string6 == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n4 = n3 + MARKER.length();
        string7 = string.substring(n4, n3 = string.indexOf(MARKER, n4));
        if (string7 == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n4 = n3 + MARKER.length();
        n3 = string.indexOf(MARKER, n4);
        String string10 = string.substring(n4, n3);
        n4 = n3 + MARKER.length();
        if (string10 == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        long l = Long.parseLong(string10);
        date = new Date(l);
        n3 = string.indexOf(MARKER, n4);
        string8 = string.substring(n4, n3);
        if (string8 == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n4 = n3 + MARKER.length();
        n3 = string.indexOf(MARKER, n4);
        this.detailedMesgId = string.substring(n4, n3);
        if (this.detailedMesgId == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n4 = n3 + MARKER.length();
        n3 = string.indexOf(MARKER, n4);
        this.logdata = string.substring(n4, n3);
        if (this.logdata == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n4 = n3 + MARKER.length();
        n3 = string.indexOf(MARKER, n4);
        try {
            n6 = Integer.parseInt(string.substring(n4, n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n4 = n3 + MARKER.length();
        n5 = 0;
        while (n5 < n6) {
            n3 = string.indexOf(MARKER, n4);
            string9 = string.substring(n4, n3);
            if (string9 == null) {
                string9 = "  ";
            }
            n4 = n3 + MARKER.length();
            this.addSubstArg(string9);
            ++n5;
        }
        n3 = string.indexOf(MARKER, n4);
        try {
            n6 = Integer.parseInt(string.substring(n4, n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        n4 = n3 + MARKER.length();
        n5 = 0;
        while (n5 < n6) {
            n3 = string.indexOf(MARKER, n4);
            string9 = string.substring(n4, n3);
            if (string9 == null) {
                string9 = "  ";
            }
            n4 = n3 + MARKER.length();
            this.data.addLabel(string9);
            n3 = string.indexOf(MARKER, n4);
            string9 = string.substring(n4, n3);
            if (string9 == null) {
                string9 = "  ";
            }
            n4 = n3 + MARKER.length();
            this.data.addValue(string9);
            ++n5;
        }
        n3 = string.indexOf(MARKER, n4);
        String string11 = string.substring(n4, n3);
        this.was_syslogged = string11 != null && !string11.equalsIgnoreCase("off");
        n4 = n3 + MARKER.length();
        if (this.detailedMesgId != null && this.detailedMesgId.compareTo("LM_DETAIL") != 0) {
            string3 = this.parseEventId(this.detailedMesgId);
        } else if (string8 != null) {
            string3 = this.parseEventId(string8);
        }
        this.logHeader = new LogRecordHeader(string4, n, n2, string5, string3, string6, string7, string8);
        this.logHeader.setDate(date);
    }

    public void addData(String string) {
        this.logdata = string;
    }

    public void addData(String string, String string2) {
        if (string != null) {
            this.data.addLabel(string);
            this.data.addValue(string2);
        }
    }

    public void addData(Vector vector, Vector vector2) {
        if (vector != null) {
            this.data.addLabel(vector);
            this.data.addValue(vector2);
        }
    }

    public void addExceptionToLog(CIMException cIMException) {
        String string = "";
        Object[] objectArray = cIMException.getParams();
        string = String.valueOf(string) + "DUMMY";
        string = String.valueOf(string) + "&!$";
        string = String.valueOf(string) + cIMException.getID();
        int n = 0;
        while (n < objectArray.length) {
            string = String.valueOf(string) + "&!$";
            string = String.valueOf(string) + objectArray[n].toString();
            ++n;
        }
        if (string != null) {
            this.addData(EXM_STR, string);
        }
    }

    public void addSubstArg(String string) {
        if (string == null) {
            return;
        }
        this.substArgs.addElement(string);
    }

    public void addSubstArg(String string, String string2) {
        if (string == null) {
            return;
        }
        this.substArgs.addElement(string);
        if (string2 == null) {
            return;
        }
        this.substArgs.addElement(string2);
    }

    public void addSubstArg(String string, String string2, String string3) {
        if (string == null) {
            return;
        }
        this.substArgs.addElement(string);
        if (string2 == null) {
            return;
        }
        this.substArgs.addElement(string2);
        if (string3 == null) {
            return;
        }
        this.substArgs.addElement(string3);
    }

    public void addSubstArg(String string, String string2, String string3, String string4) {
        if (string == null) {
            return;
        }
        this.substArgs.addElement(string);
        if (string2 == null) {
            return;
        }
        this.substArgs.addElement(string2);
        if (string3 == null) {
            return;
        }
        this.substArgs.addElement(string3);
        if (string4 == null) {
            return;
        }
        this.substArgs.addElement(string4);
    }

    public void clearData() {
        this.data.clearData();
    }

    public void clearSubstArgs() {
        this.substArgs.removeAllElements();
    }

    public String formatRecord() {
        int n = 0;
        boolean bl = false;
        Date date = this.getDate();
        long l = date.getTime();
        String string = String.valueOf(this.logHeader.getAppKey()) + MARKER + String.valueOf(this.logHeader.getCategory()) + MARKER + String.valueOf(this.logHeader.getSeverity()) + MARKER + this.logHeader.getUserName() + MARKER + this.logHeader.getClientHostName() + MARKER + this.logHeader.getAgentHostName() + MARKER + String.valueOf(l) + MARKER + this.logHeader.getSummaryMesgId() + MARKER + this.detailedMesgId + MARKER + this.logdata + MARKER + String.valueOf(this.substArgs.size()) + MARKER;
        n = 0;
        while (n < this.substArgs.size()) {
            string = String.valueOf(string) + (String)this.substArgs.elementAt(n) + MARKER;
            ++n;
        }
        Vector vector = this.data.getLabels();
        Vector vector2 = this.data.getValues();
        string = String.valueOf(string) + String.valueOf(vector.size()) + MARKER;
        n = 0;
        while (n < vector.size()) {
            string = String.valueOf(string) + (String)vector.elementAt(n) + MARKER + (String)vector2.elementAt(n) + MARKER;
            ++n;
        }
        string = this.was_syslogged ? String.valueOf(string) + "on@#@" : String.valueOf(string) + "off@#@";
        return string;
    }

    public String getAgentHostName() {
        return this.logHeader.getAgentHostName();
    }

    public String getAppKey() {
        return this.logHeader.getAppKey();
    }

    public String getAppName() {
        return this.logHeader.getAppName();
    }

    protected String getBundleName() {
        return "com.sun.wbem.logsvc.Messages";
    }

    public int getCategory() {
        return this.logHeader.getCategory();
    }

    public String getCategoryString() {
        return this.logHeader.getCategoryString();
    }

    public String getClientHostName() {
        return this.logHeader.getClientHostName();
    }

    public String getData() {
        return this.logdata;
    }

    public Date getDate() {
        return this.logHeader.getDate();
    }

    public String getDateString() {
        return this.logHeader.getDateString();
    }

    public String getDetailedMesg(boolean bl) {
        Locale locale = bl ? Locale.getDefault() : new Locale("", "");
        return this.getLocalizedMessage(this.detailedMesgId, this.substArgs, locale);
    }

    public String getEventId() {
        return this.logHeader.getEventId();
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getHashCode() {
        return this.logHeader.getHashCode();
    }

    public String[] getLabelStrings(boolean bl) {
        String[] stringArray = null;
        Vector vector = this.data.getLabels();
        int n = 0;
        int n2 = 0;
        String string = null;
        Locale locale = bl ? Locale.getDefault() : new Locale("", "");
        if (vector != null) {
            n2 = vector.size();
            stringArray = new String[n2];
            n = 0;
            while (n < n2) {
                CIMException cIMException;
                Vector vector2;
                String string2;
                if (((String)vector.elementAt(n)).compareTo(EXM_STR) == 0 && (string2 = (String)(vector2 = this.data.getValues()).elementAt(n)) != null && (cIMException = this.parseLogStr(string2)) != null) {
                    string2 = cIMException.toString();
                    this.data.setValueAt(string2, n);
                }
                stringArray[n] = (string = this.getPattern((String)vector.elementAt(n), locale)) == null ? "" : (string.length() > 25 ? string.substring(0, 25) : string);
                ++n;
            }
        }
        return stringArray;
    }

    private String getLocalizedMessage(String string, Vector vector, Locale locale) {
        boolean bl = false;
        String string2 = string;
        if (vector == null) {
            return string2;
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        try {
            string2 = MessageFormat.format(this.getPattern(string2, locale), objectArray);
        }
        catch (Exception exception) {}
        return string2;
    }

    public LogRecordHeader getLogHeader() {
        return this.logHeader;
    }

    private String getPattern(String string, Locale locale) {
        PropertyResourceBundle propertyResourceBundle = null;
        String string2 = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string3 = this.getBundleName();
        try {
            propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(string3, locale);
            string2 = propertyResourceBundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    public long getRecordId() {
        return this.logHeader.getRecordId();
    }

    public int getSeverity() {
        return this.logHeader.getSeverity();
    }

    public String getSeverityString() {
        return this.logHeader.getSeverityString();
    }

    public String getSummaryMesg(boolean bl) {
        return this.logHeader.getSummaryMesg(bl);
    }

    public boolean getSyslog() {
        return this.was_syslogged;
    }

    public String getTimeString() {
        return this.logHeader.getTimeString();
    }

    public String getUserName() {
        return this.logHeader.getUserName();
    }

    public String[] getValueStrings() {
        Object[] objectArray = null;
        Vector vector = this.data.getValues();
        boolean bl = false;
        if (vector != null) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    private String parseEventId(String string) {
        String string2 = "";
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        int n = string.lastIndexOf(95);
        try {
            string2 = string.substring(n + 1);
        }
        catch (Exception exception) {}
        return string2;
    }

    public CIMException parseLogStr(String string) {
        StringTokenizer stringTokenizer = null;
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "&!$", false);
        }
        if (stringTokenizer != null) {
            String string2;
            Object[] objectArray = new Object[stringTokenizer.countTokens() - 2];
            try {
                String string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
            CIMException cIMException = new CIMException(string2);
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    objectArray[n++] = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    cIMException.setParams(objectArray);
                    return cIMException;
                }
            }
            if (n > 0) {
                cIMException.setParams(objectArray);
            }
            return cIMException;
        }
        return null;
    }

    public void setAgentHostName(String string) {
        if (string != null) {
            this.logHeader.setAgentHostName(string);
        }
    }

    public void setAppName(String string) {
        if (string != null) {
            this.logHeader.setAppName(string);
        }
    }

    public void setBasicLogInfo(String string, int n, int n2, String string2, String string3, String string4, String string5) {
        String string6 = "";
        if (string5 != null || string5.length() > 0 || this.detailedMesgId.length() == 0) {
            string6 = this.parseEventId(string5);
        }
        this.logHeader.setBasicInfo(string, n, n2, string6, string2, string3, string4, string5);
    }

    public void setCategory(int n) {
        this.logHeader.setCategory(n);
    }

    public void setClientHostName(String string) {
        if (string != null) {
            this.logHeader.setClientHostName(string);
        }
    }

    public void setData(Vector vector, Vector vector2) {
        if (vector != null) {
            this.data = new LabelValuePairs(vector, vector2);
        }
    }

    public void setDate(Date date) {
        this.logHeader.setDate(date);
    }

    public void setDetailedMesgId(String string) {
        if (string != null || string.length() > 0) {
            this.detailedMesgId = string;
            this.logHeader.setEventId(this.parseEventId(string));
        }
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setHashCode(int n) {
        this.logHeader.setHashCode(n);
    }

    public void setRecordId(long l) {
        this.logHeader.setRecordId(l);
    }

    public void setSeverity(int n) {
        this.logHeader.setSeverity(n);
    }

    public void setSubstArgs(Vector vector) {
        if (vector != null) {
            this.substArgs = vector;
        }
    }

    public void setSummaryMesgId(String string) {
        if (string != null) {
            this.logHeader.setSummaryMesgId(string);
        }
    }

    public void setSyslog(boolean bl) {
        this.was_syslogged = bl;
    }

    public void setUserName(String string) {
        this.logHeader.setUserName(string);
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = 0;
        string = String.valueOf(string) + this.logHeader.toString() + "\n";
        string = String.valueOf(string) + "    Detail:   " + this.getDetailedMesg(true) + "\n";
        string = String.valueOf(string) + "    Data:     \n";
        String[] stringArray = this.getLabelStrings(true);
        String[] stringArray2 = this.getValueStrings();
        n2 = stringArray.length;
        n = 0;
        while (n < n2) {
            string = String.valueOf(string) + "      " + stringArray[n] + " " + stringArray2[n] + "\n";
            ++n;
        }
        string = String.valueOf(string) + "      " + this.getData() + "\n\n";
        return string;
    }
}

