/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogFilter
implements Filterable,
Serializable {
    public static final int REVERSE = 0;
    public static final int FORWARD = 1;
    private static final String MARKER = "@#@";
    private Vector appNames;
    private int[] category = new int[3];
    private int[] severity = new int[3];
    private Date start_date = null;
    private Date end_date = null;
    private String start_date_str = null;
    private String end_date_str = null;
    private String user = null;
    private String clientHostName = null;
    private String agentHostName = null;
    private int reverse;

    public LogFilter() {
        this.appNames = new Vector();
        this.category[0] = -1;
        this.category[1] = -1;
        this.category[2] = -1;
        this.severity[0] = -1;
        this.severity[1] = -1;
        this.severity[2] = -1;
        this.start_date_str = null;
        this.end_date_str = null;
        this.user = null;
        this.clientHostName = null;
        this.agentHostName = null;
        this.reverse = 0;
    }

    public LogFilter(String string) {
        this.appNames = new Vector();
        this.category[0] = -1;
        this.category[1] = -1;
        this.category[2] = -1;
        this.severity[0] = -1;
        this.severity[1] = -1;
        this.severity[2] = -1;
        this.start_date_str = null;
        this.end_date_str = null;
        this.user = null;
        this.clientHostName = null;
        this.agentHostName = null;
        this.reverse = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER);
        int n = 0;
        int n2 = 0;
        if (string == null) {
            return;
        }
        try {
            long l;
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = 0;
            while (n2 < n) {
                this.appNames.addElement(stringTokenizer.nextToken());
                ++n2;
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = 0;
            while (n2 < n) {
                this.category[n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = 0;
            while (n2 < n) {
                this.severity[n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("foo")) {
                this.start_date = null;
            } else {
                l = Long.parseLong(string2);
                this.start_date = new Date(l);
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("foo")) {
                this.end_date = null;
            } else {
                l = Long.parseLong(string2);
                this.end_date = new Date(l);
            }
            this.user = stringTokenizer.nextToken();
            if (this.user.equalsIgnoreCase("foo")) {
                this.user = null;
            }
            this.clientHostName = stringTokenizer.nextToken();
            if (this.clientHostName.equalsIgnoreCase("foo")) {
                this.clientHostName = null;
            }
            this.agentHostName = stringTokenizer.nextToken();
            if (this.agentHostName.equalsIgnoreCase("foo")) {
                this.agentHostName = null;
            }
            this.reverse = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {}
    }

    public LogFilter(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n3) {
        this.appNames = new Vector();
        if (string != null) {
            this.appNames.addElement(string);
        }
        this.category[0] = n;
        this.severity[0] = n2;
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        simpleDateFormat.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        simpleDateFormat2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
        if (string2 != null && string3 != null) {
            this.start_date_str = String.valueOf(string2) + " at " + string3;
            try {
                this.start_date = simpleDateFormat.parse(this.start_date_str);
            }
            catch (Exception exception) {}
            if (this.start_date == null) {
                try {
                    this.start_date = simpleDateFormat2.parse(this.start_date_str);
                }
                catch (Exception exception) {}
            }
        }
        if (string4 != null && string5 != null) {
            this.end_date_str = String.valueOf(string4) + " at " + string5;
            try {
                this.end_date = simpleDateFormat.parse(this.end_date_str);
            }
            catch (Exception exception) {}
            if (this.end_date == null) {
                try {
                    this.end_date = simpleDateFormat2.parse(this.end_date_str);
                }
                catch (Exception exception) {}
            }
        }
        this.user = string6;
        this.clientHostName = string7;
        this.agentHostName = string8;
        this.reverse = n3;
    }

    public boolean checkConstraints(LogRecord logRecord) {
        if (this.appNames.size() != 0) {
            int n = 0;
            boolean bl = false;
            n = 0;
            while (n < this.appNames.size()) {
                String string = (String)this.appNames.elementAt(n);
                bl = this.is_app_name_OK(string, logRecord);
                if (bl) break;
                bl |= false;
                ++n;
            }
            if (!bl) {
                return false;
            }
        }
        if ((this.category[0] != -1 || this.category[1] != -1 || this.category[2] != -1) && this.category[0] != logRecord.getCategory() && this.category[1] != logRecord.getCategory() && this.category[2] != logRecord.getCategory()) {
            return false;
        }
        if ((this.severity[0] != -1 || this.severity[1] != -1 || this.severity[2] != -1) && this.severity[0] != logRecord.getSeverity() && this.severity[1] != logRecord.getSeverity() && this.severity[2] != logRecord.getSeverity()) {
            return false;
        }
        if (this.start_date != null && this.end_date != null && (this.start_date.after(logRecord.getDate()) || this.end_date.before(logRecord.getDate()))) {
            return false;
        }
        if (this.start_date == null && this.end_date != null && this.end_date.before(logRecord.getDate())) {
            return false;
        }
        if (this.start_date != null && this.end_date == null && this.start_date.after(logRecord.getDate())) {
            return false;
        }
        if (this.user != null && !this.user.equalsIgnoreCase(logRecord.getUserName())) {
            return false;
        }
        if (this.clientHostName != null && !this.clientHostName.equalsIgnoreCase(logRecord.getClientHostName())) {
            return false;
        }
        return this.agentHostName == null || this.agentHostName.equalsIgnoreCase(logRecord.getAgentHostName());
    }

    public String flattenFilter() {
        long l;
        String string = "";
        int n = 0;
        boolean bl = false;
        string = String.valueOf(string) + String.valueOf(this.appNames.size()) + MARKER;
        n = 0;
        while (n < this.appNames.size()) {
            string = String.valueOf(string) + (String)this.appNames.elementAt(n) + MARKER;
            ++n;
        }
        string = String.valueOf(string) + String.valueOf(this.category.length) + MARKER;
        n = 0;
        while (n < this.category.length) {
            string = String.valueOf(string) + String.valueOf(this.category[n]) + MARKER;
            ++n;
        }
        string = String.valueOf(string) + String.valueOf(this.severity.length) + MARKER;
        n = 0;
        while (n < this.severity.length) {
            string = String.valueOf(string) + String.valueOf(this.severity[n]) + MARKER;
            ++n;
        }
        if (this.start_date != null) {
            l = this.start_date.getTime();
            string = String.valueOf(string) + String.valueOf(l);
        } else {
            string = String.valueOf(string) + "foo";
        }
        string = String.valueOf(string) + MARKER;
        if (this.end_date != null) {
            l = this.end_date.getTime();
            string = String.valueOf(string) + String.valueOf(l);
        } else {
            string = String.valueOf(string) + "foo";
        }
        string = String.valueOf(string) + MARKER;
        string = this.user != null ? String.valueOf(string) + this.user : String.valueOf(string) + "foo";
        string = String.valueOf(string) + MARKER;
        string = this.clientHostName != null ? String.valueOf(string) + this.clientHostName : String.valueOf(string) + "foo";
        string = String.valueOf(string) + MARKER;
        string = this.agentHostName != null ? String.valueOf(string) + this.agentHostName : String.valueOf(string) + "foo";
        string = String.valueOf(string) + MARKER;
        string = String.valueOf(string) + String.valueOf(this.reverse) + MARKER;
        return string;
    }

    public String getAgentHostName() {
        return this.agentHostName;
    }

    public Vector getAppNames() {
        return this.appNames;
    }

    public int[] getCategory() {
        return this.category;
    }

    public int getDirection() {
        return this.reverse;
    }

    public String getEndDate() {
        if (this.end_date_str != null) {
            return this.end_date_str;
        }
        return null;
    }

    public int[] getSeverity() {
        return this.severity;
    }

    public String getStartDate() {
        if (this.start_date_str != null) {
            return this.start_date_str;
        }
        return null;
    }

    public String getUser() {
        return this.user;
    }

    public String getclientHostName() {
        return this.clientHostName;
    }

    private boolean is_app_name_OK(String string, LogRecord logRecord) {
        return string.equalsIgnoreCase(logRecord.getAppKey()) || string.equalsIgnoreCase(logRecord.getAppName());
    }

    public void setAgentHostName(String string) {
        if (string != null && string.length() != 0) {
            this.agentHostName = string;
        }
    }

    public void setAppNames(String string, String string2, String string3) {
        if (string != null && string.length() != 0) {
            this.appNames.addElement(string);
        }
        if (string2 != null && string2.length() != 0) {
            this.appNames.addElement(string2);
        }
        if (string3 != null && string3.length() != 0) {
            this.appNames.addElement(string3);
        }
    }

    public void setAppNames(String string, String string2, String string3, String string4) {
        if (string != null && string.length() != 0) {
            this.appNames.addElement(string);
        }
        if (string2 != null && string2.length() != 0) {
            this.appNames.addElement(string2);
        }
        if (string3 != null && string3.length() != 0) {
            this.appNames.addElement(string3);
        }
        if (string4 != null && string4.length() != 0) {
            this.appNames.addElement(string4);
        }
    }

    public void setCategory(int n, int n2, int n3) {
        this.category[0] = n;
        this.category[1] = n2;
        this.category[2] = n3;
    }

    public void setClientHostName(String string) {
        if (string != null && string.length() != 0) {
            this.clientHostName = string;
        }
    }

    public void setDirection(int n) {
        this.reverse = n;
    }

    public void setEndDate(String string, String string2) {
        block6: {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
            SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
            simpleDateFormat.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
            simpleDateFormat2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
            if (string == null || string.length() == 0) {
                return;
            }
            if (string2 == null || string2.length() == 0) {
                string2 = "11:59:59 PM";
            }
            this.end_date_str = String.valueOf(string) + " at " + string2;
            try {
                this.end_date = simpleDateFormat.parse(this.end_date_str);
            }
            catch (Exception exception) {}
            if (this.end_date != null) break block6;
            try {
                this.end_date = simpleDateFormat2.parse(this.end_date_str);
            }
            catch (Exception exception) {}
        }
    }

    public void setSeverity(int n, int n2, int n3) {
        this.severity[0] = n;
        this.severity[1] = n2;
        this.severity[2] = n3;
    }

    public void setStartDate(String string, String string2) {
        block6: {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
            SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
            simpleDateFormat.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
            simpleDateFormat2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
            if (string == null || string.length() == 0) {
                return;
            }
            if (string2 == null || string2.length() == 0) {
                string2 = "00:00:00 AM";
            }
            this.start_date_str = String.valueOf(string) + " at " + string2;
            try {
                this.start_date = simpleDateFormat.parse(this.start_date_str);
            }
            catch (Exception exception) {}
            if (this.start_date != null) break block6;
            try {
                this.start_date = simpleDateFormat2.parse(this.start_date_str);
            }
            catch (Exception exception) {}
        }
    }

    public void setUser(String string) {
        if (string != null && string.length() != 0) {
            this.user = string;
        }
    }
}

