/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import com.sun.wbem.solarisprovider.logsvc.DataRecord;
import com.sun.wbem.solarisprovider.logsvc.InvalidRecordException;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class DataStore
implements Cloneable {
    private static String VERSION_STR = "logsvc.wbem.version.1";
    String logFileName;
    RandomAccessFile fileDescriptor;
    long totalNumRecords = 0L;
    long currentEndOffset = 0L;
    long lastRecordOffset = 0L;
    long startDate = 0L;
    long firstOffset = 0L;
    int marker;
    String version = "";

    public DataStore(String string) throws IOException, EOFException {
        this.logFileName = string;
        this.fileDescriptor = new RandomAccessFile(string, "rw");
        if (this.fileDescriptor.length() > 0L) {
            this.fileDescriptor.seek(0L);
            this.currentEndOffset = this.fileDescriptor.readLong();
            this.lastRecordOffset = this.fileDescriptor.readLong();
            this.totalNumRecords = this.fileDescriptor.readLong();
            this.marker = this.fileDescriptor.readInt();
            this.startDate = this.fileDescriptor.readLong();
            this.version = this.fileDescriptor.readUTF();
            this.firstOffset = this.fileDescriptor.getFilePointer();
        } else {
            this.marker = this.hashCode();
            this.startDate = System.currentTimeMillis();
            this.fileDescriptor.seek(0L);
            this.fileDescriptor.writeLong(this.currentEndOffset);
            this.fileDescriptor.writeLong(this.lastRecordOffset);
            this.fileDescriptor.writeLong(this.totalNumRecords);
            this.fileDescriptor.writeInt(this.marker);
            this.fileDescriptor.writeLong(this.startDate);
            this.fileDescriptor.writeUTF(VERSION_STR);
            this.firstOffset = this.currentEndOffset = this.fileDescriptor.getFilePointer();
            this.fileDescriptor.seek(0L);
            this.fileDescriptor.writeLong(this.currentEndOffset);
            this.lastRecordOffset = this.currentEndOffset;
            this.fileDescriptor.writeLong(this.lastRecordOffset);
        }
    }

    private void checkMark() throws IOException, EOFException, CorruptDataException {
        int n = this.fileDescriptor.readInt();
        if (n != this.marker) {
            throw new CorruptDataException("EXLOG_MRK");
        }
    }

    private long checkOffset(long l) {
        if (l < 0L || l >= this.currentEndOffset) {
            return -1L;
        }
        if (l == 0L) {
            l = this.firstOffset;
        }
        return l;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    protected void close() throws AdminLogException {
        try {
            this.fileDescriptor.close();
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", this.logFileName);
        }
    }

    private Object convertToObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray.length <= 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        return object;
    }

    protected void finalize() throws IOException {
        this.fileDescriptor.close();
    }

    long getCurrentEndOffset() {
        return this.currentEndOffset;
    }

    protected long getFileDate() {
        return this.startDate;
    }

    protected String getFileName() {
        return this.logFileName;
    }

    protected long getNumRecords() {
        return this.totalNumRecords;
    }

    protected String getVersion() {
        return this.version;
    }

    protected synchronized Vector readNumRecordsAsStr(long l, long l2, int n) throws IOException, EOFException, InvalidRecordException, CorruptDataException {
        Vector<DataRecord> vector = new Vector<DataRecord>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l3 = 0L;
        if (this.totalNumRecords == 0L) {
            return null;
        }
        if (n == 0) {
            if (l == 0L) {
                l = this.lastRecordOffset;
            } else {
                if (l == this.firstOffset) {
                    return null;
                }
                long l4 = l;
                this.fileDescriptor.seek(l += 8L);
                n3 = this.fileDescriptor.readInt();
                this.fileDescriptor.seek(l + (long)n3 + 4L);
                l = this.fileDescriptor.readLong();
                if (l4 == l) {
                    return null;
                }
            }
        } else if (n == 1 && l != 0L) {
            if (l == this.lastRecordOffset) {
                return null;
            }
            l = this.checkOffset(l);
            this.fileDescriptor.seek(l += 8L);
            n3 = this.fileDescriptor.readInt();
            l += (long)(n3 + 4 + 8);
        }
        l = this.checkOffset(l);
        if (l < 0L) {
            throw new InvalidRecordException("EXLOG_OFF");
        }
        this.fileDescriptor.seek(l);
        while ((long)n4 < l2) {
            try {
                this.checkMark();
                n2 = this.fileDescriptor.readInt();
                n3 = this.fileDescriptor.readInt();
                if (n3 < 0) {
                    throw new CorruptDataException("EXLOG_LEN");
                }
                byte[] byArray = new byte[n3];
                this.fileDescriptor.readFully(byArray);
                String string = new String(byArray);
                if (string == null) {
                    throw new CorruptDataException("EXLOG_DAT");
                }
                vector.addElement(new DataRecord(l, n2, string, n3, this.version));
                l3 = l;
            }
            catch (EOFException eOFException) {
                if (n4 > 0) {
                    return vector;
                }
                throw eOFException;
            }
            ++n4;
            l = this.fileDescriptor.getFilePointer();
            if (n == 0) {
                long l5 = this.fileDescriptor.readLong();
                if (l5 > l) {
                    throw new CorruptDataException("EXLOG_DAT");
                }
                if (l5 == l3) {
                    return vector;
                }
                this.fileDescriptor.seek(l5);
                l = l5;
                continue;
            }
            long l6 = this.fileDescriptor.readLong();
            l = this.fileDescriptor.getFilePointer();
        }
        return vector;
    }

    protected synchronized DataRecord readSpecificRecordAsStr(long l, int n) throws InvalidRecordException, IOException, EOFException, CorruptDataException {
        if (this.totalNumRecords == 0L) {
            return null;
        }
        if ((l = this.checkOffset(l)) < 0L) {
            throw new InvalidRecordException("EXLOG_OFF");
        }
        this.fileDescriptor.seek(l);
        this.checkMark();
        int n2 = this.fileDescriptor.readInt();
        if (n2 != n) {
            throw new InvalidRecordException("EXLOG_HSH");
        }
        int n3 = this.fileDescriptor.readInt();
        if (n3 < 0) {
            throw new CorruptDataException("EXLOG_LEN");
        }
        byte[] byArray = new byte[n3];
        this.fileDescriptor.readFully(byArray);
        String string = new String(byArray);
        if (string == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        return new DataRecord(l, n2, string, n3, this.version);
    }

    protected synchronized long writeRecord(String string, long l) throws IOException, InvalidRecordException {
        int n = 0;
        long l2 = this.lastRecordOffset;
        if (string == null) {
            throw new InvalidRecordException("EXLOG_NUL");
        }
        this.fileDescriptor.seek(this.currentEndOffset);
        n = string.length();
        if (n <= 0) {
            throw new InvalidRecordException("EXLOG_NUL");
        }
        long l3 = this.fileDescriptor.length();
        if ((l3 += (long)(12 + n + 8)) > l) {
            return -1L;
        }
        byte[] byArray = new byte[n];
        byArray = string.getBytes();
        this.lastRecordOffset = this.currentEndOffset;
        this.fileDescriptor.writeInt(this.marker);
        this.fileDescriptor.writeInt(string.hashCode());
        this.fileDescriptor.writeInt(n);
        this.fileDescriptor.write(byArray);
        this.fileDescriptor.writeLong(l2);
        this.currentEndOffset = this.fileDescriptor.getFilePointer();
        ++this.totalNumRecords;
        this.fileDescriptor.seek(0L);
        this.fileDescriptor.writeLong(this.currentEndOffset);
        this.fileDescriptor.writeLong(this.lastRecordOffset);
        this.fileDescriptor.writeLong(this.totalNumRecords);
        return this.fileDescriptor.length();
    }
}

