/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.filesystem;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.filesystem.Solaris_FileSystem_Data;
import com.sun.wbem.solarisprovider.filesystem.Solaris_FileSystem_Native;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Solaris_FileSystem
implements InstanceProvider {
    private Hashtable hash = null;
    private CIMOMHandle cimomhandle = null;

    public void cleanup() throws CIMException {
    }

    private UnsignedInt32 convertIntToCIMUnsignedInt(int n) {
        try {
            return new UnsignedInt32(Integer.toString(n));
        }
        catch (Exception exception) {
            return new UnsignedInt32("0");
        }
    }

    private UnsignedInt64 convertLongToCIMUnsignedLong(long l) {
        try {
            return new UnsignedInt64(new BigInteger(Long.toString(l)));
        }
        catch (Exception exception) {
            return new UnsignedInt64(new BigInteger("0"));
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMInstance createNewInstance(CIMClass cIMClass, Solaris_FileSystem_Data solaris_FileSystem_Data) throws Exception {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        cIMInstance.setProperty("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_FileSystem"));
        cIMInstance.setProperty("Name", new CIMValue((Object)solaris_FileSystem_Data.getMountPoint()));
        cIMInstance.setProperty("Root", new CIMValue((Object)solaris_FileSystem_Data.getDevice()));
        UnsignedInt64 unsignedInt64 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getBlockSize());
        cIMInstance.setProperty("BlockSize", new CIMValue((Object)unsignedInt64));
        UnsignedInt64 unsignedInt642 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getFileSystemSize());
        cIMInstance.setProperty("FileSystemSize", new CIMValue((Object)unsignedInt642));
        UnsignedInt64 unsignedInt643 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getAvailableSpace());
        cIMInstance.setProperty("AvailableSpace", new CIMValue((Object)unsignedInt643));
        cIMInstance.setProperty("ReadOnly", new CIMValue((Object)new Boolean(solaris_FileSystem_Data.getReadOnly())));
        cIMInstance.setProperty("EncryptionMethod", new CIMValue((Object)"Unknown"));
        cIMInstance.setProperty("CompressionMethod", new CIMValue((Object)"Unknown"));
        cIMInstance.setProperty("CaseSensitive", new CIMValue((Object)new Boolean(true)));
        cIMInstance.setProperty("CasePreserved", new CIMValue((Object)new Boolean(true)));
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        vector.addElement(new UnsignedInt16(0));
        cIMInstance.setProperty("CodeSet", new CIMValue(vector));
        UnsignedInt32 unsignedInt32 = this.convertIntToCIMUnsignedInt(solaris_FileSystem_Data.getMaxFileNameLength());
        cIMInstance.setProperty("MaxFileNameLength", new CIMValue((Object)unsignedInt32));
        cIMInstance.setProperty("ClusterSize", new CIMValue((Object)new UnsignedInt32(Integer.toString(solaris_FileSystem_Data.getClusterSize()))));
        UnsignedInt32 unsignedInt322 = this.convertIntToCIMUnsignedInt(solaris_FileSystem_Data.getClusterSize());
        cIMInstance.setProperty("FileSystemType", new CIMValue((Object)solaris_FileSystem_Data.getFileSystemType()));
        UnsignedInt64 unsignedInt644 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getUsedSpace());
        cIMInstance.setProperty("UsedSpace", new CIMValue((Object)unsignedInt644));
        cIMInstance.setProperty("MountOptions", new CIMValue((Object)solaris_FileSystem_Data.getMountOptions()));
        return cIMInstance;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        Vector<CIMObjectPath> vector = null;
        try {
            this.hash = this.getFileSystemData();
            vector = new Vector<CIMObjectPath>();
            Enumeration enumeration = this.hash.elements();
            while (enumeration.hasMoreElements()) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)enumeration.nextElement();
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("Name", new CIMValue((Object)solaris_FileSystem_Data.getMountPoint()));
                vector.addElement(cIMObjectPath2);
            }
        }
        catch (Exception exception) {}
        return vector;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        Vector<CIMInstance> vector = null;
        try {
            this.hash = this.getFileSystemData();
            vector = new Vector<CIMInstance>();
            Enumeration enumeration = this.hash.elements();
            while (enumeration.hasMoreElements()) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)enumeration.nextElement();
                CIMInstance cIMInstance = this.createNewInstance(cIMClass, solaris_FileSystem_Data);
                vector.addElement(cIMInstance);
            }
        }
        catch (Exception exception) {}
        return vector;
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) {
        return null;
    }

    private Hashtable getFileSystemData() {
        Hashtable<String, Solaris_FileSystem_Data> hashtable = new Hashtable<String, Solaris_FileSystem_Data>();
        Vector vector = Solaris_FileSystem_Native.getFileSystemData();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)vector.elementAt(n);
                hashtable.put(solaris_FileSystem_Data.getMountPoint(), solaris_FileSystem_Data);
                ++n;
            }
        }
        return hashtable;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) {
        this.hash = this.getFileSystemData();
        try {
            Object object;
            String string = "";
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                object = (CIMProperty)enumeration.nextElement();
                if (!object.getName().equalsIgnoreCase("Name")) continue;
                string = (String)object.getValue().getValue();
            }
            object = (Solaris_FileSystem_Data)this.hash.get(string);
            if (object != null) {
                CIMInstance cIMInstance = this.createNewInstance(cIMClass, (Solaris_FileSystem_Data)object);
                return cIMInstance;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
        return null;
    }

    public void initialize(CIMOMHandle cIMOMHandle) {
        this.cimomhandle = cIMOMHandle;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

