/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.ASTNamedType;
import com.sun.wbem.compiler.mib2mof.ASTObjectTypeDefinition;
import com.sun.wbem.compiler.mib2mof.BeanIfGenerator;
import com.sun.wbem.compiler.mib2mof.Def;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.MibNode;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class MbeanIfGenerator
extends BeanIfGenerator
implements Serializable {
    protected StringBuffer accessors = new StringBuffer();

    public MbeanIfGenerator(ResourceManager resourceManager, String string, String string2, String string3, MibNode mibNode, ASTMib aSTMib) throws IOException {
        super(resourceManager, string, string2, string3, mibNode, aSTMib);
        this.varName = this.node.getSymbolName();
        if (this.varName == null) {
            this.varName = this.getClassName(this.node.getComputedOid());
        }
        this.symboleName = MbeanIfGenerator.buildMBeanIfName(string2, this.varName);
        Trace.info(MessageHandler.getMessage("generate.info.if", this.varName));
        this.out = this.openFile(String.valueOf(this.symboleName) + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
    }

    protected void addAccessors(MibNode mibNode, String string, String string2) throws IOException {
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        String string3 = aSTObjectTypeDefinition.getDefinition().getDescription();
        this.accessors.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.getter", string2) + "\n" + Def.TAB + " */\n");
        this.accessors.append(String.valueOf(Def.TAB) + Def.PUBLIC + string + Def.GET + string2 + "() " + BeanIfGenerator.accessThrows + "\n");
        int n = aSTObjectTypeDefinition.getDefinition().getAccess();
        if (n == 68 || n == 85 || n == 66) {
            this.accessors.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.setter", string2) + "\n" + Def.TAB + " */\n");
            this.accessors.append(String.valueOf(Def.TAB) + Def.PUBLIC + Def.VOID + Def.SET + string2 + "(" + string + "x) " + BeanIfGenerator.accessThrows + "\n");
            this.accessors.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.checker", string2) + "\n" + Def.TAB + " */\n");
            this.accessors.append(String.valueOf(Def.TAB) + Def.PUBLIC + Def.VOID + Def.CHECK + string2 + "(" + string + "x) " + BeanIfGenerator.accessThrows + "\n");
        }
    }

    public static String buildMBeanIfName(String string, String string2) {
        return String.valueOf(string) + string2 + Def.MBEANSUFFIX;
    }

    public void endOfGroup() throws IOException {
        this.write(this.accessors.toString());
        this.write(Def.RBRACE);
        this.closeIO();
    }

    private String getTableEntryName(MibNode mibNode) throws IOException {
        Hashtable hashtable = mibNode.getChildren();
        if (hashtable.size() != 1) {
            Trace.error(MessageHandler.getMessage("generate.error.table.entry", mibNode.getRealSymbolName()));
            throw new IOException();
        }
        Enumeration enumeration = hashtable.elements();
        MibNode mibNode2 = (MibNode)enumeration.nextElement();
        String string = mibNode2.getSymbolName();
        if (string == null) {
            string = this.getClassName(mibNode2.getComputedOid());
        }
        String string2 = String.valueOf(this.prefix) + string;
        return string2;
    }

    protected void handleNestedGroups(MibNode mibNode) throws IOException {
    }

    public void handleNode(MibNode mibNode) throws IOException {
        if (mibNode.isGroup() || mibNode.hasNestedGroups()) {
            this.handleNestedGroups(mibNode);
            return;
        }
        if (mibNode.isTable()) {
            this.handleTable(mibNode);
            return;
        }
        String string = mibNode.getSymbolName();
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        if (aSTObjectTypeDefinition == null) {
            return;
        }
        ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
        String string2 = "";
        if (aSTNamedType.isEnumeratedType()) {
            String string3 = aSTNamedType.getEnumeratedDef().getSymbol();
            if (string3.length() == 0) {
                string3 = string;
            }
            string2 = String.valueOf(this.prefix) + Def.ENUMPREFIX + string3 + " ";
            mibNode.setEnumerated(true);
            mibNode.setEnumeratedType(string2);
        } else {
            string2 = aSTNamedType.getMbeanSyntax();
        }
        this.addAccessors(mibNode, string2, string);
    }

    protected void handleTable(MibNode mibNode) throws IOException {
        String string = mibNode.getSymbolName();
        String string2 = String.valueOf(this.prefix) + Def.TABLEPREFIX + string;
        String string3 = this.getTableEntryName(mibNode);
        this.accessors.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.table.access", string) + "\n" + Def.TAB + " */\n");
        this.accessors.append(String.valueOf(Def.TAB) + Def.PUBLIC + string2 + " " + Def.ACCESS + string + "() " + BeanIfGenerator.accessThrows + "\n");
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbeanif.comment.desc", this.varName) + "\n" + " */\n");
        this.write(String.valueOf(Def.PUBLIC) + Def.INTERFACE + this.symboleName + Def.LBRACE + "\n");
    }
}

