/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.client.PersistentStore;
import java.io.IOException;
import java.io.Serializable;

public class CIMRlogEntry
implements Serializable {
    private static final long serialVersionUID = 4012529228189L;
    protected String name;
    protected static PersistentStore store;
    private long objectID = -1L;

    public CIMRlogEntry() {
    }

    public CIMRlogEntry(String string) {
        this.name = string;
    }

    public void createPersistObject(byte[] byArray) {
        try {
            if (this.objectID != -1L) {
                store.deleteObject(this.objectID);
            }
            this.objectID = byArray == null || byArray.length == 0 ? -1L : store.writeObjectBytes(byArray);
        }
        catch (IOException iOException) {
            System.out.println("exception:" + iOException);
            iOException.printStackTrace();
        }
    }

    public void delete() {
        store.deleteObject(this.objectID);
    }

    public boolean euqals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof CIMRlogEntry) {
            CIMRlogEntry cIMRlogEntry = (CIMRlogEntry)object;
            return cIMRlogEntry.name.equals(this.name);
        }
        return false;
    }

    public long getID() {
        return this.objectID;
    }

    public String getName() {
        return this.name;
    }

    public String getNameKey() {
        return CIMRlogEntry.toNameKey(this.name);
    }

    public PersistentStore.PersistObject getPersistObject() {
        if (this.objectID == -1L) {
            throw new RuntimeException("CIMRlogEntry contains no object");
        }
        return store.getPersistObject(this.objectID);
    }

    public byte[] getValue() {
        if (this.objectID == -1L) {
            return null;
        }
        try {
            byte[] byArray = null;
            byArray = store.readObjectBytes(this.objectID);
            return byArray;
        }
        catch (IOException iOException) {
            System.out.println("exception:" + iOException);
            iOException.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setID(long l) {
        if (this.objectID != -1L) {
            store.deleteObject(this.objectID);
        }
        this.objectID = l;
        store.setNextID(l);
    }

    public static void setPersistentStore(PersistentStore persistentStore) {
        store = persistentStore;
    }

    protected static String toNameKey(String string) {
        return string.toLowerCase();
    }
}

