/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ChangeAppState;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.diskmgr.client.ApplicationContext;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.DiskActionsListener;
import com.sun.admin.diskmgr.client.DiskMenuBar;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.DiskMgrTree;
import com.sun.admin.diskmgr.client.DiskToolBar;
import com.sun.admin.diskmgr.client.NavigationSelectionListener;
import com.sun.admin.diskmgr.client.ServiceWrapper;
import com.sun.admin.diskmgr.client.SliceMenuBar;
import com.sun.admin.diskmgr.client.SliceToolBar;
import com.sun.admin.diskmgr.client.TreeNodeData;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class VDiskMgr
implements Tool,
PropertyChangeListener,
VConsoleActionListener {
    private ServiceWrapper diskMgr;
    private boolean bX86 = false;
    private boolean bInitialized = false;
    private VConsoleProperties properties = null;
    private ApplicationContext applicationContext = null;
    private ToolInfrastructure infrastructure = null;
    private boolean bRunning = false;
    private Vector consoleListeners = new Vector();
    private Vector navigationSelectionListeners = new Vector();
    VDisplayModel displayModel;
    private String origViewSetting = "";
    private DiskMenuBar diskMenuBar = null;
    private SliceMenuBar sliceMenuBar = null;
    private DiskToolBar diskToolBar = null;
    private SliceToolBar sliceToolBar = null;
    private DiskMgrTree theTree = null;
    private ResourceBundle resourceBundle = null;
    private AdminException initException = null;
    private boolean isCriticalStop = false;
    private JFrame frame = null;

    public VDiskMgr() {
        try {
            this.resourceBundle = ResourceManager.getBundle((String)"com.sun.admin.diskmgr.client.resources.Resources", this.getClass());
        }
        catch (Exception exception) {
            this.resourceBundle = null;
        }
        this.diskMenuBar = new DiskMenuBar(this);
        this.sliceMenuBar = new SliceMenuBar(this);
        this.diskToolBar = new DiskToolBar(this);
        this.sliceToolBar = new SliceToolBar(this);
        this.theTree = new DiskMgrTree(this);
        String string = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"FetchDisksTitle");
        this.getScopeNode().setResultPane((Component)new VBusyPanel(string));
        this.fireConsoleAction(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)this.getScopeNode()));
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (vConsoleActionListener != null) {
            this.consoleListeners.addElement(vConsoleActionListener);
        }
    }

    public void addHelpListener(DiskMgrContextHelpListener diskMgrContextHelpListener, Component component) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addHelpListener(diskMgrContextHelpListener, componentArray[n]);
                ++n;
            }
        }
        component.addFocusListener((FocusListener)((Object)diskMgrContextHelpListener));
    }

    public void addNavigationSelectionListener(NavigationSelectionListener navigationSelectionListener) {
        this.navigationSelectionListeners.addElement(navigationSelectionListener);
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (!this.bRunning) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.refresh")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Refresh");
            DiskActionsListener diskActionsListener = new DiskActionsListener(this, false);
            diskActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.sechelpselection")) {
            Vector vector = (Vector)vConsoleEvent.getPayload();
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.onSelection(vector);
        } else if (string.equals("vconsole.scopechildopened")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.onDoubleClick();
        } else if (string.equals("vconsole.displayproperties")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Properties");
            DiskActionsListener diskActionsListener = new DiskActionsListener(this, false);
            diskActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.sortup") || string.equals("vconsole.sortdown")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.saveSortPreference();
        }
    }

    public void destroy() {
    }

    public void fireConsoleAction(VConsoleEvent vConsoleEvent) {
        Enumeration enumeration = this.consoleListeners.elements();
        while (enumeration.hasMoreElements()) {
            VConsoleActionListener vConsoleActionListener = (VConsoleActionListener)enumeration.nextElement();
            vConsoleActionListener.consoleAction(vConsoleEvent);
        }
    }

    protected void fireNavigationSelection(VConsoleEvent vConsoleEvent) {
        Enumeration enumeration = this.navigationSelectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)enumeration.nextElement();
            navigationSelectionListener.valueChanged((VScopeNode)vConsoleEvent.getPayload());
        }
    }

    public VScopeNode getCurrentNode() {
        return this.theTree.getCurrentNode();
    }

    public DiskMenuBar getDiskMenuBar() {
        return this.diskMenuBar;
    }

    public ServiceWrapper getDiskMgr() {
        return this.diskMgr;
    }

    public DiskToolBar getDiskToolBar() {
        return this.diskToolBar;
    }

    public VDisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public VConsoleProperties getProperties() {
        this.displayModel = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
        return this.properties;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public VScopeNode getScopeNode() {
        return this.theTree.getRootNode();
    }

    public SliceMenuBar getSliceMenuBar() {
        return this.sliceMenuBar;
    }

    public SliceToolBar getSliceToolBar() {
        return this.sliceToolBar;
    }

    public DiskMgrTree getTree() {
        return this.theTree;
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.infrastructure = toolInfrastructure;
        try {
            this.diskMgr = this.applicationContext.getServiceWrapper(toolInfrastructure);
        }
        catch (AdminException adminException) {
            this.initException = adminException;
            String string = "<HTML><BODY>";
            string = String.valueOf(string) + ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"DESCRIPTION");
            string = String.valueOf(string) + "</p><p>" + adminException.getLocalizedMessage() + "</p>";
            string = String.valueOf(string) + "</BODY></HTML>";
            ChangeAppState.setErrorState((VScopeNode)this.getScopeNode(), (String)string);
            VLogEvent vLogEvent = new VLogEvent((Object)this, 30, new Date(), ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"LoadFailure"), ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"LoadFailure"), adminException.getLocalizedMessage(), (Throwable)adminException, null);
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
            this.fireConsoleAction(vConsoleEvent);
            this.getScopeNode().setResultPane(null);
            this.fireConsoleAction(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)this.getScopeNode()));
            return;
        }
    }

    public boolean isWaitOn() {
        return "true".equals(this.properties.getProperty("vconsole.working"));
    }

    public boolean isX86() {
        return this.bX86;
    }

    public ImageIcon loadImageIcon(String string) {
        String string2 = "images/" + string;
        return ConsoleUtility.loadImageIcon((String)string2, this.getClass());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.displaymodel")) {
            this.displayModel = (VDisplayModel)propertyChangeEvent.getNewValue();
        }
    }

    public void reportErrorException(Exception exception) {
        this.reportErrorException(exception, this.getFrame());
    }

    public void reportErrorException(Exception exception, JFrame jFrame) {
        AdminException adminException;
        String string = "";
        while (exception != null) {
            if (exception instanceof AdminException) {
                adminException = (AdminException)((Object)exception);
                string = String.valueOf(string) + "\n" + adminException.getLocalizedMessage();
                if (adminException.isEmbeddedException()) {
                    exception = adminException.getEmbeddedException();
                    continue;
                }
                exception = null;
                continue;
            }
            string = String.valueOf(string) + "\n" + exception.getLocalizedMessage();
            exception = null;
        }
        adminException = new ErrorDialog(jFrame, ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"ErrorTitle"), string);
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        return -1;
    }

    public void setInfoBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updateselinfo", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            this.frame = (JFrame)vConsoleProperties.getPropertyObject("vconsole.frame");
            this.displayModel = (VDisplayModel)vConsoleProperties.getPropertyObject("vconsole.displaymodel");
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setStatusBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public void setToolContext(ToolContext toolContext) {
        this.applicationContext = new ApplicationContext(this, toolContext);
    }

    public void setX86(boolean bl) {
        this.bX86 = bl;
        if (!this.bInitialized) {
            this.diskMenuBar.setX86(bl);
            this.sliceMenuBar.setX86(bl);
        }
        this.bInitialized = true;
    }

    public void start() throws CriticalStopException {
        if (this.initException != null) {
            if (this.isCriticalStop) {
                return;
            }
            this.reportErrorException((Exception)((Object)this.initException));
            this.isCriticalStop = true;
            throw new CriticalStopException(this.initException.getLocalizedMessage());
        }
        this.bRunning = true;
        this.origViewSetting = this.properties.getProperty("vconsole.iconstyle");
        this.properties.setProperty("vconsole.iconviewsenabled", "false");
        this.properties.setProperty("vconsole.iconstyle", "details");
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.scopeselected", (Object)this.displayModel.getSelectedNavigationNode());
        this.fireNavigationSelection(vConsoleEvent);
    }

    public void stop() throws CriticalStopException {
        if (!this.bRunning) {
            return;
        }
        this.bRunning = false;
        this.properties.setProperty("vconsole.iconstyle", this.origViewSetting);
    }

    public void waitOff() {
        this.properties.setProperty("vconsole.working", "false");
    }

    public void waitOn() {
        this.properties.setProperty("vconsole.working", "true");
    }
}

