/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.NisplusTableDefinitions;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import com.sun.wbem.utility.directorytable.TableSetup;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public class NisplusDirectoryTable
implements DirectoryTable,
TableSetup {
    TableDefinitions tableDefinitions;
    TableDefinitions passwdTableDefinitions;
    boolean needsFlush;
    String domainName;
    String serverName;
    String dataType = "";
    boolean isShadow = false;
    int sessionDescriptor = -1;

    public int access(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        String string = tableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.nisplusAccess(string, 16) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.nisplusAccess(string, 4) == 0) {
            n |= 1;
        }
        if (DirectoryTableLibrary.nisplusAccess(string, 8) == 0) {
            n |= 2;
        }
        if (DirectoryTableLibrary.nisplusAccess(string, 2) == 0) {
            n |= 8;
        }
        if (DirectoryTableLibrary.nisplusAccess(string, 1) == 0) {
            n |= 4;
        }
        return n;
    }

    public int access(String string) throws DirectoryTableException {
        int n = 0;
        NisplusTableDefinitions nisplusTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
        nisplusTableDefinitions.loadTableDefinitions(string);
        String string2 = nisplusTableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.nisplusAccess(string2, 16) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.nisplusAccess(string2, 4) == 0) {
            n |= 1;
        }
        if (DirectoryTableLibrary.nisplusAccess(string2, 8) == 0) {
            n |= 2;
        }
        if (DirectoryTableLibrary.nisplusAccess(string2, 2) == 0) {
            n |= 8;
        }
        if (DirectoryTableLibrary.nisplusAccess(string2, 1) == 0) {
            n |= 4;
        }
        return n;
    }

    public void addRow(DirectoryRow directoryRow) throws DirectoryTableException {
        int n = -1;
        int n2 = -1;
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        if (this.isShadow) {
            int n3 = 1;
            while (n3 <= directoryRow.getNumberOfRows()) {
                DirectoryRow directoryRow2 = new DirectoryRow(this.passwdTableDefinitions.getNumberOfColumns());
                String string = this.rowToShadowEntry(directoryRow, n3);
                directoryRow2.putColumn(this.passwdTableDefinitions.getColumnNumber("shadow"), string);
                directoryRow2.putColumn(this.passwdTableDefinitions.getColumnNumber("passwd"), directoryRow.getColumn(this.tableDefinitions.getColumnNumber("passwd"), n3));
                int n4 = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(directoryRow, n3, this.tableDefinitions.getColumnNumber("name")), this.passwdTableDefinitions.getColumnNumber("shadow"), this.rowToArray(directoryRow2, 1));
                DirectoryTableLibrary.nisplusErrorToException(n4, this.tableDefinitions);
                n4 = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(directoryRow, 1, this.tableDefinitions.getColumnNumber("name")), this.passwdTableDefinitions.getColumnNumber("passwd"), this.rowToArray(directoryRow2, 1));
                DirectoryTableLibrary.nisplusErrorToException(n4, this.tableDefinitions);
                ++n3;
            }
        } else {
            try {
                n = this.tableDefinitions.getColumnNumber("cname");
                n2 = this.tableDefinitions.getColumnNumber("aliases");
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                n = -1;
                n2 = -1;
            }
            if (n != -1 && n2 != -1) {
                int n5 = 1;
                while (n5 <= directoryRow.getNumberOfRows()) {
                    int n6;
                    DirectoryRow directoryRow3 = directoryRow.extractRows(n5, n5);
                    String string = directoryRow3.getColumn(n2);
                    if (string.compareTo("") == 0) {
                        directoryRow3.putColumn(n2, directoryRow3.getColumn(n));
                        n6 = DirectoryTableLibrary.nisplusAddEntry(this.sessionDescriptor, this.rowToArray(directoryRow3, 1));
                        DirectoryTableLibrary.nisplusErrorToException(n6, this.tableDefinitions);
                    } else {
                        String string2 = null;
                        StringTokenizer stringTokenizer = null;
                        stringTokenizer = new StringTokenizer(string, " \t");
                        while (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                            directoryRow3.putColumn(n2, string2);
                            n6 = DirectoryTableLibrary.nisplusAddEntry(this.sessionDescriptor, this.rowToArray(directoryRow3, 1));
                            DirectoryTableLibrary.nisplusErrorToException(n6, this.tableDefinitions);
                        }
                    }
                    ++n5;
                }
            } else {
                int n7 = 1;
                while (n7 <= directoryRow.getNumberOfRows()) {
                    int n8 = DirectoryTableLibrary.nisplusAddEntry(this.sessionDescriptor, this.rowToArray(directoryRow, n7));
                    DirectoryTableLibrary.nisplusErrorToException(n8, this.tableDefinitions);
                    ++n7;
                }
            }
        }
        this.needsFlush = true;
    }

    private void arrayIntoRow(String[] stringArray, int n, DirectoryRow directoryRow, int n2, int n3) throws DirectoryTableException {
        int n4 = this.tableDefinitions.getNumberOfColumns();
        if (n3 == 0) {
            n3 = (stringArray.length - n) / n4;
        }
        int n5 = n2;
        while (n5 < n2 + n3) {
            if (this.isShadow) {
                String string = stringArray[(n5 - n2) * n4 + n + (this.passwdTableDefinitions.getColumnNumber("shadow") - 1)];
                directoryRow.putColumn(this.tableDefinitions.getColumnNumber("name"), n5, stringArray[(n5 - n2) * n4 + n + (this.passwdTableDefinitions.getColumnNumber("name") - 1)]);
                directoryRow.putColumn(this.tableDefinitions.getColumnNumber("passwd"), n5, stringArray[(n5 - n2) * n4 + n + (this.passwdTableDefinitions.getColumnNumber("passwd") - 1)]);
                int n6 = this.tableDefinitions.getColumnNumber("passwd") + 1;
                int n7 = string.length();
                int n8 = -1;
                int n9 = 0;
                String string2 = null;
                n9 = string.indexOf(58, 0);
                while (n9 != -1 && n6 <= n4) {
                    if (n9 - n8 > 1) {
                        string2 = string.substring(n8 + 1, n9);
                        directoryRow.putColumn(n6, string2);
                    }
                    if ((n8 = n9) < n7 - 1) {
                        ++n6;
                        n9 = string.indexOf(58, n8 + 1);
                        continue;
                    }
                    break;
                }
            } else {
                int n10 = 0;
                while (n10 < n4) {
                    directoryRow.putColumn(n10 + 1, n5, stringArray[(n5 - n2) * n4 + n + n10]);
                    ++n10;
                }
            }
            ++n5;
        }
    }

    private DirectoryRow arrayToRow(String[] stringArray) throws DirectoryTableException {
        int n = this.tableDefinitions.getNumberOfColumns();
        DirectoryRow directoryRow = new DirectoryRow(n);
        if (this.isShadow) {
            String string = stringArray[this.passwdTableDefinitions.getColumnNumber("shadow") - 1];
            directoryRow.putColumn(this.tableDefinitions.getColumnNumber("name"), stringArray[this.passwdTableDefinitions.getColumnNumber("name") - 1]);
            directoryRow.putColumn(this.tableDefinitions.getColumnNumber("passwd"), stringArray[this.passwdTableDefinitions.getColumnNumber("passwd") - 1]);
            int n2 = this.tableDefinitions.getColumnNumber("passwd") + 1;
            int n3 = string.length();
            int n4 = -1;
            int n5 = 0;
            String string2 = null;
            n5 = string.indexOf(58, 0);
            while (n5 != -1 && n2 <= n) {
                if (n5 - n4 > 1) {
                    string2 = string.substring(n4 + 1, n5);
                    directoryRow.putColumn(n2, string2);
                }
                if ((n4 = n5) >= n3 - 1) break;
                ++n2;
                n5 = string.indexOf(58, n4 + 1);
            }
            if (n4 < n3 - 1 && n2 <= n) {
                string2 = string.substring(n4 + 1, n3);
                directoryRow.putColumn(n2, string2);
            }
        } else {
            int n6 = 0;
            while (n6 < n) {
                directoryRow.putColumn(n6 + 1, stringArray[n6]);
                ++n6;
            }
        }
        return directoryRow;
    }

    public void close() {
        try {
            this.flush();
        }
        catch (DirectoryTableException directoryTableException) {
            this.needsFlush = false;
        }
        DirectoryTableLibrary.nisplusCloseTable(this.sessionDescriptor);
        this.tableDefinitions = null;
        this.sessionDescriptor = -1;
        this.isShadow = false;
        this.dataType = "";
    }

    public void create(TableDefinitions tableDefinitions) throws DirectoryTableException {
        char c = tableDefinitions.getColumnSeparators().charAt(0);
        int n = DirectoryTableLibrary.convertAccessToRights(tableDefinitions.getAccess());
        int n2 = tableDefinitions.getNumberOfColumns();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = (tableDefinitions.getColumnAttributes(n3 + 1) & 1) == 1 ? "S" + tableDefinitions.getMappedColumnName(n3 + 1) : "N" + tableDefinitions.getMappedColumnName(n3 + 1);
            ++n3;
        }
        this.sessionDescriptor = DirectoryTableLibrary.nisplusAddTable(tableDefinitions.getMappedTableName(), tableDefinitions.getTableType(), n, stringArray, c);
        if (this.sessionDescriptor < 1) {
            int n4 = -this.sessionDescriptor;
            DirectoryTableLibrary.nisplusErrorToException(n4, tableDefinitions);
        }
        this.tableDefinitions = tableDefinitions;
        if (this.tableDefinitions.getTableName().equals("shadow")) {
            this.passwdTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
            this.passwdTableDefinitions.loadTableDefinitions("passwd");
            this.isShadow = true;
        }
        this.dataType = this.tableDefinitions.getTableType();
        this.needsFlush = false;
    }

    public void create(String string) throws DirectoryTableException {
        NisplusTableDefinitions nisplusTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
        nisplusTableDefinitions.loadTableDefinitions(string);
        char c = nisplusTableDefinitions.getColumnSeparators().charAt(0);
        int n = DirectoryTableLibrary.convertAccessToRights(nisplusTableDefinitions.getAccess());
        int n2 = nisplusTableDefinitions.getNumberOfColumns();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = (nisplusTableDefinitions.getColumnAttributes(n3 + 1) & 1) == 1 ? "S" + nisplusTableDefinitions.getMappedColumnName(n3 + 1) : "N" + nisplusTableDefinitions.getMappedColumnName(n3 + 1);
            ++n3;
        }
        this.sessionDescriptor = DirectoryTableLibrary.nisplusAddTable(nisplusTableDefinitions.getMappedTableName(), nisplusTableDefinitions.getTableType(), n, stringArray, c);
        if (this.sessionDescriptor < 1) {
            int n4 = -this.sessionDescriptor;
            DirectoryTableLibrary.nisplusErrorToException(n4, nisplusTableDefinitions);
        }
        this.tableDefinitions = nisplusTableDefinitions;
        if (this.tableDefinitions.getTableName().equals("shadow")) {
            this.passwdTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
            this.passwdTableDefinitions.loadTableDefinitions("passwd");
            this.isShadow = true;
        }
        this.dataType = this.tableDefinitions.getTableType();
        this.needsFlush = false;
    }

    public void delete(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        n = DirectoryTableLibrary.nisplusDeleteTable(tableDefinitions.getMappedTableName());
        DirectoryTableLibrary.nisplusErrorToException(n, tableDefinitions);
    }

    public void delete(String string) throws DirectoryTableException {
        int n = 0;
        NisplusTableDefinitions nisplusTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
        nisplusTableDefinitions.loadTableDefinitions(string);
        n = DirectoryTableLibrary.nisplusDeleteTable(nisplusTableDefinitions.getMappedTableName());
        DirectoryTableLibrary.nisplusErrorToException(n, nisplusTableDefinitions);
    }

    public void deleteRow(DirectoryRow directoryRow) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        if (this.isShadow) {
            int n = 1;
            while (n <= directoryRow.getNumberOfRows()) {
                DirectoryRow directoryRow2 = new DirectoryRow(this.passwdTableDefinitions.getNumberOfColumns());
                int n2 = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(directoryRow, n, this.tableDefinitions.getColumnNumber("name")), this.passwdTableDefinitions.getColumnNumber("shadow"), this.rowToArray(directoryRow2, 1));
                DirectoryTableLibrary.nisplusErrorToException(n2, this.tableDefinitions);
                ++n;
            }
        } else {
            int n = 1;
            while (n <= directoryRow.getNumberOfRows()) {
                int n3 = DirectoryTableLibrary.nisplusDeleteEntry(this.sessionDescriptor, this.rowToSearchName(directoryRow, n));
                DirectoryTableLibrary.nisplusErrorToException(n3, this.tableDefinitions);
                ++n;
            }
        }
        this.needsFlush = true;
    }

    public void flush() throws DirectoryTableException {
        if (this.needsFlush) {
            this.needsFlush = false;
        }
    }

    public DirectoryRow getAll() throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        String[] stringArray = DirectoryTableLibrary.nisplusGetAllEntries(this.sessionDescriptor, "");
        if (stringArray == null) {
            return directoryRow;
        }
        n = this.tableDefinitions.getNumberOfColumns();
        n2 = stringArray.length / n;
        directoryRow = new DirectoryRow(n, n2);
        this.arrayIntoRow(stringArray, 0, directoryRow, 1, n2);
        return directoryRow;
    }

    public DirectoryRow getAll(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        DirectoryRow directoryRow2 = searchTemplate.getTemplateAsRow(this.tableDefinitions);
        String string = directoryRow2 == null ? "" : this.rowToSearchName(directoryRow2, 1);
        String[] stringArray = DirectoryTableLibrary.nisplusGetAllEntries(this.sessionDescriptor, string);
        if (stringArray == null) {
            return null;
        }
        n2 = this.tableDefinitions.getNumberOfColumns();
        n3 = stringArray.length / n2;
        int n4 = 0;
        while (n4 < n3) {
            this.arrayIntoRow(stringArray, n4 * n2, directoryRow, n, 1);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, n, this.tableDefinitions)) {
                directoryRow.addRows(1);
                ++n;
            }
            ++n4;
        }
        directoryRow.deleteRow(n);
        if (n == 1) {
            return null;
        }
        return directoryRow;
    }

    public TableDefinitions getCurrentTableDefinitions() {
        return this.tableDefinitions;
    }

    public DirectoryRow getFirstRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getFirstRow(directoryRow);
    }

    public DirectoryRow getFirstRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = searchTemplate.getTemplateAsRow(this.tableDefinitions);
        String string = directoryRow == null ? "" : this.rowToSearchName(directoryRow, 1);
        String[] stringArray = DirectoryTableLibrary.nisplusGetFirstEntry(this.sessionDescriptor, string);
        if (stringArray == null) {
            return null;
        }
        DirectoryRow directoryRow2 = this.arrayToRow(stringArray);
        if (!directoryRow2.isEmpty() && searchTemplate.matchRow(directoryRow2, 1, this.tableDefinitions)) {
            return directoryRow2;
        }
        stringArray = DirectoryTableLibrary.nisplusGetNextEntry(this.sessionDescriptor);
        while (stringArray != null) {
            directoryRow2 = this.arrayToRow(stringArray);
            if (!directoryRow2.isEmpty() && searchTemplate.matchRow(directoryRow2, 1, this.tableDefinitions)) {
                return directoryRow2;
            }
            stringArray = DirectoryTableLibrary.nisplusGetNextEntry(this.sessionDescriptor);
        }
        return null;
    }

    public DirectoryRow getNextRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getNextRow(directoryRow);
    }

    public DirectoryRow getNextRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        String[] stringArray = DirectoryTableLibrary.nisplusGetNextEntry(this.sessionDescriptor);
        while (stringArray != null) {
            DirectoryRow directoryRow = this.arrayToRow(stringArray);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                return directoryRow;
            }
            stringArray = DirectoryTableLibrary.nisplusGetNextEntry(this.sessionDescriptor);
        }
        return null;
    }

    public DirectoryRow getRowInstance() {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
    }

    public DirectoryRow getRowInstance(int n) {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), n);
    }

    public Vector getScopes(int n) {
        String string;
        Vector<String> vector = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return vector;
        }
        String string2 = DirectoryTableLibrary.getDomain();
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '.') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.equals("")) {
            return vector;
        }
        NisplusTableDefinitions nisplusTableDefinitions = new NisplusTableDefinitions(string, string2);
        try {
            nisplusTableDefinitions.loadTableDefinitions("group");
        }
        catch (Exception exception) {
            return vector;
        }
        String string3 = nisplusTableDefinitions.getMappedTableName();
        if ((n & 2) == 2) {
            if (DirectoryTableLibrary.nisplusAccess(string3, 2) == 0) {
                vector = new Vector<String>();
                vector.addElement("nisplus:/" + string + "/" + string2);
            }
        } else if (DirectoryTableLibrary.nisplusAccess(string3, 1) == 0) {
            vector = new Vector();
            vector.addElement("nisplus:/" + string + "/" + string2);
        }
        return vector;
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new NisplusTableDefinitions(this.serverName, this.domainName);
    }

    public void modifyRow(DirectoryRow directoryRow, DirectoryRow directoryRow2) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        if (this.isShadow) {
            DirectoryRow directoryRow3 = new DirectoryRow(this.passwdTableDefinitions.getNumberOfColumns());
            String string = this.rowToShadowEntry(directoryRow2, 1);
            directoryRow3.putColumn(this.passwdTableDefinitions.getColumnNumber("shadow"), string);
            directoryRow3.putColumn(this.passwdTableDefinitions.getColumnNumber("passwd"), directoryRow2.getColumn(this.tableDefinitions.getColumnNumber("passwd"), 1));
            int n = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(directoryRow, 1, this.tableDefinitions.getColumnNumber("name")), this.passwdTableDefinitions.getColumnNumber("shadow"), this.rowToArray(directoryRow3, 1));
            DirectoryTableLibrary.nisplusErrorToException(n, this.tableDefinitions);
            n = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(directoryRow, 1, this.tableDefinitions.getColumnNumber("name")), this.passwdTableDefinitions.getColumnNumber("passwd"), this.rowToArray(directoryRow3, 1));
            DirectoryTableLibrary.nisplusErrorToException(n, this.tableDefinitions);
        } else {
            int n = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(directoryRow, 1), -1, this.rowToArray(directoryRow2, 1));
            DirectoryTableLibrary.nisplusErrorToException(n, this.tableDefinitions);
        }
        this.needsFlush = true;
    }

    public void open(TableDefinitions tableDefinitions) throws DirectoryTableException {
        this.sessionDescriptor = DirectoryTableLibrary.nisplusOpenTable(tableDefinitions.getMappedTableName(), tableDefinitions.getTableType());
        if (this.sessionDescriptor < 1) {
            int n = -this.sessionDescriptor;
            DirectoryTableLibrary.nisplusErrorToException(n, tableDefinitions);
        }
        this.tableDefinitions = tableDefinitions;
        if (this.tableDefinitions.getTableName().equals("shadow")) {
            this.passwdTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
            this.passwdTableDefinitions.loadTableDefinitions("passwd");
            this.isShadow = true;
        }
        this.dataType = this.tableDefinitions.getTableType();
        this.needsFlush = false;
    }

    public void open(String string) throws DirectoryTableException {
        NisplusTableDefinitions nisplusTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
        nisplusTableDefinitions.loadTableDefinitions(string);
        this.sessionDescriptor = DirectoryTableLibrary.nisplusOpenTable(nisplusTableDefinitions.getMappedTableName(), nisplusTableDefinitions.getTableType());
        if (this.sessionDescriptor < 1) {
            int n = -this.sessionDescriptor;
            DirectoryTableLibrary.nisplusErrorToException(n, nisplusTableDefinitions);
        }
        this.tableDefinitions = nisplusTableDefinitions;
        if (this.tableDefinitions.getTableName().equals("shadow")) {
            this.passwdTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
            this.passwdTableDefinitions.loadTableDefinitions("passwd");
            this.isShadow = true;
        }
        this.dataType = this.tableDefinitions.getTableType();
        this.needsFlush = false;
    }

    public void refreshSetup() {
    }

    private String[] rowToArray(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2 = directoryRow.getNumberOfColumns();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = directoryRow.getColumn(n3 + 1, n);
            ++n3;
        }
        return stringArray;
    }

    private String rowToSearchName(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2 = directoryRow.getNumberOfColumns();
        boolean bl = true;
        String string = new String("");
        int n3 = 1;
        while (n3 <= n2) {
            if ((this.tableDefinitions.getColumnAttributes(n3) & 1) == 1 && !directoryRow.getColumn(n3, n).equals("")) {
                if (bl) {
                    string = String.valueOf(string) + "[";
                    bl = false;
                } else {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + this.tableDefinitions.getMappedColumnName(n3) + "=\"" + directoryRow.getColumn(n3, n) + "\"";
            }
            ++n3;
        }
        if (!bl) {
            string = String.valueOf(string) + "],";
        }
        return string;
    }

    private String rowToSearchName(DirectoryRow directoryRow, int n, int n2) throws DirectoryTableException {
        String string = new String("");
        string = "[" + this.tableDefinitions.getMappedColumnName(n2) + "=\"" + directoryRow.getColumn(n2, n) + "\"],";
        return string;
    }

    private String rowToShadowEntry(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2 = this.tableDefinitions.getNumberOfColumns();
        String string = new String("");
        int n3 = 3;
        while (n3 < n2) {
            string = String.valueOf(string) + directoryRow.getColumn(n3, n) + ":";
            ++n3;
        }
        string = String.valueOf(string) + directoryRow.getColumn(n3, n);
        return string;
    }

    public void setContext(String string) throws DirectoryTableException {
        this.serverName = DirectoryUtility.getContextProperty(string, "serverName");
        this.domainName = DirectoryUtility.getContextProperty(string, "domainName");
        if (!DirectoryUtility.isLocalServer(this.serverName)) {
            throw new DirectoryTableOperationNotSupportedException("Remote NIS+");
        }
    }

    public void setup() {
    }
}

