/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.TableDefinitions;

public class DirectoryTableLibrary {
    public static final String DIRECTORY_TABLE_LIBRARY = "provutil";
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int R_OK = 4;
    public static final int W_OK = 2;
    public static final int X_OK = 1;
    public static final int F_OK = 0;
    public static final int NIS_EXIST_ACC = 16;
    public static final int NIS_READ_ACC = 1;
    public static final int NIS_MODIFY_ACC = 2;
    public static final int NIS_CREATE_ACC = 4;
    public static final int NIS_DESTROY_ACC = 8;
    public static final int NIS_WORLD_SHIFT = 0;
    public static final int NIS_GROUP_SHIFT = 8;
    public static final int NIS_OWNER_SHIFT = 16;
    public static final int NIS_NOBODY_SHIFT = 24;
    public static final int EPERM = 1;
    public static final int ENOENT = 2;
    public static final int ESRCH = 3;
    public static final int EINTR = 4;
    public static final int EIO = 5;
    public static final int ENXIO = 6;
    public static final int E2BIG = 7;
    public static final int ENOEXEC = 8;
    public static final int EBADF = 9;
    public static final int ECHILD = 10;
    public static final int EAGAIN = 11;
    public static final int ENOMEM = 12;
    public static final int EACCES = 13;
    public static final int EFAULT = 14;
    public static final int ENOTBLK = 15;
    public static final int EBUSY = 16;
    public static final int EEXIST = 17;
    public static final int EXDEV = 18;
    public static final int ENODEV = 19;
    public static final int ENOTDIR = 20;
    public static final int EISDIR = 21;
    public static final int EINVAL = 22;
    public static final int ENFILE = 23;
    public static final int EMFILE = 24;
    public static final int ENOTTY = 25;
    public static final int ETXTBSY = 26;
    public static final int EFBIG = 27;
    public static final int ENOSPC = 28;
    public static final int ESPIPE = 29;
    public static final int EROFS = 30;
    public static final int EMLINK = 31;
    public static final int EPIPE = 32;
    public static final int EDOM = 33;
    public static final int ERANGE = 34;
    public static final int ENOMSG = 35;
    public static final int EIDRM = 36;
    public static final int ECHRNG = 37;
    public static final int EL2NSYNC = 38;
    public static final int EL3HLT = 39;
    public static final int EL3RST = 40;
    public static final int ELNRNG = 41;
    public static final int EUNATCH = 42;
    public static final int ENOCSI = 43;
    public static final int EL2HLT = 44;
    public static final int EDEADLK = 45;
    public static final int ENOLCK = 46;
    public static final int ECANCELED = 47;
    public static final int ENOTSUP = 48;
    public static final int EDQUOT = 49;
    public static final int EBADE = 50;
    public static final int EBADR = 51;
    public static final int EXFULL = 52;
    public static final int ENOANO = 53;
    public static final int EBADRQC = 54;
    public static final int EBADSLT = 55;
    public static final int EDEADLOCK = 56;
    public static final int EBFONT = 57;
    public static final int ELIBACC = 83;
    public static final int ELIBBAD = 84;
    public static final int ELIBSCN = 85;
    public static final int ELIBMAX = 86;
    public static final int ELIBEXEC = 87;
    public static final int EILSEQ = 88;
    public static final int ENOSYS = 89;
    public static final int ELOOP = 90;
    public static final int ERESTART = 91;
    public static final int ESTRPIPE = 92;
    public static final int ENOTEMPTY = 93;
    public static final int EUSERS = 94;
    public static final int LDAP_SUCCESS = 0;
    public static final int LDAP_OPERATIONS_ERROR = 1;
    public static final int LDAP_PROTOCOL_ERROR = 2;
    public static final int LDAP_TIMELIMIT_EXCEEDED = 3;
    public static final int LDAP_SIZELIMIT_EXCEEDED = 4;
    public static final int LDAP_COMPARE_FALSE = 5;
    public static final int LDAP_COMPARE_TRUE = 6;
    public static final int LDAP_AUTH_METHOD_NOT_SUPPORTED = 7;
    public static final int LDAP_STRONG_AUTH_REQUIRED = 8;
    public static final int LDAP_PARTIAL_RESULTS = 9;
    public static final int LDAP_REFERRAL = 10;
    public static final int LDAP_ADMINLIMIT_EXCEEDED = 11;
    public static final int LDAP_UNAVAILABLE_CRITICAL_EXTENSION = 12;
    public static final int LDAP_CONFIDENTIALITY_REQUIRED = 13;
    public static final int LDAP_SASL_BIND_INPROGRESS = 14;
    public static final int LDAP_NO_SUCH_ATTRIBUTE = 16;
    public static final int LDAP_UNDEFINED_TYPE = 17;
    public static final int LDAP_INAPPROPRIATE_MATCHING = 18;
    public static final int LDAP_CONSTRAINT_VIOLATION = 19;
    public static final int LDAP_TYPE_OR_VALUE_EXISTS = 20;
    public static final int LDAP_INVALID_SYNTAX = 21;
    public static final int LDAP_NO_SUCH_OBJECT = 32;
    public static final int LDAP_ALIAS_PROBLEM = 33;
    public static final int LDAP_INVALID_DN_SYNTAX = 34;
    public static final int LDAP_IS_LEAF = 35;
    public static final int LDAP_ALIAS_DEREF_PROBLEM = 36;
    public static final int LDAP_INAPPROPRIATE_AUTH = 48;
    public static final int LDAP_INVALID_CREDENTIALS = 49;
    public static final int LDAP_INSUFFICIENT_ACCESS = 50;
    public static final int LDAP_BUSY = 51;
    public static final int LDAP_UNAVAILABLE = 52;
    public static final int LDAP_UNWILLING_TO_PERFORM = 53;
    public static final int LDAP_LOOP_DETECT = 54;
    public static final int LDAP_NAMING_VIOLATION = 64;
    public static final int LDAP_OBJECT_CLASS_VIOLATION = 65;
    public static final int LDAP_NOT_ALLOWED_ON_NONLEAF = 66;
    public static final int LDAP_NOT_ALLOWED_ON_RDN = 67;
    public static final int LDAP_ALREADY_EXISTS = 68;
    public static final int LDAP_NO_OBJECT_CLASS_MODS = 69;
    public static final int LDAP_RESULTS_TOO_LARGE = 70;
    public static final int LDAP_AFFECTS_MULTIPLE_DSAS = 71;
    public static final int LDAP_OTHER = 80;
    public static final int LDAP_SERVER_DOWN = 81;
    public static final int LDAP_LOCAL_ERROR = 82;
    public static final int LDAP_ENCODING_ERROR = 83;
    public static final int LDAP_DECODING_ERROR = 84;
    public static final int LDAP_TIMEOUT = 85;
    public static final int LDAP_AUTH_UNKNOWN = 86;
    public static final int LDAP_FILTER_ERROR = 87;
    public static final int LDAP_USER_CANCELLED = 88;
    public static final int LDAP_PARAM_ERROR = 89;
    public static final int LDAP_NO_MEMORY = 90;
    public static final int LDAP_CONNECT_ERROR = 91;
    public static final int LDAP_NOT_SUPPORTED = 92;
    public static final int LDAP_CONTROL_NOT_FOUND = 93;
    public static final int LDAP_NO_RESULTS_RETURNED = 94;
    public static final int LDAP_MORE_RESULTS_TO_RETURN = 95;
    public static final int LDAP_CLIENT_LOOP = 96;
    public static final int LDAP_REFERRAL_LIMIT_EXCEEDED = 97;
    public static final int NIS_SUCCESS = 0;
    public static final int NIS_S_SUCCESS = 1;
    public static final int NIS_NOTFOUND = 2;
    public static final int NIS_S_NOTFOUND = 3;
    public static final int NIS_CACHEEXPIRED = 4;
    public static final int NIS_NAMEUNREACHABLE = 5;
    public static final int NIS_UNKNOWNOBJ = 6;
    public static final int NIS_TRYAGAIN = 7;
    public static final int NIS_SYSTEMERROR = 8;
    public static final int NIS_CHAINBROKEN = 9;
    public static final int NIS_PERMISSION = 10;
    public static final int NIS_NOTOWNER = 11;
    public static final int NIS_NOT_ME = 12;
    public static final int NIS_NOMEMORY = 13;
    public static final int NIS_NAMEEXISTS = 14;
    public static final int NIS_NOTMASTER = 15;
    public static final int NIS_INVALIDOBJ = 16;
    public static final int NIS_BADNAME = 17;
    public static final int NIS_NOCALLBACK = 18;
    public static final int NIS_CBRESULTS = 19;
    public static final int NIS_NOSUCHNAME = 20;
    public static final int NIS_NOTUNIQUE = 21;
    public static final int NIS_IBMODERROR = 22;
    public static final int NIS_NOSUCHTABLE = 23;
    public static final int NIS_TYPEMISMATCH = 24;
    public static final int NIS_LINKNAMEERROR = 25;
    public static final int NIS_PARTIAL = 26;
    public static final int NIS_TOOMANYATTRS = 27;
    public static final int NIS_RPCERROR = 28;
    public static final int NIS_BADATTRIBUTE = 29;
    public static final int NIS_NOTSEARCHABLE = 30;
    public static final int NIS_CBERROR = 31;
    public static final int NIS_FOREIGNNS = 32;
    public static final int NIS_BADOBJECT = 33;
    public static final int NIS_NOTSAMEOBJ = 34;
    public static final int NIS_MODFAIL = 35;
    public static final int NIS_BADREQUEST = 36;
    public static final int NIS_NOTEMPTY = 37;
    public static final int NIS_COLDSTART_ERR = 38;
    public static final int NIS_RESYNC = 39;
    public static final int NIS_FAIL = 40;
    public static final int NIS_UNAVAIL = 41;
    public static final int NIS_RES2BIG = 42;
    public static final int NIS_SRVAUTH = 43;
    public static final int NIS_CLNTAUTH = 44;
    public static final int NIS_NOFILESPACE = 45;
    public static final int NIS_NOPROC = 46;
    public static final int NIS_DUMPLATER = 47;
    public static final int NIS_MODIFY_ALL = -1;
    private static boolean library_loaded = false;

    static {
        try {
            System.loadLibrary(DIRECTORY_TABLE_LIBRARY);
            library_loaded = true;
        }
        catch (SecurityException securityException) {
            System.err.println(securityException);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(unsatisfiedLinkError);
        }
    }

    public static native int addressCompare(String var0, String var1);

    public static int convertAccessToMode(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 0x100;
        }
        if ((n & 0xE) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x20;
        }
        if ((n & 0xE0) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x100) != 0) {
            n2 |= 4;
        }
        if ((n & 0xE00) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    public static int convertAccessToRights(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 0x10000;
        }
        if ((n & 2) != 0) {
            n2 |= 0x20000;
        }
        if ((n & 4) != 0) {
            n2 |= 0x40000;
        }
        if ((n & 8) != 0) {
            n2 |= 0x80000;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x100;
        }
        if ((n & 0x20) != 0) {
            n2 |= 0x200;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x400;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x800;
        }
        if ((n & 0x100) != 0) {
            n2 |= 1;
        }
        if ((n & 0x200) != 0) {
            n2 |= 2;
        }
        if ((n & 0x400) != 0) {
            n2 |= 4;
        }
        if ((n & 0x800) != 0) {
            n2 |= 8;
        }
        if ((n & 0x1000) != 0) {
            n2 |= 0x1000000;
        }
        if ((n & 0x2000) != 0) {
            n2 |= 0x2000000;
        }
        if ((n & 0x4000) != 0) {
            n2 |= 0x4000000;
        }
        if ((n & 0x8000) != 0) {
            n2 |= 0x8000000;
        }
        return n2;
    }

    public static void errnoToException(int n, TableDefinitions tableDefinitions) throws DirectoryTableException {
        switch (n) {
            case 0: {
                return;
            }
            case 30: {
                throw new DirectoryTableAccessException("EXM_READONLY");
            }
            case 1: 
            case 13: {
                throw new DirectoryTableAccessException("EXM_PERM");
            }
            case 2: {
                throw new DirectoryTableDoesNotExistException(tableDefinitions.getTableName(), "file or table", tableDefinitions.getMappedTableName());
            }
        }
        throw new DirectoryTableException("EXM_INTERNAL");
    }

    public static native int fileAccess(String var0, int var1);

    public static native int fileCopyStat(String var0, String var1);

    public static native int fileCreate(String var0, int var1, int var2, int var3);

    public static native int fileDelete(String var0);

    public static native String getDomain();

    public static native int ldapAccess(String var0, int var1, String var2, String var3);

    public static native int ldapAddEntry(int var0, String var1, String[] var2);

    public static native int ldapAddTable(String var0, int var1, String[] var2, String var3, String var4);

    public static native void ldapCloseTable(int var0);

    public static native int ldapDeleteEntry(int var0, String var1);

    public static native int ldapDeleteTable(String var0, String var1, String var2);

    public static void ldapErrorToException(int n, TableDefinitions tableDefinitions) throws DirectoryTableException {
        switch (n) {
            default: {
                throw new DirectoryTableException("EXM_LDAP", DirectoryTableLibrary.ldapGetErrorString(n));
            }
            case 0: 
        }
    }

    public static native String[] ldapGetAllEntries(int var0, String var1);

    public static native String ldapGetErrorString(int var0);

    public static native String[] ldapGetFirstEntry(int var0, String var1);

    public static native String[] ldapGetNextEntry(int var0);

    public static native int ldapModifyEntry(int var0, String var1, String[] var2);

    public static native int ldapOpenTable(String var0, String var1, String[] var2, String var3, String var4);

    public static native boolean matchRegexp(String var0, String var1);

    public static native String nisGetMaster(String var0, String var1);

    public static native int nisplusAccess(String var0, int var1);

    public static native int nisplusAddEntry(int var0, String[] var1);

    public static native int nisplusAddTable(String var0, String var1, int var2, String[] var3, char var4);

    public static native void nisplusCloseTable(int var0);

    public static native int nisplusDeleteEntry(int var0, String var1);

    public static native int nisplusDeleteTable(String var0);

    public static void nisplusErrorToException(int n, TableDefinitions tableDefinitions) throws DirectoryTableException {
        switch (n) {
            case 2: 
            case 3: 
            case 5: 
            case 20: 
            case 30: {
                throw new DirectoryTableRowNotFoundException();
            }
            case 23: {
                throw new DirectoryTableDoesNotExistException(tableDefinitions.getTableName(), "NIS+ table", tableDefinitions.getMappedTableName());
            }
            case 14: 
            case 21: {
                throw new DirectoryTableRowNotUniqueException();
            }
            case 10: 
            case 11: 
            case 12: 
            case 43: 
            case 44: {
                throw new DirectoryTableAccessException("EXM_PERM");
            }
            case 22: 
            case 35: {
                throw new DirectoryTableException("EXM_INTERNAL");
            }
            case 7: {
                throw new DirectoryTableConnectionException("EXM_TRYAGAIN");
            }
            case 28: 
            case 41: {
                throw new DirectoryTableConnectionException("EXM_NISPLUSNET");
            }
            case 37: {
                throw new DirectoryTableException("EXM_INTERNAL");
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 47: {
                throw new DirectoryTableException("EXM_NISPLUS", DirectoryTableLibrary.nisplusGetErrorString(n));
            }
        }
    }

    public static native String[] nisplusGetAllEntries(int var0, String var1);

    public static native String nisplusGetErrorString(int var0);

    public static native String[] nisplusGetFirstEntry(int var0, String var1);

    public static native String[] nisplusGetNextEntry(int var0);

    public static native int nisplusModifyEntry(int var0, String var1, int var2, String[] var3);

    public static native int nisplusOpenTable(String var0, String var1);
}

