/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMException;

class ReadersWriters {
    private String name;
    private int turn = 0;
    private int currentTurn = 0;
    private int numReaders = 0;
    private int numWriters = 0;
    private ThreadLocal tl = new ThreadLocal();
    private int count = 0;

    public ReadersWriters(String string) {
        this.name = string;
    }

    private boolean checkThreadStart(boolean bl) throws CIMException {
        RWEntry rWEntry = (RWEntry)this.tl.get();
        if (rWEntry != null) {
            if (bl && !rWEntry.writer) {
                throw new CIMException("CIM_ERR_FAILED", (Object)"Reader cant become writer");
            }
            ++rWEntry.numLocks;
            return true;
        }
        rWEntry = new RWEntry();
        rWEntry.writer = bl;
        rWEntry.count = this.count++;
        this.tl.set(rWEntry);
        return false;
    }

    private boolean checkThreadStop() throws CIMException {
        RWEntry rWEntry = (RWEntry)this.tl.get();
        if (rWEntry != null) {
            --rWEntry.numLocks;
            if (rWEntry.numLocks == 0) {
                this.tl.set(null);
                return false;
            }
            return true;
        }
        throw new CIMException("CIM_ERR_FAILED", (Object)"Thread not active!");
    }

    public void endRead() throws CIMException {
        if (this.checkThreadStop()) {
            return;
        }
        ReadersWriters readersWriters = this;
        synchronized (readersWriters) {
            --this.numReaders;
            if (this.numReaders == 0) {
                this.notifyAll();
            }
        }
    }

    public void endWrite() throws CIMException {
        if (this.checkThreadStop()) {
            return;
        }
        ReadersWriters readersWriters = this;
        synchronized (readersWriters) {
            --this.numWriters;
            ++this.currentTurn;
            this.notifyAll();
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized void startRead() throws CIMException {
        if (this.checkThreadStart(false)) {
            return;
        }
        ReadersWriters readersWriters = this;
        synchronized (readersWriters) {
            int n = this.turn++;
            while (n != this.currentTurn) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.currentTurn;
            this.notifyAll();
            ++this.numReaders;
        }
    }

    public void startWrite() throws CIMException {
        if (this.checkThreadStart(true)) {
            return;
        }
        ReadersWriters readersWriters = this;
        synchronized (readersWriters) {
            int n = this.turn++;
            while (n != this.currentTurn || this.numReaders != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.numWriters;
        }
    }

    private class RWEntry {
        int count = 0;
        int numLocks = 1;
        boolean writer = false;

        RWEntry() {
        }
    }
}

