/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.common.AdminSecurityUtil;
import com.sun.wbem.solarisprovider.usermgr.common.SolAccountAttr;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class SolarisShadowTable {
    private static String tableName = "shadow";
    private String emptyString = new String("");
    private String fileType = new String("File");
    private long secondsInaDay = 86400L;
    private String GMT_TIMEZONE = "GMT";
    private String nullPassword = "";
    private String accountLockedValue = "*LK*";
    private String nameCol = "name";
    private String passwdCol = "passwd";
    private String lastchngCol = "lastchg";
    private String minCol = "min";
    private String maxCol = "max";
    private String warnCol = "warn";
    private String inactiveCol = "inactive";
    private String exCol = "expire";
    private String flagCol = "flag";
    private String scope;

    public SolarisShadowTable(String string) throws Exception {
        this.scope = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addShadowRow(FlatUserObj flatUserObj, ProviderUtility providerUtility) throws Exception {
        String string = this.nullPassword;
        String string2 = this.nullPassword;
        if (flatUserObj.getCurPassword() != null && flatUserObj.getCurPassword().trim().length() != 0) {
            string2 = providerUtility.decryptPassword(flatUserObj.getCurPassword());
            string = AdminSecurityUtil.createUnixPassword(string2);
            string2 = "";
        }
        DirectoryTable directoryTable = null;
        directoryTable = this.openShadowTable();
        try {
            block21: {
                try {
                    TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                    DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                    if (flatUserObj.getUserName() != null) {
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), flatUserObj.getUserName());
                    }
                    if (string != null) {
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.passwdCol), string);
                    }
                    if (flatUserObj.getMustChangePasswdInDays() != null) {
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.minCol), flatUserObj.getMustChangePasswdInDays());
                    }
                    if (flatUserObj.getDoNotReUsePwdForDays() != null) {
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.maxCol), flatUserObj.getDoNotReUsePwdForDays());
                    }
                    if (flatUserObj.getWarnBeforePwdExpiresDays() != null) {
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.warnCol), flatUserObj.getWarnBeforePwdExpiresDays());
                    }
                    if (flatUserObj.getPwdInactiveDays() != null) {
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.inactiveCol), flatUserObj.getPwdInactiveDays());
                    }
                    String string3 = "";
                    if (flatUserObj.getAccountExpireDate() != null) {
                        string3 = this.setUpExpirationDate(flatUserObj.getAccountExpireDate());
                    }
                    if (string3 != null) {
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.exCol), string3);
                    }
                    directoryTable.addRow(directoryRow);
                    String string4 = providerUtility.getScopeType(this.scope);
                    if (!string4.equals("nisplus")) break block21;
                    this.setupCredTableEntry(flatUserObj, providerUtility);
                    flatUserObj.setCurPassword("");
                }
                catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                    directoryTableInvalidParameterException.printStackTrace();
                    throw directoryTableInvalidParameterException;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    directoryTableAccessException.printStackTrace();
                    throw directoryTableAccessException;
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    directoryTableConnectionException.printStackTrace();
                    throw directoryTableConnectionException;
                }
                catch (DirectoryTableException directoryTableException) {
                    directoryTableException.printStackTrace();
                    throw directoryTableException;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
            Object var7_18 = null;
            if (directoryTable == null) return;
        }
        catch (Throwable throwable) {
            Object var7_19 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteShadowRow(FlatUserObj flatUserObj, ProviderUtility providerUtility) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block12: {
            block11: {
                directoryTable = null;
                directoryTable = this.openShadowTable();
                try {
                    try {
                        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                        DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), flatUserObj.getUserName());
                        directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                        if (directoryRow == null) {
                            this.removeCredTableEntry(flatUserObj, providerUtility);
                            Object var5_12 = null;
                            if (directoryTable == null) return;
                            break block11;
                        }
                        this.removeCredTableEntry(flatUserObj, providerUtility);
                        directoryTable.deleteRow(directoryRow);
                        break block12;
                    }
                    catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                        throw directoryTableInvalidParameterException;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        throw directoryTableAccessException;
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        throw directoryTableConnectionException;
                    }
                    catch (DirectoryTableException directoryTableException) {
                        throw directoryTableException;
                    }
                    catch (Exception exception) {
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_14 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return;
        }
        Object var5_13 = null;
        if (directoryTable == null) return;
        directoryTable.close();
    }

    private String getExpirationDate(String string) {
        String string2 = "";
        long l = Long.parseLong(string);
        long l2 = l * this.secondsInaDay + 1L;
        Date date = new Date(l2 *= 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SolAccountAttr.DATE_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        simpleDateFormat.setLenient(false);
        String string3 = simpleDateFormat.format(date);
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FlatUserObj getShadowRow(FlatUserObj flatUserObj) throws Exception {
        DirectoryTable directoryTable = null;
        directoryTable = this.openShadowTable();
        flatUserObj.setChangePasswd(false);
        flatUserObj.setCurPassword(null);
        flatUserObj.setAccountExpireDate(null);
        String string = flatUserObj.getUserName();
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                flatUserObj.setMustChangePasswdInDays(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.minCol)));
                flatUserObj.setDoNotReUsePwdForDays(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.maxCol)));
                flatUserObj.setWarnBeforePwdExpiresDays(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.warnCol)));
                flatUserObj.setPwdInactiveDays(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.inactiveCol)));
                String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.passwdCol));
                if (string2.equals(this.accountLockedValue)) {
                    flatUserObj.setIsAccountLocked(true);
                } else {
                    flatUserObj.setIsAccountLocked(false);
                }
                String string3 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.exCol));
                if (string3 != null && !string3.equals("")) {
                    flatUserObj.setAccountExpireDate(this.getExpirationDate(string3));
                } else {
                    flatUserObj.setAccountExpireDate("");
                }
                if (string2.length() != 0) {
                    flatUserObj.setHasPasswd(true);
                } else {
                    flatUserObj.setHasPasswd(false);
                }
                flatUserObj.setChangePasswd(false);
                flatUserObj.setCurPassword(null);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var5_14 = null;
            if (directoryTable == null) return flatUserObj;
        }
        catch (Throwable throwable) {
            Object var5_15 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return flatUserObj;
    }

    private boolean isCredProcessingNecessary() {
        String string = "on";
        return true;
    }

    private void modifyCredUserName(String string, String string2, ProviderUtility providerUtility) throws DirectoryTableException {
        Vector vector;
        String string3;
        String string4 = providerUtility.getScopeType(this.scope);
        if (!string4.equals("nisplus")) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            return;
        }
        String string5 = providerUtility.getScopeDomainName(this.scope);
        String string6 = new String(String.valueOf(string2) + "." + string5);
        if (!string6.endsWith(".")) {
            string6 = string6.concat(".");
        }
        if (!(string3 = new String(String.valueOf(string) + "." + string5)).endsWith(".")) {
            string3 = string3.concat(".");
        }
        String string7 = new String("/usr/bin/nistbladm -E cname=" + string3 + " [cname=" + string6 + ",auth_type=LOCAL],cred.org_dir");
        try {
            vector = AdminCommonTools.CMN_exec(string7, true);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("change principal in cred table failed");
        }
        string7 = new String("/usr/bin/nistbladm -E cname=" + string3 + " [cname=" + string6 + ",auth_type=DES],cred.org_dir");
        try {
            vector = AdminCommonTools.CMN_exec(string7, true);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("nistbladm to change principal name in cred table failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyShadowRow(FlatUserObj flatUserObj, ProviderUtility providerUtility) throws Exception {
        DirectoryTable directoryTable;
        block30: {
            block28: {
                directoryTable = null;
                directoryTable = this.openShadowTable();
                String string = "";
                try {
                    try {
                        String string2;
                        DirectoryRow directoryRow;
                        DirectoryRow directoryRow2;
                        TableDefinitions tableDefinitions;
                        block29: {
                            tableDefinitions = directoryTable.getCurrentTableDefinitions();
                            directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.nameCol), flatUserObj.getUserName());
                            directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow2);
                            if (directoryRow2 == null) {
                                this.addShadowRow(flatUserObj, providerUtility);
                                Object var6_13 = null;
                                if (directoryTable == null) return;
                                break block28;
                            }
                            directoryRow = directoryRow2.extractRows(1, 1);
                            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), flatUserObj.getUserName());
                            string2 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(this.passwdCol));
                            if (!flatUserObj.getChangePasswd()) break block29;
                            string2 = this.nullPassword;
                            try {
                                if (flatUserObj.getCurPassword() != null && flatUserObj.getCurPassword().trim().length() != 0) {
                                    string = providerUtility.decryptPassword(flatUserObj.getCurPassword());
                                    string2 = AdminSecurityUtil.createUnixPassword(string);
                                }
                            }
                            catch (Exception exception) {
                                System.out.println("Shadow Entry " + flatUserObj.getUserName() + " could not decrypt password");
                                throw exception;
                            }
                        }
                        String string3 = this.setUpExpirationDate(flatUserObj.getAccountExpireDate());
                        if (flatUserObj.getIsAccountLocked()) {
                            string2 = this.accountLockedValue;
                        } else if (string2.equals(this.accountLockedValue)) {
                            string2 = this.nullPassword;
                        }
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.passwdCol), string2);
                        if (flatUserObj.getMustChangePasswdInDays() != null) {
                            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.minCol), flatUserObj.getMustChangePasswdInDays());
                        }
                        if (flatUserObj.getDoNotReUsePwdForDays() != null) {
                            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.maxCol), flatUserObj.getDoNotReUsePwdForDays());
                        }
                        if (flatUserObj.getWarnBeforePwdExpiresDays() != null) {
                            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.warnCol), flatUserObj.getWarnBeforePwdExpiresDays());
                        }
                        if (flatUserObj.getPwdInactiveDays() != null) {
                            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.inactiveCol), flatUserObj.getPwdInactiveDays());
                        }
                        if (string3 != null) {
                            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.exCol), string3);
                        }
                        directoryTable.modifyRow(directoryRow2, directoryRow);
                        if (string.trim().length() != 0) {
                            this.setupCredTableEntry(flatUserObj, providerUtility);
                            string = "";
                        }
                        break block30;
                    }
                    catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                        throw directoryTableInvalidParameterException;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        throw directoryTableAccessException;
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        throw directoryTableConnectionException;
                    }
                    catch (DirectoryTableException directoryTableException) {
                        throw directoryTableException;
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_15 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    string = "";
                    throw throwable;
                }
            }
            directoryTable.close();
            return;
        }
        Object var6_14 = null;
        if (directoryTable == null) return;
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyShadowUsername(String string, String string2, ProviderUtility providerUtility) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block15: {
            block14: {
                if (string2 == null) return;
                if (string2.trim().length() == 0) {
                    return;
                }
                directoryTable = null;
                directoryTable = this.openShadowTable();
                try {
                    try {
                        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                        DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), string2);
                        directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                        if (directoryRow == null) {
                            try {
                                this.modifyCredUserName(string, string2, providerUtility);
                            }
                            catch (Exception exception) {
                            }
                            Object var6_13 = null;
                            if (directoryTable == null) return;
                            break block14;
                        }
                        DirectoryRow directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.nameCol), string2);
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), string);
                        directoryTable.modifyRow(directoryRow2, directoryRow);
                        this.modifyCredUserName(string, string2, providerUtility);
                        break block15;
                    }
                    catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                        throw directoryTableInvalidParameterException;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        throw directoryTableAccessException;
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        throw directoryTableConnectionException;
                    }
                    catch (DirectoryTableException directoryTableException) {
                        throw directoryTableException;
                    }
                    catch (Exception exception) {
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_15 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return;
        }
        Object var6_14 = null;
        if (directoryTable == null) return;
        directoryTable.close();
    }

    private DirectoryTable openShadowTable() throws DirectoryTableException {
        try {
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(tableName);
            return directoryTable;
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw directoryTableInvalidParameterException;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw directoryTableDoesNotExistException;
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw directoryTableConnectionException;
        }
        catch (DirectoryTableException directoryTableException) {
            throw directoryTableException;
        }
    }

    private void removeCredTableEntry(FlatUserObj flatUserObj, ProviderUtility providerUtility) throws DirectoryTableException {
        String string = providerUtility.getScopeType(this.scope);
        if (!string.equals("nisplus")) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            return;
        }
        String string2 = providerUtility.getScopeDomainName(this.scope);
        String string3 = flatUserObj.getUserName();
        if (string3 == null || string3.trim().length() == 0) {
            return;
        }
        String string4 = new String(String.valueOf(string3) + "." + string2);
        if (!string4.endsWith(".")) {
            string4 = string4.concat(".");
        }
        String string5 = new String("nisaddcred -r " + string4);
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string5);
            process.getInputStream().close();
            process.getErrorStream().close();
        }
        catch (Exception exception) {}
    }

    private String setUpExpirationDate(String string) {
        Date date;
        String string2 = "";
        if (string == null || string.equals("")) {
            return string2;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SolAccountAttr.DATE_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        simpleDateFormat.setLenient(false);
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            return string2;
        }
        long l = date.getTime();
        l /= 1000L;
        string2 = String.valueOf(l /= this.secondsInaDay);
        return string2;
    }

    private void setupCredTableEntry(FlatUserObj flatUserObj, ProviderUtility providerUtility) {
        Object object;
        String string = providerUtility.getScopeType(this.scope);
        if (!string.equals("nisplus")) {
            return;
        }
        String string2 = null;
        if (flatUserObj.getCurPassword() != null && flatUserObj.getCurPassword().trim().length() != 0) {
            string2 = providerUtility.decryptPassword(flatUserObj.getCurPassword());
        }
        if (string2 == null || string2.trim().length() == 0) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            string2 = "";
            return;
        }
        String string3 = providerUtility.getScopeDomainName(this.scope);
        String string4 = flatUserObj.getUserUID();
        if (string4 == null || string4.trim().length() == 0) {
            return;
        }
        String string5 = flatUserObj.getUserName();
        if (string5 == null || string5.trim().length() == 0) {
            return;
        }
        String string6 = new String(String.valueOf(string5) + "." + string3);
        if (!string6.endsWith(".")) {
            string6 = string6.concat(".");
        }
        String string7 = new String("nisaddcred -p " + string4 + " -P " + string6 + " local");
        try {
            object = Runtime.getRuntime();
            Process process = ((Runtime)object).exec(string7);
            process.getInputStream().close();
            process.getErrorStream().close();
        }
        catch (Exception exception) {}
        object = new String("unix." + string4 + "@" + string3);
        string7 = new String("nisaddcred -p " + (String)object + " -P " + string6 + " -l " + string2 + " des");
        string2 = "";
        try {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(string7);
                process.getInputStream().close();
                process.getErrorStream().close();
            }
            catch (Exception exception) {
            }
            Object var12_15 = null;
            string7 = "";
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            string7 = "";
            throw throwable;
        }
        string7 = "";
        string2 = "";
    }
}

