/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.common;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.ExtAttrObj;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrObj;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import java.util.Enumeration;
import java.util.Vector;

public class UserRightsUtil {
    private static final String ROLE_TYPE = "role";
    private static final String USER_TYPE = "normal";
    private static final String ROLE_LIST = "roles";
    private static final String USER_LIST = "members";
    private static final String PROF_LIST = "profiles";
    private static final String AUTH_LIST = "auths";
    private static final String ROLE_ASSIGN_RIGHT = "solaris.role.assign";
    private static final String ROLE_DELEGATE_RIGHT = "solaris.role.delegate";
    private static final String PROF_ASSIGN_RIGHT = "solaris.profmgr.assign";
    private static final String PROF_DELEGATE_RIGHT = "solaris.profmgr.delegate";
    private ProviderUtility provUtil;

    public UserRightsUtil(ProviderUtility providerUtility) {
        this.provUtil = providerUtility;
    }

    public void checkAuthAssignRights(ExtAttrObj extAttrObj, ExtAttrObj extAttrObj2) throws UserException {
        String string;
        if (extAttrObj2 == null) {
            return;
        }
        String string2 = this.provUtil.getClientUserName();
        String[] stringArray = AuthorizationUtility.getUserAuths((String)string2);
        UserAttrObj userAttrObj = new UserAttrObj(string2);
        userAttrObj.setAuthNames(stringArray);
        UserAttrObj userAttrObj2 = new UserAttrObj(string2);
        Vector vector = null;
        if (extAttrObj2 != null && (vector = extAttrObj2.getAttribute(AUTH_LIST)) != null) {
            userAttrObj2.setAttribute(AUTH_LIST, vector);
        }
        if (vector == null) {
            vector = new Vector(0);
        }
        UserAttrObj userAttrObj3 = new UserAttrObj(string2);
        Vector vector2 = null;
        if (extAttrObj != null && (vector2 = extAttrObj.getAttribute(AUTH_LIST)) != null) {
            userAttrObj3.setAttribute(AUTH_LIST, vector);
        }
        if (vector2 == null) {
            vector2 = new Vector(0);
        }
        int n = 0;
        String string3 = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (userAttrObj3.checkAuthName(string) || userAttrObj.checkAuthGrant(string)) continue;
            if (n > 0) {
                string3 = string3.concat(", ");
            }
            string3 = string3.concat(string);
            ++n;
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (userAttrObj2.checkAuthName(string) || userAttrObj.checkAuthGrant(string)) continue;
            if (n > 0) {
                string3 = string3.concat(", ");
            }
            string3 = string3.concat(string);
            ++n;
        }
        if (n > 0) {
            throw new UserException("EXM_URU1", (Object)string2, string3);
        }
    }

    public void checkProfAssignRights(ExtAttrObj extAttrObj, ExtAttrObj extAttrObj2) throws UserException {
        String string;
        if (extAttrObj2 == null) {
            return;
        }
        Vector vector = null;
        if (extAttrObj2 != null) {
            vector = extAttrObj2.getAttribute(PROF_LIST);
        }
        if (vector == null) {
            vector = new Vector(0);
        }
        Vector vector2 = null;
        if (extAttrObj != null) {
            vector2 = extAttrObj.getAttribute(PROF_LIST);
        }
        if (vector2 == null) {
            vector2 = new Vector(0);
        }
        Vector vector3 = this.diffVector(vector, vector2);
        Vector vector4 = this.diffVector(vector2, vector);
        if (vector3.size() == 0 && vector4.size() == 0) {
            return;
        }
        if (this.provUtil.testRights(PROF_ASSIGN_RIGHT, null)) {
            return;
        }
        String string2 = this.provUtil.getClientUserName();
        if (!this.provUtil.testRights(PROF_DELEGATE_RIGHT, null)) {
            throw new UserException("EXM_URU4", string2);
        }
        String[] stringArray = AuthorizationUtility.getUserProfs((String)string2);
        Vector<String> vector5 = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            vector5.addElement(stringArray[n]);
            ++n;
        }
        int n2 = 0;
        String string3 = "";
        Enumeration enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (vector5.contains(string)) continue;
            if (n2 > 0) {
                string3 = string3.concat(", ");
            }
            string3 = string3.concat(string);
            ++n2;
        }
        enumeration = vector4.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (vector5.contains(string)) continue;
            if (n2 > 0) {
                string3 = string3.concat(", ");
            }
            string3 = string3.concat(string);
            ++n2;
        }
        if (n2 > 0) {
            throw new UserException("EXM_URU5", (Object)string2, string3);
        }
    }

    public void checkRoleAssignRights(String string, String string2, ExtAttrObj extAttrObj, ExtAttrObj extAttrObj2) throws UserException {
        Object object;
        Vector<String> vector;
        if (extAttrObj2 == null) {
            return;
        }
        Vector vector2 = null;
        Vector vector3 = null;
        if (string2.equals(ROLE_TYPE)) {
            if (extAttrObj2 != null) {
                vector2 = extAttrObj2.getAttribute(USER_LIST);
            }
            if (extAttrObj != null) {
                vector3 = extAttrObj.getAttribute(USER_LIST);
            }
        } else {
            if (extAttrObj2 != null) {
                vector2 = extAttrObj2.getAttribute(ROLE_LIST);
            }
            if (extAttrObj != null) {
                vector3 = extAttrObj.getAttribute(ROLE_LIST);
            }
        }
        if (vector2 == null) {
            vector2 = new Vector(0);
        }
        if (vector3 == null) {
            vector3 = new Vector(0);
        }
        Vector<String> vector4 = this.diffVector(vector2, vector3);
        Vector vector5 = this.diffVector(vector3, vector2);
        if (vector4.size() == 0 && vector5.size() == 0) {
            return;
        }
        if (this.provUtil.testRights(ROLE_ASSIGN_RIGHT, null)) {
            return;
        }
        String string3 = this.provUtil.getClientUserName();
        if (!this.provUtil.testRights(ROLE_DELEGATE_RIGHT, null)) {
            throw new UserException("EXM_URU2", string3);
        }
        if (string2.equals(ROLE_TYPE)) {
            vector4 = new Vector<String>(1);
            vector4.addElement(string);
            vector5 = new Vector(0);
        }
        if (this.provUtil.isClientRole()) {
            vector = new Vector<String>(1);
            vector.addElement(string3);
        } else {
            object = AuthorizationUtility.getRoleNames((String)string3);
            vector = new Vector(((String[])object).length);
            int n = 0;
            while (n < ((String[])object).length) {
                vector.addElement(object[n]);
                ++n;
            }
        }
        int n = 0;
        String string4 = "";
        Enumeration enumeration = vector4.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (vector.contains(object)) continue;
            if (n > 0) {
                string4 = string4.concat(", ");
            }
            string4 = string4.concat((String)object);
            ++n;
        }
        enumeration = vector5.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (vector.contains(object)) continue;
            if (n > 0) {
                string4 = string4.concat(", ");
            }
            string4 = string4.concat((String)object);
            ++n;
        }
        if (n > 0) {
            throw new UserException("EXM_URU3", (Object)string3, string4);
        }
    }

    private Vector diffVector(Vector vector, Vector vector2) {
        Vector<String> vector3 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (vector2.contains(string)) continue;
            vector3.addElement(string);
        }
        return vector3;
    }
}

