/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.process;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.process.ProcessData;
import com.sun.wbem.solarisprovider.process.ProcessManagerRunCmd;
import com.sun.wbem.solarisprovider.process.ProcessProviderException;
import com.sun.wbem.solarisprovider.process.ProcessResourceLimits;
import com.sun.wbem.solarisprovider.process.PsCmdData;
import com.sun.wbem.solarisprovider.process.Solaris_Process;
import com.sun.wbem.utility.common.LaunchProcException;
import com.sun.wbem.utility.common.ProcLauncher;
import com.sun.wbem.utility.log.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProcessManager {
    private static final String[] GET_ACTIVE_PROCESSES = new String[]{"/usr/bin/ps", "-eflo user, fname, addr, pid, ppid, pgid, pri, pcpu, pmem,vsz, rss, tty, nice, class, stime, time, s, psr, wchan, args"};
    private static final String[] ENV_ARGS = new String[]{"LC_ALL=C", "LC_MESSAGES=C", "LANG=C"};
    private static final String PSTOP = "/usr/proc/bin/pstop";
    private static final String PRESUME = "/usr/proc/bin/prun";
    private static final String PKILL = "/usr/bin/kill";
    private static final String KILLBYNAME = "/usr/bin/pkill";
    private static final String PLIMIT = "/usr/bin/plimit";
    private static final String PSTACK = "/usr/proc/bin/pstack";
    private static final String PTREE = "/usr/proc/bin/ptree";
    private static final String PFLAGS = "/usr/proc/bin/pflags";
    private static final String PCRED = "/usr/proc/bin/pcred";
    private static final String PMAP = "/usr/proc/bin/pmap";
    private static final String PLDD = "/usr/proc/bin/pldd";
    private static final String PFILE = "/usr/proc/bin/pfiles";
    private static final String PWDX = "/usr/proc/bin/pwdx";
    private static final String PTIME = "/usr/proc/bin/ptime";
    private static final String PSIG = "/usr/proc/bin/psig";
    private static final String NFSSTATS = "/usr/bin/nfsstat";
    private static final String VMSTATS = "/usr/bin/vmstat";
    private static final String OSNAME = "/usr/bin/uname";
    private static final String VOLUME_MANAGER = "/etc/init.d/volmgt";
    private static final String AUTOMOUNT_DAEMON = "/etc/init.d/autofs";
    private static final String CRON_DAEMON = "/etc/init.d/cron";
    private static final String NFS_DAEMON = "/etc/init.d/nfs.server";
    private static final String SENDMAIL_DAEMON = "/etc/init.d/sendmail";
    private static final String MOUNT_DAEMON = "/etc/init.d/nfs.server";
    private static final String USRLIBNFSD = "/usr/lib/nfs/nfsd";
    private static final String SYSTEM_SCHED_INTERFACE = "/usr/bin/priocntl";
    private ProviderUtility provUtil = null;
    private LogUtil logUtil = null;
    private CIMOMHandle cimomhandle = null;
    protected static final String PROVIDERNAME = "Process Provider";

    public ProcessManager(CIMOMHandle cIMOMHandle, ProviderUtility providerUtility, LogUtil logUtil) {
        this.provUtil = providerUtility;
        this.cimomhandle = cIMOMHandle;
        this.logUtil = logUtil;
    }

    public synchronized Vector displayActiveProcesses() throws CIMException {
        Vector vector = null;
        Vector vector2 = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(GET_ACTIVE_PROCESSES);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new CIMException(this.logUtil.getLocalizedMessage("LM_10617", null));
            }
            vector = processManagerRunCmd.getOutput();
            vector.removeElementAt(0);
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, "LM_10617", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector;
    }

    public synchronized Vector displayProcessAddrMap(int n) throws CIMException {
        Vector vector = null;
        Vector vector2 = null;
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PMAP, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10622", string);
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String[] stringArray2 = new String[]{string};
            String string2 = this.writeLog(2, "LM_10622", stringArray2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public synchronized Vector displayProcessAncestry(int n) throws CIMException {
        String string;
        Vector vector = null;
        Vector vector2 = null;
        try {
            string = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = this.writeLog(2, null, null, numberFormatException);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        if (this.getProcessData(string) == null) {
            String[] stringArray = new String[]{string};
            String string3 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        try {
            String[] stringArray = new String[]{PTREE, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10631", string);
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String string4 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        return vector;
    }

    public synchronized Vector displayProcessCWD(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PWDX, string};
        Vector vector = null;
        Vector vector2 = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10626", string);
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String[] stringArray2 = new String[]{string};
            String string2 = this.writeLog(2, "LM_10626", stringArray2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public synchronized Vector displayProcessCredentials(int n) throws CIMException {
        Vector vector = null;
        Vector vector2 = null;
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PCRED, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                String[] stringArray2 = new String[]{string};
                throw new CIMException(this.logUtil.getLocalizedMessage("LM_10621", stringArray2));
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String[] stringArray3 = new String[]{string};
            String string2 = this.writeLog(2, "LM_10621", stringArray3, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public synchronized Vector displayProcessDynamicLibs(int n) throws CIMException {
        String string = String.valueOf(n);
        Vector vector = null;
        String[] stringArray = new String[]{PLDD, string};
        Vector vector2 = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector = processManagerRunCmd.getErrors();
                if (vector != null) {
                    this.writeLog(1, vector.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10623", string);
            }
            vector2 = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String[] stringArray2 = new String[]{string};
            String string2 = this.writeLog(2, "LM_10623", stringArray2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector2;
    }

    public synchronized Vector displayProcessFlags(int n) throws CIMException {
        Vector vector = null;
        Vector vector2 = null;
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PFLAGS, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                String[] stringArray2 = new String[]{string};
                throw new CIMException(this.logUtil.getLocalizedMessage("LM_10620", stringArray2));
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String string2 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public synchronized Vector displayProcessOpenFilesInfo(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PFILE, string};
        Vector vector = null;
        Vector vector2 = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10625", string);
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String[] stringArray2 = new String[]{string};
            String string2 = this.writeLog(2, "LM_10625", stringArray2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public synchronized Vector displayProcessPriorityParams(int n) throws CIMException {
        String string;
        Vector vector = null;
        Vector vector2 = null;
        try {
            string = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)numberFormatException);
        }
        if (this.getProcessData(string) == null) {
            String[] stringArray = new String[]{string};
            String string2 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        try {
            String string3 = "-d " + string;
            String[] stringArray = new String[]{SYSTEM_SCHED_INTERFACE, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10639", string);
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String string4 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        return vector;
    }

    public synchronized Vector displayProcessResourceLimits(int n) throws CIMException {
        String string;
        Vector vector = null;
        Vector vector2 = null;
        try {
            string = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        if (this.getProcessData(string) == null) {
            String[] stringArray = new String[]{string};
            String string2 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        try {
            String string3 = "-km";
            String[] stringArray = new String[]{PLIMIT, string3, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray, ENV_ARGS);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10628", string);
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String string4 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        return vector;
    }

    public synchronized Vector displayProcessSignalActions(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PSIG, string};
        Vector vector = null;
        Vector vector2 = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10624", string);
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String[] stringArray2 = new String[]{string};
            String string2 = this.writeLog(2, "LM_10624", stringArray2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public synchronized Vector displayProcessStack(int n) throws CIMException {
        Vector vector = null;
        Vector vector2 = null;
        String string = String.valueOf(n);
        if (this.getProcessData(string) == null) {
            String[] stringArray = new String[]{string};
            String string2 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        try {
            String[] stringArray = new String[]{PSTACK, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10632", string);
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String string3 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        return vector;
    }

    public synchronized Vector displaySystemSchedConfig() throws CIMException {
        String string = "-l ";
        String[] stringArray = new String[]{SYSTEM_SCHED_INTERFACE, string};
        Vector vector = null;
        Vector vector2 = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10633");
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String string2 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public synchronized Vector displayTimedProcessInfo(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PTIME, string};
        Vector vector = null;
        Vector vector2 = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new ProcessProviderException("LM_10627", string);
            }
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            String[] stringArray2 = new String[]{string};
            String string2 = this.writeLog(2, "LM_10627", stringArray2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public synchronized int getActiveProcessesCount() throws CIMException {
        int n = 0;
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(GET_ACTIVE_PROCESSES, ENV_ARGS);
            if (processManagerRunCmd.getResult() != 0) {
                vector = processManagerRunCmd.getErrors();
                if (vector != null) {
                    this.writeLog(1, vector.toString());
                }
                processManagerRunCmd.dispose();
                throw new CIMException(this.logUtil.getLocalizedMessage("LM_10618", null));
            }
            PsCmdData psCmdData = new PsCmdData(processManagerRunCmd.getOutput());
            processManagerRunCmd.dispose();
            n = psCmdData.getActiveProcessesCount();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, "LM_10618", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return n;
    }

    public synchronized Vector getAllProcesses() throws CIMException {
        Vector vector = null;
        Vector vector2 = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(GET_ACTIVE_PROCESSES, ENV_ARGS);
            if (processManagerRunCmd.getResult() != 0) {
                vector2 = processManagerRunCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                processManagerRunCmd.dispose();
                throw new CIMException(this.logUtil.getLocalizedMessage("LM_10617", null));
            }
            PsCmdData psCmdData = new PsCmdData(processManagerRunCmd.getOutput());
            processManagerRunCmd.dispose();
            if (psCmdData != null) {
                vector = psCmdData.getProcessDataVector();
            }
        }
        catch (Exception exception) {
            String string = this.writeLog(2, "LM_10617", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector;
    }

    public synchronized Vector getExtendedProperty(String string, String string2) throws ProcessProviderException, CIMException {
        Vector vector;
        block21: {
            int n;
            vector = null;
            if (string2.equals("") || string2 == null) {
                if (string.equalsIgnoreCase("LIST_ACTIVE_PROCESSES")) {
                    try {
                        return this.displayActiveProcesses();
                    }
                    catch (Exception exception) {
                        String string3 = this.writeLog(2, null, null, exception);
                        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
                    }
                }
                throw new CIMException("CIM_ERR_FAILED");
            }
            if (string.endsWith("_LC")) {
                return this.getLCXtendedProperty(string, string2);
            }
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = this.writeLog(2, null, null, numberFormatException);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
            }
            try {
                if (string.equalsIgnoreCase("PROCESS_FLAGS")) {
                    vector = this.displayProcessFlags(n);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_CRED")) {
                    vector = this.displayProcessCredentials(n);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_ADDRMAP")) {
                    vector = this.displayProcessAddrMap(n);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_LDD")) {
                    vector = this.displayProcessDynamicLibs(n);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_SIG")) {
                    vector = this.displayProcessSignalActions(n);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_FILES")) {
                    vector = this.displayProcessOpenFilesInfo(n);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_CWD")) {
                    vector = this.displayProcessCWD(n);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_TREE")) {
                    vector = this.displayProcessAncestry(n);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_STACK")) {
                    vector = this.displayProcessStack(n);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_RESOURCE_LIMITS")) {
                    vector = this.displayProcessResourceLimits(n);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_RLIMITS")) {
                    vector = this.getProcRLIMITS(string2);
                    break block21;
                }
                if (string.equalsIgnoreCase("PROCESS_ENV")) {
                    vector = this.getProcessEnv(string2);
                    break block21;
                }
                throw new ProcessProviderException("LM_10616", string);
            }
            catch (Exception exception) {
                String string5 = this.writeLog(2, null, null, exception);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string5);
            }
        }
        return vector;
    }

    private Vector getLCXtendedProperty(String string, String string2) throws ProcessProviderException, CIMException {
        String string3;
        Object object;
        String[] stringArray;
        Vector vector = null;
        Vector vector2 = null;
        if (this.getProcessData(string2) == null) {
            String[] stringArray2 = new String[]{string2};
            String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray2, null, false, 0, 2);
            throw new ProcessProviderException(string4);
        }
        if (string.equalsIgnoreCase("PROCESS_FLAGS_LC")) {
            stringArray = new String[2];
            Array.set(stringArray, 0, PFLAGS);
            Array.set(stringArray, 1, string2);
        } else if (string.equalsIgnoreCase("PROCESS_CRED_LC")) {
            stringArray = new String[2];
            Array.set(stringArray, 0, PCRED);
            Array.set(stringArray, 1, string2);
        } else if (string.equalsIgnoreCase("PROCESS_ADDRMAP_LC")) {
            stringArray = new String[2];
            Array.set(stringArray, 0, PMAP);
            Array.set(stringArray, 1, string2);
        } else if (string.equalsIgnoreCase("PROCESS_LDD_LC")) {
            stringArray = new String[2];
            Array.set(stringArray, 0, PLDD);
            Array.set(stringArray, 1, string2);
        } else if (string.equalsIgnoreCase("PROCESS_SIG_LC")) {
            stringArray = new String[2];
            Array.set(stringArray, 0, PSIG);
            Array.set(stringArray, 1, string2);
        } else if (string.equalsIgnoreCase("PROCESS_FILES_LC")) {
            stringArray = new String[2];
            Array.set(stringArray, 0, PFILE);
            Array.set(stringArray, 0, PFILE);
            Array.set(stringArray, 1, string2);
        } else if (string.equalsIgnoreCase("PROCESS_CWD_LC")) {
            stringArray = new String[2];
            Array.set(stringArray, 0, PWDX);
            Array.set(stringArray, 1, string2);
        } else if (string.equalsIgnoreCase("PROCESS_TREE_LC")) {
            stringArray = new String[2];
            Array.set(stringArray, 0, PTREE);
            Array.set(stringArray, 1, string2);
        } else if (string.equalsIgnoreCase("PROCESS_STACK_LC")) {
            stringArray = new String[2];
            Array.set(stringArray, 0, PSTACK);
            Array.set(stringArray, 1, string2);
        } else if (string.equalsIgnoreCase("PROCESS_RESOURCE_LIMITS_LC")) {
            stringArray = new String[3];
            object = "-km";
            Array.set(stringArray, 0, PLIMIT);
            Array.set(stringArray, 1, object);
            Array.set(stringArray, 2, string2);
        } else {
            throw new ProcessProviderException("LM_10616", string);
        }
        object = new ProcessManagerRunCmd(stringArray, ENV_ARGS);
        if (((ProcessManagerRunCmd)object).getResult() == 0) {
            vector = ((ProcessManagerRunCmd)object).getOutput();
            ((ProcessManagerRunCmd)object).dispose();
            return vector;
        }
        String string5 = "unknown";
        vector2 = ((ProcessManagerRunCmd)object).getErrors();
        if (vector2 != null) {
            string5 = vector2.toString();
        }
        if (string5.indexOf("cannot examine") >= 0) {
            String[] stringArray3 = new String[]{string2};
            string3 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10629", stringArray3, string5, false, 0, 2);
        } else {
            String[] stringArray4 = new String[]{string2, string5};
            string3 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10642", stringArray4, string5, false, 0, 2);
        }
        ((ProcessManagerRunCmd)object).dispose();
        throw new ProcessProviderException(string3);
    }

    protected String getLocalHostname() throws CIMException {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (Exception exception) {
            String string2 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return string;
    }

    protected String getOSName() throws CIMException {
        String string = null;
        String string2 = "-s";
        String[] stringArray = new String[]{OSNAME, string2};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                string = "SunOS";
                processManagerRunCmd.dispose();
            } else {
                string = (String)processManagerRunCmd.getOutput().elementAt(0);
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            String string3 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        return string;
    }

    public synchronized String getParentGID(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPGID();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getParentPID(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPPID();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized Vector getProcRLIMITS(String string) throws CIMException {
        Vector<String> vector = new Vector<String>();
        try {
            ProcessResourceLimits processResourceLimits = new ProcessResourceLimits(string);
            vector.addElement(String.valueOf(processResourceLimits.getMaxFileSizeLimit()) + " " + processResourceLimits.getCurrentFileSizeLimit());
            vector.addElement(String.valueOf(processResourceLimits.getMaxHeapSizeLimit()) + " " + processResourceLimits.getCurrHeapSizeLimit());
            vector.addElement(String.valueOf(processResourceLimits.getMaxStackSizeLimit()) + " " + processResourceLimits.getCurrStackSizeLimit());
            vector.addElement(String.valueOf(processResourceLimits.getMaxCPUTIMELimit()) + " " + processResourceLimits.getCurrentCPUTIMELimit());
            vector.addElement(String.valueOf(processResourceLimits.getMaxFileDescriptorLimit()) + " " + processResourceLimits.getCurrFileDescriptorLimit());
            vector.addElement(String.valueOf(processResourceLimits.getMaxCoreFileSizeLimit()) + " " + processResourceLimits.getCurrCoreFileSizeLimit());
            vector.addElement(String.valueOf(processResourceLimits.getMaxVirtualMemorySizeLimit()) + " " + processResourceLimits.getCurrVirtualMemorySizeLimit());
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            String string2 = this.writeLog(2, "LM_10628", stringArray, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public synchronized String getProcessAddr(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPADDR();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessCMD(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPCMD();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessCPU(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPCPU();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessCumulativeTime(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPTIME();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized ProcessData getProcessData(String string) throws CIMException {
        ProcessData processData = null;
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(GET_ACTIVE_PROCESSES, ENV_ARGS);
            if (processManagerRunCmd.getResult() != 0) {
                vector = processManagerRunCmd.getErrors();
                if (vector != null) {
                    this.writeLog(1, vector.toString());
                }
                processManagerRunCmd.dispose();
                String[] stringArray = new String[]{string};
                throw new CIMException(this.logUtil.getLocalizedMessage("LM_10619", stringArray));
            }
            PsCmdData psCmdData = new PsCmdData(processManagerRunCmd.getOutput());
            processManagerRunCmd.dispose();
            Hashtable hashtable = psCmdData.getProcessDataTable();
            processData = (ProcessData)hashtable.get(string);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            String string2 = this.writeLog(2, "LM_10619", stringArray, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return processData;
    }

    public synchronized Vector getProcessEnv(String string) throws CIMException {
        if (this.getProcessData(string) == null) {
            String[] stringArray = new String[]{string};
            String string2 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        Vector<String> vector = new Vector<String>();
        String string3 = Solaris_Process.GetProcessEnv(string);
        if (string3 == null || string3.equals("null")) {
            String[] stringArray = new String[]{string};
            String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10630", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        string3 = string3.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            String[] stringArray = new String[]{string};
            String string5 = this.writeLog(2, "LM_10630", stringArray, noSuchElementException);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string5);
        }
        return vector;
    }

    public synchronized String getProcessMemory(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPMEM();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessName(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPNAME();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessNiceVal(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPNICE();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessOwner(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPUSER();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessPSR(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPPSR();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessPriority(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPPRI();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessRSS(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPRSS();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessSchedClass(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPCLASS();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessSize(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPVSZ();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessStartTime(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPSTIME();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessState(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPSTATE();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessTTY(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPTTY();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized String getProcessWCHAN(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPWCHAN();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public synchronized int killProcess(int n) throws CIMException {
        int n2;
        String string = String.valueOf(n);
        Vector vector = null;
        if (this.getProcessData(string) == null) {
            String[] stringArray = new String[]{string};
            String string2 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        try {
            String[] stringArray = new String[]{PKILL, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            String string3 = this.writeLog(2, "LM_10637", stringArray, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        return n2;
    }

    public synchronized int resumeProcess(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PRESUME, string};
        int n2 = -1;
        Vector vector = null;
        if (this.getProcessData(string) == null) {
            String[] stringArray2 = new String[]{string};
            String string2 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray2, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String[] stringArray3 = new String[]{string};
            String string3 = this.writeLog(2, "LM_10636", stringArray3, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        return n2;
    }

    private int runCmd(String[] stringArray, String[] stringArray2) {
        String string;
        BufferedReader bufferedReader;
        String string2;
        int n;
        Process process;
        block12: {
            Runtime runtime = null;
            process = null;
            n = -1;
            runtime = Runtime.getRuntime();
            string2 = null;
            bufferedReader = null;
            string = "";
            Object var9_9 = null;
            try {
                process = stringArray2 != null ? runtime.exec(stringArray, stringArray2) : runtime.exec(stringArray);
            }
            catch (Exception exception) {
                this.writeLog(1, null, null, exception);
                if (process == null) break block12;
                process = null;
            }
        }
        if (process != null) {
            try {
                Thread.currentThread();
                Thread.sleep(600L);
            }
            catch (InterruptedException interruptedException) {}
            try {
                n = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                n = 0;
            }
            if (n == -1) {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        string = string.concat(String.valueOf(string2) + "\n");
                    }
                }
                catch (IOException iOException) {
                    this.writeLog(1, null, null, iOException);
                }
                if (string != null) {
                    this.writeLog(1, string);
                }
            }
        }
        return n;
    }

    public synchronized int setProcessCPUTIMELimits(int n, String string, String string2) throws CIMException {
        int n2;
        String string3;
        Vector vector = null;
        try {
            string3 = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)numberFormatException);
        }
        if (this.getProcessData(string3) == null) {
            String[] stringArray = new String[]{string3};
            String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        try {
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            }
            String string5 = "-t";
            String[] stringArray = new String[]{PLIMIT, string5, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String string6 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string6);
        }
        return n2;
    }

    public synchronized int setProcessCoreFileSizeLimits(int n, String string, String string2) throws CIMException {
        int n2;
        String string3;
        Vector vector = null;
        try {
            string3 = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)numberFormatException);
        }
        if (this.getProcessData(string3) == null) {
            String[] stringArray = new String[]{string3};
            String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        try {
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            } else {
                string = String.valueOf(string) + "k";
            }
            if (!string2.equals("unlimited")) {
                string2 = String.valueOf(string2) + "k";
            }
            String string5 = "-c";
            String[] stringArray = new String[]{PLIMIT, string5, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String string6 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string6);
        }
        return n2;
    }

    public synchronized int setProcessFileDescriptorLimits(int n, String string, String string2) throws CIMException {
        int n2;
        String string3;
        Vector vector = null;
        try {
            string3 = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)numberFormatException);
        }
        if (this.getProcessData(string3) == null) {
            String[] stringArray = new String[]{string3};
            String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        try {
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            }
            String string5 = "-n";
            String[] stringArray = new String[]{PLIMIT, string5, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String string6 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string6);
        }
        return n2;
    }

    public synchronized int setProcessFileSizeLimits(int n, String string, String string2) throws CIMException {
        int n2;
        String string3;
        Vector vector = null;
        try {
            string3 = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)numberFormatException);
        }
        if (this.getProcessData(string3) == null) {
            String[] stringArray = new String[]{string3};
            String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        try {
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            } else {
                string = String.valueOf(string) + "k";
            }
            if (!string2.equals("unlimited")) {
                string2 = String.valueOf(string2) + "k";
            }
            String string5 = "-f";
            String[] stringArray = new String[]{PLIMIT, string5, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String string6 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string6);
        }
        return n2;
    }

    public synchronized int setProcessHeapSizeLimits(int n, String string, String string2) throws CIMException {
        int n2;
        String string3;
        Vector vector = null;
        try {
            string3 = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)numberFormatException);
        }
        if (this.getProcessData(string3) == null) {
            String[] stringArray = new String[]{string3};
            String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        try {
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            }
            String string5 = "-d";
            String[] stringArray = new String[]{PLIMIT, string5, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String string6 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string6);
        }
        return n2;
    }

    public synchronized int setProcessSchedClass(int n, String string) throws CIMException {
        int n2;
        String string2;
        Vector vector = null;
        try {
            string2 = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)numberFormatException);
        }
        if (this.getProcessData(string2) == null) {
            String[] stringArray = new String[]{string2};
            String string3 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        try {
            String string4 = "-sc " + string + " " + string2;
            String[] stringArray = new String[]{SYSTEM_SCHED_INTERFACE, string4};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String string5 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string5);
        }
        return n2;
    }

    public synchronized int setProcessStackSizeLimits(int n, String string, String string2) throws CIMException {
        int n2;
        String string3;
        Vector vector = null;
        try {
            string3 = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)numberFormatException);
        }
        if (this.getProcessData(string3) == null) {
            String[] stringArray = new String[]{string3};
            String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        try {
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            }
            String string5 = "-s";
            String[] stringArray = new String[]{PLIMIT, string5, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String string6 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string6);
        }
        return n2;
    }

    public synchronized int setProcessTimeQuantum(int n, int n2, int n3) throws CIMException {
        int n4;
        String string;
        String string2 = null;
        Vector vector = null;
        try {
            string = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = this.writeLog(2, null, null, numberFormatException);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        if (this.getProcessData(string) == null) {
            String[] stringArray = new String[]{string};
            String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        try {
            String string5 = String.valueOf(n2);
            String string6 = String.valueOf(n3);
            string2 = "-st " + string5 + " " + "-r " + string6 + " " + string;
            String[] stringArray = new String[]{SYSTEM_SCHED_INTERFACE, string2};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n4 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n4 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String string7 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string7);
        }
        return n4;
    }

    public synchronized int setProcessUserPriority(int n, int n2) throws CIMException {
        int n3;
        String string;
        Vector vector = null;
        try {
            string = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = this.writeLog(2, null, null, numberFormatException);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        if (this.getProcessData(string) == null) {
            String[] stringArray = new String[]{string};
            String string3 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        try {
            String string4 = String.valueOf(n2);
            String[] stringArray = new String[]{SYSTEM_SCHED_INTERFACE, "-s", "-p", string4, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n3 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n3 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(2, vector.toString());
            }
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            String string5 = this.writeLog(2, "LM_10638", stringArray, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string5);
        }
        return n3;
    }

    public synchronized int setVirtualMemorySizeLimits(int n, String string, String string2) throws CIMException {
        int n2;
        String string3;
        Vector vector = null;
        try {
            string3 = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)numberFormatException);
        }
        if (this.getProcessData(string3) == null) {
            String[] stringArray = new String[]{string3};
            String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        try {
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            }
            String string5 = "-v";
            String[] stringArray = new String[]{PLIMIT, string5, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String string6 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string6);
        }
        return n2;
    }

    public synchronized void startNewProcByUid(String string, String string2, String[] stringArray, String string3) throws ProcessProviderException, CIMException {
        String[] stringArray2;
        ProcLauncher procLauncher = null;
        String string4 = null;
        String[] stringArray3 = new String[1];
        File file = new File(string);
        if (!file.exists()) {
            stringArray3[0] = string;
            String string5 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10703", stringArray3, "", false, 0, 2);
            throw new ProcessProviderException(string5);
        }
        if (file.isDirectory()) {
            stringArray3[0] = string;
            String string6 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10704", stringArray3, "", false, 0, 2);
            throw new ProcessProviderException(string6);
        }
        if (string2 != null && !string2.equals("")) {
            string2 = string2.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r\f");
            int n = stringTokenizer.countTokens();
            stringArray2 = new String[n + 1];
            stringArray2[0] = string;
            try {
                int n2 = 1;
                while (n2 <= n) {
                    stringArray2[n2] = stringTokenizer.nextToken();
                    ++n2;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new ProcessProviderException("LM_10634", (Object)string, noSuchElementException);
            }
        } else {
            stringArray2 = new String[]{string};
        }
        try {
            procLauncher = new ProcLauncher(string, string3, stringArray2, stringArray, true);
        }
        catch (LaunchProcException launchProcException) {
            throw new ProcessProviderException(launchProcException.getLocalizedMessage());
        }
        catch (Exception exception) {
            throw new ProcessProviderException(exception.getMessage());
        }
        string4 = procLauncher.getErrorString();
        if (string4 == null) {
            string4 = "";
        }
        int n = procLauncher.getStatus();
        switch (n) {
            case 0: {
                stringArray3[0] = string;
                this.logUtil.writeLog(PROVIDERNAME, "LM_10700", "LM_10701", stringArray3, "", false, 0, 0);
                break;
            }
            case 2: {
                stringArray3[0] = string;
                String string7 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10703", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string7);
            }
            case 7: {
                String string8 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10705", null, string4, false, 0, 2);
                throw new ProcessProviderException(string8);
            }
            case 8: {
                stringArray3[0] = string;
                String string9 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10706", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string9);
            }
            case 11: {
                String string10 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10707", null, string4, false, 0, 2);
                throw new ProcessProviderException(string10);
            }
            case 12: {
                String string11 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10708", null, string4, false, 0, 2);
                throw new ProcessProviderException(string11);
            }
            case 13: {
                String string12 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10709", null, string4, false, 0, 2);
                throw new ProcessProviderException(string12);
            }
            case 20: {
                stringArray3[0] = string;
                String string13 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10710", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string13);
            }
            case 21: {
                stringArray3[0] = string;
                String string14 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10704", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string14);
            }
            case 26: {
                stringArray3[0] = string;
                String string15 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10718", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string15);
            }
            case 67: {
                stringArray3[0] = string;
                String string16 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10711", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string16);
            }
            case 78: {
                String string17 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10712", null, string4, false, 0, 2);
                throw new ProcessProviderException(string17);
            }
            case 90: {
                stringArray3[0] = string;
                String string18 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10713", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string18);
            }
            case 1001: {
                stringArray3[0] = string3;
                String string19 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10714", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string19);
            }
            case 1002: {
                stringArray3[0] = string3;
                String string20 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10715", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string20);
            }
            case 1003: {
                stringArray3[0] = string3;
                String string21 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10716", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string21);
            }
            default: {
                stringArray3[0] = string4;
                String string22 = this.logUtil.writeLog(PROVIDERNAME, "LM_10702", "LM_10717", stringArray3, string4, false, 0, 2);
                throw new ProcessProviderException(string22);
            }
        }
    }

    public synchronized int suspendProcess(int n) throws CIMException {
        String string = null;
        Vector vector = null;
        try {
            string = String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            String[] stringArray = new String[]{string};
            String string2 = this.writeLog(2, "LM_10635", stringArray, numberFormatException);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        if (this.getProcessData(string) == null) {
            String[] stringArray = new String[]{string};
            String string3 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", stringArray, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        String[] stringArray = new String[]{PSTOP, string};
        int n2 = -1;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
            if (n2 != 0 && (vector = processManagerRunCmd.getErrors()) != null) {
                this.writeLog(1, vector.toString());
            }
        }
        catch (Exception exception) {
            String[] stringArray2 = new String[]{string};
            String string4 = this.writeLog(2, "LM_10635", stringArray2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        return n2;
    }

    protected void writeLog(int n, String string) {
        try {
            this.logUtil.writeLog(PROVIDERNAME, "LM_10600", null, null, string, false, 0, n);
        }
        catch (Exception exception) {}
    }

    protected String writeLog(int n, String string, String[] stringArray, Exception exception) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        try {
            string3 = exception.getLocalizedMessage();
            this.logUtil.writeLog(PROVIDERNAME, "LM_10600", string, stringArray, string3, bl, 0, n);
        }
        catch (Exception exception2) {}
        if (string != null) {
            string2 = this.logUtil.getLocalizedMessage(string, stringArray);
            string2 = String.valueOf(string2) + " " + string3;
        } else {
            string2 = string3;
        }
        return string2;
    }
}

