/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.perfmon;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider.PropertyProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.query.NonJoinExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.WQLParser;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.perfmon.CPUSysinfo;
import com.sun.wbem.solarisprovider.perfmon.PerformanceMonitor;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_CpuSysinfo
implements InstanceProvider,
PropertyProvider,
MethodProvider,
Authorizable {
    public static final String PROVIDERNAME = "Solaris System Performance Monitor";
    public static final String CAPTION = "Solaris CPU system Information: cpuID# ";
    private static CIMOMHandle cimomHandle = null;
    private static ProviderUtility provUtil = null;
    private LogUtil logUtil = null;
    private PerformanceMonitor perfMon = null;

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Create Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            String[] stringArray = new String[]{"Delete Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        Vector vector2 = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            vector2 = this.perfMon.getAllCpuSysinfoObjs();
            if (vector2 == null) {
                return null;
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMObjectPath cIMObjectPath2 = null;
                cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("Name", new CIMValue((Object)String.valueOf(((CPUSysinfo)vector2.elementAt(n)).getCpuId())));
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)String.valueOf(((CPUSysinfo)vector2.elementAt(n)).getCpuId())));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_CpuSysinfo"));
                try {
                    cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (UnknownHostException unknownHostException) {}
                cIMObjectPath2.addKey("DeviceCreationClassName", new CIMValue((Object)"Solaris_Processor"));
                cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        Vector vector2 = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            vector2 = this.perfMon.getAllCpuSysinfoObjs();
            if (vector2 == null) {
                return null;
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMInstance cIMInstance = cIMClass.newInstance();
                CPUSysinfo cPUSysinfo = null;
                cPUSysinfo = (CPUSysinfo)vector2.elementAt(n);
                if (cPUSysinfo != null) {
                    cIMInstance.setProperty("PhysicalBlockReads", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getPhysicalBlockReads())));
                    cIMInstance.setProperty("PhysicalBlockWrites", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getPhysicalBlockWrites())));
                    cIMInstance.setProperty("LogicalBlockReads", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getLogicalBlockReads())));
                    cIMInstance.setProperty("LogicalBlockWrites", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getLogicalBlockWrites())));
                    cIMInstance.setProperty("RawIOReads", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getRawIOReads())));
                    cIMInstance.setProperty("RawIOWrites", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getRawIOWrites())));
                    cIMInstance.setProperty("ContextSwitches", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getContextSwitches())));
                    cIMInstance.setProperty("Traps", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getTraps())));
                    cIMInstance.setProperty("DeviceInterrupts", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getDeviceInterrupts())));
                    cIMInstance.setProperty("SysCalls", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysCalls())));
                    cIMInstance.setProperty("SysReads", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysReads())));
                    cIMInstance.setProperty("SysWrites", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysWrites())));
                    cIMInstance.setProperty("SysForks", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysForks())));
                    cIMInstance.setProperty("SysVforks", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysVforks())));
                    cIMInstance.setProperty("SysExec", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysExec())));
                    cIMInstance.setProperty("ReadChar", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getReadChar())));
                    cIMInstance.setProperty("WriteChar", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getWriteChar())));
                    cIMInstance.setProperty("RawChar", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getRawChar())));
                    cIMInstance.setProperty("CanonicalChar", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getCanonicalChar())));
                    cIMInstance.setProperty("OutputChar", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getOutputChar())));
                    cIMInstance.setProperty("MsgCount", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getMsgCount())));
                    cIMInstance.setProperty("SemaOpsCount", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSemaOpsCount())));
                    cIMInstance.setProperty("PnameLookups", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getPnameLookups())));
                    cIMInstance.setProperty("UfsInodeGets", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsInodeGets())));
                    cIMInstance.setProperty("UfsDirBlksRead", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsDirBlksRead())));
                    cIMInstance.setProperty("UfsInodePages", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsInodePages())));
                    cIMInstance.setProperty("UfsInodeNoPages", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsInodeNoPages())));
                    cIMInstance.setProperty("InodeTableOvfs", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getInodeTableOvfs())));
                    cIMInstance.setProperty("FileTableOvfs", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getFileTableOvfs())));
                    cIMInstance.setProperty("ProcTableOvfs", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getProcTableOvfs())));
                    cIMInstance.setProperty("IntrThreads", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getIntrThreads())));
                    cIMInstance.setProperty("IntrBlkd", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getIntrBlkd())));
                    cIMInstance.setProperty("IdleThread", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getIdleThread())));
                    cIMInstance.setProperty("InvolSwtch", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getInvolSwtch())));
                    cIMInstance.setProperty("ThreadCreates", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getThreadCreates())));
                    cIMInstance.setProperty("CpuMigrate", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getCpuMigrate())));
                    cIMInstance.setProperty("XCalls", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getXCalls())));
                    cIMInstance.setProperty("MutexAdEnters", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getMutexAdEnters())));
                    cIMInstance.setProperty("ReaderFailures", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getReaderFailures())));
                    cIMInstance.setProperty("ReaderFailures", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getReaderFailures())));
                    cIMInstance.setProperty("WriterFailures", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getWriterFailures())));
                    cIMInstance.setProperty("ModLoad", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getModLoad())));
                    cIMInstance.setProperty("modUnload", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getModUnload())));
                    cIMInstance.setProperty("AsyncBlkWrites", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getAsyncBlkWrites())));
                    cIMInstance.setProperty("Name", new CIMValue((Object)String.valueOf(cPUSysinfo.getCpuId())));
                    cIMInstance.setProperty("DeviceID", new CIMValue((Object)String.valueOf(cPUSysinfo.getCpuId())));
                }
                if (!bl2) {
                    cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_CpuSysinfo"));
                    try {
                        cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                    }
                    catch (UnknownHostException unknownHostException) {}
                    cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMInstance.setProperty("DeviceCreationClassName", new CIMValue((Object)"Solaris_Processor"));
                    cIMInstance.setProperty("Description", new CIMValue((Object)PROVIDERNAME));
                    cIMInstance.setProperty("Caption", new CIMValue((Object)(CAPTION + cPUSysinfo.getCpuId())));
                }
                vector.addElement(cIMInstance);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"execQuery"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            SelectExp selectExp = (SelectExp)wQLParser.querySpecification();
            SelectList selectList = selectExp.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            QueryExp queryExp = selectExp.getWhereClause();
            Vector vector2 = new Vector();
            vector2 = this.enumInstances(cIMObjectPath, false, cIMClass, true);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (queryExp == null || queryExp.apply((CIMElement)((CIMInstance)vector2.elementAt(n2)))) {
                    vector.addElement(selectList.apply((CIMElement)((CIMInstance)vector2.elementAt(n2))));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            String string2 = this.perfMon.writeLog(2, "LM_9630", stringArray, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public Integer getBulkData(Vector vector) throws CIMException {
        Integer n;
        try {
            String string = this.perfMon.getBulkCpuSysInfo();
            if (string == null) {
                n = new Integer(-1);
            } else {
                vector.addElement(new CIMValue((Object)string));
                n = new Integer(0);
            }
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return n;
    }

    protected static CIMOMHandle getCimomHandle() {
        return cimomHandle;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        CIMInstance cIMInstance = cIMClass.newInstance();
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"getInstance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            CPUSysinfo cPUSysinfo;
            String string = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration != null && enumeration.hasMoreElements()) {
                cPUSysinfo = (CIMProperty)enumeration.nextElement();
                if (!cPUSysinfo.getName().equalsIgnoreCase("Name")) continue;
                string = (String)cPUSysinfo.getValue().getValue();
            }
            cPUSysinfo = this.perfMon.getCpuSysinfoObj(Integer.parseInt(string));
            if (cPUSysinfo != null) {
                cIMInstance.setProperty("PhysicalBlockReads", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getPhysicalBlockReads())));
                cIMInstance.setProperty("PhysicalBlockWrites", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getPhysicalBlockWrites())));
                cIMInstance.setProperty("LogicalBlockReads", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getLogicalBlockReads())));
                cIMInstance.setProperty("LogicalBlockWrites", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getLogicalBlockWrites())));
                cIMInstance.setProperty("RawIOReads", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getRawIOReads())));
                cIMInstance.setProperty("RawIOWrites", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getRawIOWrites())));
                cIMInstance.setProperty("ContextSwitches", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getContextSwitches())));
                cIMInstance.setProperty("Traps", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getTraps())));
                cIMInstance.setProperty("DeviceInterrupts", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getDeviceInterrupts())));
                cIMInstance.setProperty("SysCalls", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysCalls())));
                cIMInstance.setProperty("SysReads", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysReads())));
                cIMInstance.setProperty("SysWrites", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysWrites())));
                cIMInstance.setProperty("SysForks", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysForks())));
                cIMInstance.setProperty("SysVforks", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysVforks())));
                cIMInstance.setProperty("SysExec", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysExec())));
                cIMInstance.setProperty("ReadChar", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getReadChar())));
                cIMInstance.setProperty("WriteChar", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getWriteChar())));
                cIMInstance.setProperty("RawChar", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getRawChar())));
                cIMInstance.setProperty("CanonicalChar", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getCanonicalChar())));
                cIMInstance.setProperty("OutputChar", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getOutputChar())));
                cIMInstance.setProperty("MsgCount", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getMsgCount())));
                cIMInstance.setProperty("SemaOpsCount", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSemaOpsCount())));
                cIMInstance.setProperty("PnameLookups", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getPnameLookups())));
                cIMInstance.setProperty("UfsInodeGets", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsInodeGets())));
                cIMInstance.setProperty("UfsDirBlksRead", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsDirBlksRead())));
                cIMInstance.setProperty("UfsInodePages", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsInodePages())));
                cIMInstance.setProperty("UfsInodeNoPages", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsInodeNoPages())));
                cIMInstance.setProperty("InodeTableOvfs", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getInodeTableOvfs())));
                cIMInstance.setProperty("FileTableOvfs", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getFileTableOvfs())));
                cIMInstance.setProperty("ProcTableOvfs", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getProcTableOvfs())));
                cIMInstance.setProperty("IntrThreads", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getIntrThreads())));
                cIMInstance.setProperty("IntrBlkd", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getIntrBlkd())));
                cIMInstance.setProperty("IdleThread", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getIdleThread())));
                cIMInstance.setProperty("InvolSwtch", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getInvolSwtch())));
                cIMInstance.setProperty("ThreadCreates", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getThreadCreates())));
                cIMInstance.setProperty("CpuMigrate", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getCpuMigrate())));
                cIMInstance.setProperty("XCalls", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getXCalls())));
                cIMInstance.setProperty("MutexAdEnters", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getMutexAdEnters())));
                cIMInstance.setProperty("ReaderFailures", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getReaderFailures())));
                cIMInstance.setProperty("WriterFailures", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getWriterFailures())));
                cIMInstance.setProperty("ModLoad", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getModLoad())));
                cIMInstance.setProperty("modUnload", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getModUnload())));
                cIMInstance.setProperty("AsyncBlkWrites", new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getAsyncBlkWrites())));
                cIMInstance.setProperty("Name", new CIMValue((Object)String.valueOf(cPUSysinfo.getCpuId())));
                cIMInstance.setProperty("DeviceID", new CIMValue((Object)String.valueOf(cPUSysinfo.getCpuId())));
            }
            if (bl) {
                return cIMInstance;
            }
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_CpuSysinfo"));
            try {
                cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (UnknownHostException unknownHostException) {}
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("DeviceCreationClassName", new CIMValue((Object)"Solaris_Processor"));
            cIMInstance.setProperty("Description", new CIMValue((Object)PROVIDERNAME));
            cIMInstance.setProperty("Caption", new CIMValue((Object)(CAPTION + cPUSysinfo.getCpuId())));
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return cIMInstance;
    }

    public synchronized CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        CIMValue cIMValue;
        block55: {
            Object object;
            String[] stringArray;
            String string3 = null;
            CPUSysinfo cPUSysinfo = null;
            try {
                provUtil.checkAuthenticated();
            }
            catch (CIMException cIMException) {
                String[] stringArray2 = new String[]{"getPropertyValue"};
                this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray2, null, false, 0, 2);
                throw new CIMException("CIM_ERR_ACCESS_DENIED");
            }
            try {
                stringArray = cIMObjectPath.getKeys().elements();
                while (stringArray != null && stringArray.hasMoreElements()) {
                    object = (CIMProperty)stringArray.nextElement();
                    if (!object.getName().equalsIgnoreCase("Name")) continue;
                    string3 = (String)object.getValue().getValue();
                }
                cPUSysinfo = this.perfMon.getCpuSysinfoObj(Integer.parseInt(string3));
            }
            catch (Exception exception) {
                String string4 = this.perfMon.writeLog(2, null, null, exception);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
            }
            try {
                if (string2.equalsIgnoreCase("PhysicalBlockReads")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getPhysicalBlockReads()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("PhysicalBlockWrites")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getPhysicalBlockWrites()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("LogicalBlockReads")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getLogicalBlockReads()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("LogicalBlockWrites")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getLogicalBlockWrites()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("RawIOReads")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getRawIOReads()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("RawIOWrites")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getRawIOWrites()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("ContextSwitches")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getContextSwitches()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("Traps")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getTraps()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("DeviceInterrupts")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getDeviceInterrupts()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("SysCalls")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysCalls()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("SysReads")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysReads()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("SysWrites")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysWrites()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("SysForks")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysForks()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("SysVforks")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysVforks()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("SysExec")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSysExec()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("ReadChar")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getReadChar()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("WriteChar")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getWriteChar()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("RawChar")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getRawChar()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("CanonicalChar")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getCanonicalChar()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("OutputChar")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getOutputChar()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("MsgCount")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getMsgCount()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("SemaOpsCount")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getSemaOpsCount()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("PnameLookups")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getPnameLookups()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("UfsInodeGets")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsInodeGets()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("UfsDirBlksRead")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsDirBlksRead()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("UfsInodePages")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsInodePages()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("UfsInodeNoPages")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getUfsInodeNoPages()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("InodeTableOvfs")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getInodeTableOvfs()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("FileTableOvfs")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getFileTableOvfs()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("ProcTableOvfs")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getProcTableOvfs()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("IntrThreads")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getIntrThreads()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("IntrBlkd")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getIntrBlkd()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("IdleThread")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getIdleThread()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("InvolSwtch")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getInvolSwtch()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("ThreadCreates")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getThreadCreates()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("CpuMigrate")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getCpuMigrate()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("XCalls")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getXCalls()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("MutexAdEnters")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getMutexAdEnters()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("ReaderFailures")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getReaderFailures()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("WriterFailures")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getWriterFailures()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("ModLoad")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getModLoad()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("ModUnload")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getModUnload()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("AsyncBlkWrites")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUSysinfo.getAsyncBlkWrites()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("Name")) {
                    cIMValue = new CIMValue((Object)String.valueOf(cPUSysinfo.getCpuId()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("DeviceID")) {
                    cIMValue = new CIMValue((Object)String.valueOf(cPUSysinfo.getCpuId()));
                    break block55;
                }
                if (string2.equalsIgnoreCase("CreationClassName")) {
                    cIMValue = new CIMValue((Object)"Solaris_CpuSysinfo");
                    break block55;
                }
                if (string2.equalsIgnoreCase("SystemName")) {
                    cIMValue = new CIMValue((Object)InetAddress.getLocalHost().getHostName());
                    break block55;
                }
                if (string2.equalsIgnoreCase("SystemCreationClassName")) {
                    cIMValue = new CIMValue((Object)"Solaris_ComputerSystem");
                    break block55;
                }
                stringArray = new String[]{string2};
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.logUtil.getLocalizedMessage("LM_9601", stringArray));
            }
            catch (Exception exception) {
                object = this.perfMon.writeLog(2, null, null, exception);
                throw new CIMProviderException("GENERAL_EXCEPTION", object);
            }
        }
        return cIMValue;
    }

    protected static ProviderUtility getProviderUtil() {
        return provUtil;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        cimomHandle = cIMOMHandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        try {
            provUtil = new ProviderUtility(cimomHandle, PROVIDERNAME);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.perfMon = new PerformanceMonitor(cIMOMHandle, this.logUtil, provUtil);
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"invokeMethod"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        if (string.equalsIgnoreCase("getBulkData")) {
            return new CIMValue((Object)this.getBulkData(vector2));
        }
        return null;
    }

    protected UnsignedInt32 javaIntToCIMUnsignedInt(int n) {
        try {
            return new UnsignedInt32(Integer.toString(n));
        }
        catch (Exception exception) {
            return new UnsignedInt32("0");
        }
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Set Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public synchronized void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        try {
            String[] stringArray = new String[]{"setPropertyValue"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

