/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import COM.odi.ClassInfo;
import COM.odi.GenericObject;
import COM.odi.IPersistent;
import COM.odi.ObjectStore;
import com.sun.jini.outrigger.BasicSpace;
import com.sun.jini.outrigger.NotifyChit;
import com.sun.jini.outrigger.SpaceProxy;
import com.sun.jini.outrigger.ThrowThis;
import com.sun.jini.outrigger.Transactable;
import com.sun.jini.outrigger.TransactableChitClassInfo;
import com.sun.jini.outrigger.TransactableMgr;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.MarshalledObject;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.transaction.TransactionException;
import net.jini.space.InternalSpaceException;

class TransactableChit
extends NotifyChit
implements Transactable {
    static final long serialVersionUID = -3536516340557928230L;
    private TransactableMgr mgr;
    private boolean sendException;
    private boolean forProxy;
    private static PrintWriter dbgTxns;
    private static final Exception TRANSACTION_EXCEPTION;
    static ClassInfo myOdiClassInfoInstance;

    static {
        myOdiClassInfoInstance = ClassInfo.register((ClassInfo)new TransactableChitClassInfo());
        dbgTxns = BasicSpace.dbgTxns;
        TRANSACTION_EXCEPTION = new TransactionException("completed while operation in progress");
    }

    TransactableChit(TransactableMgr transactableMgr, RemoteEventListener remoteEventListener, long l, MarshalledObject marshalledObject) {
        super(remoteEventListener, l, marshalledObject);
        this.mgr = transactableMgr;
        this.forProxy = remoteEventListener instanceof SpaceProxy.ProxyListener;
    }

    public void abort(TransactableMgr transactableMgr, BasicSpace basicSpace) {
        this.prepare(transactableMgr, basicSpace);
    }

    boolean canSee(TransactableMgr transactableMgr) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return transactableMgr == null || transactableMgr == this.mgr;
    }

    public void commit(TransactableMgr transactableMgr, BasicSpace basicSpace) {
        throw new InternalSpaceException("committing a NotifyChit!");
    }

    public int prepare(TransactableMgr transactableMgr, BasicSpace basicSpace) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (!this.forProxy) {
            this.setExpiration(0L);
        } else {
            TransactableChit transactableChit;
            try {
                Long l = (Long)this.handback().get();
                ThrowThis throwThis = new ThrowThis(l, TRANSACTION_EXCEPTION);
                this.handback(new MarshalledObject(throwThis));
            }
            catch (IOException iOException) {
                throw new InternalSpaceException("can't create ThrowThis", (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InternalSpaceException("can't create ThrowThis", (Throwable)classNotFoundException);
            }
            if (((transactableChit = this).ODIObjectState & 2) != 0) {
                transactableChit = transactableChit;
                ObjectStore.dirty((IPersistent)transactableChit);
            }
            transactableChit.sendException = true;
            if (dbgTxns != null) {
                dbgTxns.println("TransactableChit.prepare: exceptionToSend");
            }
            basicSpace.exceptionToSend((NotifyChit)this);
        }
        return 4;
    }

    boolean sendException() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.sendException;
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this.mgr = (TransactableMgr)genericObject.getInterfaceField(1, classInfo);
        this.sendException = genericObject.getBooleanField(2, classInfo);
        this.forProxy = genericObject.getBooleanField(3, classInfo);
        super.initializeContents(genericObject);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setInterfaceField(1, (Object)this.mgr, classInfo);
        genericObject.setBooleanField(2, this.sendException, classInfo);
        genericObject.setBooleanField(3, this.forProxy, classInfo);
        super.flushContents(genericObject);
    }

    public void clearContents() {
        this.mgr = null;
        this.sendException = false;
        this.forProxy = false;
        super.clearContents();
    }

    public TransactableChit(ClassInfo classInfo) {
        super(classInfo);
    }
}

