/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.sort.Compare;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.cis.service.authorization.AuthAttrObj;
import com.sun.admin.cis.service.authorization.UserAttrObj;
import com.sun.admin.usermgr.client.AdminViews;
import com.sun.admin.usermgr.client.AuthAttrCompare;
import com.sun.admin.usermgr.client.AuthAttrModelEntry;
import com.sun.admin.usermgr.client.UserMgrClient;
import java.util.Vector;

public class AuthAttrMgmt {
    public static final String AUTH_HELP_RELPATH = "auths";
    private String user_name;
    private AdminViews views;
    private UserMgrClient client;
    private UserAttrObj admin_auth;
    private UserAttrObj user_auth;
    private AuthAttrObj[] auth_list;
    private AuthAttrModelEntry[] auth_entries;

    public AuthAttrMgmt(String string, UserAttrObj userAttrObj) throws AdminException {
        this.user_name = string;
        this.user_auth = userAttrObj;
        this.views = AdminViews.instance();
        this.client = UserMgrClient.instance();
        this.auth_list = null;
        if (this.views != null) {
            this.auth_list = this.views.getAuthAttrObjList();
        }
        this.admin_auth = null;
        if (this.views != null) {
            this.admin_auth = this.views.getAdminUserAttr();
        }
    }

    public void readAuthInfo() throws AdminException {
        if (this.auth_list == null) {
            try {
                this.auth_list = this.client.getAuthAttrList();
            }
            catch (AdminException adminException) {
                AdminCommonTools.CMN_HandleOutput("Auth rights: unable to get auth list");
                throw adminException;
            }
            if (this.views != null) {
                this.views.setAuthAttrObjList(this.auth_list);
            }
        }
        if (this.admin_auth == null) {
            try {
                this.admin_auth = this.client.getAdminUserAttr();
            }
            catch (AdminException adminException) {
                AdminCommonTools.CMN_HandleOutput("Auth rights: unable to get admin rights");
                this.admin_auth = null;
            }
            if (this.views != null) {
                this.views.setAdminUserAttr(this.admin_auth);
            }
        }
    }

    public AuthAttrModelEntry[] getAuthEntries() throws AdminException {
        if (this.auth_list == null) {
            this.readAuthInfo();
        }
        if (this.admin_auth == null) {
            this.readAuthInfo();
        }
        if (this.auth_list.length > 1) {
            AuthAttrCompare authAttrCompare = new AuthAttrCompare();
            Sort.sort(this.auth_list, (Compare)authAttrCompare);
        }
        String string = null;
        String string2 = null;
        String string3 = "";
        int n = this.auth_list.length;
        Vector<AuthAttrModelEntry> vector = new Vector<AuthAttrModelEntry>(n);
        AuthAttrModelEntry authAttrModelEntry = new AuthAttrModelEntry("", "", "");
        vector.addElement(authAttrModelEntry);
        int n2 = 0;
        while (n2 < n) {
            String string4 = this.auth_list[n2].getAuthName();
            if (string4.equals("solaris.*")) {
                string = this.auth_list[n2].getShortDesc();
                string2 = this.auth_list[n2].getLongDescId();
            } else if (!string4.equals("solaris.grant")) {
                authAttrModelEntry = new AuthAttrModelEntry(this.auth_list[n2]);
                if (string4.endsWith(".")) {
                    string3 = string4;
                    vector.addElement(authAttrModelEntry);
                } else {
                    String string5;
                    int n3 = string4.lastIndexOf(46);
                    if (n3 > 0 && !(string5 = string4.substring(0, n3 + 1)).equals(string3)) {
                        string3 = string5;
                        vector.addElement(new AuthAttrModelEntry(string3, "", ""));
                    }
                    if (this.admin_auth != null && this.admin_auth.checkAuthGrant(string4)) {
                        authAttrModelEntry.setToBeGranted();
                    }
                    if (this.user_auth != null && this.user_auth.checkAuthName(string4)) {
                        authAttrModelEntry.grant();
                    }
                    vector.addElement(authAttrModelEntry);
                }
            }
            ++n2;
        }
        Object[] objectArray = new AuthAttrModelEntry[vector.size()];
        vector.copyInto(objectArray);
        objectArray[0] = new AuthAttrModelEntry("solaris.*", string, string2);
        if (this.admin_auth != null && this.admin_auth.checkAuthGrant("solaris.*")) {
            ((AuthAttrModelEntry)objectArray[0]).setToBeGranted();
        }
        if (this.user_auth != null && this.user_auth.checkAuthName("solaris.*")) {
            ((AuthAttrModelEntry)objectArray[0]).grant();
        }
        return objectArray;
    }

    public UserAttrObj setAuthEntries(AuthAttrModelEntry[] authAttrModelEntryArray) throws AdminException {
        String string;
        UserAttrObj userAttrObj = null;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        if (authAttrModelEntryArray[0].isGranted()) {
            vector.addElement("solaris.*");
            vector.addElement("solaris.grant");
            bl = true;
        }
        int n = -1;
        int n2 = 1;
        while (n2 < authAttrModelEntryArray.length) {
            string = authAttrModelEntryArray[n2].getName();
            if (string.endsWith(".")) {
                authAttrModelEntryArray[n2].grant();
                n = n2;
            } else if (!string.endsWith("grant") && !authAttrModelEntryArray[n2].isGranted() && n >= 0) {
                authAttrModelEntryArray[n].revoke();
            }
            ++n2;
        }
        boolean bl2 = true;
        n2 = 1;
        while (n2 < authAttrModelEntryArray.length) {
            string = authAttrModelEntryArray[n2].getName();
            if (!bl || !string.startsWith("solaris.")) {
                if (string.endsWith(".")) {
                    if (authAttrModelEntryArray[n2].isGranted()) {
                        vector.addElement(string.concat("*"));
                        bl2 = false;
                    } else {
                        bl2 = true;
                    }
                } else if (authAttrModelEntryArray[n2].isGranted() && (bl2 || string.endsWith("grant"))) {
                    vector.addElement(string);
                }
            }
            ++n2;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        userAttrObj = this.user_auth != null ? (UserAttrObj)this.user_auth.clone() : new UserAttrObj(this.user_name);
        userAttrObj.setAuthNames((String[])objectArray);
        return userAttrObj;
    }
}

