/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.mount;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.fsmgr.client.mount.MountListView;
import com.sun.admin.fsmgr.client.mount.MountListViewListener;
import com.sun.admin.fsmgr.client.mount.MountTableView;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MountViewPanel
extends JPanel {
    private MountTableView tableView;
    private MountListView currentView;

    public MountViewPanel() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.tableView = new MountTableView();
        this.setView(this.tableView);
        this.addMouseListener(new ViewMouseListener());
    }

    public void showTableView() {
        this.currentView.clearSelection();
        this.setView(this.tableView);
    }

    public MountListView getCurrentView() {
        return this.currentView;
    }

    public void repaintView() {
        this.setView(this.currentView);
    }

    private void setView(MountListView mountListView) {
        this.removeAll();
        mountListView.populate();
        this.currentView = mountListView;
        Constraints.constrain(this, mountListView, 0, 0, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        this.invalidate();
        this.validate();
        this.repaint();
        this.currentView.clearSelection();
        this.currentView.fireViewChanged();
    }

    public void addListViewListener(MountListViewListener mountListViewListener) {
        this.tableView.addListViewListener(mountListViewListener);
    }

    public void removeListViewListener(MountListViewListener mountListViewListener) {
        this.tableView.removeListViewListener(mountListViewListener);
    }

    class ViewMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MountViewPanel.this.tableView.doPopupMenu(mouseEvent, !mouseEvent.isControlDown());
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MountViewPanel.this.tableView.clearSelection();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MountViewPanel.this.tableView.doPopupMenu(mouseEvent, !mouseEvent.isControlDown());
            }
        }

        ViewMouseListener() {
            MountViewPanel.this = MountViewPanel.this;
        }
    }
}

