/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.AdminProps;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.server.AdminFactoryImpl;
import com.sun.admin.cis.server.AdminServerImpl;
import com.sun.admin.cis.service.authorization.AuthAttrObj;
import com.sun.admin.cis.service.authorization.UserAttrObj;
import com.sun.admin.cis.service.logging.LogServiceFactoryImpl;
import com.sun.admin.cis.service.security.AdminVerificationException;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.cis.service.security.ServerSecurityContext;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.NTDllException;
import com.sun.admin.usermgr.common.PDCAccessAttr;
import com.sun.admin.usermgr.common.PDCCliException;
import com.sun.admin.usermgr.common.PDCGroupAttr;
import com.sun.admin.usermgr.common.PDCPasswordAttr;
import com.sun.admin.usermgr.common.PDCPolicyAttr;
import com.sun.admin.usermgr.common.PDCUserEnvAttr;
import com.sun.admin.usermgr.common.SolServerException;
import com.sun.admin.usermgr.common.UMgrTools;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.admin.usermgr.server.NTCommandLines;
import com.sun.admin.usermgr.server.NTNativeAPI;
import com.sun.admin.usermgr.server.UserMgrFactory;
import java.io.File;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Vector;

public class PDCUserMgrFactoryImpl
extends AdminFactoryImpl
implements UserMgrFactory {
    private static String strNetCmd = "";
    private static String strWinDir = "";
    private static NTCommandLines cli;
    private static AdminProps serverProps;
    private static int iRMIPort;
    private static boolean bFirstRelease;
    private static NTNativeAPI api;
    private static boolean bDLLRunning;
    private static AdminServerImpl admsvr;
    private static LogServiceFactoryImpl logsvc;
    private static String APP_NAME;

    public PDCUserMgrFactoryImpl() throws RemoteException, AdminException {
        super((AdminServerImpl)null);
        this.single = true;
        this.setServerPaths();
    }

    public PDCUserMgrFactoryImpl(AdminServerImpl adminServerImpl) throws RemoteException, AdminException {
        super(adminServerImpl);
        this.single = true;
        this.setServerPaths();
        admsvr = adminServerImpl;
        logsvc = (LogServiceFactoryImpl)adminServerImpl.getServiceImpl("com.sun.admin.cis.service.logging.LogServiceFactoryImpl");
    }

    private void setWinNTDir(String string) {
        strWinDir = string;
    }

    private static String getOSType() {
        String string = System.getProperty("os.name");
        return string;
    }

    private static boolean startDLLOnNT() throws RemoteException, AdminException {
        boolean bl;
        block3: {
            String string = PDCUserMgrFactoryImpl.getOSType();
            String string2 = "Windows NT";
            bl = true;
            if (!string.equals(string2)) break block3;
            try {
                api = new NTNativeAPI();
                bDLLRunning = true;
            }
            catch (SecurityException securityException) {
                bl = false;
                bDLLRunning = false;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
                bDLLRunning = false;
            }
        }
        return bl;
    }

    public synchronized boolean isUserAnAdmin(SecurityToken securityToken, String string, byte[] byArray) throws PDCCliException, RemoteException, Exception {
        String[] stringArray;
        Object object;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 0;
        boolean bl = true;
        ServerSecurityContext serverSecurityContext = null;
        Object[] objectArray = null;
        try {
            serverSecurityContext = admsvr.getAuthenticatedContext(securityToken);
        }
        catch (AdminException adminException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_1030", "LM_2152", null, "LM_USER_APP_NAME", admsvr);
            throw adminException;
        }
        if (admsvr.isVerify()) {
            objectArray = new Object[]{string};
        }
        try {
            admsvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_1020", "LM_2153", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_UM1");
        }
        try {
            object = byArray;
            string3 = serverSecurityContext.decryptPassword((byte[])object);
        }
        catch (AdminException adminException) {
            String string5 = serverSecurityContext.getAdminPrincipal().getName();
            String[] stringArray2 = new String[]{string5};
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2040", "LM_1002", stringArray2, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_LOGON_DECRYPT_PWD");
        }
        object = new File(String.valueOf(strWinDir) + strNetCmd);
        if (!((File)object).exists()) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2037", "LM_2156", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_NO_CLI");
        }
        string2 = String.valueOf(strWinDir) + strNetCmd + " logoff ";
        try {
            stringArray = this.NET_Exec(string2);
        }
        catch (SecurityException securityException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2040", "LM_2151", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_EXC", securityException.getLocalizedMessage(), admsvr);
            throw new PDCCliException("EXM_SECEXECPROCFAILED");
        }
        catch (Exception exception) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2040", "LM_2150", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_CLI", string2, admsvr);
            throw new PDCCliException("EXM_SECEXECFAILED");
        }
        string2 = String.valueOf(strWinDir) + strNetCmd + " logon " + string + " " + string3;
        String string6 = String.valueOf(strWinDir) + strNetCmd + " logon " + string + " XXXX";
        try {
            stringArray = this.NET_Exec(string2);
        }
        catch (SecurityException securityException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2040", "LM_2151", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_EXC", securityException.getLocalizedMessage(), admsvr);
            throw new PDCCliException("EXM_SECEXECPROCFAILED");
        }
        catch (Exception exception) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2040", "LM_2150", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_CLI", string6, admsvr);
            throw new PDCCliException("EXM_SECEXECFAILED");
        }
        n = this.parseForSuccess(stringArray, "successfully logged you on");
        if (n != 0) {
            bl = false;
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2040", "LM_2152", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_CLI", string6, admsvr);
        } else {
            String string7 = "ADMINISTRATOR";
            string4 = AdminCommonTools.CMN_parseLinesForData(stringArray, string7);
            if (string4 == "" || string4.equals("")) {
                bl = false;
            }
            string2 = String.valueOf(strWinDir) + strNetCmd + " logoff ";
            try {
                stringArray = this.NET_Exec(string2);
            }
            catch (SecurityException securityException) {
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private synchronized String getUserDescription(String string, String string2) throws PDCCliException {
        String[] stringArray;
        String string3 = "";
        int n = 0;
        if (string == null) {
            string = String.valueOf(strWinDir) + strNetCmd + " user " + string2;
        }
        try {
            stringArray = this.NET_Exec(string);
        }
        catch (SecurityException securityException) {
            throw new PDCCliException("EXM_EXECPROCFAILED");
        }
        catch (Exception exception) {
            throw new PDCCliException("EXM_EXECFAILED");
        }
        n = this.parseForSuccess(stringArray, null);
        if (n != 0) {
            throw new PDCCliException("EXM_CLI1");
        }
        String string4 = "Comment";
        string3 = AdminCommonTools.CMN_parseLinesForData(stringArray, string4);
        return string3;
    }

    private synchronized int setUserFullName(String string, String string2, String string3) throws PDCCliException {
        String[] stringArray;
        int n = 0;
        if (string == null) {
            string = String.valueOf(strWinDir) + strNetCmd + " user";
            string = String.valueOf(string) + string2 + " /FULLNAME:" + "\"" + string3 + "\"";
        }
        try {
            stringArray = this.NET_Exec(string);
        }
        catch (SecurityException securityException) {
            throw new PDCCliException("EXM_EXECPROCFAILED");
        }
        catch (Exception exception) {
            throw new PDCCliException("EXM_EXECFAILED");
        }
        n = this.parseForSuccess(stringArray, null);
        if (n != 0) {
            throw new PDCCliException("EXM_CLI1");
        }
        return n;
    }

    private synchronized String getUserFullName(String string, String string2) throws PDCCliException {
        String[] stringArray;
        String string3 = "";
        int n = 0;
        if (string == null) {
            string = String.valueOf(strWinDir) + strNetCmd + " user " + string2;
        }
        try {
            stringArray = this.NET_Exec(string);
        }
        catch (SecurityException securityException) {
            throw new PDCCliException("EXM_EXECPROCFAILED");
        }
        catch (Exception exception) {
            throw new PDCCliException("EXM_EXECFAILED");
        }
        n = this.parseForSuccess(stringArray, null);
        if (n != 0) {
            throw new PDCCliException("EXM_CLI1");
        }
        String string4 = "Full Name";
        string3 = AdminCommonTools.CMN_parseLinesForData(stringArray, string4);
        return string3;
    }

    private synchronized int setUserDescription(String string, String string2, String string3) throws PDCCliException {
        String[] stringArray;
        int n = 0;
        if (string == null) {
            string = String.valueOf(strWinDir) + strNetCmd + " user ";
            string = String.valueOf(string) + string2 + " /COMMENT:" + "\"" + string3 + "\"";
        }
        try {
            stringArray = this.NET_Exec(string);
        }
        catch (SecurityException securityException) {
            throw new PDCCliException("EXM_EXECPROCFAILED");
        }
        catch (Exception exception) {
            throw new PDCCliException("EXM_EXECFAILED");
        }
        n = this.parseForSuccess(stringArray, null);
        if (n != 0) {
            throw new PDCCliException("EXM_CLI1");
        }
        return n;
    }

    public synchronized UserObj getFullAttributes(SecurityToken securityToken, UserObj userObj) throws PDCCliException {
        PDCUserMgrFactoryImpl.getOSType();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        new Vector();
        Object[] objectArray = null;
        if (admsvr.isVerify()) {
            objectArray = new Object[]{userObj};
        }
        try {
            admsvr.checkVerifier(securityToken, null);
        }
        catch (AdminException adminException) {
            throw new PDCCliException("EXM_UM1", "getFullAttributes");
        }
        try {
            AdminMgmtScope adminMgmtScope = admsvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new PDCCliException("EXM_UF1", "getFullAttributes");
        }
        string4 = userObj.getUserName();
        string = String.valueOf(strWinDir) + strNetCmd + " user " + string4;
        String[] stringArray = this.NET_Exec(string);
        userObj = new UserObj(string4);
        string3 = "Comment";
        string2 = AdminCommonTools.CMN_parseLinesForData(stringArray, string3);
        string3 = "Full Name";
        string5 = AdminCommonTools.CMN_parseLinesForData(stringArray, string3);
        userObj.setUserType("Solaris and PC NetLink");
        userObj.setUserID("0");
        userObj.setUserDescription(string2);
        userObj.setUserFullName(string5);
        PDCPasswordAttr pDCPasswordAttr = new PDCPasswordAttr();
        try {
            cli.getAllPWDAttrs(pDCPasswordAttr, stringArray);
            userObj.setPDCPasswordAttr(pDCPasswordAttr);
        }
        catch (PDCCliException pDCCliException) {
            throw new PDCCliException("EXM_CLI5");
        }
        PDCGroupAttr pDCGroupAttr = new PDCGroupAttr();
        try {
            cli.getAllGroupAttrs(pDCGroupAttr);
        }
        catch (PDCCliException pDCCliException) {
            throw new PDCCliException("EXM_CLI3");
        }
        userObj.setPDCGroupAttr(pDCGroupAttr);
        PDCAccessAttr pDCAccessAttr = new PDCAccessAttr();
        try {
            cli.getAllAccessAttrs(pDCAccessAttr, string4);
            userObj.setPDCAccessAttr(pDCAccessAttr);
        }
        catch (PDCCliException pDCCliException) {
            throw new PDCCliException("EXM_CLI4");
        }
        PDCUserEnvAttr pDCUserEnvAttr = new PDCUserEnvAttr();
        try {
            cli.getAllENVAttributes(pDCUserEnvAttr, stringArray);
            userObj.setPDCUserEnvAttr(pDCUserEnvAttr);
        }
        catch (PDCCliException pDCCliException) {
            throw new PDCCliException("EXM_CLI6");
        }
        PDCPolicyAttr pDCPolicyAttr = new PDCPolicyAttr();
        try {
            cli.getAllPolicyAttrs(pDCPolicyAttr);
            userObj.setPDCPolicyAttr(pDCPolicyAttr);
        }
        catch (PDCCliException pDCCliException) {
            throw new PDCCliException("EXM_CLI7");
        }
        return userObj;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized UserObj modifyUser(SecurityToken var1_1, UserObj var2_2, UserObj var3_3) throws PDCCliException, AdminException {
        var6_4 = "";
        var7_5 = "";
        PDCUserMgrFactoryImpl.getOSType();
        var12_6 = null;
        var13_7 = new Vector<String>();
        var14_8 = new Vector();
        try {
            var12_6 = PDCUserMgrFactoryImpl.admsvr.getAuthenticatedContext(var1_1);
        }
        catch (AdminException v0) {
            UMgrTools.writeLog(var12_6, 2, "LM_1030", "LM_2152", null, "LM_USER_APP_NAME", PDCUserMgrFactoryImpl.admsvr);
            throw new PDCCliException("EXM_BSS");
        }
        var15_9 = null;
        if (PDCUserMgrFactoryImpl.admsvr.isVerify()) {
            var15_9 = new Object[]{var2_2, var3_3};
        }
        try {
            PDCUserMgrFactoryImpl.admsvr.checkVerifier(var1_1, var15_9);
        }
        catch (AdminVerificationException v1) {
            UMgrTools.writeLog(var12_6, 2, "LM_1020", "LM_2153", null, "LM_USER_APP_NAME", PDCUserMgrFactoryImpl.admsvr);
            throw new PDCCliException("EXM_UM1");
        }
        var16_10 = new File(String.valueOf(PDCUserMgrFactoryImpl.strWinDir) + PDCUserMgrFactoryImpl.strNetCmd);
        if (!var16_10.exists()) {
            UMgrTools.writeLog(var12_6, 2, "LM_2037", "LM_2156", null, "LM_USER_APP_NAME", PDCUserMgrFactoryImpl.admsvr);
            throw new PDCCliException("EXM_NO_CLI");
        }
        var8_11 = var2_2.getPDCPasswordAttr();
        if (var8_11 != null && var8_11.getPWDRequired()) {
            try {
                var17_12 = var8_11.getUserPassword();
                if (var17_12 != null) {
                    var7_5 = var12_6.decryptPassword((byte[])var17_12);
                }
            }
            catch (AdminException v2) {
                var17_13 = var12_6.getAdminPrincipal().getName();
                var18_14 = new String[]{var17_13};
                UMgrTools.writeLog(var12_6, 2, "LM_2011", "LM_2154", var18_14, "LM_USER_APP_NAME", PDCUserMgrFactoryImpl.admsvr);
                throw new PDCCliException("EXM_DECRYPT_PWD");
            }
        }
        if (PDCUserMgrFactoryImpl.bFirstRelease) {
            var13_7.addElement(String.valueOf(PDCUserMgrFactoryImpl.strWinDir) + PDCUserMgrFactoryImpl.strNetCmd);
            var13_7.addElement("user");
            var13_7.addElement(var2_2.getUserName());
            var17_12 = var3_3.getUserName();
            var18_15 = var2_2.getUserName();
            if (!var18_15.equals(var17_12)) {
                this.deleteUser(var12_6, var3_3);
                this.addUser(var12_6, var2_2);
            } else {
                block30: {
                    if (var8_11 != null && var8_11.getPWDRequired()) {
                        var13_7.addElement(var7_5);
                        var13_7.addElement("/PASSWORDREQ:YES");
                    } else {
                        var13_7.addElement("/PASSWORDREQ:NO");
                    }
                    var19_16 = var2_2.getUserDescription();
                    if (var19_16.length() > 46) {
                        var19_16 = var19_16.substring(0, 46);
                    }
                    var13_7.addElement("/COMMENT:\"" + (String)var19_16 + "\"");
                    var5_17 = new String[var13_7.size()];
                    var13_7.copyInto(var5_17);
                    var20_18 = String.valueOf(PDCUserMgrFactoryImpl.strWinDir) + PDCUserMgrFactoryImpl.strNetCmd + " user " + var2_2.getUserName();
                    var20_18 = var8_11 != null && var8_11.getPWDRequired() != false ? String.valueOf(var20_18) + " XXXX /PASSWORDREQ:YES" : String.valueOf(var20_18) + " /PASSWORDREQ:NO";
                    var20_18 = String.valueOf(var20_18) + " /COMMENT:\"" + (String)var19_16 + "\"";
                    try {
                        var14_8 = this.NET_Exec((String[])var5_17, true);
                        break block30;
                    }
                    catch (SecurityException var21_19) {
                        UMgrTools.writeLog(var12_6, 2, "LM_2011", "LM_2151", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_EXC", var21_19.getLocalizedMessage(), PDCUserMgrFactoryImpl.admsvr);
                        throw new PDCCliException("EXM_MOD_EXECPROCFAILED");
                    }
                    catch (Exception v3) {
                        var21_20 = "";
                        var22_21 = 0;
                        ** while (var22_21 < var13_7.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        var21_20 = String.valueOf(var21_20) + " " + var13_7.elementAt(var22_21);
                        ++var22_21;
                        continue;
                    }
lbl76:
                    // 1 sources

                    UMgrTools.writeLog(var12_6, 2, "LM_2011", "LM_2150", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_CLI", var20_18, PDCUserMgrFactoryImpl.admsvr);
                    throw new PDCCliException("EXM_MOD_EXECFAILED");
                }
                var2_2.setUserType("Solaris and PC NetLink");
            }
            var19_16 = new String[]{var2_2.getUserName()};
            UMgrTools.writeLog(var12_6, 0, "LM_2010", "LM_2053", var19_16, "LM_USER_APP_NAME", PDCUserMgrFactoryImpl.admsvr);
        } else {
            var6_4 = String.valueOf(PDCUserMgrFactoryImpl.strWinDir) + PDCUserMgrFactoryImpl.strNetCmd + " user " + var2_2.getUserName();
            var6_4 = String.valueOf(var6_4) + " " + var7_5;
            var17_12 = var2_2.getUserDescription();
            if (var17_12.length() > 46) {
                var17_12 = var17_12.substring(0, 46);
            }
            var6_4 = String.valueOf(var6_4) + " /ADD /COMMENT:\"" + (String)var17_12 + "\"";
            var6_4 = String.valueOf(var6_4) + " /FULLNAME:\"" + var2_2.getUserFullName() + "\"";
            var4_22 = this.NET_Exec(var6_4);
            try {
                PDCUserMgrFactoryImpl.cli.setAllPWDAttrs(var7_5, var8_11, var2_2.getUserName());
            }
            catch (Exception v4) {}
            var9_23 = var2_2.getPDCUserEnvAttr();
            try {
                PDCUserMgrFactoryImpl.cli.setAllENVAttributes(var9_23, var2_2.getUserName());
            }
            catch (Exception v5) {}
            var10_24 = var2_2.getPDCAccessAttr();
            try {
                PDCUserMgrFactoryImpl.cli.setAllAccessAttrs(var10_24, var2_2.getUserName());
            }
            catch (Exception v6) {}
            var11_25 = var2_2.getPDCPolicyAttr();
            try {
                PDCUserMgrFactoryImpl.cli.setAllPolicyAttrs(var11_25);
            }
            catch (Exception v7) {}
        }
        return var2_2;
    }

    public synchronized void addUser(SecurityToken securityToken, UserObj userObj) throws PDCCliException, AdminException {
        ServerSecurityContext serverSecurityContext = null;
        Vector vector = new Vector();
        try {
            serverSecurityContext = admsvr.getAuthenticatedContext(securityToken);
        }
        catch (AdminException adminException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_1030", "LM_2152", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_BSS");
        }
        Object[] objectArray = null;
        if (admsvr.isVerify()) {
            objectArray = new Object[]{userObj};
        }
        try {
            admsvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_1020", "LM_2153", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_UM1");
        }
        this.addUser(serverSecurityContext, userObj);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void addUser(ServerSecurityContext var1_1, UserObj var2_2) throws PDCCliException, AdminException {
        block12: {
            var5_3 = "";
            var7_4 = new Vector<String>();
            var8_5 = new File(String.valueOf(PDCUserMgrFactoryImpl.strWinDir) + PDCUserMgrFactoryImpl.strNetCmd);
            if (!var8_5.exists()) {
                UMgrTools.writeLog(var1_1, 2, "LM_2037", "LM_2156", null, "LM_USER_APP_NAME", PDCUserMgrFactoryImpl.admsvr);
                throw new PDCCliException("EXM_NO_CLI");
            }
            var6_6 = var2_2.getPDCPasswordAttr();
            if (var6_6 != null && var6_6.getPWDRequired()) {
                try {
                    var9_7 = var6_6.getUserPassword();
                    if (var9_7 != null) {
                        var5_3 = var1_1.decryptPassword((byte[])var9_7);
                    }
                }
                catch (AdminException v0) {
                    var9_8 = var1_1.getAdminPrincipal().getName();
                    var10_9 = new String[]{var9_8};
                    UMgrTools.writeLog(var1_1, 2, "LM_2007", "LM_2154", var10_9, "LM_USER_APP_NAME", PDCUserMgrFactoryImpl.admsvr);
                    throw new PDCCliException("EXM_DECRYPT_PWD");
                }
            }
            var7_4.addElement(String.valueOf(PDCUserMgrFactoryImpl.strWinDir) + PDCUserMgrFactoryImpl.strNetCmd);
            var7_4.addElement("user");
            var7_4.addElement(var2_2.getUserName());
            if (var6_6 != null && var6_6.getPWDRequired()) {
                var7_4.addElement(var5_3);
                var7_4.addElement("/PASSWORDREQ:YES");
            } else {
                var7_4.addElement("/PASSWORDREQ:NO");
            }
            var7_4.addElement("/ADD");
            var9_7 = var2_2.getUserDescription();
            if (var9_7.length() > 46) {
                var9_7 = var9_7.substring(0, 46);
            }
            var7_4.addElement("/COMMENT:\"" + (String)var9_7 + "\"");
            var4_11 = new String[var7_4.size()];
            var7_4.copyInto(var4_11);
            var10_10 = String.valueOf(PDCUserMgrFactoryImpl.strWinDir) + PDCUserMgrFactoryImpl.strNetCmd + " user " + var2_2.getUserName();
            var10_10 = var6_6 != null && var6_6.getPWDRequired() != false ? String.valueOf(var10_10) + " XXXX /PASSWORDREQ:YES" : String.valueOf(var10_10) + " /PASSWORDREQ:NO";
            var10_10 = String.valueOf(var10_10) + " /ADD /COMMENT:\"" + (String)var9_7 + "\"";
            try {
                var11_12 = this.NET_Exec((String[])var4_11, true);
                var3_15 = (String[])var11_12.elementAt(0);
                break block12;
            }
            catch (SecurityException var11_13) {
                UMgrTools.writeLog(var1_1, 2, "LM_2007", "LM_2151", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_EXC", var11_13.getLocalizedMessage(), PDCUserMgrFactoryImpl.admsvr);
                throw new PDCCliException("EXM_ADD_EXECPROCFAILED");
            }
            catch (Exception v1) {
                var11_14 = "";
                var12_16 = 0;
                ** while (var12_16 < var7_4.size())
            }
lbl-1000:
            // 1 sources

            {
                var11_14 = String.valueOf(var11_14) + " " + var7_4.elementAt(var12_16);
                ++var12_16;
                continue;
            }
lbl51:
            // 1 sources

            UMgrTools.writeLog(var1_1, 2, "LM_2007", "LM_2150", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_CLI", var10_10, PDCUserMgrFactoryImpl.admsvr);
            throw new PDCCliException("EXM_ADD_EXECFAILED");
        }
        var11_12 = new String[]{var2_2.getUserName()};
        UMgrTools.writeLog(var1_1, 0, "LM_2006", "LM_2051", var11_12, "LM_USER_APP_NAME", PDCUserMgrFactoryImpl.admsvr);
    }

    public synchronized void deleteUser(SecurityToken securityToken, UserObj userObj) throws PDCCliException, AdminException {
        ServerSecurityContext serverSecurityContext = null;
        try {
            serverSecurityContext = admsvr.getAuthenticatedContext(securityToken);
        }
        catch (AdminException adminException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_1030", "LM_2152", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_BSS");
        }
        Object[] objectArray = null;
        if (admsvr.isVerify()) {
            objectArray = new Object[]{userObj};
        }
        try {
            admsvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_1020", "LM_2153", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_UM1");
        }
        this.deleteUser(serverSecurityContext, userObj);
    }

    private synchronized void deleteUser(ServerSecurityContext serverSecurityContext, UserObj userObj) throws PDCCliException, AdminException {
        int n = 1;
        String string = "";
        boolean bl = false;
        File file = new File(String.valueOf(strWinDir) + strNetCmd);
        if (!file.exists()) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2037", "LM_2156", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_NO_CLI");
        }
        try {
            bl = this.userAccountExists(serverSecurityContext, userObj);
        }
        catch (Exception exception) {
            bl = true;
            throw new PDCCliException("EXM_CANT_GET_USERS", userObj.getUserName());
        }
        if (bl) {
            String[] stringArray;
            string = String.valueOf(strWinDir) + strNetCmd + " user ";
            string = String.valueOf(string) + userObj.getUserName() + " /DELETE";
            try {
                stringArray = this.NET_Exec(string);
            }
            catch (SecurityException securityException) {
                UMgrTools.writeLog(serverSecurityContext, 2, "LM_2009", "LM_2151", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_EXC", securityException.getLocalizedMessage(), admsvr);
                throw new PDCCliException("EXM_DEL_EXECPROCFAILED");
            }
            catch (Exception exception) {
                UMgrTools.writeLog(serverSecurityContext, 2, "LM_2009", "LM_2150", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_CLI", string, admsvr);
                throw new PDCCliException("EXM_DEL_EXECFAILED");
            }
            n = this.parseForSuccess(stringArray, null);
            if (n != 0) {
                UMgrTools.writeLog(serverSecurityContext, 2, "LM_2009", "LM_2150", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_CLI", string, admsvr);
                throw new PDCCliException("EXM_CLI_DEL_FAILED");
            }
            String[] stringArray2 = new String[]{userObj.getUserName()};
            UMgrTools.writeLog(serverSecurityContext, 0, "LM_2008", "LM_2052", stringArray2, "LM_USER_APP_NAME", admsvr);
        }
    }

    public boolean userAccountExists(SecurityToken securityToken, UserObj userObj) throws PDCCliException, RemoteException {
        boolean bl = false;
        userObj.getUserName();
        ServerSecurityContext serverSecurityContext = null;
        try {
            serverSecurityContext = admsvr.getAuthenticatedContext(securityToken);
        }
        catch (AdminException adminException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_1030", "LM_2152", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_BSS");
        }
        Object[] objectArray = null;
        if (admsvr.isVerify()) {
            objectArray = new Object[]{userObj};
        }
        try {
            admsvr.checkVerifier(securityToken, null);
        }
        catch (AdminException adminException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_1020", "LM_2153", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_UM1");
        }
        bl = this.userAccountExists(serverSecurityContext, userObj);
        return bl;
    }

    private boolean userAccountExists(ServerSecurityContext serverSecurityContext, UserObj userObj) throws PDCCliException, RemoteException {
        boolean bl = false;
        String string = userObj.getUserName();
        Vector vector = this.getAllUsers(serverSecurityContext);
        int n = 0;
        while (n < vector.size()) {
            UserObj userObj2 = (UserObj)vector.elementAt(n);
            if (string.equals(userObj2.getUserName())) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public synchronized Vector getAllUsers(SecurityToken securityToken) throws PDCCliException {
        PDCUserMgrFactoryImpl.getOSType();
        ServerSecurityContext serverSecurityContext = null;
        Vector vector = new Vector();
        Object[] objectArray = null;
        if (admsvr.isVerify()) {
            objectArray = new Object[1];
        }
        try {
            admsvr.checkVerifier(securityToken, null);
        }
        catch (AdminException adminException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_1020", "LM_2153", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_UM1");
        }
        try {
            serverSecurityContext = admsvr.getAuthenticatedContext(securityToken);
        }
        catch (AdminException adminException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_1030", "LM_2152", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_BSS");
        }
        vector = this.getAllUsers(serverSecurityContext);
        return vector;
    }

    private synchronized Vector getAllUsers(ServerSecurityContext serverSecurityContext) throws PDCCliException {
        String[] stringArray;
        String[] stringArray2 = null;
        PDCUserMgrFactoryImpl.getOSType();
        String string = "";
        int n = 0;
        Vector<UserObj> vector = new Vector<UserObj>();
        string = String.valueOf(strWinDir) + strNetCmd + " user ";
        File file = new File(String.valueOf(strWinDir) + strNetCmd);
        if (!file.exists()) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2037", "LM_2156", null, "LM_USER_APP_NAME", admsvr);
            throw new PDCCliException("EXM_NO_CLI");
        }
        try {
            stringArray = this.NET_Exec(string);
        }
        catch (SecurityException securityException) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2036", "LM_2151", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_EXC", securityException.getLocalizedMessage(), admsvr);
            throw new PDCCliException("EXM_GET_EXECPROCFAILED");
        }
        catch (Exception exception) {
            UMgrTools.writeLog(serverSecurityContext, 2, "LM_2036", "LM_2150", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_CLI", string, admsvr);
            throw new PDCCliException("EXM_GET_EXECFAILED");
        }
        stringArray2 = this.parseNTGetUserNameInfo(stringArray);
        if (stringArray2.length - 1 >= 0) {
            n = 0;
            while (n < stringArray2.length - 1) {
                UserObj userObj = new UserObj(stringArray2[n]);
                vector.addElement(userObj);
                ++n;
            }
        }
        return vector;
    }

    public synchronized Vector getAllUsers(SecurityToken securityToken, ListProperties listProperties) throws NTDllException, PDCCliException, AdminException {
        Vector<UserObj> vector;
        block14: {
            String[] stringArray;
            String[] stringArray2 = null;
            PDCUserMgrFactoryImpl.getOSType();
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            vector = new Vector<UserObj>();
            int n = 0;
            ServerSecurityContext serverSecurityContext = null;
            try {
                serverSecurityContext = admsvr.getAuthenticatedContext(securityToken);
            }
            catch (AdminException adminException) {
                UMgrTools.writeLog(serverSecurityContext, 2, "LM_1030", "LM_2152", null, "LM_USER_APP_NAME", admsvr);
                throw new PDCCliException("EXM_BSS");
            }
            Object[] objectArray = null;
            if (admsvr.isVerify()) {
                objectArray = new Object[]{listProperties};
            }
            try {
                admsvr.checkVerifier(securityToken, null);
            }
            catch (AdminException adminException) {
                UMgrTools.writeLog(serverSecurityContext, 2, "LM_1020", "LM_2153", null, "LM_USER_APP_NAME", admsvr);
                throw new PDCCliException("EXM_UM1");
            }
            File file = new File(String.valueOf(strWinDir) + strNetCmd);
            if (!file.exists()) {
                UMgrTools.writeLog(serverSecurityContext, 2, "LM_2037", "LM_2156", null, "LM_USER_APP_NAME", admsvr);
                throw new PDCCliException("EXM_NO_CLI");
            }
            string = String.valueOf(strWinDir) + strNetCmd + " user ";
            try {
                stringArray = this.NET_Exec(string);
            }
            catch (SecurityException securityException) {
                UMgrTools.writeLog(serverSecurityContext, 2, "LM_2036", "LM_2151", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_EXC", securityException.getLocalizedMessage(), admsvr);
                throw new PDCCliException("EXM_GET_EXECPROCFAILED");
            }
            catch (Exception exception) {
                UMgrTools.writeLog(serverSecurityContext, 2, "LM_2036", "LM_2150", null, "LM_USER_APP_NAME", "LM_LABEL_UMGR_CLI", string, admsvr);
                throw new PDCCliException("EXM_GET_EXECFAILED");
            }
            stringArray2 = this.parseNTGetUserNameInfo(stringArray);
            if (stringArray2.length - 1 < 0) break block14;
            if (bFirstRelease) {
                n = 0;
                while (n < stringArray2.length - 1) {
                    UserObj userObj = new UserObj(stringArray2[n]);
                    if (stringArray2[n] != null) {
                        vector.addElement(userObj);
                    }
                    ++n;
                }
            } else {
                n = 0;
                while (n < stringArray2.length - 1) {
                    UserObj userObj = new UserObj(stringArray2[n]);
                    string = String.valueOf(strWinDir) + strNetCmd + " user " + stringArray2[n];
                    stringArray = this.NET_Exec(string);
                    string2 = "Comment";
                    string3 = AdminCommonTools.CMN_parseLinesForData(stringArray, string2);
                    string2 = "Full Name";
                    string4 = AdminCommonTools.CMN_parseLinesForData(stringArray, string2);
                    userObj.setUserType("Solaris and PC NetLink");
                    userObj.setUserID("0");
                    userObj.setUserDescription(string3);
                    userObj.setUserFullName(string4);
                    vector.addElement(userObj);
                    ++n;
                }
            }
        }
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    private String[] parseNTGetUserNameInfo(String[] var1_1) throws PDCCliException {
        var3_2 = "";
        var4_3 = "";
        var5_4 = false;
        var6_5 = 0;
        var7_6 = 0;
        var2_7 = new Vector<String>();
        var6_5 = 0;
        while (var6_5 < var1_1.length) {
            block7: {
                var3_2 = var1_1[var6_5];
                if (var3_2 == null || !var5_4) break block7;
                var7_6 = 0;
                ** GOTO lbl25
                {
                    var9_8 = new Character(var3_2.charAt(var7_6));
                    var4_3 = String.valueOf(var4_3) + new String(var9_8.toString());
                    if (var7_6 < var3_2.length() - 1) {
                        ++var7_6;
                    }
                    do {
                        if (var7_6 < var3_2.length() - 1 && (Character.isLetterOrDigit(var3_2.charAt(var7_6)) || var3_2.charAt(var7_6) == '|' || var3_2.charAt(var7_6) == '_' || var3_2.charAt(var7_6) == ' ' && Character.isLetterOrDigit(var3_2.charAt(var7_6 + 1)) || var3_2.charAt(var7_6) == '-')) continue block1;
                        if (!var4_3.equals("")) {
                            var4_3 = var4_3.trim();
                            var2_7.addElement(var4_3);
                            var4_3 = "";
                        }
                        if (var7_6 >= var3_2.length() - 1) continue;
                        ++var7_6;
lbl25:
                        // 3 sources

                    } while (var7_6 < var3_2.length() - 1 && var3_2.charAt(var7_6) != '\n');
                }
            }
            if (var3_2 != null && var3_2.indexOf("--------") != -1) {
                var5_4 = true;
            }
            ++var6_5;
        }
        if (!var5_4) {
            throw new PDCCliException("EXM_CLI1");
        }
        var8_9 = new String[var2_7.size() + 1];
        var2_7.copyInto(var8_9);
        var8_9[var2_7.size()] = null;
        return var8_9;
    }

    private int parseForSuccess(String[] stringArray, String string) {
        String string2 = "";
        String string3 = "The command completed successfully.";
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        if (string != null) {
            string3 = string;
        }
        n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n];
            if (string2.indexOf(string3) != -1) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            n2 = 1;
        }
        return n2;
    }

    public UserAttrObj getAdminUserAttr(SecurityToken securityToken) throws SolServerException {
        UserAttrObj userAttrObj = null;
        return userAttrObj;
    }

    public AuthAttrObj[] getAuthAttrList(SecurityToken securityToken) throws SolServerException {
        AuthAttrObj[] authAttrObjArray = null;
        return authAttrObjArray;
    }

    public String getNextAvailableUID(SecurityToken securityToken) throws SolServerException {
        return "";
    }

    public String getNextAvailableGID(SecurityToken securityToken) throws SolServerException {
        return "";
    }

    public boolean checkHomeDirSize(SecurityToken securityToken, UserObj userObj, int n) throws RemoteException, SolServerException {
        return true;
    }

    public UserObj getPermissions(SecurityToken securityToken, UserObj userObj) throws RemoteException, SolServerException {
        return userObj;
    }

    public void createHomeDir(SecurityToken securityToken, UserObj userObj) throws RemoteException, SolServerException {
    }

    public UserObj modifyHomeDir(SecurityToken securityToken, UserObj userObj, UserObj userObj2) throws RemoteException, SolServerException {
        return userObj;
    }

    public void createMailbox(SecurityToken securityToken, UserObj userObj) throws RemoteException, SolServerException {
    }

    public UserObj modifyMailbox(SecurityToken securityToken, UserObj userObj, UserObj userObj2) throws RemoteException, SolServerException {
        return userObj;
    }

    public Vector getAllGroups(SecurityToken securityToken, ListProperties listProperties) throws RemoteException, SolServerException {
        Vector vector = new Vector();
        return vector;
    }

    public Vector getAllGroups(SecurityToken securityToken) throws RemoteException, SolServerException {
        Vector vector = new Vector();
        return vector;
    }

    public void deleteGroup(SecurityToken securityToken, GroupObj groupObj) throws RemoteException, SolServerException {
    }

    public void addGroup(SecurityToken securityToken, GroupObj groupObj) throws RemoteException, SolServerException {
    }

    public GroupObj modifyGroup(SecurityToken securityToken, GroupObj groupObj, GroupObj groupObj2) throws RemoteException, SolServerException {
        return groupObj;
    }

    public GroupObj addUsersToGroup(SecurityToken securityToken, GroupObj groupObj, String[] stringArray) throws RemoteException, SolServerException {
        return groupObj;
    }

    public GroupObj deleteUsersFromGroup(SecurityToken securityToken, GroupObj groupObj, String[] stringArray) throws RemoteException, SolServerException {
        return groupObj;
    }

    public GroupObj getGroupAttributes(SecurityToken securityToken, GroupObj groupObj) throws RemoteException, SolServerException {
        return groupObj;
    }

    public Vector getAllEmailAliases(SecurityToken securityToken) throws SolServerException {
        Vector vector = new Vector();
        return vector;
    }

    public Vector getAllEmailAliases(SecurityToken securityToken, ListProperties listProperties) throws SolServerException {
        Vector vector = new Vector();
        return vector;
    }

    public EmailAliasObj getEmailAliasAttributes(SecurityToken securityToken, EmailAliasObj emailAliasObj) throws SolServerException {
        return emailAliasObj;
    }

    public void deleteEmailAlias(SecurityToken securityToken, EmailAliasObj emailAliasObj) throws SolServerException {
    }

    public void addEmailAlias(SecurityToken securityToken, EmailAliasObj emailAliasObj) throws SolServerException {
    }

    public EmailAliasObj modifyEmailAlias(SecurityToken securityToken, EmailAliasObj emailAliasObj, EmailAliasObj emailAliasObj2) throws SolServerException {
        return emailAliasObj;
    }

    public static void main(String[] stringArray) {
        String string = "\ntype: PDCUserMgrFactoryImpl [optional: -P <path of system32 dir>]\n";
        String string2 = null;
        int n = 0;
        if (stringArray.length > 1) {
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase("-P") && n + 1 <= stringArray.length) {
                    strWinDir = stringArray[++n];
                } else if (stringArray[n].equalsIgnoreCase("-H") || stringArray[n].equalsIgnoreCase("-HELP")) {
                    System.exit(1);
                } else {
                    AdminCommonTools.CMN_HandleOutput(string);
                    System.exit(1);
                }
                ++n;
            }
        }
        System.setSecurityManager(new RMISecurityManager());
        try {
            String string3 = PDCUserMgrFactoryImpl.getOSType();
            String string4 = "Windows NT";
            PDCUserMgrFactoryImpl pDCUserMgrFactoryImpl = new PDCUserMgrFactoryImpl();
            string2 = "rmi://" + InetAddress.getLocalHost().getHostAddress() + ":" + iRMIPort + "/UserMgrFactory";
            if (string3.equals(string4) && !PDCUserMgrFactoryImpl.startDLLOnNT()) {
                System.exit(1);
            }
            try {
                LocateRegistry.createRegistry(iRMIPort);
            }
            catch (RemoteException remoteException) {
                AdminCommonTools.CMN_HandleOutput("\n registry already running?");
            }
            Naming.rebind(string2, pDCUserMgrFactoryImpl);
            AdminCommonTools.CMN_HandleOutput("PDCUserMgrFactoryImpl bound in registry to port " + iRMIPort);
            return;
        }
        catch (RemoteException remoteException) {
            AdminCommonTools.CMN_HandleOutput("could not connect to registry:  " + string2);
            AdminCommonTools.CMN_HandleOutput("PDCUserMgrFactoryImpl error: " + remoteException.getMessage());
            AdminCommonTools.CMN_TraceStack(1, remoteException);
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("Error while trying to connect to " + string2);
            AdminCommonTools.CMN_HandleOutput("PDCUserMgrFactoryImpl error: " + exception.getMessage());
            AdminCommonTools.CMN_TraceStack(1, exception);
            return;
        }
    }

    private void setServerPaths() {
        String string = "\ntype: PDCUserMgrFactoryImpl [optional: -P <path of system32 dir>]\n";
        File file = new File(" ");
        String string2 = "1099";
        String string3 = PDCUserMgrFactoryImpl.getOSType();
        String string4 = "Windows NT";
        try {
            serverProps = new AdminProps("admin.server.properties", "AdminServer.properties", 0);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_TraceStack(1, exception);
        }
        try {
            string2 = serverProps.getAdminProp("admin.server.port");
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_TraceStack(1, adminException);
        }
        iRMIPort = string2 == null || string2.trim().length() == 0 ? 1099 : new Integer(string2);
        try {
            strWinDir = serverProps.getAdminProp("admin.server.net_cli.path");
            String string5 = serverProps.getAdminProp("admin.server.net_cli.package");
            String string6 = "pkginfo -l " + string5;
            String[] stringArray = this.NET_Exec(string6);
            String string7 = "BASEDIR:";
            String string8 = AdminCommonTools.CMN_parseLinesForData(stringArray, string7);
            if (!string8.equals("/")) {
                strWinDir = String.valueOf(string8) + strWinDir;
            }
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_TraceStack(1, adminException);
        }
        if (strWinDir != null && strWinDir.trim() != "") {
            file = new File(strWinDir);
        }
        if (!file.exists()) {
            strWinDir = "/opt/lanman/bin";
            file = new File(strWinDir);
        }
        if (!file.exists()) {
            AdminCommonTools.CMN_HandleOutput(string);
            System.exit(1);
        }
        if (string3.equals(string4)) {
            strWinDir = String.valueOf(strWinDir) + File.separator;
            strNetCmd = "net1 /DOMAIN";
        } else {
            strWinDir = String.valueOf(strWinDir) + File.separator;
            strNetCmd = "net";
        }
        cli = new NTCommandLines(strWinDir);
    }

    public String[] NET_Exec(String string) {
        String[] stringArray = new String[]{"LANG=en_US", "LC_ALL=en_US"};
        String[] stringArray2 = AdminCommonTools.CMN_exec(string, stringArray);
        return stringArray2;
    }

    public Vector NET_Exec(String[] stringArray, boolean bl) {
        String[] stringArray2 = new String[]{"LC_ALL=C", "LC_MESSAGES=C", "LANG=C"};
        Vector vector = AdminCommonTools.CMN_exec(stringArray, bl, stringArray2);
        return vector;
    }

    static {
        serverProps = null;
        bFirstRelease = true;
        APP_NAME = "com.sun.admin.usermgr.server.PDCUserMgrFactoryImpl";
    }
}

