/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.security.AdminSecurityUtil;
import com.sun.admin.usermgr.client.MultiUserXferObj;
import com.sun.admin.usermgr.client.UserMgrClient;
import com.sun.admin.usermgr.common.PDCPasswordAttr;
import com.sun.admin.usermgr.common.Permissions;
import com.sun.admin.usermgr.common.SolAccountAttr;
import com.sun.admin.usermgr.common.SolGroupAttr;
import com.sun.admin.usermgr.common.SolHomedirAttr;
import com.sun.admin.usermgr.common.SolPasswordAttr;
import com.sun.admin.usermgr.common.SolServerPartialSuccessException;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UserException;
import com.sun.admin.usermgr.common.UserMgrIDAlreadyInUseException;
import com.sun.admin.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.admin.usermgr.common.UserObj;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Vector;

public class MultiUser {
    MultiUserXferObj muxo = null;
    UserMgrClient userMgrClient;

    public MultiUser(String string, UserMgrClient userMgrClient) throws AdminException {
        this.userMgrClient = userMgrClient;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.muxo = (MultiUserXferObj)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("MultiUser: Error reading data transfer file: " + exception.getMessage());
            this.logError("LM_2057", exception);
            throw new UserException("EXM_AMU1");
        }
        AdminCommonTools.CMN_Trace3("Adding multiple users:");
        AdminCommonTools.CMN_Trace3("   Number users:  " + this.muxo.numberUsers);
        AdminCommonTools.CMN_Trace3("   Type of add:   " + this.muxo.addType);
        if (this.muxo.addType == 1) {
            AdminCommonTools.CMN_Trace3("   User prefix:   " + this.muxo.namePrefix);
            AdminCommonTools.CMN_Trace3("   User suffix:   " + this.muxo.nameInitialSuffix);
            AdminCommonTools.CMN_Trace3("   User incr:     " + this.muxo.nameIncrementSuffix);
        } else {
            AdminCommonTools.CMN_Trace3("   User list size:" + this.muxo.userList.size());
        }
        AdminCommonTools.CMN_Trace3("   Description:   " + this.muxo.userDescription);
        AdminCommonTools.CMN_Trace3("   First user id: " + this.muxo.initialUserId);
        AdminCommonTools.CMN_Trace3("   Primary group: " + this.muxo.priGid);
        AdminCommonTools.CMN_Trace3("   Home server:   " + this.muxo.hdirServer);
        AdminCommonTools.CMN_Trace3("   Home pathname: " + this.muxo.hdirPath);
        AdminCommonTools.CMN_Trace3("   Autohome on:   " + (this.muxo.hdirAutomount ? "Yes" : "No"));
        AdminCommonTools.CMN_Trace3("   Mail server:   " + this.muxo.mailServer);
        AdminCommonTools.CMN_Trace3("   Unix shell:    " + this.muxo.unixShell);
        AdminCommonTools.CMN_Trace3("   Expire date:   " + this.muxo.pswdExpireDate);
        AdminCommonTools.CMN_Trace3("   Change days:   " + this.muxo.pswdChangeDays);
        AdminCommonTools.CMN_Trace3("   Alert days:    " + this.muxo.pswdAlertDays);
        AdminCommonTools.CMN_Trace3("   No reuse days: " + this.muxo.pswdReuseDays);
        AdminCommonTools.CMN_Trace3("   Inactive days: " + this.muxo.pswdIdleDays);
        AdminCommonTools.CMN_Trace3("   Add to Solaris:" + (this.muxo.addSolarisUser ? "Yes" : "No"));
        AdminCommonTools.CMN_Trace3("   Add to PDC:    " + (this.muxo.addPDCUser ? "Yes" : "No"));
    }

    public void createUsers() throws AdminException {
        Object object;
        Cloneable cloneable;
        UserObj userObj = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        SolHomedirAttr solHomedirAttr = null;
        int n = 0;
        try {
            n = Integer.parseInt(this.muxo.initialUserId);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("MultiUser: Error converting base user identifier");
            this.logError("LM_2056", exception);
            throw new UserException("EXM_AMU1");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n2 = this.muxo.numberUsers;
        this.logStart(n2);
        userObj = new UserObj();
        string2 = this.muxo.hashPswd != null && this.muxo.hashPswd.length() > 0 ? AdminSecurityUtil.unhashPassword(this.muxo.hashPswd) : "";
        userObj.setUserDescription(this.muxo.userDescription);
        if (this.muxo.addSolarisUser && this.muxo.addPDCUser) {
            userObj.setUserType("Solaris and PC NetLink");
        } else if (this.muxo.addPDCUser) {
            userObj.setUserType("Solaris and PC NetLink");
        } else {
            userObj.setUserType("Solaris");
        }
        if (this.muxo.addPDCUser) {
            cloneable = new PDCPasswordAttr();
            ((PDCPasswordAttr)cloneable).setPWDExpireDate("NEVER");
            ((PDCPasswordAttr)cloneable).setPWDChangeAtNextLogon(false);
            ((PDCPasswordAttr)cloneable).setAccountLockedOutVal(false);
            ((PDCPasswordAttr)cloneable).setPWDChangeAllowedByUser(true);
            ((PDCPasswordAttr)cloneable).setPWDNeverExpires(true);
            if (string2.length() == 0) {
                ((PDCPasswordAttr)cloneable).setPWDRequired(false);
            } else {
                ((PDCPasswordAttr)cloneable).setPWDRequired(true);
            }
            userObj.setPDCPasswordAttr((PDCPasswordAttr)cloneable);
            userObj = this.userMgrClient.setUpPDCPassword(string2, userObj);
        }
        if (this.muxo.addSolarisUser) {
            cloneable = new SolPasswordAttr();
            ((SolPasswordAttr)cloneable).setMustChangeDays(this.muxo.pswdChangeDays);
            ((SolPasswordAttr)cloneable).setAlertChangeDays(this.muxo.pswdAlertDays);
            ((SolPasswordAttr)cloneable).setCannotChangeDays(this.muxo.pswdReuseDays);
            ((SolPasswordAttr)cloneable).setInactiveDays(this.muxo.pswdIdleDays);
            userObj.setSolPasswordAttr((SolPasswordAttr)cloneable);
            userObj = this.userMgrClient.setUpPassword(string2, userObj);
            object = new SolGroupAttr();
            ((SolGroupAttr)object).setPrimaryGroup(this.muxo.priGid);
            ((SolGroupAttr)object).setNumberSecondaryGroups(0);
            userObj.setSolGroupAttr((SolGroupAttr)object);
            SolServicesAttr solServicesAttr = new SolServicesAttr();
            solServicesAttr.setInitialShell(this.muxo.unixShell);
            solServicesAttr.setMailServer(this.muxo.mailServer);
            userObj.setSolServicesAttr(solServicesAttr);
            SolAccountAttr solAccountAttr = userObj.getSolAccountAttr();
            if (solAccountAttr == null) {
                solAccountAttr = new SolAccountAttr();
                userObj.setSolAccountAttr(solAccountAttr);
            }
            solAccountAttr.setAccountExpires(this.muxo.pswdExpireDate);
            solHomedirAttr = new SolHomedirAttr();
            string3 = new String(this.muxo.hdirPath);
            if (!string3.endsWith("/")) {
                string3 = string3.concat("/");
            }
            solHomedirAttr.setServer(this.muxo.hdirServer);
            Permissions permissions = new Permissions();
            permissions.setOwner(7);
            permissions.setGroup(5);
            solHomedirAttr.setPerms(permissions);
            solHomedirAttr.setAutomount(this.muxo.hdirAutomount);
            userObj.setSolHomedirAttr(solHomedirAttr);
        }
        object = "user";
        int n6 = 1;
        int n7 = 1;
        int n8 = this.muxo.addType;
        if (n8 == 1) {
            object = this.muxo.namePrefix;
            n6 = this.muxo.nameInitialSuffix;
            n7 = this.muxo.nameIncrementSuffix;
        }
        AdminCommonTools.CMN_Trace3("MultiUser: Starting to add users...");
        int n9 = 0;
        while (n9 < n2) {
            if (n8 == 0) {
                string = (String)this.muxo.userList.elementAt(n9);
            }
            boolean bl = false;
            while (!bl) {
                bl = true;
                if (n8 == 1) {
                    string = String.valueOf(object) + new Integer(n6).toString();
                }
                userObj.setUserName(string);
                userObj.setUserID(new Integer(n).toString());
                solHomedirAttr.setPathname(string3.concat(string));
                AdminCommonTools.CMN_Trace3("MultiUser: Adding user " + string);
                boolean bl2 = true;
                try {
                    this.userMgrClient.addUser(userObj);
                }
                catch (UserMgrNameAlreadyInUseException userMgrNameAlreadyInUseException) {
                    AdminCommonTools.CMN_Trace3("MultiUser: Name " + string + " already exists");
                    bl2 = false;
                    if (n8 == 1) {
                        n6 += n7;
                        bl = false;
                    } else {
                        this.logDupName(string);
                        ++n5;
                    }
                }
                catch (UserMgrIDAlreadyInUseException userMgrIDAlreadyInUseException) {
                    AdminCommonTools.CMN_Trace3("MultiUser: Uid " + n + " already exists");
                    bl2 = false;
                    bl = false;
                    ++n;
                }
                catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                    AdminCommonTools.CMN_Trace3("MultiUser: Partial failure error");
                    bl2 = false;
                    ++n4;
                }
                catch (Exception exception) {
                    AdminCommonTools.CMN_Trace1("MultiUser: Error creating user: " + exception.getMessage());
                    this.logError("LM_2062", exception);
                    bl2 = false;
                    ++n5;
                }
                if (!bl2) continue;
                ++n3;
            }
            ++n;
            if (n8 == 1) {
                n6 += n7;
            }
            ++n9;
        }
        this.logFinish(n2, n3, n4, n5);
    }

    private void logStart(int n) {
        Vector<String> vector = null;
        vector = new Vector<String>(1);
        vector.addElement(new Integer(n).toString());
        LogRecord logRecord = this.userMgrClient.initLogRecord(0, "LM_2041", "LM_2054", vector);
        logRecord.addData("LM_UM_UNUM", new Integer(this.muxo.numberUsers).toString());
        if (this.muxo.addType == 1) {
            logRecord.addData("LM_UM_TYPE1", "");
            logRecord.addData("LM_UM_PRFX", this.muxo.namePrefix);
            logRecord.addData("LM_UM_SUFX", new Integer(this.muxo.nameInitialSuffix).toString());
            logRecord.addData("LM_UM_INCR", new Integer(this.muxo.nameIncrementSuffix).toString());
        } else {
            logRecord.addData("LM_UM_TYPE0", "");
        }
        logRecord.addData("LM_UM_DESC", this.muxo.userDescription);
        logRecord.addData("LM_UM_UID", this.muxo.initialUserId);
        logRecord.addData("LM_UM_GRP", this.muxo.priGid);
        logRecord.addData("LM_UM_SHELL", this.muxo.unixShell);
        logRecord.addData("LM_UM_HDSRV", this.muxo.hdirServer);
        logRecord.addData("LM_UM_HDPATH", this.muxo.hdirPath);
        logRecord.addData("LM_UM_HDAUTO", this.muxo.hdirAutomount ? "Yes" : "No");
        logRecord.addData("LM_UM_MAILSRV", this.muxo.mailServer);
        logRecord.addData("LM_UM_PSWD_EXP", this.muxo.pswdExpireDate);
        logRecord.addData("LM_UM_PSWD_CHG", this.muxo.pswdChangeDays);
        logRecord.addData("LM_UM_PSWD_ALT", this.muxo.pswdAlertDays);
        logRecord.addData("LM_UM_PSWD_USE", this.muxo.pswdReuseDays);
        logRecord.addData("LM_UM_PSWD_INA", this.muxo.pswdIdleDays);
        logRecord.addData("LM_UM_SOL_ADD", this.muxo.addSolarisUser ? "Yes" : "No");
        logRecord.addData("LM_UM_PDC_ADD", this.muxo.addPDCUser ? "Yes" : "No");
        try {
            this.userMgrClient.writeLogRecord(logRecord);
            return;
        }
        catch (AdminException adminException) {
            return;
        }
    }

    private void logFinish(int n, int n2, int n3, int n4) {
        Vector<String> vector = null;
        vector = new Vector<String>(1);
        vector.addElement(new Integer(n).toString());
        LogRecord logRecord = this.userMgrClient.initLogRecord(0, "LM_2041", "LM_2055", vector);
        logRecord.addData("LM_UM_NUM_USERS", new Integer(n).toString());
        logRecord.addData("LM_UM_NUM_ADDED", new Integer(n2).toString());
        logRecord.addData("LM_UM_NUM_PARTS", new Integer(n3).toString());
        logRecord.addData("LM_UM_NUM_ERRS", new Integer(n4).toString());
        try {
            this.userMgrClient.writeLogRecord(logRecord);
            return;
        }
        catch (AdminException adminException) {
            return;
        }
    }

    private void logDupName(String string) {
        Vector<String> vector = null;
        vector = new Vector<String>(1);
        vector.addElement(string);
        try {
            LogRecord logRecord = this.userMgrClient.initLogRecord(2, "LM_2001", "LM_2063", vector);
            this.userMgrClient.writeLogRecord(logRecord);
            return;
        }
        catch (AdminException adminException) {
            return;
        }
    }

    private void logError(String string, Exception exception) {
        try {
            LogRecord logRecord = this.userMgrClient.initLogRecord(2, "LM_2041", string, null);
            if (exception != null) {
                if (exception instanceof AdminException) {
                    logRecord.addExceptionToLog((AdminException)exception);
                } else {
                    logRecord.addData("LM_LABEL_UMGR_EXC", exception.getLocalizedMessage());
                }
            }
            this.userMgrClient.writeLogRecord(logRecord);
            return;
        }
        catch (AdminException adminException) {
            return;
        }
    }
}

