/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.serialmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.serialmgr.client.AbstractIconModel;
import com.sun.admin.serialmgr.client.AbstractIconView;
import com.sun.admin.serialmgr.client.Main;
import com.sun.admin.serialmgr.client.SerialActionsListener;
import com.sun.admin.serialmgr.common.SerialPortData;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;

public class SerialIconView
extends AbstractIconView {
    private ImageIcon serialPortIcon;
    private IconModel iconModel = new IconModel();

    public SerialIconView() {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.serialPortIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "LargePortGif"), "");
    }

    protected AbstractIconModel getIconModel() {
        return this.iconModel;
    }

    protected void onDoubleClick() {
        this.fireItemPressed(2);
        ActionEvent actionEvent = new ActionEvent(this, 1001, "ViewProps");
        SerialActionsListener serialActionsListener = new SerialActionsListener();
        serialActionsListener.actionPerformed(actionEvent);
    }

    public String getSortAttribute() {
        return "serialListPortName";
    }

    public Vector getAvailableSortAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("serialListPortName");
        return vector;
    }

    class IconModel
    extends AbstractIconModel {
        private int preferredWidth;

        public String getIconLabel(Object object) {
            return ((SerialPortData)object).getPortName();
        }

        public ImageIcon getIcon(Object object) {
            return SerialIconView.this.serialPortIcon;
        }

        public String getHelpName(Object object) {
            return "starting";
        }

        public int getButtonWidth() {
            if (this.preferredWidth > 0) {
                return this.preferredWidth;
            }
            try {
                ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
                this.preferredWidth = Integer.parseInt(ResourceStrings.getString(resourceBundle, "SerialIconButtonWidth"));
            }
            catch (NumberFormatException numberFormatException) {
                this.preferredWidth = 85;
            }
            return this.preferredWidth;
        }

        public int compare(Object object, Object object2) {
            SerialPortData serialPortData = (SerialPortData)object;
            SerialPortData serialPortData2 = (SerialPortData)object2;
            String string = this.getIconLabel(serialPortData);
            String string2 = this.getIconLabel(serialPortData2);
            int n = string.compareTo(string2);
            return n;
        }

        IconModel() {
            SerialIconView.this = SerialIconView.this;
        }
    }
}

