/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.serialmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.serialmgr.client.AbstractPropsPanel;
import com.sun.admin.serialmgr.client.Main;
import com.sun.admin.serialmgr.client.SerialMgrContextHelpListener;
import com.sun.admin.serialmgr.common.SerialPortData;
import com.sun.admin.serialmgr.common.SerialPortException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SerialGenPropsPanel
extends AbstractPropsPanel {
    private SerialPortData originalPortObj;
    private JLabel portNameLabel;
    private JLabel portName;
    private JLabel baudRateLabel;
    private JComboBox baudRate;
    private JLabel terminalTypeLabel;
    private JTextField terminalType;
    private JLabel descriptionLabel;
    private JTextField description;
    private JLabel serviceStatusLabel;
    private JRadioButton enabledServiceStatus;
    private JRadioButton disabledServiceStatus;
    private JLabel loginPromptLabel;
    private JTextField loginPrompt;
    private String deviceType;
    private Vector baudRateKeys = new Vector();
    private final String keyPrefix = "BaudRate";

    public SerialGenPropsPanel(GenInfoPanel genInfoPanel, SerialPortData serialPortData, String string) {
        Object object;
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.deviceType = string;
        this.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(resourceBundle, "GenPropsPortName");
        this.portNameLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.portNameLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 20, 5, 10, 5);
        this.portNameLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.portNameLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.portName = new JLabel(serialPortData.getPortName());
        Constraints.constrain(this, this.portName, 1, -1, 1, 1, 0, 17, 1.0, 0.0, 20, 0, 10, 5);
        this.portName.setForeground(Constants.PROPS_RO_VALUE_COLOR);
        this.portName.setFont(Constants.PROPS_RO_VALUE_FONT);
        actionString = new ActionString(resourceBundle, "GenPropsComment");
        this.descriptionLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.descriptionLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        this.descriptionLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.descriptionLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.descriptionLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.description = new JTextField(serialPortData.getComment(), 16);
        Constraints.constrain(this, this.description, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 5);
        this.description.setMinimumSize(this.description.getPreferredSize());
        this.description.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.description.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "describe"));
        this.descriptionLabel.setLabelFor(this.description);
        if (string.compareTo("Terminal") == 0) {
            this.description.setText(ResourceStrings.getString(resourceBundle, "CommentTerminal"));
        }
        if (string.compareTo("ModemDialIn") == 0) {
            this.description.setText(ResourceStrings.getString(resourceBundle, "CommentModemDialIn"));
        }
        if (string.compareTo("ModemDialOut") == 0) {
            this.description.setText(ResourceStrings.getString(resourceBundle, "CommentModemDialOut"));
        }
        if (string.compareTo("ModemDialInOut") == 0) {
            this.description.setText(ResourceStrings.getString(resourceBundle, "CommentModemDialInOut"));
        }
        actionString = new ActionString(resourceBundle, "GenPropsServiceStatus");
        this.serviceStatusLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.serviceStatusLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 0, 5);
        this.serviceStatusLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.serviceStatusLabel.setFont(Constants.PROPS_LABEL_FONT);
        actionString = new ActionString(resourceBundle, "GenPropsServiceEnabled");
        this.enabledServiceStatus = new JRadioButton(actionString.getString());
        this.enabledServiceStatus.setMnemonic(actionString.getMnemonic());
        this.enabledServiceStatus.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "serv_status"));
        actionString = new ActionString(resourceBundle, "GenPropsServiceDisabled");
        this.disabledServiceStatus = new JRadioButton(actionString.getString());
        this.disabledServiceStatus.setMnemonic(actionString.getMnemonic());
        this.disabledServiceStatus.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "serv_status"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.enabledServiceStatus);
        buttonGroup.add(this.disabledServiceStatus);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Constraints.constrain(jPanel, this.enabledServiceStatus, 0, 0, 1, 1);
        Constraints.constrain(jPanel, this.disabledServiceStatus, 0, 1, 1, 1);
        this.enabledServiceStatus.setSelected(serialPortData.isEnableSet());
        this.disabledServiceStatus.setSelected(!serialPortData.isEnableSet());
        int n = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont()).stringWidth("AAAA");
        Constraints.constrain(this, jPanel, 0, -1, 2, 1, 0, 17, 0.0, 0.0, 0, n, 10, 0);
        actionString = new ActionString(resourceBundle, "GenPropsBaudRate");
        this.baudRateLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.baudRateLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        this.baudRateLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.baudRateLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.baudRateLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.baudRateKeys.addElement(new String("BaudRate38400"));
        this.baudRateKeys.addElement(new String("BaudRate19200"));
        this.baudRateKeys.addElement(new String("BaudRate9600"));
        this.baudRateKeys.addElement(new String("BaudRate4800"));
        this.baudRateKeys.addElement(new String("BaudRate2400"));
        this.baudRateKeys.addElement(new String("BaudRate1200"));
        this.baudRateKeys.addElement(new String("BaudRate300"));
        this.baudRateKeys.addElement(new String("BaudRateauto"));
        int n2 = -1;
        this.baudRate = new JComboBox();
        int n3 = 0;
        while (n3 < this.baudRateKeys.size()) {
            object = (String)this.baudRateKeys.elementAt(n3);
            this.baudRate.addItem(ResourceStrings.getString(resourceBundle, (String)object));
            String string2 = ((String)object).substring("BaudRate".length());
            if (string2.compareTo(serialPortData.getTTYLabel()) == 0) {
                n2 = n3;
            }
            ++n3;
        }
        this.baudRate.setEditable(true);
        if (n2 < 0) {
            this.baudRateKeys.addElement(new String(serialPortData.getTTYLabel()));
            this.baudRate.addItem(serialPortData.getTTYLabel());
            n2 = this.baudRateKeys.size() - 1;
        }
        this.baudRate.setSelectedIndex(n2);
        Constraints.constrain(this, this.baudRate, 1, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 10, 5);
        this.baudRate.setFont(Constants.PROPS_RW_VALUE_FONT);
        object = this.baudRate.getEditor().getEditorComponent();
        ((Component)object).addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "baud"));
        this.baudRateLabel.setLabelFor(this.baudRate);
        this.terminalType = new JTextField(serialPortData.getTerminalType(), 16);
        if (string.length() == 0 || string.compareTo("Terminal") == 0) {
            actionString = new ActionString(resourceBundle, "GenPropsTerminalType");
            this.terminalTypeLabel = new JLabel(actionString.getString());
            Constraints.constrain(this, this.terminalTypeLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
            this.terminalTypeLabel.setForeground(Constants.PROPS_LABEL_COLOR);
            this.terminalTypeLabel.setFont(Constants.PROPS_LABEL_FONT);
            this.terminalTypeLabel.setDisplayedMnemonic(actionString.getMnemonic());
            Constraints.constrain(this, this.terminalType, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 5);
            this.terminalType.setMinimumSize(this.terminalType.getPreferredSize());
            this.terminalType.setFont(Constants.PROPS_RW_VALUE_FONT);
            this.terminalType.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "terminal"));
            this.terminalTypeLabel.setLabelFor(this.terminalType);
        }
        actionString = new ActionString(resourceBundle, "GenPropsLoginPrompt");
        this.loginPromptLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.loginPromptLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        this.loginPromptLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.loginPromptLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.loginPromptLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.loginPrompt = new JTextField(serialPortData.getPrompt(), 16);
        Constraints.constrain(this, this.loginPrompt, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 5);
        this.loginPrompt.setMinimumSize(this.loginPrompt.getPreferredSize());
        this.loginPrompt.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.loginPrompt.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "login"));
        this.loginPromptLabel.setLabelFor(this.loginPrompt);
        Constraints.constrain(this, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        this.originalPortObj = serialPortData;
    }

    public void dialogDataExchange(Object object) throws SerialPortException {
        Object object2;
        SerialPortData serialPortData = (SerialPortData)object;
        int n = this.baudRate.getSelectedIndex();
        if (n > 0) {
            object2 = (String)this.baudRateKeys.elementAt(n);
            if (((String)object2).indexOf("BaudRate") >= 0) {
                serialPortData.setTTYLabel(((String)object2).substring("BaudRate".length()));
            } else {
                serialPortData.setTTYLabel((String)object2);
            }
        } else {
            object2 = this.baudRate.getEditor();
            serialPortData.setTTYLabel(object2.getItem().toString());
        }
        try {
            serialPortData.validateTTYLabel();
        }
        catch (SerialPortException serialPortException) {
            this.baudRate.requestFocus();
            throw serialPortException;
        }
        if (this.deviceType.length() == 0 || this.deviceType.compareTo("Terminal") == 0) {
            serialPortData.setTerminalType(this.terminalType.getText());
            if (this.deviceType.compareTo("Terminal") == 0 && serialPortData.getTerminalType().length() == 0) {
                this.terminalType.requestFocus();
                throw new SerialPortException("EXM_SPRT_GUI_MISSING_PROPS_VALUE", this.terminalTypeLabel.getText().substring(0, this.terminalTypeLabel.getText().length() - 1));
            }
            try {
                serialPortData.validateTerminalType();
            }
            catch (SerialPortException serialPortException) {
                this.terminalType.requestFocus();
                throw serialPortException;
            }
        }
        serialPortData.setComment(this.description.getText());
        try {
            serialPortData.validateComment();
        }
        catch (SerialPortException serialPortException) {
            this.description.requestFocus();
            throw serialPortException;
        }
        if (this.enabledServiceStatus.isSelected()) {
            serialPortData.setEnable(true);
        } else {
            serialPortData.setEnable(false);
        }
        serialPortData.setPrompt(this.loginPrompt.getText());
        try {
            serialPortData.validatePrompt();
            return;
        }
        catch (SerialPortException serialPortException) {
            this.loginPrompt.requestFocus();
            throw serialPortException;
        }
    }

    public void dialogDataInitialize(Object object) {
    }

    public String getHelpName() {
        return "basictab";
    }
}

