/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.AbstractPropsPanel;
import com.sun.admin.hostmgr.client.ContentPanel;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.client.NetworkAdvPropsPanel;
import com.sun.admin.hostmgr.client.NetworkGenPropsPanel;
import com.sun.admin.hostmgr.client.NetworkPropsDialog;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.HostWarningException;
import com.sun.admin.hostmgr.common.NetworkData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class NetworkPropsDialog
extends AdminDialog {
    NetworkData originalNetworkObj;
    ResourceBundle bundle = Main.getApp().getResourceBundle();
    Vector groupPanels;

    public NetworkPropsDialog(JFrame jFrame, NetworkData networkData) {
        super(jFrame, "", true);
        Object object;
        if (networkData.getNetworkAddress().length() != 0) {
            object = networkData.isNetwork() ? ResourceStrings.getString(this.bundle, "ModNetwork") : ResourceStrings.getString(this.bundle, "ModSubNetwork");
            object = String.valueOf(object) + " " + networkData.getNetworkAddress();
            if (networkData.getNetworkName().length() != 0) {
                object = String.valueOf(object) + " (" + networkData.getNetworkName() + ")";
            }
            this.setTitle((String)object);
        } else {
            this.setTitle(ResourceStrings.getString(this.bundle, "NewNetwork"));
        }
        object = this.getInfoPanel();
        this.groupPanels = new Vector();
        this.groupPanels.addElement(new NetworkGenPropsPanel((GenInfoPanel)object, networkData));
        this.groupPanels.addElement(new NetworkAdvPropsPanel((GenInfoPanel)object, networkData));
        JPanel jPanel = this.getRightPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        while (n < this.groupPanels.size()) {
            Constraints.constrain(jPanel, (JPanel)this.groupPanels.elementAt(n), 0, -1, 1, 1, 2, 18, 1.0, 0.0, 10, 5, 20, 5);
            ++n;
        }
        Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        JButton jButton = this.getOKBtn();
        jButton.addActionListener(new 1());
        JPanel jPanel2 = this.getbuttonPanel();
        JButton jButton2 = this.getApplyBtn();
        if (networkData.getNetworkAddress().length() == 0) {
            jButton2.addActionListener(new 3());
        } else {
            jPanel2.remove(jButton2);
        }
        Vector vector = Main.getApp().getHostMgr().getUserRights();
        if (!vector.contains("solaris.admin.hostmgr.write")) {
            jButton.setEnabled(false);
            jButton2.setEnabled(false);
        }
        JButton jButton3 = this.getCancelBtn();
        jButton3.addActionListener(new 5());
        this.pack();
        this.setMySize(this.getSize());
        if (networkData.getNetworkAddress().length() != 0) {
            this.setDefaultFocusListener(new HostMgrContextHelpListener((GenInfoPanel)object, "dlg_netprop_overview"), true);
        } else {
            this.setDefaultFocusListener(new HostMgrContextHelpListener((GenInfoPanel)object, "dlg_newnet_overview"), true);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        this.originalNetworkObj = networkData;
    }

    public void onApply() throws HostException {
        int n;
        NetworkData networkData = new NetworkData();
        Main.getApp().getTree().getCurrentContentPanel().getDataCache();
        ContentPanel contentPanel = Main.getApp().getTree().getCurrentContentPanel();
        AbstractPropsPanel abstractPropsPanel = null;
        ProgressPanel progressPanel = new ProgressPanel(Main.getApp().getFrame(), 3, 30, false);
        try {
            Object[] objectArray;
            String string;
            n = 0;
            while (n < this.groupPanels.size()) {
                abstractPropsPanel = (AbstractPropsPanel)this.groupPanels.elementAt(n);
                abstractPropsPanel.dialogDataExchange(networkData);
                ++n;
            }
            boolean bl = false;
            if (this.originalNetworkObj.getNetworkAddress().length() == 0) {
                if (!contentPanel.offerNew(networkData, true)) {
                    string = "\n";
                    string = String.valueOf(string) + ResourceStrings.getString(this.bundle, "OptionAddNetworkFitMessage");
                    int n2 = JOptionPane.showConfirmDialog(null, string = String.valueOf(string) + "\n\n", ResourceStrings.getString(this.bundle, "OptionFitMessageTitle"), 0, 3);
                    if (n2 == 1) {
                        throw new HostException("");
                    }
                } else {
                    bl = true;
                }
                progressPanel.setTitle(ResourceStrings.getString(this.bundle, "AddNetworkTitle"));
                ((Component)progressPanel).setVisible(true);
                string = ResourceStrings.getString(this.bundle, "AddingNetwork");
                objectArray = new Object[]{networkData.getNetworkAddress()};
                progressPanel.setText(MessageFormat.format(string, objectArray));
                try {
                    Main.getApp().getHostMgr().addNetwork(networkData);
                }
                catch (HostWarningException hostWarningException) {
                    Main.getApp().reportErrorException(hostWarningException);
                    networkData = Main.getApp().getHostMgr().getNetwork(networkData);
                }
                catch (Exception exception) {
                    throw exception;
                }
                progressPanel.appendText(ResourceStrings.getString(this.bundle, "UpdatingOtherViews"));
                ContentPanel.broadcastUpdate(null, networkData, false);
            } else {
                if (!contentPanel.offerNew(networkData, true)) {
                    string = "\n";
                    string = String.valueOf(string) + ResourceStrings.getString(this.bundle, "OptionModNetworkFitMessage");
                    int n3 = JOptionPane.showConfirmDialog(null, string = String.valueOf(string) + "\n\n", ResourceStrings.getString(this.bundle, "OptionFitMessageTitle"), 0, 3);
                    if (n3 == 1) {
                        throw new HostException("");
                    }
                }
                progressPanel.setTitle(ResourceStrings.getString(this.bundle, "ModifyNetworkTitle"));
                ((Component)progressPanel).setVisible(true);
                string = ResourceStrings.getString(this.bundle, "ModifyingNetwork");
                objectArray = new Object[]{networkData.getNetworkAddress()};
                progressPanel.setText(MessageFormat.format(string, objectArray));
                try {
                    Main.getApp().getHostMgr().setNetwork(this.originalNetworkObj, networkData);
                }
                catch (HostWarningException hostWarningException) {
                    Main.getApp().reportErrorException(hostWarningException);
                    networkData = Main.getApp().getHostMgr().getNetwork(networkData);
                }
                catch (Exception exception) {
                    throw exception;
                }
                progressPanel.appendText(ResourceStrings.getString(this.bundle, "UpdatingOtherViews"));
                ContentPanel.broadcastUpdate(this.originalNetworkObj, networkData, false);
            }
            progressPanel.appendText(ResourceStrings.getString(this.bundle, "RepaintingCurrentView"));
            contentPanel.repaintView();
            if (bl) {
                contentPanel.getCurrentView().find(networkData);
            }
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
        }
        catch (Exception exception) {
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            if (exception.getLocalizedMessage().length() > 0) {
                Main.getApp().reportErrorException(exception);
            }
            throw new HostException(exception.getMessage());
        }
        n = 0;
        while (n < this.groupPanels.size()) {
            abstractPropsPanel = (AbstractPropsPanel)this.groupPanels.elementAt(n);
            this.originalNetworkObj = new NetworkData();
            abstractPropsPanel.dialogDataInitialize(this.originalNetworkObj);
            ++n;
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            2 var2_2 = new 2(NetworkPropsDialog.this);
            var2_2.start();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            4 var2_2 = new 4(NetworkPropsDialog.this);
            var2_2.start();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            NetworkPropsDialog.this.dispose();
        }

        /* synthetic */ 5() {
        }
    }
}

