/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.server.AdminFactoryImpl;
import com.sun.admin.cis.server.AdminServerImpl;
import com.sun.admin.cis.service.authorization.AuthNoAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryTableAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogServiceFactoryImpl;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrMount;
import com.sun.admin.fsmgr.common.FsMgrNfsSecurityModeException;
import com.sun.admin.fsmgr.common.FsMgrRemoteFile;
import com.sun.admin.fsmgr.common.FsMgrShare;
import com.sun.admin.fsmgr.common.FsMgrUsage;
import com.sun.admin.fsmgr.server.FsMgrDfsTable;
import com.sun.admin.fsmgr.server.FsMgrFactory;
import com.sun.admin.fsmgr.server.FsMgrMountInterface;
import com.sun.admin.fsmgr.server.FsMgrMountTable;
import com.sun.admin.fsmgr.server.FsMgrNetCfgTable;
import com.sun.admin.fsmgr.server.FsMgrNfsSecTable;
import com.sun.admin.fsmgr.server.FsMgrShareInterface;
import com.sun.admin.fsmgr.server.FsMgrShareTable;
import com.sun.admin.fsmgr.server.FsMgrUsageTable;
import com.sun.admin.fsmgr.server.FsMgrVfsTable;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Vector;

public class FsMgrFactoryImpl
extends AdminFactoryImpl
implements FsMgrFactory {
    private AdminServerImpl adminSvr;
    private AdminMgmtScope scope;
    private LogServiceFactoryImpl logService;
    private String scopeUserName = "";
    private String scopeClientHost = "";
    private String scopeHostName = "";
    private static final String[] fsMgrRights = new String[]{"solaris.admin.fsmgr.write"};
    public static final String FSMGR_APPNAME = "File System Manager";
    private static final String showmountStr = new String("/usr/sbin/showmount");
    private static final String switchStr = new String("-e");

    public FsMgrFactoryImpl(AdminServerImpl adminServerImpl) throws RemoteException, AdminException {
        super(adminServerImpl);
        this.adminSvr = adminServerImpl;
        this.setAppName(FSMGR_APPNAME);
        this.logService = (LogServiceFactoryImpl)adminServerImpl.getServiceImpl("com.sun.admin.cis.service.logging.LogServiceFactoryImpl");
    }

    protected String[] myAuthRights() {
        return fsMgrRights;
    }

    public void initializeLogging(SecurityToken securityToken) throws RemoteException, AdminException {
        this.scope = this.adminSvr.getMgmtScope(securityToken);
        this.scopeUserName = this.adminSvr.getUserName(securityToken);
        this.scopeClientHost = this.adminSvr.getClientHost(securityToken);
        this.scopeHostName = this.adminSvr.getHostName();
    }

    public AdminServerImpl getAdminSvr() {
        return this.adminSvr;
    }

    public FsMgrRemoteFile makeDirectory(SecurityToken securityToken, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        FsMgrRemoteFile fsMgrRemoteFile = null;
        if (this.mkdir(string)) {
            File file = new File(string);
            fsMgrRemoteFile = new FsMgrRemoteFile(file.getParent(), file.getName(), file.isDirectory());
        }
        return fsMgrRemoteFile;
    }

    private boolean mkdir(String string) {
        boolean bl = false;
        try {
            File file = new File(string);
            if (!file.exists()) {
                File file2 = new File(file.getParent());
                if (!file2.exists()) {
                    this.mkdir(file.getParent());
                }
                if (file2.exists()) {
                    bl = file.mkdir();
                    String string2 = "/usr/bin/chmod -f 777 ";
                    string2 = string2.concat(file.getAbsolutePath());
                    AdminCommonTools.CMN_exec(string2);
                }
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public FsMgrRemoteFile getFile(SecurityToken securityToken, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        FsMgrRemoteFile fsMgrRemoteFile = null;
        File file = new File(string);
        if (file.exists()) {
            fsMgrRemoteFile = new FsMgrRemoteFile(file.getParent(), file.getName(), file.isDirectory());
        }
        return fsMgrRemoteFile;
    }

    public Vector getList(SecurityToken securityToken, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        FsMgrRemoteFile fsMgrRemoteFile = null;
        Vector<FsMgrRemoteFile> vector = new Vector<FsMgrRemoteFile>();
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                fsMgrRemoteFile = new FsMgrRemoteFile(file2.getParent(), file2.getName(), file2.isDirectory());
                vector.addElement(fsMgrRemoteFile);
                ++n;
            }
        }
        return vector;
    }

    public Vector getShareList(SecurityToken securityToken, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        Vector vector = null;
        try {
            FsMgrShareInterface fsMgrShareInterface = null;
            if (string.equals(FsMgrDfsTable.DFSTAB)) {
                fsMgrShareInterface = new FsMgrDfsTable(this);
            } else if (string.equals(FsMgrShareTable.SHARETAB)) {
                fsMgrShareInterface = new FsMgrShareTable(this);
            }
            vector = fsMgrShareInterface.list();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4052", null, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_SHRLST_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4052", null, null, null, null);
            throw new FsMgrException("EXM_FSS_SHRLST_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4052", null, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_SHRLST_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4052", null, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        return vector;
    }

    public FsMgrShare getShareEntry(SecurityToken securityToken, String string, String string2) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        FsMgrShare fsMgrShare = null;
        try {
            FsMgrShareInterface fsMgrShareInterface = null;
            if (string.equals(FsMgrDfsTable.DFSTAB)) {
                fsMgrShareInterface = new FsMgrDfsTable(this);
            } else if (string.equals(FsMgrShareTable.SHARETAB)) {
                fsMgrShareInterface = new FsMgrShareTable(this);
            }
            fsMgrShare = fsMgrShareInterface.getShareEntry(string2);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4053", string2, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_SHRENT_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4053", string2, null, null, null);
            throw new FsMgrException("EXM_FSS_SHRENT_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4053", string2, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_SHRENT_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4053", string2, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        return fsMgrShare;
    }

    public void addShare(SecurityToken securityToken, FsMgrShare fsMgrShare, String[] stringArray) throws RemoteException, FsMgrException, AuthNoAccessException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{fsMgrShare, stringArray};
        }
        this.checkRights(securityToken, objectArray, "solaris.admin.fsmgr.write");
        int n = 0;
        while (n < stringArray.length) {
            this.commonAddShare(fsMgrShare, stringArray[n]);
            ++n;
        }
    }

    public void addShare(SecurityToken securityToken, FsMgrShare fsMgrShare, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{fsMgrShare, string};
        }
        this.checkRights(securityToken, objectArray, "solaris.admin.fsmgr.write");
        this.commonAddShare(fsMgrShare, string);
    }

    public void commonAddShare(FsMgrShare fsMgrShare, String string) throws RemoteException, FsMgrException {
        try {
            FsMgrShareInterface fsMgrShareInterface = null;
            if (string.equals(FsMgrDfsTable.DFSTAB)) {
                fsMgrShareInterface = new FsMgrDfsTable(this);
            } else if (string.equals(FsMgrShareTable.SHARETAB)) {
                fsMgrShareInterface = new FsMgrShareTable(this);
            }
            if (fsMgrShareInterface == null) {
                this.writeLog(2, "LM_4047", "LM_4054", fsMgrShare.getPathname(), null, null, null);
                FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
                throw new FsMgrException("EXM_FSS_SHRADD_DTDNE", fsMgrException.getMessage());
            }
            fsMgrShareInterface.addShare(fsMgrShare);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4054", fsMgrShare.getPathname(), null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_SHRADD_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4054", fsMgrShare.getPathname(), null, null, null);
            throw new FsMgrException("EXM_FSS_SHRADD_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4054", fsMgrShare.getPathname(), null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_SHRADD_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4054", fsMgrShare.getPathname(), null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        this.writeLog(0, "LM_4000", "LM_4010", fsMgrShare.getPathname(), null, null, null);
    }

    public void removeShare(SecurityToken securityToken, FsMgrShare fsMgrShare, String[] stringArray) throws RemoteException, FsMgrException, AuthNoAccessException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{fsMgrShare, stringArray};
        }
        this.checkRights(securityToken, objectArray, "solaris.admin.fsmgr.write");
        int n = 0;
        while (n < stringArray.length) {
            this.commonRemoveShare(fsMgrShare, stringArray[n]);
            ++n;
        }
    }

    public void removeShare(SecurityToken securityToken, FsMgrShare fsMgrShare, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{fsMgrShare, string};
        }
        this.checkRights(securityToken, objectArray, "solaris.admin.fsmgr.write");
        this.commonRemoveShare(fsMgrShare, string);
    }

    public void commonRemoveShare(FsMgrShare fsMgrShare, String string) throws RemoteException, FsMgrException {
        try {
            FsMgrShareInterface fsMgrShareInterface = null;
            if (string.equals(FsMgrDfsTable.DFSTAB)) {
                fsMgrShareInterface = new FsMgrDfsTable(this);
            } else if (string.equals(FsMgrShareTable.SHARETAB)) {
                fsMgrShareInterface = new FsMgrShareTable(this);
            }
            if (fsMgrShareInterface == null) {
                this.writeLog(2, "LM_4047", "LM_4054", fsMgrShare.getPathname(), null, null, null);
                FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
                throw new FsMgrException("EXM_FSS_SHRREM_DTDNE", fsMgrException.getMessage());
            }
            fsMgrShareInterface.removeShare(fsMgrShare);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4055", fsMgrShare.getPathname(), null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_SHRREM_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4055", fsMgrShare.getPathname(), null, null, null);
            throw new FsMgrException("EXM_FSS_SHRREM_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4055", fsMgrShare.getPathname(), null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_SHRREM_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4055", fsMgrShare.getPathname(), null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        this.writeLog(0, "LM_4001", "LM_4011", fsMgrShare.getPathname(), null, null, null);
    }

    public void modifyShare(SecurityToken securityToken, FsMgrShare fsMgrShare, FsMgrShare fsMgrShare2, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{fsMgrShare, fsMgrShare2, string};
        }
        this.checkRights(securityToken, objectArray, "solaris.admin.fsmgr.write");
        try {
            FsMgrShareInterface fsMgrShareInterface = null;
            if (string.equals(FsMgrDfsTable.DFSTAB)) {
                fsMgrShareInterface = new FsMgrDfsTable(this);
            } else if (string.equals(FsMgrShareTable.SHARETAB)) {
                fsMgrShareInterface = new FsMgrShareTable(this);
            }
            if (fsMgrShareInterface == null) {
                this.writeLog(2, "LM_4047", "LM_4071", fsMgrShare.getPathname(), null, null, null);
                FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
                throw new FsMgrException("EXM_FSS_SHRMOD_DTDNE", fsMgrException.getMessage());
            }
            fsMgrShareInterface.modifyShare(fsMgrShare, fsMgrShare2);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4071", fsMgrShare.getPathname(), null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_SHRMOD_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4071", fsMgrShare.getPathname(), null, null, null);
            throw new FsMgrException("EXM_FSS_SHRMOD_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4071", fsMgrShare.getPathname(), null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_SHRMOD_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4071", fsMgrShare.getPathname(), null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        this.writeLog(0, "LM_4004", "LM_4016", fsMgrShare.getPathname(), null, null, null);
    }

    public Vector getMountList(SecurityToken securityToken, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        Vector vector = null;
        try {
            FsMgrMountInterface fsMgrMountInterface = null;
            if (string.equals(FsMgrVfsTable.VFSTAB)) {
                fsMgrMountInterface = new FsMgrVfsTable(this);
            } else if (string.equals(FsMgrMountTable.MOUNTTAB)) {
                fsMgrMountInterface = new FsMgrMountTable(this);
            }
            vector = fsMgrMountInterface.list();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4056", null, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_MNTLST_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4056", null, null, null, null);
            throw new FsMgrException("EXM_FSS_MNTLST_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4056", null, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_MNTLST_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4056", null, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        return vector;
    }

    public FsMgrMount getMountEntry(SecurityToken securityToken, String string, String string2, String string3) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        FsMgrMount fsMgrMount = null;
        try {
            FsMgrMountInterface fsMgrMountInterface = null;
            if (string.equals(FsMgrVfsTable.VFSTAB)) {
                fsMgrMountInterface = new FsMgrVfsTable(this);
            } else if (string.equals(FsMgrMountTable.MOUNTTAB)) {
                fsMgrMountInterface = new FsMgrMountTable(this);
            }
            fsMgrMount = fsMgrMountInterface.getMountEntry(string2, string3);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4057", null, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_MNTENT_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4057", string2, string3, null, null);
            throw new FsMgrException("EXM_FSS_MNTENT_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4057", string2, string3, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_MNTENT_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4057", string2, string3, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        return fsMgrMount;
    }

    public void addMount(SecurityToken securityToken, FsMgrMount fsMgrMount, String[] stringArray) throws RemoteException, FsMgrException, AuthNoAccessException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{fsMgrMount, stringArray};
        }
        this.checkRights(securityToken, objectArray, "solaris.admin.fsmgr.write");
        int n = 0;
        while (n < stringArray.length) {
            this.commonAddMount(fsMgrMount, stringArray[n]);
            ++n;
        }
    }

    public void addMount(SecurityToken securityToken, FsMgrMount fsMgrMount, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{fsMgrMount, string};
        }
        this.checkRights(securityToken, objectArray, "solaris.admin.fsmgr.write");
        this.commonAddMount(fsMgrMount, string);
    }

    public void commonAddMount(FsMgrMount fsMgrMount, String string) throws RemoteException, FsMgrException {
        try {
            FsMgrMountInterface fsMgrMountInterface = null;
            if (string.equals(FsMgrVfsTable.VFSTAB)) {
                fsMgrMountInterface = new FsMgrVfsTable(this);
            } else if (string.equals(FsMgrMountTable.MOUNTTAB)) {
                fsMgrMountInterface = new FsMgrMountTable(this);
            }
            if (fsMgrMountInterface == null) {
                this.writeLog(2, "LM_4047", "LM_4058", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
                FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
                throw new FsMgrException("EXM_FSS_MNTADD_DTDNE", fsMgrException.getMessage());
            }
            fsMgrMountInterface.addMount(fsMgrMount);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4058", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_MNTADD_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4058", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            throw new FsMgrException("EXM_FSS_MNTADD_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4058", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_MNTADD_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4058", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        this.writeLog(0, "LM_4002", "LM_4012", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
    }

    public void removeMount(SecurityToken securityToken, FsMgrMount fsMgrMount, String[] stringArray) throws RemoteException, FsMgrException, AuthNoAccessException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{fsMgrMount, stringArray};
        }
        this.checkRights(securityToken, objectArray, "solaris.admin.fsmgr.write");
        int n = 0;
        while (n < stringArray.length) {
            this.commonRemoveMount(fsMgrMount, stringArray[n]);
            ++n;
        }
    }

    public void removeMount(SecurityToken securityToken, FsMgrMount fsMgrMount, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{fsMgrMount, string};
        }
        this.checkRights(securityToken, objectArray, "solaris.admin.fsmgr.write");
        this.commonRemoveMount(fsMgrMount, string);
    }

    public void commonRemoveMount(FsMgrMount fsMgrMount, String string) throws RemoteException, FsMgrException {
        try {
            FsMgrMountInterface fsMgrMountInterface = null;
            if (string.equals(FsMgrVfsTable.VFSTAB)) {
                fsMgrMountInterface = new FsMgrVfsTable(this);
            } else if (string.equals(FsMgrMountTable.MOUNTTAB)) {
                fsMgrMountInterface = new FsMgrMountTable(this);
            }
            if (fsMgrMountInterface == null) {
                this.writeLog(2, "LM_4047", "LM_4058", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
                FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
                throw new FsMgrException("EXM_FSS_MNTREM_DTDNE", fsMgrException.getMessage());
            }
            fsMgrMountInterface.removeMount(fsMgrMount);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4059", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_MNTREM_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4059", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            throw new FsMgrException("EXM_FSS_MNTREM_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4059", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_MNTREM_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4059", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        this.writeLog(0, "LM_4003", "LM_4013", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
    }

    public void modifyMount(SecurityToken securityToken, FsMgrMount fsMgrMount, FsMgrMount fsMgrMount2, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{fsMgrMount, fsMgrMount2, string};
        }
        this.checkRights(securityToken, objectArray, "solaris.admin.fsmgr.write");
        try {
            FsMgrMountInterface fsMgrMountInterface = null;
            if (string.equals(FsMgrVfsTable.VFSTAB)) {
                fsMgrMountInterface = new FsMgrVfsTable(this);
            } else if (string.equals(FsMgrMountTable.MOUNTTAB)) {
                fsMgrMountInterface = new FsMgrMountTable(this);
            }
            if (fsMgrMountInterface == null) {
                this.writeLog(2, "LM_4047", "LM_4072", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
                FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
                throw new FsMgrException("EXM_FSS_MNTMOD_DTDNE", fsMgrException.getMessage());
            }
            fsMgrMountInterface.modifyMount(fsMgrMount, fsMgrMount2);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4072", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_MNTMOD_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4072", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            throw new FsMgrException("EXM_FSS_MNTMOD_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4072", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_MNTMOD_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4072", fsMgrMount.getResource(), fsMgrMount.getMountPoint(), null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        this.writeLog(0, "LM_4005", "LM_4017", fsMgrMount2.getResource(), fsMgrMount2.getMountPoint(), null, null);
    }

    public String[] showMounts(SecurityToken securityToken, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        String[] stringArray = new String[]{showmountStr, switchStr, string};
        String[] stringArray2 = AdminCommonTools.CMN_exec(stringArray);
        return stringArray2;
    }

    public Vector getUsageList(SecurityToken securityToken) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        Vector vector = null;
        try {
            Vector vector2 = null;
            FsMgrMountTable fsMgrMountTable = new FsMgrMountTable(this);
            vector2 = fsMgrMountTable.list();
            FsMgrUsageTable fsMgrUsageTable = new FsMgrUsageTable(this);
            vector = fsMgrUsageTable.list(vector2);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4060", null, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_USGLST_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4060", null, null, null, null);
            throw new FsMgrException("EXM_FSS_USGLST_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4060", null, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_USGLST_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4060", null, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        return vector;
    }

    public FsMgrUsage getUsageEntry(SecurityToken securityToken, String string) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        FsMgrUsage fsMgrUsage = null;
        try {
            Vector vector = null;
            FsMgrMountTable fsMgrMountTable = new FsMgrMountTable(this);
            vector = fsMgrMountTable.list();
            FsMgrUsageTable fsMgrUsageTable = new FsMgrUsageTable(this);
            fsMgrUsage = fsMgrUsageTable.getUsageEntry(vector, string);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4061", string, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_USGLST_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4061", string, null, null, null);
            throw new FsMgrException("EXM_FSS_USGLST_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4061", string, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_USGLST_DTERR", fsMgrException.getMessage());
        }
        catch (FsMgrException fsMgrException) {
            throw fsMgrException;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4061", string, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        return fsMgrUsage;
    }

    public Vector getNetCfgList(SecurityToken securityToken) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        Vector vector = null;
        try {
            FsMgrNetCfgTable fsMgrNetCfgTable = new FsMgrNetCfgTable(this);
            vector = fsMgrNetCfgTable.list();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.writeLog(2, "LM_4049", "LM_4070", null, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_CFGLST_DTDNE", fsMgrException.getMessage());
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.writeLog(2, "LM_4050", "LM_4070", null, null, null, null);
            throw new FsMgrException("EXM_FSS_CFGLST_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4070", null, null, null, null);
            FsMgrException fsMgrException = new FsMgrException("EXM_FSS_TRY");
            throw new FsMgrException("EXM_FSS_CFGLST_DTERR", fsMgrException.getMessage());
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4070", null, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        return vector;
    }

    public Vector getNfsSecList(SecurityToken securityToken) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        Vector vector = null;
        try {
            FsMgrNfsSecTable fsMgrNfsSecTable = new FsMgrNfsSecTable(this);
            vector = fsMgrNfsSecTable.listModes();
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4073", null, null, null, null);
            throw new FsMgrNfsSecurityModeException("EXM_FSS_NOMODES");
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4073", null, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        return vector;
    }

    public String getDefaultNfsSecMode(SecurityToken securityToken) throws RemoteException, FsMgrException, AuthNoAccessException {
        this.checkRights(securityToken, null, null);
        String string = null;
        try {
            FsMgrNfsSecTable fsMgrNfsSecTable = new FsMgrNfsSecTable(this);
            string = fsMgrNfsSecTable.getDefaultSecurityMode();
        }
        catch (DirectoryTableException directoryTableException) {
            this.writeLog(2, "LM_4048", "LM_4073", null, null, null, null);
            throw new FsMgrNfsSecurityModeException("EXM_FSS_NOMODE");
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_4051", "LM_4073", null, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        if (string == null) {
            throw new FsMgrNfsSecurityModeException("EXM_FSS_NOMODE");
        }
        return string;
    }

    public void writeLog(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        LogRecord logRecord = null;
        if (this.logService == null) {
            return;
        }
        try {
            logRecord = new LogRecord("LM_FSMGR_APP_NAME", 0, n, this.scopeUserName, this.scopeClientHost, this.scopeHostName, string, string2, null, this.scope);
            logRecord.addSubstArg(string3, string4, string5, string6);
            this.logService.writeRecord(logRecord, false);
            return;
        }
        catch (Exception exception) {
            System.out.println("Server: write log: exception: " + exception.getMessage());
            return;
        }
    }

    private void checkRights(SecurityToken securityToken, Object[] objectArray, String string) throws FsMgrException, AuthNoAccessException {
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new FsMgrException("EXM_FSS_CVF");
        }
        if (string != null) {
            String string2 = "";
            try {
                string2 = this.adminSvr.getUserName(securityToken);
                if (!this.adminSvr.checkRights(securityToken, string)) {
                    this.localAppName();
                    this.writeLog(0, "LM_1010", "LM_1014", string2, this.localAppName(), null, null);
                    throw new AuthNoAccessException(string2, this.localAppName());
                }
            }
            catch (AuthNoAccessException authNoAccessException) {
                throw authNoAccessException;
            }
            catch (AdminException adminException) {
                throw new FsMgrException("EXM_FSS_NOA", string2);
            }
        }
    }
}

