/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.server;

import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.FileDirectoryTable;
import com.sun.admin.fsmgr.common.FsMgrShare;
import com.sun.admin.fsmgr.server.FsMgrFactoryImpl;
import com.sun.admin.fsmgr.server.FsMgrShareInterface;
import java.util.Vector;

public class FsMgrDfsTable
implements FsMgrShareInterface {
    public static final String DFSTAB = new String("dfstab");
    private static final String[] shareCommands = new String[]{new String("/usr/sbin/share"), new String("share")};
    private static final String descOption = new String("-d");
    private static final String FSSpecOption = new String("-o");
    private static final String FSTypeOption = new String("-F");
    private static final String emptyString = new String("");
    private static final String quote = new String("\"");
    private static final String space = new String(" ");
    private static final String fileType = new String("File");
    private static final int commandColumn = 1;
    private FsMgrFactoryImpl factoryImpl;

    public FsMgrDfsTable(FsMgrFactoryImpl fsMgrFactoryImpl) {
        this.factoryImpl = fsMgrFactoryImpl;
    }

    public Vector list() throws DirectoryTableException {
        Vector<FsMgrShare> vector = new Vector<FsMgrShare>();
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openDfsTable();
            DirectoryRow directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                FsMgrShare fsMgrShare = this.parseShareEntry(directoryRow);
                if (fsMgrShare != null) {
                    FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
                    fsMgrShare.setRawString(fileDirectoryTable.getRowAsString(directoryRow, 1));
                    vector.addElement(fsMgrShare);
                }
                directoryRow = directoryTable.getNextRow();
            }
            directoryTable.close();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        return vector;
    }

    public FsMgrShare getShareEntry(String string) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        FsMgrShare fsMgrShare = null;
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openDfsTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrShare = this.parseShareEntry(directoryRow);
                if (fsMgrShare != null) {
                    if (string.equals(fsMgrShare.getPathname())) {
                        FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
                        fsMgrShare.setRawString(fileDirectoryTable.getRowAsString(directoryRow, 1));
                        break;
                    }
                    fsMgrShare = null;
                }
                directoryRow = directoryTable.getNextRow();
            }
            directoryTable.close();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        return fsMgrShare;
    }

    public void addShare(FsMgrShare fsMgrShare) throws DirectoryTableException {
        DirectoryTable directoryTable;
        try {
            directoryTable = this.openDfsTable();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            directoryTable = this.createDfsTable();
        }
        try {
            DirectoryRow directoryRow = this.makeRow(directoryTable, fsMgrShare);
            directoryTable.addRow(directoryRow);
            directoryTable.close();
            return;
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
    }

    public void removeShare(FsMgrShare fsMgrShare) throws DirectoryTableException {
        DirectoryTable directoryTable = this.openDfsTable();
        try {
            DirectoryRow directoryRow = directoryTable.getRowInstance();
            FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
            fileDirectoryTable.parseStringIntoRow(fsMgrShare.getRawString(), directoryRow, 1);
            directoryTable.deleteRow(directoryRow);
            directoryTable.close();
            return;
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
    }

    public void modifyShare(FsMgrShare fsMgrShare, FsMgrShare fsMgrShare2) throws DirectoryTableException {
        DirectoryTable directoryTable = this.openDfsTable();
        try {
            DirectoryRow directoryRow = directoryTable.getRowInstance();
            FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
            fileDirectoryTable.parseStringIntoRow(fsMgrShare.getRawString(), directoryRow, 1);
            DirectoryRow directoryRow2 = this.makeRow(directoryTable, fsMgrShare2);
            directoryTable.modifyRow(directoryRow, directoryRow2);
            directoryTable.close();
            return;
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
    }

    private DirectoryTable createDfsTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(fileType, emptyString, emptyString);
        directoryTable.create(DFSTAB);
        return directoryTable;
    }

    private DirectoryTable openDfsTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(fileType, emptyString, emptyString);
        directoryTable.open(DFSTAB);
        return directoryTable;
    }

    private DirectoryRow makeRow(DirectoryTable directoryTable, FsMgrShare fsMgrShare) throws DirectoryTableException {
        DirectoryRow directoryRow = directoryTable.getRowInstance();
        String[] stringArray = fsMgrShare.toArray(true);
        int n = 0;
        while (n < stringArray.length) {
            directoryRow.putColumn(n + 1, stringArray[n]);
            ++n;
        }
        return directoryRow;
    }

    private FsMgrShare parseShareEntry(DirectoryRow directoryRow) throws DirectoryTableException {
        Object object;
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object object2 = null;
        String string6 = emptyString;
        int n2 = 1;
        string = directoryRow.getColumn(n2++);
        int n3 = 0;
        while (n3 < shareCommands.length) {
            if (string.equals(shareCommands[n3])) break;
            ++n3;
        }
        if (n3 == shareCommands.length) {
            return null;
        }
        boolean bl = true;
        while (bl) {
            string6 = directoryRow.getColumn(n2);
            if (string6 == null) {
                bl = false;
                return null;
            }
            if (string6.equals(FSTypeOption)) {
                string4 = directoryRow.getColumn(++n2);
                ++n2;
                continue;
            }
            if (string6.equals(FSSpecOption)) {
                string5 = directoryRow.getColumn(++n2);
                ++n2;
                continue;
            }
            if (string6.equals(descOption)) {
                object2 = null;
                n = 0;
                while ((object = directoryRow.getColumn(++n2)) != null && ((String)object).length() != 0) {
                    int n4 = 0;
                    while ((n4 = ((String)object).indexOf(quote, n4)) != -1) {
                        n = n != 0 ? 0 : 1;
                        ++n4;
                    }
                    object2 = object2 != null ? String.valueOf(object2) + space + (String)object : object;
                    if (n == 0) break;
                }
                if (((String)object2).startsWith(quote) && ((String)object2).endsWith(quote)) {
                    object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                }
                if (object2 == null) {
                    return null;
                }
                ++n2;
                continue;
            }
            bl = false;
        }
        n = directoryRow.getNumberOfColumns();
        if (n < n2) {
            return null;
        }
        string2 = directoryRow.getColumn(n2++);
        string3 = directoryRow.getColumn(n2);
        object = new FsMgrShare(string2, string3, string4, string5, (String)object2);
        return object;
    }
}

