/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.usage;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.sort.TableSorter;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.usage.Usage;
import com.sun.admin.fsmgr.client.usage.UsageCache;
import com.sun.admin.fsmgr.client.usage.UsageCacheEntry;
import com.sun.admin.fsmgr.client.usage.UsageListView;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class UsageTableView
extends UsageListView {
    JTable table;
    JScrollPane scrollPane;
    Object[][] theData;
    UsageTableModel dataModel;
    TableSorter tableSorter;
    int oldSortColumn;
    int theSortColumn;
    boolean ascendSort = true;
    UsageTableView thisView;
    Vector vColumns = new Vector();
    ResourceBundle bundle = FsMgr.getFsMgr().getResourceBundle();
    private static String FILESYSTEM = FsMgrResourceStrings.getString("UsageTableFilesystem");
    private static String TOTAL = FsMgrResourceStrings.getString("UsageTableTotal");
    private static String PERCENTAGE = FsMgrResourceStrings.getString("UsageTablePercentage");
    private static String USED = FsMgrResourceStrings.getString("UsageTableUsed");
    private static String AVAILABLE = FsMgrResourceStrings.getString("UsageTableAvailable");
    private static String MOUNTED = FsMgrResourceStrings.getString("UsageTableMounted");
    String[] columnKeys = new String[]{FILESYSTEM, MOUNTED, PERCENTAGE, TOTAL, USED, AVAILABLE};

    public UsageTableView() {
        this.thisView = this;
        this.vColumns.addElement(new String(FILESYSTEM));
        this.vColumns.addElement(new String(MOUNTED));
        this.vColumns.addElement(new String(PERCENTAGE));
        this.vColumns.addElement(new String(TOTAL));
        this.vColumns.addElement(new String(USED));
        this.vColumns.addElement(new String(AVAILABLE));
        this.dataModel = new UsageTableModel();
        this.theData = new Object[0][this.dataModel.getMaxColumnCount()];
        this.tableSorter = new TableSorter(this.dataModel);
        this.table = new JTable(this.tableSorter);
        this.table.setBackground(Color.white);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(4);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new 1());
        this.table.addMouseListener(new TableMouseListener(this));
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(new 2());
        this.setViewportView(this.table);
        this.setBackground(Color.white);
    }

    protected int getViewType() {
        return 1;
    }

    public void populate() {
        UsageCache usageCache = Usage.getInstance().getUsageCache();
        this.theData = new Object[usageCache.size()][this.dataModel.getMaxColumnCount()];
        int n = 0;
        while (n < usageCache.size()) {
            UsageCacheEntry usageCacheEntry = (UsageCacheEntry)usageCache.elementAt(n);
            this.dataModel.addUsageAtRow(n, usageCacheEntry);
            ++n;
        }
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
    }

    public void clear() {
        this.clearSelection();
        this.theData = new Object[0][this.dataModel.getMaxColumnCount()];
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
    }

    public void append(Vector vector) {
    }

    public Object getSelectedItem() {
        int[] nArray = this.table.getSelectedRows();
        UsageCache usageCache = Usage.getInstance().getUsageCache();
        Object e = usageCache.elementAt(this.tableSorter.convertRowIndexToModel(nArray[0]));
        return e;
    }

    public int getNumSelections() {
        return this.table.getSelectedRowCount();
    }

    private void onSelect() {
        this.fireItemPressed(1);
    }

    public void selectAll() {
        this.table.setRowSelectionInterval(0, this.table.getRowCount() - 1);
    }

    public void clearSelection() {
        this.table.clearSelection();
        this.fireItemPressed(0);
    }

    public void sortAscending() {
        this.ascendSort = true;
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
    }

    public void sortDescending() {
        this.ascendSort = false;
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
    }

    public void sortByAttribute(String string) {
        try {
            int n;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            this.theSortColumn = n = tableColumnModel.getColumnIndex(string);
            this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
            this.fireSortChanged();
            return;
        }
        catch (Exception exception) {
            this.fireSortChanged();
            return;
        }
    }

    protected int getSortOrder() {
        if (this.ascendSort) {
            return 10;
        }
        return 11;
    }

    public String getSortAttribute() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(this.theSortColumn);
        return (String)tableColumn.getIdentifier();
    }

    public void find(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        if (this.table.getRowCount() == 0) {
            return;
        }
        int n = 0;
        while (n < this.table.getRowCount()) {
            int n2 = this.tableSorter.convertRowIndexToModel(n);
            String string3 = this.dataModel.getFileSystem(n2);
            String string4 = this.dataModel.getMountPoint(n2);
            if (string3 != null && string4 != null && string.equals(string3) && string2.equals(string4)) {
                this.table.clearSelection();
                this.table.setRowSelectionInterval(n, n);
                Rectangle rectangle = this.table.getCellRect(n, 0, false);
                this.table.scrollRectToVisible(rectangle);
                return;
            }
            ++n;
        }
    }

    public Vector getAvailableSortAttributes() {
        return this.vColumns;
    }

    class UsageTableModel
    extends AbstractTableModel {
        Vector tableColumns = new Vector();

        public int getColumnCount() {
            return UsageTableView.this.vColumns.size();
        }

        public int getRowCount() {
            return UsageTableView.this.theData.length;
        }

        public String getFileSystem(int n) {
            int n2 = this.getColumnModelIndex(FILESYSTEM);
            return (String)this.getValueAt(n, n2);
        }

        public String getMountPoint(int n) {
            int n2 = this.getColumnModelIndex(MOUNTED);
            return (String)this.getValueAt(n, n2);
        }

        public Object getValueAt(int n, int n2) {
            if (UsageTableView.this.theData.length == 0) {
                return null;
            }
            return UsageTableView.this.theData[n][n2];
        }

        public Class getColumnClass(int n) {
            return UsageTableView.this.theData[0][n].getClass();
        }

        public String getColumnName(int n) {
            String string = (String)UsageTableView.this.vColumns.elementAt(n);
            ActionString actionString = new ActionString(UsageTableView.this.bundle, string);
            return actionString.getString();
        }

        public void addUsageAtRow(int n, UsageCacheEntry usageCacheEntry) {
            double d;
            long l;
            Number number;
            int n2 = this.getColumnModelIndex(FILESYSTEM);
            String string = usageCacheEntry.getData().getFileSystem();
            UsageTableView.this.theData[n][n2] = string;
            n2 = this.getColumnModelIndex(MOUNTED);
            string = usageCacheEntry.getData().getMountPoint();
            UsageTableView.this.theData[n][n2] = string;
            n2 = this.getColumnModelIndex(PERCENTAGE);
            string = usageCacheEntry.getData().getCapacity();
            if (string.startsWith("-")) {
                UsageTableView.this.theData[n][n2] = new Integer(0);
            } else if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
                number = new Integer(string);
                UsageTableView.this.theData[n][n2] = number;
            } else {
                UsageTableView.this.theData[n][n2] = new Integer(0);
            }
            n2 = this.getColumnModelIndex(TOTAL);
            string = usageCacheEntry.getData().getTotalBytes();
            if (string.startsWith("-")) {
                UsageTableView.this.theData[n][n2] = new Double(0.0);
            } else {
                number = new Long(string);
                l = ((Long)number).intValue() * 10 / 1024;
                d = (double)l / 10.0;
                UsageTableView.this.theData[n][n2] = new Double(d);
            }
            n2 = this.getColumnModelIndex(USED);
            string = usageCacheEntry.getData().getUsedBytes();
            if (string.startsWith("-")) {
                UsageTableView.this.theData[n][n2] = new Double(0.0);
            } else {
                number = new Long(string);
                l = ((Long)number).intValue() * 10 / 1024;
                d = (double)l / 10.0;
                UsageTableView.this.theData[n][n2] = new Double(d);
            }
            n2 = this.getColumnModelIndex(AVAILABLE);
            string = usageCacheEntry.getData().getAvailBytes();
            if (string.startsWith("-")) {
                UsageTableView.this.theData[n][n2] = new Double(0.0);
                return;
            }
            number = new Long(string);
            l = ((Long)number).intValue() * 10 / 1024;
            d = (double)l / 10.0;
            UsageTableView.this.theData[n][n2] = new Double(d);
        }

        public int getMaxColumnCount() {
            return UsageTableView.this.columnKeys.length;
        }

        public String getColumnModelKey(int n) {
            return UsageTableView.this.columnKeys[n];
        }

        public TableColumn getTableColumn(int n) {
            return (TableColumn)this.tableColumns.elementAt(n);
        }

        public int getColumnModelIndex(String string) {
            int n = 0;
            while (n < this.getMaxColumnCount()) {
                if (string.compareTo(UsageTableView.this.columnKeys[n]) == 0) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public UsageTableModel() {
            UsageTableView.this = UsageTableView.this;
            int n = 0;
            while (n < UsageTableView.this.columnKeys.length) {
                String string = UsageTableView.this.columnKeys[n];
                ActionString actionString = new ActionString(UsageTableView.this.bundle, string);
                TableColumn tableColumn = new TableColumn();
                tableColumn.setIdentifier(string);
                tableColumn.setHeaderValue(actionString.getString());
                tableColumn.setModelIndex(n);
                this.tableColumns.addElement(tableColumn);
                ++n;
            }
        }
    }

    private final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            UsageTableView.this.onSelect();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        boolean needSort = false;

        public void mouseExited(MouseEvent mouseEvent) {
            this.needSort = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.needSort = true;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.needSort) {
                return;
            }
            this.needSort = false;
            TableColumnModel tableColumnModel = UsageTableView.this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = UsageTableView.this.table.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                UsageCacheEntry usageCacheEntry = null;
                if (UsageTableView.this.getNumSelections() != 0) {
                    usageCacheEntry = (UsageCacheEntry)UsageTableView.this.getSelectedItem();
                }
                UsageTableView.this.oldSortColumn = UsageTableView.this.theSortColumn;
                UsageTableView.this.theSortColumn = n2;
                UsageTableView.this.ascendSort = UsageTableView.this.theSortColumn == UsageTableView.this.oldSortColumn ? !UsageTableView.this.ascendSort : true;
                UsageTableView.this.tableSorter.sortByColumn(UsageTableView.this.theSortColumn, UsageTableView.this.ascendSort);
                UsageTableView.this.fireSortChanged();
                if (usageCacheEntry != null) {
                    UsageTableView.this.find(usageCacheEntry.getData().getFileSystem(), usageCacheEntry.getData().getMountPoint());
                }
            }
        }

        /* synthetic */ 2() {
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        UsageListView listView;

        public TableMouseListener(UsageListView usageListView) {
            UsageTableView.this = UsageTableView.this;
            this.listView = usageListView;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = UsageTableView.this.table.rowAtPoint(point);
            UsageTableView.this.table.columnAtPoint(point);
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && n == -1) {
                UsageTableView.this.table.clearSelection();
                return;
            }
            if (mouseEvent.isControlDown() || mouseEvent.getClickCount() != 2) {
                return;
            }
            this.listView.fireItemPressed(2);
        }
    }
}

