/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.share;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.fsmgr.client.share.ShareListView;
import com.sun.admin.fsmgr.client.share.ShareListViewListener;
import com.sun.admin.fsmgr.client.share.ShareTableView;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ShareViewPanel
extends JPanel {
    private ShareTableView tableView;
    private ShareListView currentView;

    public ShareViewPanel() {
        this.setLayout(new GridBagLayout());
        this.tableView = new ShareTableView();
        this.setBackground(Color.white);
        this.setView(this.tableView);
        this.addMouseListener(new ViewMouseListener());
    }

    public void showTableView() {
        this.currentView.clearSelection();
        this.setView(this.tableView);
    }

    public ShareListView getCurrentView() {
        return this.currentView;
    }

    public void repaintView() {
        this.setView(this.currentView);
    }

    private void setView(ShareListView shareListView) {
        this.removeAll();
        shareListView.populate();
        this.currentView = shareListView;
        Constraints.constrain(this, shareListView, 0, 0, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        this.invalidate();
        this.validate();
        this.repaint();
        this.currentView.clearSelection();
        this.currentView.fireViewChanged();
    }

    public void addListViewListener(ShareListViewListener shareListViewListener) {
        this.tableView.addListViewListener(shareListViewListener);
    }

    public void removeListViewListener(ShareListViewListener shareListViewListener) {
        this.tableView.removeListViewListener(shareListViewListener);
    }

    class ViewMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ShareViewPanel.this.tableView.doPopupMenu(mouseEvent, !mouseEvent.isControlDown());
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                ShareViewPanel.this.tableView.clearSelection();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ShareViewPanel.this.tableView.doPopupMenu(mouseEvent, !mouseEvent.isControlDown());
            }
        }

        ViewMouseListener() {
            ShareViewPanel.this = ShareViewPanel.this;
        }
    }
}

