/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.share;

import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.cis.common.WholeNumField;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrAccessListOption;
import com.sun.admin.fsmgr.client.FsMgrIntegerOption;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.share.ClientTablePanel;
import com.sun.admin.fsmgr.client.share.ClientTableRow;
import com.sun.admin.fsmgr.client.share.ClientTableView;
import com.sun.admin.fsmgr.client.share.FsMgrSecurityOption;
import com.sun.admin.fsmgr.client.share.FsMgrShareData;
import com.sun.admin.fsmgr.common.FsMgrShareDataException;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class SecModePanel
extends JPanel {
    private static final String CUSTOM_RBTN_HELP = new String("fs_ctx_dlg_shareprop_tab_access_buildcustom");
    private static final String DEFAULT_RBTN_HELP = new String("fs_ctx_dlg_shareprop_tab_access_setdefault");
    private static final String DEFAULT_ACCESS_HELP = new String("fs_ctx_dlg_shareprop_tab_access_readwrite");
    private static final String ADD_BTN_HELP = new String("fs_ctx_dlg_shareprop_tab_access_add");
    private static final String MODIFY_BTN_HELP = new String("fs_ctx_dlg_shareprop_tab_access_modify");
    private static final String REMOVE_BTN_HELP = new String("fs_ctx_dlg_shareprop_tab_access_remove");
    private static final String UPDOWN_BTN_HELP = new String("fs_ctx_dlg_shareprop_tab_access_customlist");
    private static final String LIFETIME_HELP = new String("fs_ctx_dlg_shareprop_tab_access_lifetime");
    private static final String ENABLE_HELP = new String("fs_ctx_dlg_shareprop_tab_access_enable");
    FsMgrSecurityOption secModeOption;
    FsMgrAccessListOption roListObject;
    FsMgrAccessListOption rwListObject;
    FsMgrAccessListOption rootListObject;
    FsMgrIntegerOption requestObject;
    JCheckBox enabledChk;
    JRadioButton defaultRBtn;
    JRadioButton customRBtn;
    JComboBox defaultAccessCombo;
    Vector defaultAccessVec;
    WholeNumField requestMinField;
    WholeNumField requestSecField;
    ClientTablePanel tablePanel;
    SecModePanel modePanel;
    JPanel defaultPanel;
    JPanel invisiblePanel;
    JLabel requestLbl;
    JLabel requestColonLbl;
    JLabel requestUnitsLbl;
    FlowArea requestFA;
    String auth;
    ErrorDialog errorDlg;
    WarningDialog warningDlg;
    WarningListener warningListener;
    boolean defaultAccess = true;
    boolean authNone = false;
    boolean hasRequest = false;
    String nonDefaultStr;
    AdminDialog adminDlg;
    DefaultAccessListener dfa;
    public static final int rwIndex = 0;
    public static final int roIndex = 1;
    int defaultAccessIndex = 0;

    public SecModePanel(AdminDialog adminDialog, String string, FsMgrSecurityOption fsMgrSecurityOption) {
        JComponent jComponent;
        this.adminDlg = adminDialog;
        this.secModeOption = fsMgrSecurityOption;
        this.modePanel = this;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.modePanel.setLayout(gridBagLayout);
        this.warningListener = new WarningListener();
        String string2 = "";
        this.auth = string;
        if (this.auth == FsMgrShareData.SYS) {
            string2 = FsMgrResourceStrings.getString("share_wiz_auth_enabled_authsys");
        } else if (this.auth == FsMgrShareData.DH) {
            string2 = FsMgrResourceStrings.getString("share_wiz_auth_enabled_authdes");
            this.hasRequest = true;
        } else if (this.auth == FsMgrShareData.KRB4) {
            string2 = FsMgrResourceStrings.getString("share_wiz_auth_enabled_authkrb4");
            this.hasRequest = true;
        } else if (this.auth == FsMgrShareData.NONE) {
            string2 = FsMgrResourceStrings.getString("share_wiz_auth_enabled_authnone");
            this.authNone = true;
        } else {
            string2 = "Problem getting authentication mode string";
        }
        this.defaultPanel = new JPanel();
        this.defaultPanel.setLayout(gridBagLayout);
        Constraints.constrain(this.modePanel, this.defaultPanel, 0, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.enabledChk = new JCheckBox(string2, false);
        this.enabledChk.setForeground(Constants.PURPLE);
        Constraints.constrain(this.defaultPanel, this.enabledChk, 0, 0, 2, 1, 0, 17, 1.0, 0.0, 0, 5, 5, 5);
        this.enabledChk.addActionListener(new EnabledListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.defaultRBtn = new JRadioButton(FsMgrResourceStrings.getString("sec_mode_default_rbtn"));
        Constraints.constrain(this.defaultPanel, this.defaultRBtn, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 22, 0, 0);
        this.defaultRBtn.setActionCommand("default");
        RadioListener radioListener = new RadioListener();
        buttonGroup.add(this.defaultRBtn);
        this.defaultAccessVec = new Vector(2);
        this.defaultAccessVec.addElement(FsMgrResourceStrings.getString("read_write"));
        this.defaultAccessVec.addElement(FsMgrResourceStrings.getString("read_only"));
        this.defaultAccessCombo = new JComboBox(this.defaultAccessVec);
        Constraints.constrain(this.defaultPanel, this.defaultAccessCombo, 1, 1, 1, 1, 0, 17, 1.0, 0.0, 0, 5, 0, 5);
        this.defaultAccessCombo.setEditable(false);
        this.defaultAccessCombo.setBackground(Color.white);
        this.customRBtn = new JRadioButton(FsMgrResourceStrings.getString("sec_mode_custom_rbtn"));
        Constraints.constrain(this.defaultPanel, this.customRBtn, 0, 2, 1, 1, 0, 17, 0.0, 0.0, 0, 22, 0, 0);
        this.customRBtn.setActionCommand("custom");
        this.customRBtn.addActionListener(radioListener);
        buttonGroup.add(this.customRBtn);
        if (this.secModeOption == null) {
            this.defaultRBtn.setSelected(true);
            this.defaultAccessCombo.setSelectedIndex(0);
            this.nonDefaultStr = FsMgrResourceStrings.getString("read_only");
        } else if (this.secModeOption.isGloballyRo()) {
            this.defaultRBtn.setSelected(true);
            this.defaultAccessIndex = 1;
            this.defaultAccessCombo.setSelectedIndex(this.defaultAccessIndex);
            this.nonDefaultStr = FsMgrResourceStrings.getString("read_write");
        } else if (this.secModeOption.isGloballyRw()) {
            this.defaultRBtn.setSelected(true);
            this.defaultAccessIndex = 0;
            this.defaultAccessCombo.setSelectedIndex(this.defaultAccessIndex);
            this.nonDefaultStr = FsMgrResourceStrings.getString("read_only");
        } else {
            this.customRBtn.setSelected(true);
            this.replaceDefaultAccessCombo(false, -1);
            this.defaultAccess = false;
        }
        this.tablePanel = new ClientTablePanel(this.modePanel);
        Constraints.constrain(this.modePanel, this.tablePanel, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 0, 0, 0);
        if (this.hasRequest) {
            if (fsMgrSecurityOption != null) {
                this.requestObject = (FsMgrIntegerOption)fsMgrSecurityOption.getOption(FsMgrSecurityOption.WINDOW);
            }
            jComponent = new JPanel();
            jComponent.setLayout(gridBagLayout);
            Constraints.constrain(this.modePanel, jComponent, 0, 2, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
            this.requestFA = new FlowArea(FsMgrResourceStrings.getString("sec_mode_request_exp"));
            Constraints.constrain(jComponent, this.requestFA, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 5, 5, 5);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(gridBagLayout);
            Constraints.constrain(jComponent, jPanel, 0, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
            this.requestLbl = new JLabel(FsMgrResourceStrings.getString("sec_mode_request"));
            Constraints.constrain(jPanel, this.requestLbl, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 5);
            int n = (int)Math.floor(3.579139311666667E7);
            this.requestMinField = new WholeNumField(500, 3, n);
            this.requestMinField.setMinimumSize(this.requestMinField.getPreferredSize());
            Constraints.constrain(jPanel, this.requestMinField, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 5);
            this.requestMinField.setEditable(true);
            this.requestColonLbl = new JLabel(FsMgrResourceStrings.getString("sec_mode_request_colon"));
            Constraints.constrain(jPanel, this.requestColonLbl, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 5, 0);
            this.requestSecField = new WholeNumField(0, 2, 60);
            this.requestSecField.setMinimumSize(this.requestSecField.getPreferredSize());
            Constraints.constrain(jPanel, this.requestSecField, 3, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 5);
            this.requestSecField.setEditable(true);
            this.requestUnitsLbl = new JLabel(FsMgrResourceStrings.getString("min_sec"));
            Constraints.constrain(jPanel, this.requestUnitsLbl, 4, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 0, 5, 5);
            this.invisiblePanel = new JPanel();
            Constraints.constrain(this.modePanel, this.invisiblePanel, 0, 3, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        } else {
            this.invisiblePanel = new JPanel();
            Constraints.constrain(this.modePanel, this.invisiblePanel, 0, 2, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        }
        if (adminDialog != null) {
            FsMgr.getFsMgr().addHelpListener(adminDialog, this.defaultRBtn, DEFAULT_RBTN_HELP);
            FsMgr.getFsMgr().addHelpListener(adminDialog, this.enabledChk, ENABLE_HELP);
            FsMgr.getFsMgr().addHelpListener(adminDialog, this.customRBtn, CUSTOM_RBTN_HELP);
            FsMgr.getFsMgr().addHelpListener(adminDialog, this.defaultAccessCombo, DEFAULT_ACCESS_HELP);
            jComponent = (ClientTableView)this.tablePanel.table.getCurrentView();
            FsMgr.getFsMgr().addHelpListener(adminDialog, ((ClientTableView)jComponent).table, UPDOWN_BTN_HELP);
            FsMgr.getFsMgr().addHelpListener(adminDialog, this.tablePanel.amrPanel.addBtn, ADD_BTN_HELP);
            FsMgr.getFsMgr().addHelpListener(adminDialog, this.tablePanel.amrPanel.modifyBtn, MODIFY_BTN_HELP);
            FsMgr.getFsMgr().addHelpListener(adminDialog, this.tablePanel.amrPanel.removeBtn, REMOVE_BTN_HELP);
            FsMgr.getFsMgr().addHelpListener(adminDialog, this.tablePanel.udPanel.upBtn, UPDOWN_BTN_HELP);
            FsMgr.getFsMgr().addHelpListener(adminDialog, this.tablePanel.udPanel.downBtn, UPDOWN_BTN_HELP);
            if (this.requestMinField != null) {
                FsMgr.getFsMgr().addHelpListener(adminDialog, this.requestMinField, LIFETIME_HELP);
            }
            if (this.requestSecField != null) {
                FsMgr.getFsMgr().addHelpListener(adminDialog, this.requestSecField, LIFETIME_HELP);
            }
        }
        if (fsMgrSecurityOption == null) {
            this.enabledChk.doClick();
            this.enabledChk.doClick();
        } else {
            this.setOptions(fsMgrSecurityOption);
        }
        this.defaultRBtn.addActionListener(radioListener);
        if (this.dfa == null) {
            this.dfa = new DefaultAccessListener();
            this.defaultAccessCombo.addActionListener(this.dfa);
        }
        this.modePanel.invalidate();
        this.modePanel.validate();
        this.modePanel.repaint();
    }

    public boolean isDefaultAccess() {
        return this.defaultAccess;
    }

    public String getNonDefaultStr() {
        return this.nonDefaultStr;
    }

    public boolean isAuthNone() {
        return this.authNone;
    }

    public FsMgrSecurityOption getSecOption() {
        this.updateSecOption();
        return this.secModeOption;
    }

    private void setOptions(FsMgrSecurityOption fsMgrSecurityOption) {
        String string;
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        if (fsMgrSecurityOption == null) {
            return;
        }
        this.enabledChk.doClick();
        this.roListObject = (FsMgrAccessListOption)fsMgrSecurityOption.getOption(FsMgrSecurityOption.ROLIST);
        if (this.roListObject != null) {
            vector = this.roListObject.getValue();
        }
        this.rwListObject = (FsMgrAccessListOption)fsMgrSecurityOption.getOption(FsMgrSecurityOption.RWLIST);
        if (this.rwListObject != null) {
            vector2 = this.rwListObject.getValue();
        }
        this.rootListObject = (FsMgrAccessListOption)fsMgrSecurityOption.getOption(FsMgrSecurityOption.ROOTLIST);
        if (this.rootListObject != null) {
            vector3 = this.rootListObject.getValue();
        }
        if ((string = fsMgrSecurityOption.getAccessListKing()) != null && string.equals(FsMgrSecurityOption.RWLIST)) {
            this.buildRwRows(vector2, vector3);
            this.buildRoRows(vector, vector3);
            this.buildRootRows(vector3);
        } else if (string != null && string.equals(FsMgrSecurityOption.ROLIST)) {
            this.buildRoRows(vector, vector3);
            this.buildRwRows(vector2, vector3);
            this.buildRootRows(vector3);
        } else {
            this.buildRootRows(vector3);
        }
        if (this.requestObject != null) {
            this.setRequestFields();
        }
        this.modePanel.invalidate();
        this.modePanel.validate();
        this.modePanel.repaint();
    }

    public void setRequestFields() {
        int n = this.requestObject.getValue();
        if (n <= 60) {
            this.requestMinField.setValue(0);
            this.requestSecField.setValue(n);
            return;
        }
        int n2 = n % 60;
        int n3 = (n - n2) / 60;
        this.requestMinField.setValue(n3);
        this.requestSecField.setValue(n2);
    }

    public int getRequestFields() {
        int n = 0;
        int n2 = this.requestMinField.getValue();
        int n3 = this.requestSecField.getValue();
        if (n2 > 0) {
            n = n2 * 60;
        }
        if (n3 > 0) {
            n += n3;
        }
        return n;
    }

    private void buildRoRows(Vector vector, Vector vector2) {
        String string = FsMgrResourceStrings.getString("read_only");
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                boolean bl = false;
                String string2 = (String)vector.elementAt(n);
                if (vector2 != null && vector2.contains(string2)) {
                    bl = vector2.removeElement(string2);
                }
                ClientTableRow clientTableRow = new ClientTableRow(string2, string, bl);
                this.tablePanel.table.getCurrentView().append(clientTableRow);
                ++n;
            }
        }
    }

    private void buildRwRows(Vector vector, Vector vector2) {
        String string = FsMgrResourceStrings.getString("read_write");
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                boolean bl = false;
                String string2 = (String)vector.elementAt(n);
                if (vector2 != null && vector2.contains(string2)) {
                    bl = vector2.removeElement(string2);
                }
                ClientTableRow clientTableRow = new ClientTableRow(string2, string, bl);
                this.tablePanel.table.getCurrentView().append(clientTableRow);
                ++n;
            }
        }
    }

    private void buildRootRows(Vector vector) {
        String string = FsMgrResourceStrings.getString("default_access");
        if (vector != null && vector.size() > 0) {
            boolean bl = true;
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                ClientTableRow clientTableRow = new ClientTableRow(string2, string, bl);
                this.tablePanel.table.getCurrentView().append(clientTableRow);
                ++n;
            }
        }
    }

    public void replaceDefaultAccessCombo(boolean bl, int n) {
        this.defaultPanel.remove(this.defaultAccessCombo);
        this.defaultAccessCombo = new JComboBox(this.defaultAccessVec);
        this.defaultAccessCombo.setEditable(false);
        this.defaultAccessCombo.setBackground(Color.white);
        Constraints.constrain(this.defaultPanel, this.defaultAccessCombo, 1, 1, 1, 1, 0, 17, 1.0, 0.0, 0, 5, 0, 5);
        this.defaultAccessCombo.setEnabled(bl);
        if (n >= 0) {
            this.defaultAccessCombo.setSelectedIndex(n);
        }
        if (this.adminDlg != null) {
            FsMgr.getFsMgr().addHelpListener(this.adminDlg, this.defaultAccessCombo, DEFAULT_ACCESS_HELP);
        }
        this.defaultPanel.invalidate();
        this.defaultPanel.validate();
        this.defaultPanel.repaint();
        this.dfa = new DefaultAccessListener();
        this.defaultAccessCombo.addActionListener(this.dfa);
    }

    public void updateSecOption() {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (!this.enabledChk.isSelected()) {
            this.secModeOption = null;
            return;
        }
        if (this.secModeOption == null) {
            this.secModeOption = new FsMgrSecurityOption(this.auth);
        }
        if (this.defaultRBtn.isSelected()) {
            if (this.defaultAccessCombo.getSelectedIndex() == 1) {
                try {
                    this.secModeOption.setOption(FsMgrShareData.RO, true);
                }
                catch (FsMgrShareDataException fsMgrShareDataException) {
                    this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
                }
                try {
                    this.secModeOption.setOption(FsMgrShareData.RW, false);
                }
                catch (FsMgrShareDataException fsMgrShareDataException) {
                    this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
                }
            } else {
                try {
                    this.secModeOption.setOption(FsMgrShareData.RW, true);
                }
                catch (FsMgrShareDataException fsMgrShareDataException) {
                    this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
                }
                try {
                    this.secModeOption.setOption(FsMgrShareData.RO, false);
                }
                catch (FsMgrShareDataException fsMgrShareDataException) {
                    this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
                }
            }
        } else {
            try {
                this.secModeOption.setOption(FsMgrShareData.RO, false);
            }
            catch (FsMgrShareDataException fsMgrShareDataException) {
                this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
            }
            try {
                this.secModeOption.setOption(FsMgrShareData.RW, false);
            }
            catch (FsMgrShareDataException fsMgrShareDataException) {
                this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
            }
        }
        this.setAccessListKing(this.secModeOption);
        string = this.tablePanel.getRoList();
        FsMgrAccessListOption fsMgrAccessListOption = new FsMgrAccessListOption(FsMgrShareData.RO, string);
        try {
            this.secModeOption.setOption(FsMgrShareData.RO, fsMgrAccessListOption);
        }
        catch (FsMgrShareDataException fsMgrShareDataException) {
            this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
        }
        string2 = this.tablePanel.getRwList();
        fsMgrAccessListOption = new FsMgrAccessListOption(FsMgrShareData.RW, string2);
        try {
            this.secModeOption.setOption(FsMgrShareData.RW, fsMgrAccessListOption);
        }
        catch (FsMgrShareDataException fsMgrShareDataException) {
            this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
        }
        string3 = this.tablePanel.getRootList();
        fsMgrAccessListOption = new FsMgrAccessListOption(FsMgrShareData.ROOTLIST, string3);
        try {
            this.secModeOption.setOption(FsMgrShareData.ROOT, fsMgrAccessListOption);
        }
        catch (FsMgrShareDataException fsMgrShareDataException) {
            this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
        }
        if (this.hasRequest) {
            int n = this.getRequestFields();
            Integer n2 = new Integer(n);
            if (this.requestObject == null && n != 30000 || this.requestObject != null && this.requestObject.getValue() != n) {
                this.requestObject = new FsMgrIntegerOption(FsMgrShareData.WINDOW, n);
                try {
                    this.secModeOption.setOption(FsMgrShareData.WINDOW, n2.toString());
                    return;
                }
                catch (FsMgrShareDataException fsMgrShareDataException) {
                    this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrShareDataException.getLocalizedMessage());
                    return;
                }
            }
        }
    }

    private void setAccessListKing(FsMgrSecurityOption fsMgrSecurityOption) {
        Vector vector = this.tablePanel.table.getCurrentView().getRowData();
        ClientTableRow clientTableRow = null;
        String string = FsMgrResourceStrings.getString("read_only");
        String string2 = FsMgrResourceStrings.getString("read_write");
        int n = 0;
        while (n < vector.size()) {
            clientTableRow = (ClientTableRow)vector.elementAt(n);
            if (clientTableRow.getAccessStr().equals(string)) {
                fsMgrSecurityOption.setAccessListKing(FsMgrSecurityOption.ROLIST);
                return;
            }
            if (clientTableRow.getAccessStr().equals(string2)) {
                fsMgrSecurityOption.setAccessListKing(FsMgrSecurityOption.RWLIST);
                return;
            }
            ++n;
        }
    }

    class EnabledListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (SecModePanel.this.enabledChk.isSelected()) {
                SecModePanel.this.modePanel.setEnabled(true);
                SecModePanel.this.defaultRBtn.setEnabled(true);
                if (SecModePanel.this.defaultRBtn.isSelected()) {
                    SecModePanel.this.replaceDefaultAccessCombo(true, SecModePanel.this.defaultAccessIndex);
                } else {
                    SecModePanel.this.replaceDefaultAccessCombo(false, -1);
                }
                SecModePanel.this.customRBtn.setEnabled(true);
                SecModePanel.this.tablePanel.enablePanel(true);
                if (SecModePanel.this.auth.equals(FsMgrShareData.DH) || SecModePanel.this.auth.equals(FsMgrShareData.KRB4)) {
                    SecModePanel.this.requestFA.setEnabled(true);
                    SecModePanel.this.requestLbl.setEnabled(true);
                    SecModePanel.this.requestMinField.setEditable(true);
                    SecModePanel.this.requestColonLbl.setEnabled(true);
                    SecModePanel.this.requestMinField.setEnabled(true);
                    SecModePanel.this.requestSecField.setEditable(true);
                    SecModePanel.this.requestSecField.setEnabled(true);
                    SecModePanel.this.requestUnitsLbl.setEnabled(true);
                }
            } else {
                SecModePanel.this.modePanel.setEnabled(false);
                SecModePanel.this.defaultRBtn.setEnabled(false);
                SecModePanel.this.replaceDefaultAccessCombo(false, -1);
                SecModePanel.this.customRBtn.setEnabled(false);
                SecModePanel.this.tablePanel.enablePanel(false);
                if (SecModePanel.this.auth.equals(FsMgrShareData.DH) || SecModePanel.this.auth.equals(FsMgrShareData.KRB4)) {
                    SecModePanel.this.requestFA.setEnabled(false);
                    SecModePanel.this.requestLbl.setEnabled(false);
                    SecModePanel.this.requestMinField.setEditable(false);
                    SecModePanel.this.requestColonLbl.setEnabled(false);
                    SecModePanel.this.requestMinField.setEnabled(false);
                    SecModePanel.this.requestSecField.setEditable(false);
                    SecModePanel.this.requestSecField.setEnabled(false);
                    SecModePanel.this.requestUnitsLbl.setEnabled(false);
                }
            }
            SecModePanel.this.modePanel.invalidate();
            SecModePanel.this.modePanel.validate();
            SecModePanel.this.modePanel.repaint();
        }

        EnabledListener() {
            SecModePanel.this = SecModePanel.this;
        }
    }

    class RadioListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (SecModePanel.this.defaultAccess && actionEvent.getActionCommand().equals("default") || !SecModePanel.this.defaultAccess && actionEvent.getActionCommand().equals("custom")) {
                return;
            }
            if (SecModePanel.this.tablePanel.table.getCurrentView().isPopulated()) {
                SecModePanel.this.warningDlg = new WarningDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("warning_dlg_title"), FsMgrResourceStrings.getString("client_table_err2"), (ActionListener)SecModePanel.this.warningListener, FsMgrResourceStrings.getString("continue_button"));
                if (SecModePanel.this.tablePanel.table.getCurrentView().isPopulated()) {
                    if (SecModePanel.this.defaultRBtn.isSelected()) {
                        SecModePanel.this.customRBtn.setSelected(true);
                        return;
                    }
                    SecModePanel.this.defaultRBtn.setSelected(true);
                    return;
                }
            }
            if (actionEvent.getActionCommand().equals("default")) {
                SecModePanel.this.tablePanel.setDefaultLabel();
                SecModePanel.this.defaultAccessCombo.setEnabled(true);
                SecModePanel.this.defaultAccessCombo.setSelectedIndex(SecModePanel.this.defaultAccessIndex);
                SecModePanel.this.defaultAccess = true;
            } else {
                SecModePanel.this.tablePanel.setCustomLabel();
                SecModePanel.this.replaceDefaultAccessCombo(false, -1);
                SecModePanel.this.defaultAccess = false;
            }
            SecModePanel.this.modePanel.invalidate();
            SecModePanel.this.modePanel.validate();
            SecModePanel.this.modePanel.repaint();
        }

        RadioListener() {
            SecModePanel.this = SecModePanel.this;
        }
    }

    class WarningListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SecModePanel.this.tablePanel.table.getCurrentView().clear();
            SecModePanel.this.secModeOption = null;
        }

        WarningListener() {
            SecModePanel.this = SecModePanel.this;
        }
    }

    class DefaultAccessListener
    implements ActionListener {
        int correctIndex = -2;

        public void actionPerformed(ActionEvent actionEvent) {
            if (SecModePanel.this.tablePanel.table.getCurrentView().isPopulated()) {
                SecModePanel.this.warningDlg = new WarningDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("warning_dlg_title"), FsMgrResourceStrings.getString("client_table_err2"), (ActionListener)SecModePanel.this.warningListener, FsMgrResourceStrings.getString("continue_button"));
                if (SecModePanel.this.tablePanel.table.getCurrentView().isPopulated()) {
                    this.correctIndex = 0;
                    if (SecModePanel.this.defaultAccessCombo.getSelectedIndex() == 0) {
                        this.correctIndex = 1;
                    }
                    SecModePanel.this.replaceDefaultAccessCombo(true, this.correctIndex);
                    return;
                }
            } else {
                if (SecModePanel.this.defaultAccessCombo.getSelectedIndex() == 0) {
                    SecModePanel.this.defaultAccessIndex = 0;
                    SecModePanel.this.nonDefaultStr = FsMgrResourceStrings.getString("read_only");
                    return;
                }
                SecModePanel.this.defaultAccessIndex = 1;
                SecModePanel.this.nonDefaultStr = FsMgrResourceStrings.getString("read_write");
            }
        }

        DefaultAccessListener() {
            SecModePanel.this = SecModePanel.this;
        }
    }
}

