/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.mount;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.mount.FsMgrMountData;
import com.sun.admin.fsmgr.client.mount.Mount;
import com.sun.admin.fsmgr.client.mount.MountCacheEntry;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrMount;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DeleteAction {
    private MountCacheEntry cacheEntry;
    private boolean canDelete = false;

    public DeleteAction(MountCacheEntry mountCacheEntry) {
        String string;
        this.cacheEntry = mountCacheEntry;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            string = FsMgrResourceStrings.getString("ConfirmDeleteNumColumns");
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        string = FsMgrResourceStrings.getString("ConfirmDelete");
        FlowArea flowArea = new FlowArea(string, n, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 0, 0, 2, 1, 20, 5, 0, 5);
        String string2 = FsMgrResourceStrings.getString("ConfirmDeleteWill");
        flowArea = new FlowArea(string2, n, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 0, 1, 2, 1, 20, 5, 10, 5);
        String string3 = FsMgrResourceStrings.getString("DialogBulletGif");
        ImageIcon imageIcon = FsMgr.getFsMgr().loadImageIcon(string3, "DialogBulletGif");
        Constraints.constrain(jPanel, new JLabel(imageIcon), 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
        String string4 = FsMgrResourceStrings.getString("ConfirmDeleteBullet1");
        flowArea = new FlowArea(string4, n - 5, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 1, 2, 1, 1, 0, 5, 10, 5);
        Constraints.constrain(jPanel, new JLabel(imageIcon), 0, 3, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
        string4 = FsMgrResourceStrings.getString("ConfirmDeleteBullet2");
        flowArea = new FlowArea(string4, n - 5, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 1, 3, 1, 1, 0, 5, 10, 5);
        Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        new WarningDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("ConfirmDeleteTitle"), jPanel, (ActionListener)new ConfirmDeleteListener(), FsMgrResourceStrings.getString("DeleteMount"));
    }

    public void delete() {
        if (!this.canDelete) {
            return;
        }
        String string = FsMgrResourceStrings.getString("DeleteMountTitle");
        String string2 = FsMgrResourceStrings.getString("DeleteMountMessage");
        Object[] objectArray = new Object[]{this.cacheEntry.getResource()};
        String string3 = MessageFormat.format(string2, objectArray);
        ProgressPanel progressPanel = new ProgressPanel(FsMgr.getFsMgr().getFrame(), 1, 30, false, false);
        progressPanel.setTitle(string);
        progressPanel.setText(string3);
        ((Component)progressPanel).setVisible(true);
        progressPanel.show();
        FsMgrClient fsMgrClient = FsMgrClient.instance();
        FsMgrMountData fsMgrMountData = this.cacheEntry.getBootData();
        FsMgrMount fsMgrMount = fsMgrMountData.toFsMgrMount();
        try {
            fsMgrClient.removeMount(fsMgrMount, FsMgrMountData.VFSTAB);
            Mount.getInstance().refresh(null, null);
        }
        catch (FsMgrException fsMgrException) {
            new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
        }
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
        }
        catch (Exception exception) {}
        ((Component)progressPanel).setVisible(false);
        progressPanel.dispose();
    }

    static /* synthetic */ boolean access$0(DeleteAction deleteAction) {
        return deleteAction.canDelete;
    }

    private class ConfirmDeleteListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DeleteAction.this.canDelete = true;
        }

        ConfirmDeleteListener() {
            DeleteAction.this = DeleteAction.this;
        }
    }
}

