/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.security;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.server.AdminServerLibrary;
import com.sun.admin.cis.service.security.AdminAuthenticationException;
import com.sun.admin.cis.service.security.AdminPrincipal;
import com.sun.admin.cis.service.security.AdminSecurityException;
import com.sun.admin.cis.service.security.AuthenticationFlavor;
import com.sun.admin.cis.service.security.AuthenticatorSecurityToken;
import com.sun.admin.cis.service.security.ConfirmSecurityToken;
import com.sun.admin.cis.service.security.Pwcx;
import com.sun.admin.cis.service.security.RequestSecurityToken;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.cis.service.security.ServerSecurityContext;
import com.sun.admin.cis.service.security.VerifierSecurityToken;
import com.sun.admin.cis.service.security.WeakAuthFlavor;
import com.sun.admin.cis.service.security.WeakRequestSecurityToken;

public class WeakServerSecurityContext
extends ServerSecurityContext {
    public WeakServerSecurityContext() throws AdminSecurityException {
        super(new WeakAuthFlavor());
    }

    public boolean verifyAuthFlavor(AuthenticationFlavor authenticationFlavor) throws AdminSecurityException {
        boolean bl = false;
        if (authenticationFlavor.getAuthType() == 0) {
            bl = true;
        } else {
            this.writeLog(2, "LM_1030", "LM_1037", authenticationFlavor.getAuthTypeName(), "weak");
            AdminCommonTools.CMN_Trace1("Security service: authentication flavor mismatch");
        }
        return bl;
    }

    public SecurityToken verifyRequest(RequestSecurityToken requestSecurityToken) throws AdminSecurityException {
        WeakRequestSecurityToken weakRequestSecurityToken;
        try {
            weakRequestSecurityToken = (WeakRequestSecurityToken)requestSecurityToken;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_1030", "LM_1035");
            throw new AdminSecurityException("EXSS_BRT");
        }
        AdminCommonTools.CMN_Trace3("Security service: verifying authentication request...");
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        AdminPrincipal adminPrincipal = weakRequestSecurityToken.getAdminPrincipal();
        if (adminPrincipal != null) {
            string = adminPrincipal.getUserName();
            string2 = adminPrincipal.getDomainName();
            if (string != null) {
                try {
                    string4 = AdminServerLibrary.getEncryptedPassword(string);
                }
                catch (AdminException adminException) {
                    this.writeLog(2, "LM_1030", "LM_1031");
                    throw new AdminAuthenticationException(adminPrincipal.getName());
                }
                if (string4 == null || string4.trim().length() == 0) {
                    this.writeLog(0, "LM_1000", "LM_1001", adminPrincipal.getName());
                    AdminCommonTools.CMN_Trace1("Security service: cannot access user password for " + adminPrincipal.getName());
                    throw new AdminAuthenticationException(adminPrincipal.getName());
                }
                string3 = string4.substring(0, 2);
            } else {
                adminPrincipal = null;
            }
        }
        if (adminPrincipal == null) {
            AdminCommonTools.CMN_Trace1("Security service: null or invalid admin principal identity");
            this.writeLog(2, "LM_1030", "LM_1032");
            throw new AdminSecurityException("EXSS_BUI");
        }
        AdminCommonTools.CMN_Trace3("   Client user identity=" + string);
        String string5 = this.decryptPswd(weakRequestSecurityToken.getUserPassword());
        String string6 = null;
        if (string5 != null) {
            Pwcx pwcx = new Pwcx();
            byte[] byArray = pwcx.pwcx(string5.getBytes(), string3.getBytes());
            string6 = new String(byArray);
        }
        if (string6 == null) {
            AdminCommonTools.CMN_Trace1("Security service: cannot generate hashed password");
            this.writeLog(0, "LM_1000", "LM_1004", adminPrincipal.getName());
            throw new AdminSecurityException("EXSS_BUP");
        }
        if (!string4.equals(string6)) {
            this.writeLog(0, "LM_1000", "LM_1003", adminPrincipal.getName());
            throw new AdminAuthenticationException(adminPrincipal.getName());
        }
        AdminCommonTools.CMN_Trace3("   User is authenticated!");
        this.setAdminPrincipal(adminPrincipal);
        this.setClientHost(weakRequestSecurityToken.getClientHost());
        this.setAuthState(4);
        ConfirmSecurityToken confirmSecurityToken = new ConfirmSecurityToken(0, this.getSecurityId());
        return confirmSecurityToken;
    }

    public SecurityToken verifyAuthenticator(AuthenticatorSecurityToken authenticatorSecurityToken) throws AdminSecurityException {
        SecurityToken securityToken = null;
        this.writeLog(2, "LM_1030", "LM_1036", "weak");
        if (securityToken == null) {
            throw new AdminSecurityException("EXSS_NVA");
        }
        return securityToken;
    }

    public void checkVerifier(VerifierSecurityToken verifierSecurityToken, Object[] objectArray) throws AdminSecurityException {
    }

    public String decryptPassword(byte[] byArray) throws AdminSecurityException {
        if (this.getAuthState() != 4) {
            throw new AdminSecurityException("EXSS_NAX", "encryptPassword");
        }
        return this.decryptPswd(byArray);
    }

    public ServerSecurityContext newCopy() throws AdminSecurityException {
        WeakServerSecurityContext weakServerSecurityContext = new WeakServerSecurityContext();
        super.copyAttrs(weakServerSecurityContext);
        return weakServerSecurityContext;
    }

    private String decryptPswd(byte[] byArray) throws AdminSecurityException {
        byte[] byArray2 = "pAsSwOrDsEcUrItY".getBytes();
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = byArray2.length;
        while (n < n3) {
            int n4 = n;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray[n]);
            if (bl && byArray2[n] == 0) {
                bl = false;
                n2 = n;
            }
            ++n;
        }
        if (n2 < 1 || n2 > 16) {
            throw new AdminSecurityException("EXSS_BEP");
        }
        String string = new String(byArray2, 0, n2);
        return string;
    }
}

