/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.security;

import com.sun.admin.cis.service.security.AdminSecurityException;
import com.sun.admin.cis.service.security.AuthenticationFlavor;

public class DigestAuthFlavor
extends AuthenticationFlavor {
    private String digestAlgo;
    private String signAlgo;
    private String keyAlgo;
    private int strength;

    public DigestAuthFlavor() throws AdminSecurityException {
        super(1);
        this.digestAlgo = "SHA";
        this.signAlgo = "DSA";
        this.keyAlgo = "DSA";
        this.strength = new Integer("1024");
    }

    public DigestAuthFlavor(String string, String string2, String string3, int n) throws AdminSecurityException {
        super(1);
        if (string == null || string.trim().length() == 0) {
            throw new AdminSecurityException("EXSS_BSA", "digest");
        }
        this.digestAlgo = string;
        if (string2 == null || string2.trim().length() == 0) {
            throw new AdminSecurityException("EXSS_BSA", "digest");
        }
        this.signAlgo = string2;
        if (string3 == null || string3.trim().length() == 0) {
            throw new AdminSecurityException("EXSS_BSA", "digest");
        }
        this.keyAlgo = string3;
        if (n <= 0) {
            throw new AdminSecurityException("EXSS_BKS", "digest");
        }
        this.strength = n;
    }

    public AuthenticationFlavor newCopy() throws AdminSecurityException {
        DigestAuthFlavor digestAuthFlavor = new DigestAuthFlavor(this.digestAlgo, this.signAlgo, this.keyAlgo, this.strength);
        return digestAuthFlavor;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgo;
    }

    public void setDigestAlgorithm(String string) throws AdminSecurityException {
        if (string == null || string.trim().length() == 0) {
            throw new AdminSecurityException("EXSS_BSA", "digest");
        }
        this.digestAlgo = string;
    }

    public String getSignatureAlgorithm() {
        return this.signAlgo;
    }

    public void setSignatureAlgorithm(String string) throws AdminSecurityException {
        if (string == null || string.trim().length() == 0) {
            throw new AdminSecurityException("EXSS_BSA", "digest");
        }
        this.signAlgo = string;
    }

    public String getKeyGenerationAlgorithm() {
        return this.keyAlgo;
    }

    public void setKeyGenerationAlgorithm(String string) throws AdminSecurityException {
        if (string == null || string.trim().length() == 0) {
            throw new AdminSecurityException("EXSS_BSA", "digest");
        }
        this.keyAlgo = string;
    }

    public int getKeyStrength() {
        return this.strength;
    }

    public void setKeyStrength(int n) throws AdminSecurityException {
        if (n <= 0) {
            throw new AdminSecurityException("EXSS_BKS", "digest");
        }
        this.strength = n;
    }
}

