/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.security;

import com.sun.admin.cis.service.security.AdminSecurityException;
import com.sun.admin.cis.service.security.AdminSecurityUtil;
import com.sun.admin.cis.service.security.AuthenticationFlavor;
import com.sun.admin.cis.service.security.ConfirmSecurityToken;
import com.sun.admin.cis.service.security.ResponseSecurityToken;
import com.sun.admin.cis.service.security.SecurityContext;
import com.sun.admin.cis.service.security.SecurityToken;

public abstract class ClientSecurityContext
extends SecurityContext {
    SecurityToken secTok = null;
    String userPswd = null;

    public ClientSecurityContext(AuthenticationFlavor authenticationFlavor) throws AdminSecurityException {
        super(authenticationFlavor);
        this.setAuthState(0);
    }

    public abstract ClientSecurityContext newCopy() throws AdminSecurityException;

    public abstract SecurityToken generateRequest() throws AdminSecurityException;

    public abstract SecurityToken verifyResponse(ResponseSecurityToken var1) throws AdminSecurityException;

    public abstract SecurityToken verifyConfirm(ConfirmSecurityToken var1) throws AdminSecurityException;

    public abstract SecurityToken generateVerifier(Object[] var1) throws AdminSecurityException;

    public abstract byte[] encryptPassword(String var1) throws AdminSecurityException;

    public void reset() {
        this.secTok = null;
        this.setSecurityId(null);
        this.setAuthState(0);
    }

    public SecurityToken getSecurityToken() {
        return this.secTok;
    }

    public String getUserPassword() {
        return AdminSecurityUtil.unhashPassword(this.userPswd);
    }

    public void setUserPassword(String string) {
        this.userPswd = AdminSecurityUtil.hashPassword(string);
    }

    protected void copyAttrs(ClientSecurityContext clientSecurityContext) throws AdminSecurityException {
        super.copyAttrs(clientSecurityContext);
        clientSecurityContext.setUserPassword(this.getUserPassword());
    }

    protected void setSecurityToken(SecurityToken securityToken) {
        this.secTok = securityToken;
    }

    private String scramble(String string) {
        return string;
    }

    private String unscramble(String string) {
        return string;
    }
}

