/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.server.AdminServerException;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.admin.usermgr.server.SolarisGroupTable;

public class AdminServerLibrary {
    public static final String ADMIN_SERVER_LIBRARY = "admsvr";
    private static boolean library_loaded;

    public static String getEncryptedPassword(String string) throws AdminException {
        String string2 = null;
        if (library_loaded) {
            string2 = AdminServerLibrary.getPassword(string);
            if (string2 == null || string2.trim().length() == 0) {
                string2 = null;
            }
        } else {
            throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
        }
        return string2;
    }

    public static String getDomainName() throws AdminException {
        String string = null;
        if (library_loaded) {
            string = AdminServerLibrary.getDomain();
            if (string == null || string.trim().length() == 0) {
                string = null;
            }
        } else {
            throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
        }
        return string;
    }

    public static String ypLookup(String string, String string2, String string3) throws AdminException {
        String string4 = null;
        if (library_loaded) {
            int n = string3.length();
            string4 = AdminServerLibrary.ypMatch(string, string2, string3, n);
            if (string4 == null || string4.trim().length() == 0) {
                string4 = null;
            }
        } else {
            throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
        }
        return string4;
    }

    public static void writeToSyslog(String string, String string2, int n) throws AdminException {
        if (library_loaded) {
            AdminServerLibrary.doSyslog(string, string2, n);
            return;
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int doStat(String string) throws AdminException {
        if (library_loaded) {
            return AdminServerLibrary.runStat(string);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int isConsole(String string) throws AdminException {
        if (library_loaded) {
            return AdminServerLibrary.isPortConsole(string);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int eepromSet(String string) throws AdminException {
        if (library_loaded) {
            return AdminServerLibrary.doEEprom(string);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static String getArchitecture() throws AdminException {
        if (library_loaded) {
            return AdminServerLibrary.getArch();
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int checkTTYLabel(String string, String string2) throws AdminException {
        if (library_loaded) {
            return AdminServerLibrary.checkLabel(string, string2);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int auditUserCreate(UserObj userObj, int n) throws AdminException {
        if (library_loaded) {
            if (userObj != null) {
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                if (userObj.getSolGroupAttr() != null) {
                    string = userObj.getSolGroupAttr().getPrimaryGroup();
                    if (string == null) {
                        string = "";
                    }
                    if (userObj.getSolGroupAttr().getSecondaryGroups() != null) {
                        string2 = SolarisGroupTable.formatMembersIntoString(userObj.getSolGroupAttr().getSecondaryGroups());
                    }
                    if (string2 == null) {
                        string2 = "";
                    }
                }
                if (userObj.getSolServicesAttr() != null && (string3 = userObj.getSolServicesAttr().getInitialShell()) == null) {
                    string3 = "";
                }
                if (userObj.getSolPasswordAttr() != null) {
                    string4 = userObj.getSolPasswordAttr().getCannotChangeDays();
                    if (string4 == null) {
                        string4 = "";
                    }
                    if ((string5 = userObj.getSolPasswordAttr().getAlertChangeDays()) == null) {
                        string5 = "";
                    }
                    if ((string6 = userObj.getSolPasswordAttr().getInactiveDays()) == null) {
                        string6 = "";
                    }
                }
                if (userObj.getSolAccountAttr() != null && (string7 = userObj.getSolAccountAttr().getAccountExpires()) == null) {
                    string7 = "";
                }
                if (userObj.getSolHomedirAttr() != null) {
                    string8 = userObj.getSolHomedirAttr().getPathname();
                    if (string8 == null) {
                        string8 = "";
                    }
                    if ((string9 = userObj.getSolHomedirAttr().getServer()) == null) {
                        string9 = "";
                    }
                    if (userObj.getSolHomedirAttr().getPerms() != null) {
                        string10 = userObj.getSolHomedirAttr().getPerms().getPermissions();
                    }
                    if (string10 == null) {
                        string10 = "";
                    }
                }
                int n2 = 3;
                int n3 = 0;
                if (userObj.getSolAccountAttr() != null && userObj.getSolAccountAttr().isAccountLocked()) {
                    n2 = 2;
                    n3 = 1;
                } else {
                    n2 = userObj.getSolPasswordAttr() != null && userObj.getSolPasswordAttr().isThereAPassword() ? 1 : 0;
                }
                return AdminServerLibrary.auditUserCreateEvent(userObj.getUserID(), userObj.getUserName(), string, string2, string3, string4, string5, string6, string7, string5, string8, string9, string10, n2, n3, n);
            }
            return -1;
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int auditUserModify(UserObj userObj, int n) throws AdminException {
        if (library_loaded) {
            if (userObj != null) {
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                if (userObj.getSolGroupAttr() != null) {
                    string = userObj.getSolGroupAttr().getPrimaryGroup();
                    if (string == null) {
                        string = "";
                    }
                    if (userObj.getSolGroupAttr().getSecondaryGroups() != null) {
                        string2 = SolarisGroupTable.formatMembersIntoString(userObj.getSolGroupAttr().getSecondaryGroups());
                    }
                    if (string2 == null) {
                        string2 = "";
                    }
                }
                if (userObj.getSolServicesAttr() != null && (string3 = userObj.getSolServicesAttr().getInitialShell()) == null) {
                    string3 = "";
                }
                if (userObj.getSolPasswordAttr() != null) {
                    string4 = userObj.getSolPasswordAttr().getCannotChangeDays();
                    if (string4 == null) {
                        string4 = "";
                    }
                    if ((string5 = userObj.getSolPasswordAttr().getAlertChangeDays()) == null) {
                        string5 = "";
                    }
                    if ((string6 = userObj.getSolPasswordAttr().getInactiveDays()) == null) {
                        string6 = "";
                    }
                }
                if (userObj.getSolAccountAttr() != null && (string7 = userObj.getSolAccountAttr().getAccountExpires()) == null) {
                    string7 = "";
                }
                if (userObj.getSolHomedirAttr() != null) {
                    string8 = userObj.getSolHomedirAttr().getPathname();
                    if (string8 == null) {
                        string8 = "";
                    }
                    if ((string9 = userObj.getSolHomedirAttr().getServer()) == null) {
                        string9 = "";
                    }
                }
                int n2 = 3;
                int n3 = 0;
                if (userObj.getSolAccountAttr() != null && userObj.getSolAccountAttr().isAccountLocked()) {
                    n2 = 2;
                    n3 = 1;
                } else {
                    n2 = userObj.getSolPasswordAttr() != null && userObj.getSolPasswordAttr().isThereAPassword() ? 1 : 0;
                }
                return AdminServerLibrary.auditUserModifyEvent(userObj.getUserID(), userObj.getUserName(), string, string2, string3, string4, string5, string6, string7, string5, string8, string9, n2, n3, n);
            }
            return -1;
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int auditUserDelete(String string, String string2, int n) throws AdminException {
        if (string == null || string2 == null) {
            return -1;
        }
        if (library_loaded) {
            if (n >= 0) {
                return AdminServerLibrary.auditDeleteUserSuccess(string, string2);
            }
            return AdminServerLibrary.auditDeleteUserFailure(string, string2);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int auditMount(String string, String string2, int n) throws AdminException {
        if (string == null || string2 == null) {
            return -1;
        }
        if (library_loaded) {
            return AdminServerLibrary.auditMountEvent(string, string2, n);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int auditUMount(String string, String string2) throws AdminException {
        if (string == null || string2 == null) {
            return -1;
        }
        if (library_loaded) {
            return AdminServerLibrary.auditUMountEvent(string, string2);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    private static native String getPassword(String var0);

    private static native String getDomain();

    private static native String ypMatch(String var0, String var1, String var2, int var3);

    private static native void doSyslog(String var0, String var1, int var2);

    private static native int runStat(String var0);

    private static native int isPortConsole(String var0);

    private static native int doEEprom(String var0);

    private static native String getArch();

    private static native int checkLabel(String var0, String var1);

    private static native int auditUserCreateEvent(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, int var13, int var14, int var15);

    private static native int auditUserModifyEvent(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, int var12, int var13, int var14);

    private static native int auditDeleteUserSuccess(String var0, String var1);

    private static native int auditDeleteUserFailure(String var0, String var1);

    private static native int auditMountEvent(String var0, String var1, int var2);

    private static native int auditUMountEvent(String var0, String var1);

    static {
        try {
            System.loadLibrary(ADMIN_SERVER_LIBRARY);
            library_loaded = true;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Server daemon: Unable to load libadmsvr shared library: " + exception.getMessage());
        }
    }
}

