/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Stopwatch;
import com.sun.admin.cis.common.Util;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.Vector;

public class Sequence {
    private static long infiniteCycle = -1L;
    private Vector cells = new Vector();
    private Point lastPaintLocation = new Point(0, 0);
    private Stopwatch cellAdvanceTimer = new Stopwatch();
    private Image currentImage;
    private Image lastImagePainted;
    private long cellAdvanceInterval;
    private long currentCycle;
    private long cyclesPerAnimation;

    public Sequence() {
    }

    public Sequence(Component component, Image[] imageArray) {
        int n = 0;
        while (n < imageArray.length) {
            this.addImage(component, imageArray[n]);
            ++n;
        }
        this.cyclesPerAnimation = infiniteCycle;
    }

    public void start() {
        this.cellAdvanceTimer.start();
    }

    public Image getLastImage() {
        return this.lastImagePainted;
    }

    public Point getLastLocation() {
        return this.lastPaintLocation;
    }

    public int getNumImages() {
        return this.cells.size();
    }

    public long getCurrentCycle() {
        return this.currentCycle;
    }

    public void setCurrentCycle(long l) {
        this.currentCycle = l;
    }

    public long getCyclesPerAnimation() {
        return this.currentCycle;
    }

    public void setCyclesPerAnimation(long l) {
        this.cyclesPerAnimation = l;
    }

    public Image getFirstImage() {
        return (Image)this.cells.firstElement();
    }

    public Image getCurrentImage() {
        return this.currentImage;
    }

    public int getCurrentImagePosition() {
        return this.cells.indexOf(this.currentImage);
    }

    public Image getNextImage() {
        int n = this.cells.indexOf(this.currentImage);
        Image image = n == this.cells.size() - 1 ? (Image)this.cells.elementAt(0) : (Image)this.cells.elementAt(n + 1);
        return image;
    }

    public void setAdvanceInterval(long l) {
        this.cellAdvanceInterval = l;
    }

    public void addImage(Component component, Image image) {
        if (this.currentImage == null) {
            this.currentImage = image;
        }
        Util.waitForImage(component, image);
        this.cells.addElement(image);
    }

    public void removeImage(Image image) {
        this.cells.removeElement(image);
    }

    public boolean needsRepainting(Point point) {
        return this.lastPaintLocation.x != point.x || this.lastPaintLocation.y != point.y || this.lastImagePainted != this.currentImage;
    }

    public boolean isAtLastImage() {
        return this.getCurrentImagePosition() == this.cells.size() - 1;
    }

    public boolean timeToAdvanceCell() {
        return this.cellAdvanceTimer.elapsedTime() > this.cellAdvanceInterval;
    }

    public boolean animationOver() {
        return this.cyclesPerAnimation != infiniteCycle && this.currentCycle >= this.cyclesPerAnimation;
    }

    public void advance() {
        if (this.isAtLastImage()) {
            ++this.currentCycle;
        }
        this.currentImage = this.getNextImage();
        this.cellAdvanceTimer.reset();
    }
}

