/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.sort.Compare;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrRemoteFile;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;

public class FsMgrDirectoryTree
extends JTree {
    private DefaultTreeModel treeModel;
    private DefaultTreeSelectionModel treeSelectionModel;
    private String selectedPath;
    private static String DIRECTORY_DELIMTER = new String("/");

    public FsMgrDirectoryTree(String string) throws FsMgrException {
        super((TreeModel)null);
        FsMgrDirectoryTreeNode fsMgrDirectoryTreeNode = new FsMgrDirectoryTreeNode(string);
        this.treeModel = new DefaultTreeModel(fsMgrDirectoryTreeNode);
        this.setModel(this.treeModel);
        this.treeSelectionModel = new DefaultTreeSelectionModel();
        this.treeSelectionModel.setSelectionMode(1);
        this.setSelectionModel(this.treeSelectionModel);
        this.expandNode(fsMgrDirectoryTreeNode);
        this.addTreeExpansionListener(new FsMgrDirectoryTreeExpansionHandler());
        this.addTreeSelectionListener(new FsMgrDirectoryTreeSelectionHandler());
    }

    public void expandNode(FsMgrDirectoryTreeNode fsMgrDirectoryTreeNode) throws FsMgrException {
        if (fsMgrDirectoryTreeNode.isExpanded()) {
            return;
        }
        Vector vector = fsMgrDirectoryTreeNode.getSubDirectoryNodes();
        if (vector.size() != 0) {
            Sort.sort(vector, (Compare)new FsMgrDirectoryTreeNodeSort());
            int n = 0;
            while (n < vector.size()) {
                FsMgrDirectoryTreeNode fsMgrDirectoryTreeNode2 = (FsMgrDirectoryTreeNode)vector.elementAt(n);
                fsMgrDirectoryTreeNode.add(fsMgrDirectoryTreeNode2);
                ++n;
            }
        }
        fsMgrDirectoryTreeNode.setExpanded();
        this.treeModel.nodeStructureChanged(fsMgrDirectoryTreeNode);
    }

    public void setSelectedPath(String string) {
        this.selectedPath = string;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    protected class FsMgrDirectoryTreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            FsMgrDirectoryTree fsMgrDirectoryTree = (FsMgrDirectoryTree)treeSelectionEvent.getSource();
            FsMgrDirectoryTreeNode fsMgrDirectoryTreeNode = (FsMgrDirectoryTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            String string = fsMgrDirectoryTreeNode.getName();
            if (treeSelectionEvent.isAddedPath()) {
                fsMgrDirectoryTree.setSelectedPath(string);
                return;
            }
            fsMgrDirectoryTree.setSelectedPath(null);
        }

        protected FsMgrDirectoryTreeSelectionHandler() {
            FsMgrDirectoryTree.this = FsMgrDirectoryTree.this;
        }
    }

    protected class FsMgrDirectoryTreeExpansionHandler
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            FsMgrDirectoryTree fsMgrDirectoryTree = (FsMgrDirectoryTree)treeExpansionEvent.getSource();
            FsMgrDirectoryTreeNode fsMgrDirectoryTreeNode = (FsMgrDirectoryTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
            try {
                fsMgrDirectoryTree.expandNode(fsMgrDirectoryTreeNode);
                return;
            }
            catch (FsMgrException fsMgrException) {
                new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
                return;
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        protected FsMgrDirectoryTreeExpansionHandler() {
            FsMgrDirectoryTree.this = FsMgrDirectoryTree.this;
        }
    }

    public class FsMgrDirectoryTreeNodeSort
    implements Compare {
        public final int doCompare(Object object, Object object2) {
            FsMgrDirectoryTreeNode fsMgrDirectoryTreeNode = (FsMgrDirectoryTreeNode)object;
            FsMgrDirectoryTreeNode fsMgrDirectoryTreeNode2 = (FsMgrDirectoryTreeNode)object2;
            return fsMgrDirectoryTreeNode.getName().compareTo(fsMgrDirectoryTreeNode2.getName());
        }

        public FsMgrDirectoryTreeNodeSort() {
            FsMgrDirectoryTree.this = FsMgrDirectoryTree.this;
        }
    }

    protected class FsMgrDirectoryTreeNode
    extends DefaultMutableTreeNode {
        FsMgrRemoteFile fsMgrRemoteFile;
        boolean expanded = false;

        public FsMgrDirectoryTreeNode(String string) throws FsMgrException {
            FsMgrDirectoryTree.this = FsMgrDirectoryTree.this;
            this.fsMgrRemoteFile = FsMgrClient.instance().getFile(string);
        }

        public String getName() {
            String string = this.fsMgrRemoteFile.getParent();
            String string2 = string != null && string.equals(DIRECTORY_DELIMTER) ? String.valueOf(string) + this.fsMgrRemoteFile.getName() : (string != null ? String.valueOf(string) + DIRECTORY_DELIMTER + this.fsMgrRemoteFile.getName() : this.fsMgrRemoteFile.getName());
            if (string2 == null || string2.length() == 0) {
                string2 = DIRECTORY_DELIMTER;
            }
            return string2;
        }

        public Vector getSubDirectoryNodes() throws FsMgrException {
            Vector<FsMgrDirectoryTreeNode> vector = new Vector<FsMgrDirectoryTreeNode>();
            Vector vector2 = FsMgrClient.instance().getList(this.getName());
            if (vector2 != null) {
                int n = 0;
                while (n < vector2.size()) {
                    FsMgrRemoteFile fsMgrRemoteFile = (FsMgrRemoteFile)vector2.elementAt(n);
                    if (fsMgrRemoteFile.isDirectory()) {
                        vector.addElement(new FsMgrDirectoryTreeNode(String.valueOf(this.getName()) + DIRECTORY_DELIMTER + fsMgrRemoteFile.getName()));
                    }
                    ++n;
                }
            }
            return vector;
        }

        public void setExpanded() {
            this.expanded = true;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public boolean isLeaf() {
            return !this.fsMgrRemoteFile.isDirectory();
        }

        public boolean getAllowsChildren() {
            return this.fsMgrRemoteFile.isDirectory();
        }

        public String toString() {
            String string = this.fsMgrRemoteFile.getName();
            if (string == null || string.length() == 0) {
                string = DIRECTORY_DELIMTER;
            }
            return string;
        }
    }
}

