/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.authorization;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.service.authorization.AuthAttrObj;
import com.sun.admin.cis.service.authorization.AuthAttrTable;
import com.sun.admin.cis.service.authorization.KeyValue;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import java.util.Hashtable;
import java.util.Vector;

public class SolarisAuthAttrTable
implements AuthAttrTable {
    private static final String table = new String("auth_attr");
    private static final String emptyString = new String("");
    private static final String nameCol = "name";
    private static final String res1Col = "res1";
    private static final String res2Col = "res2";
    private static final String shortDescCol = "short_descr";
    private static final String longDescCol = "long_descr";
    private static final String attrCol = "attr";
    private Hashtable attrGetterHash;
    private Hashtable attrSetterHash;
    private String scope;
    static /* synthetic */ Class array$Ljava$lang$String;

    public SolarisAuthAttrTable(String string) {
        this.scope = string;
        Class[] classArray = new Class[]{};
        Class[] classArray2 = new Class[]{array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = SolarisAuthAttrTable.class$("[Ljava.lang.String;"))};
        AuthAttrObj authAttrObj = new AuthAttrObj();
        this.attrGetterHash = KeyValue.getAttrHash(authAttrObj, classArray, AuthAttrObj.knownKeys, AuthAttrObj.getters);
        this.attrSetterHash = KeyValue.getAttrHash(authAttrObj, classArray2, AuthAttrObj.knownKeys, AuthAttrObj.setters);
    }

    public AuthAttrObj readAuthAttrObj(String string) throws DirectoryTableException {
        DirectoryTable directoryTable;
        AuthAttrObj authAttrObj;
        block3: {
            authAttrObj = null;
            directoryTable = this.openAuthAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow != null) {
                    authAttrObj = new AuthAttrObj(string);
                    authAttrObj.setShortDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(shortDescCol)));
                    authAttrObj.setLongDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(longDescCol)));
                    String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(attrCol));
                    KeyValue.getAttributes(authAttrObj, string2, this.attrSetterHash);
                    break block3;
                }
                AdminCommonTools.CMN_Trace3("Attributes for " + string + " do not exist");
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var5_7 = null;
        directoryTable.close();
        return authAttrObj;
    }

    public AuthAttrObj[] listAuthAttributes() throws DirectoryTableException {
        Vector<AuthAttrObj> vector = new Vector<AuthAttrObj>();
        DirectoryTable directoryTable = this.openAuthAttrTable();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = directoryTable.getAll();
            int n = 1;
            while (n <= directoryRow.getNumberOfRows()) {
                AuthAttrObj authAttrObj = new AuthAttrObj();
                authAttrObj.setAuthName(directoryRow.getColumn(tableDefinitions.getColumnNumber(nameCol), n));
                authAttrObj.setShortDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(shortDescCol), n));
                authAttrObj.setLongDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(longDescCol), n));
                String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(attrCol), n);
                KeyValue.getAttributes(authAttrObj, string, this.attrSetterHash);
                vector.addElement(authAttrObj);
                ++n;
            }
        }
        finally {
            Object var5_8 = null;
            directoryTable.close();
        }
        Object[] objectArray = new AuthAttrObj[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public AuthAttrObj[] readAuthAttrObjList(String string) throws DirectoryTableException {
        Vector<AuthAttrObj> vector = new Vector<AuthAttrObj>();
        DirectoryTable directoryTable = this.openAuthAttrTable();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = directoryTable.getAll();
            int n = 1;
            while (n <= directoryRow.getNumberOfRows()) {
                String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(nameCol), n);
                if (string2.startsWith(string)) {
                    AuthAttrObj authAttrObj = new AuthAttrObj(string2);
                    authAttrObj.setShortDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(shortDescCol), n));
                    authAttrObj.setLongDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(longDescCol), n));
                    String string3 = directoryRow.getColumn(tableDefinitions.getColumnNumber(attrCol));
                    KeyValue.getAttributes(authAttrObj, string3, this.attrSetterHash);
                    vector.addElement(authAttrObj);
                }
                ++n;
            }
        }
        finally {
            Object var7_10 = null;
            directoryTable.close();
        }
        Object[] objectArray = new AuthAttrObj[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void writeAuthAttrObj(AuthAttrObj authAttrObj) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block3: {
            directoryTable = this.openAuthAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), authAttrObj.getAuthName());
                DirectoryRow directoryRow2 = directoryTable.getFirstRow(directoryRow);
                String string = directoryRow2 != null ? directoryRow2.getColumn(tableDefinitions.getColumnNumber(attrCol)) : null;
                String string2 = KeyValue.putAttributes(authAttrObj, string, this.attrGetterHash);
                directoryRow.putColumn(tableDefinitions.getColumnNumber(shortDescCol), authAttrObj.getShortDesc());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(longDescCol), authAttrObj.getLongDesc());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(attrCol), string2);
                if (directoryRow2 == null) {
                    directoryTable.addRow(directoryRow);
                    break block3;
                }
                directoryTable.modifyRow(directoryRow2, directoryRow);
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var4_8 = null;
        directoryTable.close();
    }

    public void removeAuthAttrObj(String string) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block3: {
            directoryTable = this.openAuthAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow == null) {
                    AdminCommonTools.CMN_Trace3("Authorization " + string + " does not exist");
                    break block3;
                }
                directoryTable.deleteRow(directoryRow);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var4_5 = null;
        directoryTable.close();
    }

    public void removeAuthAttrObj(AuthAttrObj authAttrObj) throws DirectoryTableException {
        String string = authAttrObj.getAuthName();
        this.removeAuthAttrObj(string);
    }

    public void createAuthAttrTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        boolean bl = true;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope);
            directoryTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            bl = false;
        }
        catch (DirectoryTableException directoryTableException) {
            AdminCommonTools.CMN_Trace1("Unexpected error creating auth table: " + directoryTableException.getMessage());
            directoryTable.close();
            throw directoryTableException;
        }
        TableDefinitions tableDefinitions = null;
        try {
            try {
                if (!bl) {
                    tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions(table);
                    directoryTable.create(table);
                }
            }
            catch (DirectoryTableException directoryTableException) {
                AdminCommonTools.CMN_Trace1("Auth: error creating table: " + directoryTableException.getMessage());
                throw directoryTableException;
            }
            Object var5_7 = null;
            directoryTable.close();
            return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            directoryTable.close();
            throw throwable;
        }
    }

    private DirectoryTable openAuthAttrTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope);
        directoryTable.open(table);
        return directoryTable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

