/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.UmbrellaConnection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WarningDialog {
    private JDialog dialog;
    private JButton okBtn;
    private JButton cancelBtn;
    private JFrame parent;
    private String title = ResourceStrings.getString("warning_title");
    private JPanel msgPanel;
    private String btnLabel = ResourceStrings.getString("w_ok_button");
    private ActionListener listener;
    private static final String imageDir = String.valueOf(UmbrellaConnection.sharedInstance().getClientComm().getImagePath()) + "/cis/common/images/";
    private static final ImageIcon warningIcon = new ImageIcon(String.valueOf(imageDir) + "warning_icon.gif");
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public WarningDialog(JFrame jFrame, JPanel jPanel, ActionListener actionListener) {
        this.parent = jFrame;
        this.msgPanel = jPanel;
        this.listener = actionListener;
        this.createWarningDialog();
    }

    public WarningDialog(JFrame jFrame, String string, JPanel jPanel, ActionListener actionListener) {
        this.parent = jFrame;
        this.title = string;
        this.msgPanel = jPanel;
        this.listener = actionListener;
        this.createWarningDialog();
    }

    public WarningDialog(JFrame jFrame, JPanel jPanel, ActionListener actionListener, String string) {
        this.parent = jFrame;
        this.msgPanel = jPanel;
        this.btnLabel = string;
        this.listener = actionListener;
        this.createWarningDialog();
    }

    public WarningDialog(JFrame jFrame, String string, JPanel jPanel, ActionListener actionListener, String string2) {
        this.parent = jFrame;
        this.title = string;
        this.msgPanel = jPanel;
        this.btnLabel = string2;
        this.listener = actionListener;
        this.createWarningDialog();
    }

    public WarningDialog(JFrame jFrame, String string, String string2, ActionListener actionListener, String string3) {
        this.parent = jFrame;
        this.title = string;
        this.btnLabel = string3;
        this.listener = actionListener;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        FlowArea flowArea = new FlowArea(string2, 30, Constants.ERROR_DIALOG_FONT);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain(jPanel, flowArea, 0, 0, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        this.msgPanel = jPanel;
        this.createWarningDialog();
    }

    private void createWarningDialog() {
        this.dialog = new JDialog(this.parent, this.title, true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        SpecialKeyListener specialKeyListener = new SpecialKeyListener();
        this.dialog.addKeyListener(specialKeyListener);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        Constraints.constrain(jPanel, jPanel2, 0, 0, 1, 2, 3, 17, 0.0, 1.0, 5, 5, 5, 0);
        JLabel jLabel = this.getIconLabel();
        Constraints.constrain(jPanel2, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        JPanel jPanel3 = new JPanel();
        Constraints.constrain(jPanel2, jPanel3, 0, 1, 1, 1, 3, 17, 0.0, 1.0, 0, 0, 0, 0);
        this.msgPanel.setSize(this.msgPanel.getPreferredSize());
        Constraints.constrain(jPanel, this.msgPanel, 1, 0, 1, 1, 1, 17, 1.0, 1.0, 20, 10, 20, 20);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        jPanel3 = new JPanel();
        Constraints.constrain(jPanel4, jPanel3, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.okBtn = new JButton(this.btnLabel);
        this.okBtn.addActionListener(new OKBtnListener());
        Constraints.constrain(jPanel4, this.okBtn, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        this.cancelBtn = new JButton(ResourceStrings.getString("w_cancel_button"));
        this.cancelBtn.addActionListener(new CancelBtnListener());
        Constraints.constrain(jPanel4, this.cancelBtn, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 0, 5, 5);
        Constraints.constrain(jPanel, jPanel4, 1, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.dialog.getContentPane().setLayout(gridBagLayout);
        Constraints.constrain(this.dialog.getContentPane(), jPanel, 0, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.centerDialog();
        this.okBtn.requestFocus();
        ((Component)this.dialog).setVisible(true);
    }

    private JLabel getIconLabel() {
        JLabel jLabel = new JLabel(warningIcon);
        return jLabel;
    }

    public void centerDialog() {
        ((Component)this.dialog).setLocation(WarningDialog.screenSize.width / 2 - this.dialog.getSize().width / 2, WarningDialog.screenSize.height / 2 - this.dialog.getSize().height / 2);
    }

    class OKBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = new JButton();
            jButton.addActionListener(WarningDialog.this.listener);
            jButton.doClick();
            WarningDialog.this.dialog.dispose();
        }

        OKBtnListener() {
            WarningDialog.this = WarningDialog.this;
        }
    }

    class CancelBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            WarningDialog.this.dialog.dispose();
        }

        CancelBtnListener() {
            WarningDialog.this = WarningDialog.this;
        }
    }

    protected class SpecialKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                WarningDialog.this.okBtn.doClick();
                return;
            }
            if (keyEvent.getKeyCode() == 27) {
                WarningDialog.this.dialog.dispose();
            }
        }

        protected SpecialKeyListener() {
            WarningDialog.this = WarningDialog.this;
        }
    }
}

