/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.mount;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.fsmgr.client.FsMgrBooleanOption;
import com.sun.admin.fsmgr.client.FsMgrIntegerOption;
import com.sun.admin.fsmgr.client.FsMgrStringOption;
import com.sun.admin.fsmgr.common.FsMgrMount;
import com.sun.admin.fsmgr.common.FsMgrMountDataException;

public class FsMgrMountData
implements Cloneable {
    private static final String EMPTY_STRING = new String("");
    private static final String COMMA = new String(",");
    public static final String YES = new String("yes");
    public static final String NO = new String("no");
    public static final String DASH = new String("-");
    public static final String UFS = new String("ufs");
    public static final String NFS = new String("nfs");
    public static final String HSFS = new String("hsfs");
    public static final String SWAP = new String("swap");
    public static final String TMPFS = new String("tmpfs");
    public static final String PROC = new String("proc");
    public static final String FD = new String("fd");
    public static final String DH = new String("dh");
    public static final String KRB4 = new String("krb4");
    public static final String ROOT = new String("/");
    public static final String USR = new String("/usr");
    public static final String VAR = new String("/var");
    public static final String MOUNTTAB = new String("mounttab");
    public static final String VFSTAB = new String("vfstab");
    public static final String[] MOUNTTAB_ARRAY = new String[]{MOUNTTAB};
    public static final String[] VFSTAB_ARRAY = new String[]{VFSTAB};
    public static final String[] MOUNTBOTH_ARRAY = new String[]{MOUNTTAB, VFSTAB};
    private String rawString = EMPTY_STRING;
    private String resource = EMPTY_STRING;
    private String fsckDevice = EMPTY_STRING;
    private String mountPoint = EMPTY_STRING;
    private String fsType = EMPTY_STRING;
    private String fsckPass = EMPTY_STRING;
    private String bootMount = EMPTY_STRING;
    private FsMgrBooleanOption rw;
    private FsMgrBooleanOption ro;
    private FsMgrBooleanOption intr;
    private FsMgrBooleanOption nointr;
    private FsMgrBooleanOption nosuid;
    private FsMgrBooleanOption suid;
    private FsMgrBooleanOption quota;
    private FsMgrBooleanOption noquota;
    private FsMgrIntegerOption acdirmax;
    private FsMgrIntegerOption acdirmin;
    private FsMgrIntegerOption acregmax;
    private FsMgrIntegerOption acregmin;
    private FsMgrIntegerOption actimeo;
    private FsMgrBooleanOption bg;
    private FsMgrBooleanOption fg;
    private FsMgrBooleanOption grpid;
    private FsMgrBooleanOption hard;
    private FsMgrBooleanOption soft;
    private FsMgrBooleanOption kerberos;
    private FsMgrBooleanOption noac;
    private FsMgrIntegerOption port;
    private FsMgrBooleanOption posix;
    private FsMgrStringOption proto;
    private FsMgrBooleanOption webnfs;
    private FsMgrIntegerOption retrans;
    private FsMgrIntegerOption retry;
    private FsMgrIntegerOption rsize;
    private FsMgrStringOption sec;
    private FsMgrBooleanOption secure;
    private FsMgrIntegerOption timeo;
    private FsMgrIntegerOption vers;
    private FsMgrIntegerOption wsize;
    private FsMgrBooleanOption largefiles;
    private FsMgrBooleanOption nolargefiles;
    private FsMgrBooleanOption noatime;
    private FsMgrBooleanOption forcedirectio;
    private FsMgrBooleanOption noforcedirectio;
    private FsMgrBooleanOption logging;
    private FsMgrBooleanOption nologging;
    private FsMgrBooleanOption rq;
    private FsMgrStringOption onerror;
    private FsMgrStringOption toosoon;
    private FsMgrBooleanOption nrr;
    private FsMgrBooleanOption notraildot;
    private FsMgrBooleanOption nomaplcase;
    public static final String ACDIRMAX = new String("acdirmax");
    public static final String ACDIRMIN = new String("acdirmin");
    public static final String ACREGMAX = new String("acregmax");
    public static final String ACREGMIN = new String("acregmin");
    public static final String ACTIMEO = new String("actimeo");
    public static final String BG = new String("bg");
    public static final String FG = new String("fg");
    public static final String GRPID = new String("grpid");
    public static final String HARD = new String("hard");
    public static final String SOFT = new String("soft");
    public static final String INTR = new String("intr");
    public static final String NOINTR = new String("nointr");
    public static final String KERBEROS = new String("kerberos");
    public static final String NOAC = new String("noac");
    public static final String PORT = new String("port");
    public static final String POSIX = new String("posix");
    public static final String PROTO = new String("proto");
    public static final String PUBLIC = new String("public");
    public static final String QUOTA = new String("quota");
    public static final String NOQUOTA = new String("noquota");
    public static final String RETRANS = new String("retrans");
    public static final String RETRY = new String("retry");
    public static final String RO = new String("ro");
    public static final String RW = new String("rw");
    public static final String RSIZE = new String("rsize");
    public static final String SEC = new String("sec");
    public static final String SECURE = new String("secure");
    public static final String SUID = new String("suid");
    public static final String NOSUID = new String("nosuid");
    public static final String TIMEO = new String("timeo");
    public static final String VERS = new String("vers");
    public static final String WSIZE = new String("wsize");
    public static final String LARGEFILES = new String("largefiles");
    public static final String NOLARGEFILES = new String("nolargefiles");
    public static final String NOATIME = new String("noatime");
    public static final String FORCEDIRECTIO = new String("forcedirectio");
    public static final String NOFORCEDIRECTIO = new String("noforcedirectio");
    public static final String LOGGING = new String("logging");
    public static final String NOLOGGING = new String("nologging");
    public static final String RQ = new String("rq");
    public static final String ONERROR = new String("onerror");
    public static final String TOOSOON = new String("toosoon");
    public static final String NRR = new String("nrr");
    public static final String NOTRAILDOT = new String("notraildot");
    public static final String NOMAPLCASE = new String("nomaplcase");
    public static final int ACDIRMAX_DEFAULT = 60;
    public static final int ACDIRMIN_DEFAULT = 30;
    public static final int ACREGMAX_DEFAULT = 60;
    public static final int ACREGMIN_DEFAULT = 3;
    public static final boolean BG_DEFAULT = false;
    public static final boolean FG_DEFAULT = true;
    public static final boolean GRPID_DEFAULT = false;
    public static final boolean HARD_DEFAULT = true;
    public static final boolean SOFT_DEFAULT = false;
    public static final boolean INTR_DEFAULT = true;
    public static final boolean NOINTR_DEFAULT = false;
    public static final boolean KERBEROS_DEFAULT = false;
    public static final boolean NOAC_DEFAULT = false;
    public static final int PORT_DEFAULT = 2049;
    public static final boolean POSIX_DEFAULT = false;
    public static final String PROTO_DEFAULT = new String("tcp");
    public static final boolean PUBLIC_DEFAULT = false;
    public static final boolean QUOTA_DEFAULT = false;
    public static final boolean NOQUOTA_DEFAULT = true;
    public static final int RETRANS_DEFAULT = 5;
    public static final int RETRY_DEFAULT = 10000;
    public static final boolean RO_DEFAULT = false;
    public static final boolean RW_DEFAULT = true;
    public static final int RSIZE_DEFAULT = 32768;
    public static final boolean SECURE_DEFAULT = false;
    public static final boolean SUID_DEFAULT = true;
    public static final boolean NOSUID_DEFAULT = false;
    public static final int TIMEO_DEFAULT = 11;
    public static final int VERS_DEFAULT = 3;
    public static final int WSIZE_DEFAULT = 32768;
    public static final boolean LARGEFILES_DEFAULT = true;
    public static final boolean NOLARGEFILES_DEFAULT = false;
    public static final boolean NOATIME_DEFAULT = false;
    public static final boolean FORCEDIRECTIO_DEFAULT = false;
    public static final boolean NOFORCEDIRECTIO_DEFAULT = true;
    public static final boolean LOGGING_DEFAULT = false;
    public static final boolean NOLOGGING_DEFAULT = true;
    public static final boolean RQ_DEFAULT = false;
    public static final String ONERROR_DEFAULT = new String("panic");
    public static final String TOOSOON_DEFAULT = new String("1w");
    public static final boolean NRR_DEFAULT = false;
    public static final boolean NOTRAILDOT_DEFAULT = false;
    public static final boolean NOMAPLCASE_DEFAULT = false;

    public FsMgrMountData(String string) throws FsMgrMountDataException {
        if (string == null || string.length() == 0) {
            AdminCommonTools.CMN_HandleOutput("Invalid mount resource");
            throw new FsMgrMountDataException("EXM_MNTRSRC");
        }
        this.resource = string;
    }

    public FsMgrMountData(FsMgrMount fsMgrMount) throws FsMgrMountDataException {
        if (fsMgrMount == null) {
            return;
        }
        this.rawString = fsMgrMount.getRawString();
        this.resource = fsMgrMount.getResource();
        if (this.resource == null || this.resource.length() == 0) {
            AdminCommonTools.CMN_HandleOutput("Invalid mount resource");
            throw new FsMgrMountDataException("EXM_MNTRSRC");
        }
        this.fsckDevice = fsMgrMount.getFsckDevice();
        this.mountPoint = fsMgrMount.getMountPoint();
        this.fsType = fsMgrMount.getFsType();
        this.fsckPass = fsMgrMount.getFsckPass();
        this.bootMount = fsMgrMount.getBootMount();
        String string = fsMgrMount.getOptions();
        if (string == null || string.length() == 0 || string.trim().equals(DASH)) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 44;
        boolean bl = true;
        while (bl) {
            String string2;
            n2 = string.indexOf(n3, n);
            if (n2 == -1) {
                if (n == string.length() - 1) {
                    bl = false;
                }
                string2 = string.substring(n).trim();
                bl = false;
            } else {
                string2 = string.substring(n, n2).trim();
                n = n2 + 1;
            }
            this.setOption(string2);
        }
        this.verify();
        this.convertAccess();
    }

    public Object clone() {
        try {
            FsMgrMountData fsMgrMountData = (FsMgrMountData)super.clone();
            if (this.acdirmax != null) {
                fsMgrMountData.acdirmax = (FsMgrIntegerOption)this.acdirmax.clone();
            }
            if (this.acdirmin != null) {
                fsMgrMountData.acdirmin = (FsMgrIntegerOption)this.acdirmin.clone();
            }
            if (this.acregmax != null) {
                fsMgrMountData.acregmax = (FsMgrIntegerOption)this.acregmax.clone();
            }
            if (this.acregmin != null) {
                fsMgrMountData.acregmin = (FsMgrIntegerOption)this.acregmin.clone();
            }
            if (this.actimeo != null) {
                fsMgrMountData.actimeo = (FsMgrIntegerOption)this.actimeo.clone();
            }
            if (this.bg != null) {
                fsMgrMountData.bg = (FsMgrBooleanOption)this.bg.clone();
            }
            if (this.fg != null) {
                fsMgrMountData.fg = (FsMgrBooleanOption)this.fg.clone();
            }
            if (this.grpid != null) {
                fsMgrMountData.grpid = (FsMgrBooleanOption)this.grpid.clone();
            }
            if (this.hard != null) {
                fsMgrMountData.hard = (FsMgrBooleanOption)this.hard.clone();
            }
            if (this.soft != null) {
                fsMgrMountData.soft = (FsMgrBooleanOption)this.soft.clone();
            }
            if (this.intr != null) {
                fsMgrMountData.intr = (FsMgrBooleanOption)this.intr.clone();
            }
            if (this.nointr != null) {
                fsMgrMountData.nointr = (FsMgrBooleanOption)this.nointr.clone();
            }
            if (this.kerberos != null) {
                fsMgrMountData.kerberos = (FsMgrBooleanOption)this.kerberos.clone();
            }
            if (this.noac != null) {
                fsMgrMountData.noac = (FsMgrBooleanOption)this.noac.clone();
            }
            if (this.port != null) {
                fsMgrMountData.port = (FsMgrIntegerOption)this.port.clone();
            }
            if (this.posix != null) {
                fsMgrMountData.posix = (FsMgrBooleanOption)this.posix.clone();
            }
            if (this.proto != null) {
                fsMgrMountData.proto = (FsMgrStringOption)this.proto.clone();
            }
            if (this.webnfs != null) {
                fsMgrMountData.webnfs = (FsMgrBooleanOption)this.webnfs.clone();
            }
            if (this.quota != null) {
                fsMgrMountData.quota = (FsMgrBooleanOption)this.quota.clone();
            }
            if (this.noquota != null) {
                fsMgrMountData.noquota = (FsMgrBooleanOption)this.noquota.clone();
            }
            if (this.retrans != null) {
                fsMgrMountData.retrans = (FsMgrIntegerOption)this.retrans.clone();
            }
            if (this.retry != null) {
                fsMgrMountData.retry = (FsMgrIntegerOption)this.retry.clone();
            }
            if (this.ro != null) {
                fsMgrMountData.ro = (FsMgrBooleanOption)this.ro.clone();
            }
            if (this.rw != null) {
                fsMgrMountData.rw = (FsMgrBooleanOption)this.rw.clone();
            }
            if (this.rsize != null) {
                fsMgrMountData.rsize = (FsMgrIntegerOption)this.rsize.clone();
            }
            if (this.sec != null) {
                fsMgrMountData.sec = (FsMgrStringOption)this.sec.clone();
            }
            if (this.secure != null) {
                fsMgrMountData.secure = (FsMgrBooleanOption)this.secure.clone();
            }
            if (this.suid != null) {
                fsMgrMountData.suid = (FsMgrBooleanOption)this.suid.clone();
            }
            if (this.nosuid != null) {
                fsMgrMountData.nosuid = (FsMgrBooleanOption)this.nosuid.clone();
            }
            if (this.timeo != null) {
                fsMgrMountData.timeo = (FsMgrIntegerOption)this.timeo.clone();
            }
            if (this.vers != null) {
                fsMgrMountData.vers = (FsMgrIntegerOption)this.vers.clone();
            }
            if (this.wsize != null) {
                fsMgrMountData.wsize = (FsMgrIntegerOption)this.wsize.clone();
            }
            if (this.largefiles != null) {
                fsMgrMountData.largefiles = (FsMgrBooleanOption)this.largefiles.clone();
            }
            if (this.nolargefiles != null) {
                fsMgrMountData.nolargefiles = (FsMgrBooleanOption)this.nolargefiles.clone();
            }
            if (this.noatime != null) {
                fsMgrMountData.noatime = (FsMgrBooleanOption)this.noatime.clone();
            }
            if (this.forcedirectio != null) {
                fsMgrMountData.forcedirectio = (FsMgrBooleanOption)this.forcedirectio.clone();
            }
            if (this.noforcedirectio != null) {
                fsMgrMountData.noforcedirectio = (FsMgrBooleanOption)this.noforcedirectio.clone();
            }
            if (this.logging != null) {
                fsMgrMountData.logging = (FsMgrBooleanOption)this.logging.clone();
            }
            if (this.nologging != null) {
                fsMgrMountData.nologging = (FsMgrBooleanOption)this.nologging.clone();
            }
            if (this.rq != null) {
                fsMgrMountData.rq = (FsMgrBooleanOption)this.rq.clone();
            }
            if (this.onerror != null) {
                fsMgrMountData.onerror = (FsMgrStringOption)this.onerror.clone();
            }
            if (this.toosoon != null) {
                fsMgrMountData.toosoon = (FsMgrStringOption)this.toosoon.clone();
            }
            if (this.nrr != null) {
                fsMgrMountData.nrr = (FsMgrBooleanOption)this.nrr.clone();
            }
            if (this.notraildot != null) {
                fsMgrMountData.notraildot = (FsMgrBooleanOption)this.notraildot.clone();
            }
            if (this.nomaplcase != null) {
                fsMgrMountData.nomaplcase = (FsMgrBooleanOption)this.nomaplcase.clone();
            }
            return fsMgrMountData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equalAttributes(FsMgrBooleanOption fsMgrBooleanOption, FsMgrBooleanOption fsMgrBooleanOption2, boolean bl) {
        if (fsMgrBooleanOption == null && fsMgrBooleanOption2 == null) {
            return true;
        }
        if (fsMgrBooleanOption == null || fsMgrBooleanOption2 == null) {
            if (fsMgrBooleanOption == null) {
                fsMgrBooleanOption = new FsMgrBooleanOption(fsMgrBooleanOption2.getOptionName(), bl);
            } else {
                fsMgrBooleanOption2 = new FsMgrBooleanOption(fsMgrBooleanOption.getOptionName(), bl);
            }
        }
        return this.equalAttributes(fsMgrBooleanOption, fsMgrBooleanOption2);
    }

    public boolean equalAttributes(FsMgrStringOption fsMgrStringOption, FsMgrStringOption fsMgrStringOption2, String string) {
        if (fsMgrStringOption == null && fsMgrStringOption2 == null) {
            return true;
        }
        if (fsMgrStringOption == null || fsMgrStringOption2 == null) {
            if (fsMgrStringOption == null) {
                fsMgrStringOption = new FsMgrStringOption(fsMgrStringOption2.getOptionName(), string);
            } else {
                fsMgrStringOption2 = new FsMgrStringOption(fsMgrStringOption.getOptionName(), string);
            }
        }
        return this.equalAttributes(fsMgrStringOption, fsMgrStringOption2);
    }

    public boolean equalAttributes(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof String) {
            if (object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.equals(string2);
            }
            return false;
        }
        if (object instanceof FsMgrBooleanOption) {
            if (object instanceof FsMgrBooleanOption) {
                FsMgrBooleanOption fsMgrBooleanOption = (FsMgrBooleanOption)object;
                FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)object2;
                return fsMgrBooleanOption.equals(fsMgrBooleanOption2);
            }
            return false;
        }
        if (object instanceof FsMgrStringOption) {
            if (object instanceof FsMgrStringOption) {
                FsMgrStringOption fsMgrStringOption = (FsMgrStringOption)object;
                FsMgrStringOption fsMgrStringOption2 = (FsMgrStringOption)object2;
                return fsMgrStringOption.equals(fsMgrStringOption2);
            }
            return false;
        }
        if (object instanceof FsMgrIntegerOption) {
            if (object instanceof FsMgrIntegerOption) {
                FsMgrIntegerOption fsMgrIntegerOption = (FsMgrIntegerOption)object;
                FsMgrIntegerOption fsMgrIntegerOption2 = (FsMgrIntegerOption)object2;
                return fsMgrIntegerOption.equals(fsMgrIntegerOption2);
            }
            return false;
        }
        AdminCommonTools.CMN_HandleOutput("Can't compare unrecognizable attribute types");
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            AdminCommonTools.CMN_HandleOutput("object is null");
            return false;
        }
        if (!(object instanceof FsMgrMountData)) {
            return false;
        }
        FsMgrMountData fsMgrMountData = (FsMgrMountData)object;
        String string = fsMgrMountData.getResource();
        if (!this.equalAttributes(string, this.resource)) {
            AdminCommonTools.CMN_HandleOutput("resource NOT equal");
            return false;
        }
        String string2 = fsMgrMountData.getFsckDevice();
        if (!(this.equalAttributes(string2, this.fsckDevice) || string2.equals(DASH) || this.fsckDevice.equals(DASH))) {
            AdminCommonTools.CMN_HandleOutput("fsckDevice NOT equal");
            return false;
        }
        String string3 = fsMgrMountData.getMountPoint();
        if (!this.equalAttributes(string3, this.mountPoint)) {
            AdminCommonTools.CMN_HandleOutput("mountPoint NOT equal");
            return false;
        }
        String string4 = fsMgrMountData.getFsType();
        if (!this.equalAttributes(string4, this.fsType)) {
            AdminCommonTools.CMN_HandleOutput("fsType NOT equal");
            return false;
        }
        String string5 = fsMgrMountData.getFsckPass();
        if (!(this.equalAttributes(string5, this.fsckPass) || string5.equals(DASH) || this.fsckPass.equals(DASH))) {
            AdminCommonTools.CMN_HandleOutput("fsckPass NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption = (FsMgrIntegerOption)fsMgrMountData.getOption(ACDIRMAX);
        if (!this.equalAttributes(fsMgrIntegerOption, this.acdirmax)) {
            AdminCommonTools.CMN_HandleOutput("acdirmax NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption2 = (FsMgrIntegerOption)fsMgrMountData.getOption(ACDIRMIN);
        if (!this.equalAttributes(fsMgrIntegerOption2, this.acdirmin)) {
            AdminCommonTools.CMN_HandleOutput("acdirmin NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption3 = (FsMgrIntegerOption)fsMgrMountData.getOption(ACREGMAX);
        if (!this.equalAttributes(fsMgrIntegerOption3, this.acregmax)) {
            AdminCommonTools.CMN_HandleOutput("acregmax NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption4 = (FsMgrIntegerOption)fsMgrMountData.getOption(ACREGMIN);
        if (!this.equalAttributes(fsMgrIntegerOption4, this.acregmin)) {
            AdminCommonTools.CMN_HandleOutput("acregmin NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption5 = (FsMgrIntegerOption)fsMgrMountData.getOption(ACTIMEO);
        if (!this.equalAttributes(fsMgrIntegerOption5, this.actimeo)) {
            AdminCommonTools.CMN_HandleOutput("actimeo NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption = (FsMgrBooleanOption)fsMgrMountData.getOption(GRPID);
        if (!this.equalAttributes(fsMgrBooleanOption, this.grpid, false)) {
            AdminCommonTools.CMN_HandleOutput("grpid NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)fsMgrMountData.getOption(HARD);
        if (!this.equalAttributes(fsMgrBooleanOption2, this.hard, true)) {
            AdminCommonTools.CMN_HandleOutput("hard NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption3 = (FsMgrBooleanOption)fsMgrMountData.getOption(SOFT);
        if (!this.equalAttributes(fsMgrBooleanOption3, this.soft, false)) {
            AdminCommonTools.CMN_HandleOutput("soft NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption4 = (FsMgrBooleanOption)fsMgrMountData.getOption(INTR);
        if (!this.equalAttributes(fsMgrBooleanOption4, this.intr, true)) {
            AdminCommonTools.CMN_HandleOutput("intr NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption5 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOINTR);
        if (!this.equalAttributes(fsMgrBooleanOption5, this.nointr, false)) {
            AdminCommonTools.CMN_HandleOutput("nointr NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption6 = (FsMgrBooleanOption)fsMgrMountData.getOption(KERBEROS);
        if (!this.equalAttributes(fsMgrBooleanOption6, this.kerberos, false)) {
            AdminCommonTools.CMN_HandleOutput("kerberos NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption7 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOAC);
        if (!this.equalAttributes(fsMgrBooleanOption7, this.noac, false)) {
            AdminCommonTools.CMN_HandleOutput("noac NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption6 = (FsMgrIntegerOption)fsMgrMountData.getOption(PORT);
        if (!this.equalAttributes(fsMgrIntegerOption6, this.port)) {
            AdminCommonTools.CMN_HandleOutput("port NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption8 = (FsMgrBooleanOption)fsMgrMountData.getOption(POSIX);
        if (!this.equalAttributes(fsMgrBooleanOption8, this.posix, false)) {
            AdminCommonTools.CMN_HandleOutput("posix NOT equal");
            return false;
        }
        FsMgrStringOption fsMgrStringOption = (FsMgrStringOption)fsMgrMountData.getOption(PROTO);
        if (!this.equalAttributes(fsMgrStringOption, this.proto)) {
            AdminCommonTools.CMN_HandleOutput("proto NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption9 = (FsMgrBooleanOption)fsMgrMountData.getOption(PUBLIC);
        if (!this.equalAttributes(fsMgrBooleanOption9, this.webnfs, false)) {
            AdminCommonTools.CMN_HandleOutput("webnfs NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption10 = (FsMgrBooleanOption)fsMgrMountData.getOption(QUOTA);
        if (!this.equalAttributes(fsMgrBooleanOption10, this.quota, false)) {
            AdminCommonTools.CMN_HandleOutput("quota NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption11 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOQUOTA);
        if (!this.equalAttributes(fsMgrBooleanOption11, this.noquota, true)) {
            AdminCommonTools.CMN_HandleOutput("noquota NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption7 = (FsMgrIntegerOption)fsMgrMountData.getOption(RETRANS);
        if (!this.equalAttributes(fsMgrIntegerOption7, this.retrans)) {
            AdminCommonTools.CMN_HandleOutput("retrans NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption12 = (FsMgrBooleanOption)fsMgrMountData.getOption(RO);
        if (!this.equalAttributes(fsMgrBooleanOption12, this.ro, false)) {
            AdminCommonTools.CMN_HandleOutput("ro NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption13 = (FsMgrBooleanOption)fsMgrMountData.getOption(RW);
        if (!this.equalAttributes(fsMgrBooleanOption13, this.rw, true)) {
            AdminCommonTools.CMN_HandleOutput("rw NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption8 = (FsMgrIntegerOption)fsMgrMountData.getOption(RSIZE);
        if (!this.equalAttributes(fsMgrIntegerOption8, this.rsize)) {
            AdminCommonTools.CMN_HandleOutput("rsize NOT equal");
            return false;
        }
        FsMgrStringOption fsMgrStringOption2 = (FsMgrStringOption)fsMgrMountData.getOption(SEC);
        if (!this.equalAttributes(fsMgrStringOption2, this.sec)) {
            AdminCommonTools.CMN_HandleOutput("sec NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption14 = (FsMgrBooleanOption)fsMgrMountData.getOption(SECURE);
        if (!this.equalAttributes(fsMgrBooleanOption14, this.secure, false)) {
            AdminCommonTools.CMN_HandleOutput("secure NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption15 = (FsMgrBooleanOption)fsMgrMountData.getOption(SUID);
        if (!this.equalAttributes(fsMgrBooleanOption15, this.suid, true)) {
            AdminCommonTools.CMN_HandleOutput("suid NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption16 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOSUID);
        if (!this.equalAttributes(fsMgrBooleanOption16, this.nosuid, false)) {
            AdminCommonTools.CMN_HandleOutput("nosuid NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption9 = (FsMgrIntegerOption)fsMgrMountData.getOption(TIMEO);
        if (!this.equalAttributes(fsMgrIntegerOption9, this.timeo)) {
            AdminCommonTools.CMN_HandleOutput("timeo NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption10 = (FsMgrIntegerOption)fsMgrMountData.getOption(VERS);
        if (!this.equalAttributes(fsMgrIntegerOption10, this.vers)) {
            AdminCommonTools.CMN_HandleOutput("vers NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption11 = (FsMgrIntegerOption)fsMgrMountData.getOption(WSIZE);
        if (!this.equalAttributes(fsMgrIntegerOption11, this.wsize)) {
            AdminCommonTools.CMN_HandleOutput("wsize NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption17 = (FsMgrBooleanOption)fsMgrMountData.getOption(LARGEFILES);
        if (!this.equalAttributes(fsMgrBooleanOption17, this.largefiles, true)) {
            AdminCommonTools.CMN_HandleOutput("largefiles NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption18 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOLARGEFILES);
        if (!this.equalAttributes(fsMgrBooleanOption18, this.nolargefiles, false)) {
            AdminCommonTools.CMN_HandleOutput("nolargefiles NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption19 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOATIME);
        if (!this.equalAttributes(fsMgrBooleanOption19, this.noatime, false)) {
            AdminCommonTools.CMN_HandleOutput("noatime NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption20 = (FsMgrBooleanOption)fsMgrMountData.getOption(FORCEDIRECTIO);
        if (!this.equalAttributes(fsMgrBooleanOption20, this.forcedirectio, false)) {
            AdminCommonTools.CMN_HandleOutput("forcedirectio NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption21 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOFORCEDIRECTIO);
        if (!this.equalAttributes(fsMgrBooleanOption21, this.noforcedirectio, true)) {
            AdminCommonTools.CMN_HandleOutput("noforcedirectio NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption22 = (FsMgrBooleanOption)fsMgrMountData.getOption(LOGGING);
        if (!this.equalAttributes(fsMgrBooleanOption22, this.logging, false)) {
            AdminCommonTools.CMN_HandleOutput("logging NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption23 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOLOGGING);
        if (!this.equalAttributes(fsMgrBooleanOption23, this.nologging, true)) {
            AdminCommonTools.CMN_HandleOutput("nologging NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption24 = (FsMgrBooleanOption)fsMgrMountData.getOption(RQ);
        if (!this.equalAttributes(fsMgrBooleanOption24, this.rq, false)) {
            AdminCommonTools.CMN_HandleOutput("rq NOT equal");
            return false;
        }
        FsMgrStringOption fsMgrStringOption3 = (FsMgrStringOption)fsMgrMountData.getOption(ONERROR);
        if (!this.equalAttributes(fsMgrStringOption3, this.onerror, ONERROR_DEFAULT)) {
            AdminCommonTools.CMN_HandleOutput("onerror NOT equal");
            return false;
        }
        FsMgrStringOption fsMgrStringOption4 = (FsMgrStringOption)fsMgrMountData.getOption(TOOSOON);
        if (!this.equalAttributes(fsMgrStringOption4, this.toosoon, TOOSOON_DEFAULT)) {
            AdminCommonTools.CMN_HandleOutput("toosoon NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption25 = (FsMgrBooleanOption)fsMgrMountData.getOption(NRR);
        if (!this.equalAttributes(fsMgrBooleanOption25, this.nrr, false)) {
            AdminCommonTools.CMN_HandleOutput("nrr NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption26 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOTRAILDOT);
        if (!this.equalAttributes(fsMgrBooleanOption26, this.notraildot, false)) {
            AdminCommonTools.CMN_HandleOutput("notraildot NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption27 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOMAPLCASE);
        if (!this.equalAttributes(fsMgrBooleanOption27, this.nomaplcase, false)) {
            AdminCommonTools.CMN_HandleOutput("nomaplcase NOT equal");
            return false;
        }
        return true;
    }

    public boolean equalAccess(Object object) {
        FsMgrBooleanOption fsMgrBooleanOption;
        if (object == null) {
            return false;
        }
        if (!(object instanceof FsMgrMountData)) {
            return false;
        }
        FsMgrMountData fsMgrMountData = (FsMgrMountData)object;
        FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)fsMgrMountData.getOption(RW);
        if (!this.equalAttributes(fsMgrBooleanOption2, this.rw, true)) {
            AdminCommonTools.CMN_HandleOutput("rw NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption3 = (FsMgrBooleanOption)fsMgrMountData.getOption(RO);
        if (!this.equalAttributes(fsMgrBooleanOption3, this.ro, false)) {
            AdminCommonTools.CMN_HandleOutput("ro NOT equal");
            return false;
        }
        if (this.fsType == UFS && !this.equalAttributes(fsMgrBooleanOption = (FsMgrBooleanOption)fsMgrMountData.getOption(RQ), this.rq, false)) {
            AdminCommonTools.CMN_HandleOutput("rq NOT equal");
            return false;
        }
        return true;
    }

    private FsMgrBooleanOption createOption(String string, FsMgrBooleanOption fsMgrBooleanOption, boolean bl) throws FsMgrMountDataException {
        if (fsMgrBooleanOption != null) {
            AdminCommonTools.CMN_HandleOutput("Can't set option twice");
            throw new FsMgrMountDataException("EXM_MNTOPT", string);
        }
        return new FsMgrBooleanOption(string, bl);
    }

    private FsMgrIntegerOption createOption(String string, FsMgrIntegerOption fsMgrIntegerOption, String string2) throws FsMgrMountDataException {
        if (fsMgrIntegerOption != null) {
            AdminCommonTools.CMN_HandleOutput("Can't set option twice");
            throw new FsMgrMountDataException("EXM_MNTOPT", string);
        }
        return new FsMgrIntegerOption(string, string2);
    }

    private FsMgrStringOption createOption(String string, FsMgrStringOption fsMgrStringOption, String string2) throws FsMgrMountDataException {
        if (fsMgrStringOption != null) {
            AdminCommonTools.CMN_HandleOutput("Can't set option twice");
            throw new FsMgrMountDataException("EXM_MNTOPT", string);
        }
        return new FsMgrStringOption(string, string2);
    }

    private void setOption(String string) throws FsMgrMountDataException {
        int n = 61;
        int n2 = string.indexOf(n);
        if (n2 != -1) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            this.setOption(string2, string3);
            return;
        }
        String string4 = string;
        this.setOption(string4, true);
    }

    public void setOption(String string, String string2) throws FsMgrMountDataException {
        if (string.equals(ACDIRMAX)) {
            if (this.acdirmax == null) {
                this.acdirmax = this.createOption(ACDIRMAX, this.acdirmax, string2);
                return;
            }
            this.acdirmax.setValue(string2);
            return;
        }
        if (string.equals(ACDIRMIN)) {
            if (this.acdirmin == null) {
                this.acdirmin = this.createOption(ACDIRMIN, this.acdirmin, string2);
                return;
            }
            this.acdirmin.setValue(string2);
            return;
        }
        if (string.equals(ACREGMAX)) {
            if (this.acregmax == null) {
                this.acregmax = this.createOption(ACREGMAX, this.acregmax, string2);
                return;
            }
            this.acregmax.setValue(string2);
            return;
        }
        if (string.equals(ACREGMIN)) {
            if (this.acregmin == null) {
                this.acregmin = this.createOption(ACREGMIN, this.acregmin, string2);
                return;
            }
            this.acregmin.setValue(string2);
            return;
        }
        if (string.equals(ACTIMEO)) {
            if (this.actimeo == null) {
                this.actimeo = this.createOption(ACTIMEO, this.actimeo, string2);
                return;
            }
            this.actimeo.setValue(string2);
            return;
        }
        if (string.equals(PORT)) {
            if (this.port == null) {
                this.port = this.createOption(PORT, this.port, string2);
                return;
            }
            this.port.setValue(string2);
            return;
        }
        if (string.equals(PROTO)) {
            if (this.proto == null) {
                this.proto = this.createOption(PROTO, this.proto, string2);
                return;
            }
            this.proto.setValue(string2);
            return;
        }
        if (string.equals(RETRANS)) {
            if (this.retrans == null) {
                this.retrans = this.createOption(RETRANS, this.retrans, string2);
                return;
            }
            this.retrans.setValue(string2);
            return;
        }
        if (string.equals(RETRY)) {
            if (this.retry == null) {
                this.retry = this.createOption(RETRY, this.retry, string2);
                return;
            }
            this.retry.setValue(string2);
            return;
        }
        if (string.equals(RSIZE)) {
            if (this.rsize == null) {
                this.rsize = this.createOption(RSIZE, this.rsize, string2);
                return;
            }
            this.rsize.setValue(string2);
            return;
        }
        if (string.equals(SEC)) {
            if (this.sec == null) {
                this.sec = this.createOption(SEC, this.sec, string2);
                return;
            }
            this.sec.setValue(string2);
            return;
        }
        if (string.equals(TIMEO)) {
            if (this.timeo == null) {
                this.timeo = this.createOption(TIMEO, this.timeo, string2);
                return;
            }
            this.timeo.setValue(string2);
            return;
        }
        if (string.equals(VERS)) {
            if (this.vers == null) {
                this.vers = this.createOption(VERS, this.vers, string2);
                return;
            }
            this.vers.setValue(string2);
            return;
        }
        if (string.equals(WSIZE)) {
            if (this.wsize == null) {
                this.wsize = this.createOption(WSIZE, this.wsize, string2);
                return;
            }
            this.wsize.setValue(string2);
            return;
        }
        if (string.equals(ONERROR)) {
            if (this.onerror == null) {
                this.onerror = this.createOption(ONERROR, this.onerror, string2);
                return;
            }
            this.onerror.setValue(string2);
            return;
        }
        if (string.equals(TOOSOON)) {
            if (this.toosoon == null) {
                this.toosoon = this.createOption(TOOSOON, this.toosoon, string2);
                return;
            }
            this.toosoon.setValue(string2);
            return;
        }
        AdminCommonTools.CMN_HandleOutput("Unsupported option = " + string);
        throw new FsMgrMountDataException("EXM_MNTOPT", string);
    }

    public void setOption(String string, int n) throws FsMgrMountDataException {
        this.setOption(string, Integer.toString(n));
    }

    public void setOption(String string, boolean bl) throws FsMgrMountDataException {
        if (string.equals(BG)) {
            if (this.bg == null) {
                this.bg = this.createOption(BG, this.bg, bl);
            } else {
                this.bg.setValue(bl);
            }
            if (this.fg != null) {
                this.fg.setValue(!bl);
                return;
            }
        } else if (string.equals(FG)) {
            if (this.fg == null) {
                this.fg = this.createOption(FG, this.fg, bl);
            } else {
                this.fg.setValue(bl);
            }
            if (this.bg != null) {
                this.bg.setValue(!bl);
                return;
            }
        } else {
            if (string.equals(GRPID)) {
                if (this.grpid == null) {
                    this.grpid = this.createOption(GRPID, this.grpid, bl);
                    return;
                }
                this.grpid.setValue(bl);
                return;
            }
            if (string.equals(HARD)) {
                if (this.hard == null) {
                    this.hard = this.createOption(HARD, this.hard, bl);
                } else {
                    this.hard.setValue(bl);
                }
                if (this.soft != null) {
                    this.soft.setValue(!bl);
                    return;
                }
            } else if (string.equals(SOFT)) {
                if (this.soft == null) {
                    this.soft = this.createOption(SOFT, this.soft, bl);
                } else {
                    this.soft.setValue(bl);
                }
                if (this.hard != null) {
                    this.hard.setValue(!bl);
                    return;
                }
            } else if (string.equals(INTR)) {
                if (this.intr == null) {
                    this.intr = this.createOption(INTR, this.intr, bl);
                } else {
                    this.intr.setValue(bl);
                }
                if (this.nointr != null) {
                    this.nointr.setValue(!bl);
                    return;
                }
            } else if (string.equals(NOINTR)) {
                if (this.nointr == null) {
                    this.nointr = this.createOption(NOINTR, this.nointr, bl);
                } else {
                    this.nointr.setValue(bl);
                }
                if (this.intr != null) {
                    this.intr.setValue(!bl);
                    return;
                }
            } else {
                if (string.equals(KERBEROS)) {
                    if (this.kerberos == null) {
                        this.kerberos = this.createOption(KERBEROS, this.kerberos, bl);
                        return;
                    }
                    this.kerberos.setValue(bl);
                    return;
                }
                if (string.equals(NOAC)) {
                    if (this.noac == null) {
                        this.noac = this.createOption(NOAC, this.noac, bl);
                        return;
                    }
                    this.noac.setValue(bl);
                    return;
                }
                if (string.equals(POSIX)) {
                    if (this.posix == null) {
                        this.posix = this.createOption(POSIX, this.posix, bl);
                        return;
                    }
                    this.posix.setValue(bl);
                    return;
                }
                if (string.equals(PUBLIC)) {
                    if (this.webnfs == null) {
                        this.webnfs = this.createOption(PUBLIC, this.webnfs, bl);
                        return;
                    }
                    this.webnfs.setValue(bl);
                    return;
                }
                if (string.equals(QUOTA)) {
                    if (this.quota == null) {
                        this.quota = this.createOption(QUOTA, this.quota, bl);
                    } else {
                        this.quota.setValue(bl);
                    }
                    if (this.noquota != null) {
                        this.noquota.setValue(!bl);
                        return;
                    }
                } else if (string.equals(NOQUOTA)) {
                    if (this.noquota == null) {
                        this.noquota = this.createOption(NOQUOTA, this.noquota, bl);
                    } else {
                        this.noquota.setValue(bl);
                    }
                    if (this.quota != null) {
                        this.quota.setValue(!bl);
                        return;
                    }
                } else if (string.equals(RO)) {
                    if (this.ro == null) {
                        this.ro = this.createOption(RO, this.ro, bl);
                    } else {
                        this.ro.setValue(bl);
                    }
                    if (this.rw != null) {
                        this.rw.setValue(!bl);
                        return;
                    }
                } else if (string.equals(RW)) {
                    if (this.rw == null) {
                        this.rw = this.createOption(RW, this.rw, bl);
                    } else {
                        this.rw.setValue(bl);
                    }
                    if (this.ro != null) {
                        this.ro.setValue(!bl);
                        return;
                    }
                } else {
                    if (string.equals(SECURE)) {
                        if (this.secure == null) {
                            this.secure = this.createOption(SECURE, this.secure, bl);
                            return;
                        }
                        this.secure.setValue(bl);
                        return;
                    }
                    if (string.equals(SUID)) {
                        if (this.suid == null) {
                            this.suid = this.createOption(SUID, this.suid, bl);
                        } else {
                            this.suid.setValue(bl);
                        }
                        if (this.nosuid != null) {
                            this.nosuid.setValue(!bl);
                            return;
                        }
                    } else if (string.equals(NOSUID)) {
                        if (this.nosuid == null) {
                            this.nosuid = this.createOption(NOSUID, this.nosuid, bl);
                        } else {
                            this.nosuid.setValue(bl);
                        }
                        if (this.suid != null) {
                            this.suid.setValue(!bl);
                            return;
                        }
                    } else if (string.equals(LARGEFILES)) {
                        if (this.largefiles == null) {
                            this.largefiles = this.createOption(LARGEFILES, this.largefiles, bl);
                        } else {
                            this.largefiles.setValue(bl);
                        }
                        if (this.nolargefiles != null) {
                            this.nolargefiles.setValue(!bl);
                            return;
                        }
                    } else if (string.equals(NOLARGEFILES)) {
                        if (this.nolargefiles == null) {
                            this.nolargefiles = this.createOption(NOLARGEFILES, this.nolargefiles, bl);
                        } else {
                            this.nolargefiles.setValue(bl);
                        }
                        if (this.largefiles != null) {
                            this.largefiles.setValue(!bl);
                            return;
                        }
                    } else {
                        if (string.equals(NOATIME)) {
                            if (this.noatime == null) {
                                this.noatime = this.createOption(NOATIME, this.noatime, bl);
                                return;
                            }
                            this.noatime.setValue(bl);
                            return;
                        }
                        if (string.equals(FORCEDIRECTIO)) {
                            if (this.forcedirectio == null) {
                                this.forcedirectio = this.createOption(FORCEDIRECTIO, this.forcedirectio, bl);
                            } else {
                                this.forcedirectio.setValue(bl);
                            }
                            if (this.noforcedirectio != null) {
                                this.noforcedirectio.setValue(!bl);
                                return;
                            }
                        } else if (string.equals(NOFORCEDIRECTIO)) {
                            if (this.noforcedirectio == null) {
                                this.noforcedirectio = this.createOption(NOFORCEDIRECTIO, this.noforcedirectio, bl);
                            } else {
                                this.noforcedirectio.setValue(bl);
                            }
                            if (this.forcedirectio != null) {
                                this.forcedirectio.setValue(!bl);
                                return;
                            }
                        } else if (string.equals(LOGGING)) {
                            if (this.logging == null) {
                                this.logging = this.createOption(LOGGING, this.logging, bl);
                            } else {
                                this.logging.setValue(bl);
                            }
                            if (this.nologging != null) {
                                this.nologging.setValue(!bl);
                                return;
                            }
                        } else if (string.equals(NOLOGGING)) {
                            if (this.nologging == null) {
                                this.nologging = this.createOption(NOLOGGING, this.nologging, bl);
                            } else {
                                this.nologging.setValue(bl);
                            }
                            if (this.logging != null) {
                                this.logging.setValue(!bl);
                                return;
                            }
                        } else {
                            if (string.equals(RQ)) {
                                if (this.rq == null) {
                                    this.rq = this.createOption(RQ, this.rq, bl);
                                    return;
                                }
                                this.rq.setValue(bl);
                                return;
                            }
                            if (string.equals(NRR)) {
                                if (this.nrr == null) {
                                    this.nrr = this.createOption(NRR, this.nrr, bl);
                                    return;
                                }
                                this.nrr.setValue(bl);
                                return;
                            }
                            if (string.equals(NOTRAILDOT)) {
                                if (this.notraildot == null) {
                                    this.notraildot = this.createOption(NOTRAILDOT, this.notraildot, bl);
                                    return;
                                }
                                this.notraildot.setValue(bl);
                                return;
                            }
                            if (string.equals(NOMAPLCASE)) {
                                if (this.nomaplcase == null) {
                                    this.nomaplcase = this.createOption(NOMAPLCASE, this.nomaplcase, bl);
                                    return;
                                }
                                this.nomaplcase.setValue(bl);
                                return;
                            }
                            AdminCommonTools.CMN_HandleOutput("Unsupported option = " + string);
                            throw new FsMgrMountDataException("EXM_MNTOPT", string);
                        }
                    }
                }
            }
        }
    }

    public Object getOption(String string) {
        Cloneable cloneable = null;
        if (string == ACDIRMAX) {
            cloneable = this.acdirmax;
        } else if (string == ACDIRMIN) {
            cloneable = this.acdirmin;
        } else if (string == ACREGMAX) {
            cloneable = this.acregmax;
        } else if (string == ACREGMIN) {
            cloneable = this.acregmin;
        } else if (string == ACTIMEO) {
            cloneable = this.actimeo;
        } else if (string == BG) {
            cloneable = this.bg;
        } else if (string == FG) {
            cloneable = this.fg;
        } else if (string == GRPID) {
            cloneable = this.grpid;
        } else if (string == HARD) {
            cloneable = this.hard;
        } else if (string == SOFT) {
            cloneable = this.soft;
        } else if (string == INTR) {
            cloneable = this.intr;
        } else if (string == NOINTR) {
            cloneable = this.nointr;
        } else if (string == KERBEROS) {
            cloneable = this.kerberos;
        } else if (string == NOAC) {
            cloneable = this.noac;
        } else if (string == PORT) {
            cloneable = this.port;
        } else if (string == POSIX) {
            cloneable = this.posix;
        } else if (string == PROTO) {
            cloneable = this.proto;
        } else if (string == PUBLIC) {
            cloneable = this.webnfs;
        } else if (string == QUOTA) {
            cloneable = this.quota;
        } else if (string == NOQUOTA) {
            cloneable = this.noquota;
        } else if (string == RETRANS) {
            cloneable = this.retrans;
        } else if (string == RETRY) {
            cloneable = this.retry;
        } else if (string == RO) {
            cloneable = this.ro;
        } else if (string == RW) {
            cloneable = this.rw;
        } else if (string == RSIZE) {
            cloneable = this.rsize;
        } else if (string == SEC) {
            cloneable = this.sec;
        } else if (string == SECURE) {
            cloneable = this.secure;
        } else if (string == SUID) {
            cloneable = this.suid;
        } else if (string == NOSUID) {
            cloneable = this.nosuid;
        } else if (string == TIMEO) {
            cloneable = this.timeo;
        } else if (string == VERS) {
            cloneable = this.vers;
        } else if (string == WSIZE) {
            cloneable = this.wsize;
        } else if (string == LARGEFILES) {
            cloneable = this.largefiles;
        } else if (string == NOLARGEFILES) {
            cloneable = this.nolargefiles;
        } else if (string == NOATIME) {
            cloneable = this.noatime;
        } else if (string == FORCEDIRECTIO) {
            cloneable = this.forcedirectio;
        } else if (string == NOFORCEDIRECTIO) {
            cloneable = this.noforcedirectio;
        } else if (string == LOGGING) {
            cloneable = this.logging;
        } else if (string == NOLOGGING) {
            cloneable = this.nologging;
        } else if (string == RQ) {
            cloneable = this.rq;
        } else if (string == ONERROR) {
            cloneable = this.onerror;
        } else if (string == TOOSOON) {
            cloneable = this.toosoon;
        } else if (string == NRR) {
            cloneable = this.nrr;
        } else if (string == NOTRAILDOT) {
            cloneable = this.notraildot;
        } else if (string == NOMAPLCASE) {
            cloneable = this.nomaplcase;
        } else {
            AdminCommonTools.CMN_HandleOutput("Unsupported option = " + string);
        }
        return cloneable;
    }

    private void verify() throws FsMgrMountDataException {
    }

    public void removeOption(String string) {
        if (string == ACDIRMAX) {
            this.acdirmax = null;
            return;
        }
        if (string == ACDIRMIN) {
            this.acdirmin = null;
            return;
        }
        if (string == ACREGMAX) {
            this.acregmax = null;
            return;
        }
        if (string == ACREGMIN) {
            this.acregmin = null;
            return;
        }
        if (string == ACTIMEO) {
            this.actimeo = null;
            return;
        }
        if (string == BG) {
            this.bg = null;
            return;
        }
        if (string == FG) {
            this.fg = null;
            return;
        }
        if (string == GRPID) {
            this.grpid = null;
            return;
        }
        if (string == HARD) {
            this.hard = null;
            return;
        }
        if (string == SOFT) {
            this.soft = null;
            return;
        }
        if (string == INTR) {
            this.intr = null;
            return;
        }
        if (string == NOINTR) {
            this.nointr = null;
            return;
        }
        if (string == KERBEROS) {
            this.kerberos = null;
            return;
        }
        if (string == NOAC) {
            this.noac = null;
            return;
        }
        if (string == PORT) {
            this.port = null;
            return;
        }
        if (string == POSIX) {
            this.posix = null;
            return;
        }
        if (string == PROTO) {
            this.proto = null;
            return;
        }
        if (string == PUBLIC) {
            this.webnfs = null;
            return;
        }
        if (string == QUOTA) {
            this.quota = null;
            return;
        }
        if (string == NOQUOTA) {
            this.noquota = null;
            return;
        }
        if (string == RETRANS) {
            this.retrans = null;
            return;
        }
        if (string == RETRY) {
            this.retry = null;
            return;
        }
        if (string == RO) {
            this.ro = null;
            return;
        }
        if (string == RW) {
            this.rw = null;
            return;
        }
        if (string == RSIZE) {
            this.rsize = null;
            return;
        }
        if (string == SEC) {
            this.sec = null;
            return;
        }
        if (string == SECURE) {
            this.secure = null;
            return;
        }
        if (string == SUID) {
            this.suid = null;
            return;
        }
        if (string == NOSUID) {
            this.nosuid = null;
            return;
        }
        if (string == TIMEO) {
            this.timeo = null;
            return;
        }
        if (string == VERS) {
            this.vers = null;
            return;
        }
        if (string == WSIZE) {
            this.wsize = null;
            return;
        }
        if (string == LARGEFILES) {
            this.largefiles = null;
            return;
        }
        if (string == NOLARGEFILES) {
            this.nolargefiles = null;
            return;
        }
        if (string == NOATIME) {
            this.noatime = null;
            return;
        }
        if (string == FORCEDIRECTIO) {
            this.forcedirectio = null;
            return;
        }
        if (string == NOFORCEDIRECTIO) {
            this.noforcedirectio = null;
            return;
        }
        if (string == LOGGING) {
            this.logging = null;
            return;
        }
        if (string == NOLOGGING) {
            this.nologging = null;
            return;
        }
        if (string == RQ) {
            this.rq = null;
            return;
        }
        if (string == ONERROR) {
            this.onerror = null;
            return;
        }
        if (string == TOOSOON) {
            this.toosoon = null;
            return;
        }
        if (string == NRR) {
            this.nrr = null;
            return;
        }
        if (string == NOTRAILDOT) {
            this.notraildot = null;
            return;
        }
        if (string == NOMAPLCASE) {
            this.nomaplcase = null;
        }
    }

    public boolean isRw() {
        boolean bl = false;
        if (this.rw != null && this.rw.getValue() || this.fsType.equals(UFS) && this.rq != null && this.rq.getValue() || this.ro == null || !this.ro.getValue()) {
            bl = true;
        }
        return bl;
    }

    public boolean isRo() {
        boolean bl = false;
        if (this.ro != null && this.ro.getValue()) {
            bl = true;
        }
        return bl;
    }

    public FsMgrMount toFsMgrMount() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.acdirmax != null) {
            stringBuffer.append(this.acdirmax.toString());
            stringBuffer.append(COMMA);
        }
        if (this.acdirmin != null) {
            stringBuffer.append(this.acdirmin.toString());
            stringBuffer.append(COMMA);
        }
        if (this.acregmax != null) {
            stringBuffer.append(this.acregmax.toString());
            stringBuffer.append(COMMA);
        }
        if (this.acregmin != null) {
            stringBuffer.append(this.acregmin.toString());
            stringBuffer.append(COMMA);
        }
        if (this.actimeo != null) {
            stringBuffer.append(this.actimeo.toString());
            stringBuffer.append(COMMA);
        }
        if (this.bg != null && this.bg.getValue()) {
            stringBuffer.append(this.bg.toString());
            stringBuffer.append(COMMA);
        }
        if (this.fg != null && this.fg.getValue()) {
            stringBuffer.append(this.fg.toString());
            stringBuffer.append(COMMA);
        }
        if (this.grpid != null && this.grpid.getValue()) {
            stringBuffer.append(this.grpid.toString());
            stringBuffer.append(COMMA);
        }
        if (this.hard != null && this.hard.getValue()) {
            stringBuffer.append(this.hard.toString());
            stringBuffer.append(COMMA);
        }
        if (this.soft != null && this.soft.getValue()) {
            stringBuffer.append(this.soft.toString());
            stringBuffer.append(COMMA);
        }
        if (this.intr != null && this.intr.getValue()) {
            stringBuffer.append(this.intr.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nointr != null && this.nointr.getValue()) {
            stringBuffer.append(this.nointr.toString());
            stringBuffer.append(COMMA);
        }
        if (this.kerberos != null && this.kerberos.getValue()) {
            stringBuffer.append(this.kerberos.toString());
            stringBuffer.append(COMMA);
        }
        if (this.noac != null && this.noac.getValue()) {
            stringBuffer.append(this.noac.toString());
            stringBuffer.append(COMMA);
        }
        if (this.port != null) {
            stringBuffer.append(this.port.toString());
            stringBuffer.append(COMMA);
        }
        if (this.posix != null && this.posix.getValue()) {
            stringBuffer.append(this.posix.toString());
            stringBuffer.append(COMMA);
        }
        if (this.proto != null) {
            stringBuffer.append(this.proto.toString());
            stringBuffer.append(COMMA);
        }
        if (this.webnfs != null && this.webnfs.getValue()) {
            stringBuffer.append(this.webnfs.toString());
            stringBuffer.append(COMMA);
        }
        if (this.quota != null && this.quota.getValue()) {
            stringBuffer.append(this.quota.toString());
            stringBuffer.append(COMMA);
        }
        if (this.noquota != null && this.noquota.getValue()) {
            stringBuffer.append(this.noquota.toString());
            stringBuffer.append(COMMA);
        }
        if (this.retrans != null) {
            stringBuffer.append(this.retrans.toString());
            stringBuffer.append(COMMA);
        }
        if (this.retry != null) {
            stringBuffer.append(this.retry.toString());
            stringBuffer.append(COMMA);
        }
        if (this.ro != null && this.ro.getValue()) {
            stringBuffer.append(this.ro.toString());
            stringBuffer.append(COMMA);
        }
        if (this.rw != null && this.rw.getValue()) {
            stringBuffer.append(this.rw.toString());
            stringBuffer.append(COMMA);
        }
        if (this.rsize != null) {
            stringBuffer.append(this.rsize.toString());
            stringBuffer.append(COMMA);
        }
        if (this.sec != null) {
            stringBuffer.append(this.sec.toString());
            stringBuffer.append(COMMA);
        }
        if (this.secure != null && this.secure.getValue()) {
            stringBuffer.append(this.secure.toString());
            stringBuffer.append(COMMA);
        }
        if (this.suid != null && this.suid.getValue()) {
            stringBuffer.append(this.suid.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nosuid != null && this.nosuid.getValue()) {
            stringBuffer.append(this.nosuid.toString());
            stringBuffer.append(COMMA);
        }
        if (this.timeo != null) {
            stringBuffer.append(this.timeo.toString());
            stringBuffer.append(COMMA);
        }
        if (this.vers != null) {
            stringBuffer.append(this.vers.toString());
            stringBuffer.append(COMMA);
        }
        if (this.wsize != null) {
            stringBuffer.append(this.wsize.toString());
            stringBuffer.append(COMMA);
        }
        if (this.largefiles != null && this.largefiles.getValue()) {
            stringBuffer.append(this.largefiles.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nolargefiles != null && this.nolargefiles.getValue()) {
            stringBuffer.append(this.nolargefiles.toString());
            stringBuffer.append(COMMA);
        }
        if (this.noatime != null && this.noatime.getValue()) {
            stringBuffer.append(this.noatime.toString());
            stringBuffer.append(COMMA);
        }
        if (this.forcedirectio != null && this.forcedirectio.getValue()) {
            stringBuffer.append(this.forcedirectio.toString());
            stringBuffer.append(COMMA);
        }
        if (this.noforcedirectio != null && this.noforcedirectio.getValue()) {
            stringBuffer.append(this.noforcedirectio.toString());
            stringBuffer.append(COMMA);
        }
        if (this.logging != null && this.logging.getValue()) {
            stringBuffer.append(this.logging.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nologging != null && this.nologging.getValue()) {
            stringBuffer.append(this.nologging.toString());
            stringBuffer.append(COMMA);
        }
        if (this.rq != null && this.rq.getValue()) {
            stringBuffer.append(this.rq.toString());
            stringBuffer.append(COMMA);
        }
        if (this.onerror != null) {
            stringBuffer.append(this.onerror.toString());
            stringBuffer.append(COMMA);
        }
        if (this.toosoon != null) {
            stringBuffer.append(this.toosoon.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nrr != null && this.nrr.getValue()) {
            stringBuffer.append(this.nrr.toString());
            stringBuffer.append(COMMA);
        }
        if (this.notraildot != null && this.notraildot.getValue()) {
            stringBuffer.append(this.notraildot.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nomaplcase != null && this.nomaplcase.getValue()) {
            stringBuffer.append(this.nomaplcase.toString());
            stringBuffer.append(COMMA);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        FsMgrMount fsMgrMount = new FsMgrMount(this.resource, this.fsckDevice, this.mountPoint, this.fsType, this.fsckPass, this.bootMount, stringBuffer.toString());
        fsMgrMount.setRawString(this.rawString);
        return fsMgrMount;
    }

    public void convertAccess() throws FsMgrMountDataException {
        if (this.kerberos != null && this.kerberos.getValue()) {
            this.setOption(SEC, KRB4);
            this.kerberos = null;
        } else if (this.secure != null && this.secure.getValue()) {
            this.setOption(SEC, DH);
            this.secure = null;
        }
        if (this.rq != null && this.rq.getValue()) {
            this.setOption(QUOTA, true);
            this.quota = null;
            this.setOption(RW, true);
            this.rw = null;
        }
        if (this.actimeo != null) {
            this.setOption(ACDIRMAX, this.actimeo.getValue());
            this.setOption(ACDIRMIN, this.actimeo.getValue());
            this.setOption(ACREGMAX, this.actimeo.getValue());
            this.setOption(ACREGMIN, this.actimeo.getValue());
        }
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public String getFsckDevice() {
        return this.fsckDevice;
    }

    public void setFsckDevice(String string) {
        this.fsckDevice = string;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public void setMountPoint(String string) {
        this.mountPoint = string;
    }

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String string) {
        this.fsType = string;
    }

    public String getFsckPass() {
        return this.fsckPass;
    }

    public void setFsckPass(String string) {
        this.fsckPass = string;
    }

    public String getBootMount() {
        return this.bootMount;
    }

    public void setBootMount(String string) {
        this.bootMount = string;
    }

    public boolean isSpecial() {
        return this.mountPoint.equals(ROOT) || this.mountPoint.equals(USR) || this.mountPoint.equals(VAR) || this.fsType.equals(PROC) || this.fsType.equals(FD) || this.fsType.equals(TMPFS) || this.fsType.equals(SWAP);
    }
}

