/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.server;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.server.AdminFactory;
import com.sun.admin.cis.server.AdminServerImpl;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogServiceFactoryImpl;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.cis.service.security.VerifierSecurityToken;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public abstract class AdminFactoryImpl
extends UnicastRemoteObject
implements AdminFactory {
    private static final String[] rights = new String[0];
    private AdminServerImpl admsvr;
    private String appname;
    protected boolean single;
    private boolean down;

    protected String[] myAuthRights() {
        return rights;
    }

    public AdminFactoryImpl(AdminServerImpl adminServerImpl) throws RemoteException, AdminException {
        this.admsvr = adminServerImpl;
        this.appname = null;
        this.single = false;
        this.down = false;
    }

    public String getAppName() throws RemoteException {
        return this.localAppName();
    }

    public Vector getUserRights(SecurityToken securityToken) throws RemoteException, AdminException {
        return this.localUserRights(securityToken);
    }

    public boolean isSingleton() throws RemoteException {
        return this.localIsSingleton();
    }

    public void localCheckExecuteRight(VerifierSecurityToken verifierSecurityToken) throws AdminException {
    }

    public void localShutDown() throws AdminException {
        this.down = true;
    }

    public String localAppName() {
        String string = this.appname;
        if (string == null) {
            string = this.getClass().getName();
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            if ((n = string.lastIndexOf("Impl")) > 0) {
                string = string.substring(0, n);
            }
            if ((n = string.lastIndexOf("Factory")) > 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public Vector localUserRights(SecurityToken securityToken) throws AdminException {
        return this.admsvr.getUserRights(securityToken, this.localAuthRights());
    }

    public String[] localAuthRights() {
        return this.myAuthRights();
    }

    public boolean localIsSingleton() {
        return this.single;
    }

    protected void writeLog(SecurityToken securityToken, int n, String string, String string2, String[] stringArray) {
        LogServiceFactoryImpl logServiceFactoryImpl = null;
        LogRecord logRecord = null;
        Vector<String> vector = null;
        try {
            logServiceFactoryImpl = (LogServiceFactoryImpl)this.admsvr.getServiceImpl("com.sun.admin.cis.service.logging.LogServiceFactoryImpl");
        }
        catch (AdminException adminException) {
            logServiceFactoryImpl = null;
        }
        if (logServiceFactoryImpl != null) {
            if (stringArray != null && stringArray.length > 0) {
                vector = new Vector<String>(stringArray.length);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    vector.addElement(stringArray[n2]);
                    ++n2;
                }
            }
            try {
                logRecord = new LogRecord(this.localAppName(), 0, n, this.admsvr.getUserName(securityToken), this.admsvr.getClientHost(securityToken), this.admsvr.getHostName(), string, string2, vector, this.admsvr.getMgmtScope(securityToken));
                logServiceFactoryImpl.writeRecord(logRecord, false);
            }
            catch (Exception exception) {}
            logRecord = null;
        }
    }

    protected void writeLog(LogRecord logRecord) {
        LogServiceFactoryImpl logServiceFactoryImpl = null;
        try {
            logServiceFactoryImpl = (LogServiceFactoryImpl)this.admsvr.getServiceImpl("com.sun.admin.cis.service.logging.LogServiceFactoryImpl");
        }
        catch (AdminException adminException) {
            logServiceFactoryImpl = null;
        }
        if (logServiceFactoryImpl != null) {
            try {
                logServiceFactoryImpl.writeRecord(logRecord, false);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    protected LogRecord createLogRecord(SecurityToken securityToken, int n, String string, String string2, String[] stringArray) {
        LogRecord logRecord = null;
        Vector<String> vector = null;
        if (stringArray != null && stringArray.length > 0) {
            vector = new Vector<String>(stringArray.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
        }
        try {
            logRecord = new LogRecord(this.localAppName(), 0, n, this.admsvr.getUserName(securityToken), this.admsvr.getClientHost(securityToken), this.admsvr.getHostName(), string, string2, vector, this.admsvr.getMgmtScope(securityToken));
        }
        catch (Exception exception) {
            logRecord = null;
        }
        return logRecord;
    }

    protected boolean isShutdown() {
        return this.down;
    }

    protected AdminServerImpl getAdminServer() {
        return this.admsvr;
    }

    protected void setAppName(String string) {
        this.appname = string;
    }

    protected void setSingleton() {
        this.single = true;
    }
}

