/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.AdminClientException;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.LaunchBatchJobTimedOutException;
import java.io.IOException;
import java.io.InputStream;

public class LaunchBatchJob {
    public static final String LBJ_LAUNCHING = "LAUNCHING:";
    public static final String LBJ_RUNNING = "RUNNING:";
    public static final String LBJ_ERROR = "ERROR:";
    public static final String LBJ_TIMEOUT = "TIMEOUT:";
    public static final long LBJ_MAXTIME = 5000L;
    public static final int LBJ_SLEEPTIME = 1000;
    LBJThread launch_thread;
    String command;
    String result;

    public LaunchBatchJob(String string) {
        this.command = string;
        this.result = LBJ_LAUNCHING;
    }

    public void launchProcess() throws AdminException {
        Object object;
        AdminCommonTools.CMN_Trace1("LaunchBatchJob: Launching command: " + this.command);
        this.launch_thread = new LBJThread(this.command, Thread.currentThread());
        this.launch_thread.start();
        boolean bl = false;
        long l = System.currentTimeMillis();
        while (!bl) {
            long l2;
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            object = this.result;
            synchronized (object) {
                if (!this.result.equals(LBJ_LAUNCHING)) {
                    bl = true;
                }
            }
            if (bl || (l2 = System.currentTimeMillis()) - l < 5000L) continue;
            this.launch_thread.interrupt();
            object = this.result;
            synchronized (object) {
                this.result = LBJ_TIMEOUT;
            }
            bl = true;
        }
        if (this.result.startsWith(LBJ_RUNNING)) {
            AdminCommonTools.CMN_Trace1("LaunchBatchJob: Job in running state...");
            return;
        }
        if (this.result.startsWith(LBJ_ERROR)) {
            object = AdminException.parseLogStr(this.result.substring(6));
            AdminCommonTools.CMN_Trace1("LaunchBatchJob: Job terminated with error:" + ((AdminException)object).getMessage());
            throw object;
        }
        if (this.result.startsWith(LBJ_TIMEOUT)) {
            AdminCommonTools.CMN_Trace1("LaunchBatchJob: Timeout waiting for job to reach running state");
            throw new LaunchBatchJobTimedOutException();
        }
        AdminCommonTools.CMN_Trace1("LaunchBatchJob: Unexpected result from batch job: " + this.result);
        throw new AdminClientException("EXM_LBJ2", this.result);
    }

    public class LBJThread
    extends Thread {
        private String cmd;
        private Thread parent;

        public LBJThread(String string, Thread thread) {
            LaunchBatchJob.this = LaunchBatchJob.this;
            this.cmd = string;
            this.parent = thread;
        }

        public void run() {
            Runtime runtime = Runtime.getRuntime();
            Process process = null;
            AdminClientException adminClientException = null;
            try {
                process = runtime.exec(LaunchBatchJob.this.command);
            }
            catch (IOException iOException) {
                AdminCommonTools.CMN_Trace1("LaunchMonitor: problem execing the batch command: " + iOException.getMessage());
                adminClientException = new AdminClientException("EXM_LBJ3");
                this.setError(adminClientException.formatForLogging());
                return;
            }
            Thread thread = Thread.currentThread();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            String string = "";
            StringBuffer stringBuffer = new StringBuffer("");
            boolean bl = true;
            InputStream inputStream = process.getInputStream();
            while (bl) {
                try {
                    while (inputStream.available() > 0) {
                        char c = (char)inputStream.read();
                        if (c == '\n') {
                            string = stringBuffer.toString();
                            AdminCommonTools.CMN_Trace3("LaunchMonitor: from batch job: " + string);
                            if (string.startsWith(LaunchBatchJob.LBJ_ERROR)) {
                                this.setResult(string);
                                bl = false;
                                break;
                            }
                            if (string.startsWith(LaunchBatchJob.LBJ_RUNNING)) {
                                this.setResult(LaunchBatchJob.LBJ_RUNNING);
                                bl = false;
                                break;
                            }
                            stringBuffer.setLength(0);
                            continue;
                        }
                        stringBuffer.append(c);
                    }
                    if (!bl) continue;
                    int n = process.exitValue();
                    if (n == 0) {
                        AdminCommonTools.CMN_Trace1("LaunchMonitor: batch job exited successfully");
                        this.setResult(LaunchBatchJob.LBJ_RUNNING);
                    } else {
                        AdminCommonTools.CMN_Trace1("LaunchMonitor: batch job exited with error status: " + n);
                        adminClientException = new AdminClientException("EXM_LBJ4", new Integer(n).toString());
                        this.setError(adminClientException.formatForLogging());
                    }
                    bl = false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception exception) {
                    AdminCommonTools.CMN_Trace1("LaunchMonitor: Unexpected error monitoring batch job: " + exception.getMessage());
                    adminClientException = new AdminClientException("EXM_LBJ5");
                    this.setError(adminClientException.formatForLogging());
                    bl = false;
                }
            }
        }

        private void setError(String string) {
            this.setResult(LaunchBatchJob.LBJ_ERROR + string);
        }

        private void setResult(String string) {
            String string2 = LaunchBatchJob.this.result;
            synchronized (string2) {
                LaunchBatchJob.this.result = string;
            }
            this.parent.interrupt();
        }
    }
}

