/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WholeNumField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DateWidget
extends JComponent {
    private JLabel dateLabel;
    private WholeNumField ddField;
    private WholeNumField mmField;
    private WholeNumField yyyyField;
    private JPanel datePanel;
    private String dateString = "";
    private int dd = -1;
    private int mm = -1;
    private int yyyy = -1;
    private JFrame parent;
    public static final int CURRENT_YEAR = 1999;

    public DateWidget(JFrame jFrame) {
        this(jFrame, -1, -1, -1);
    }

    public DateWidget(JFrame jFrame, String string) {
        this(jFrame, -1, -1, -1);
        this.setDateString(string);
    }

    public DateWidget(JFrame jFrame, int n, int n2, int n3) {
        this.parent = jFrame;
        this.dd = n;
        this.mm = n2;
        this.yyyy = n3;
        this.createGui();
    }

    private void createGui() {
        this.datePanel = new JPanel();
        this.datePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.dateLabel = new JLabel(ResourceStrings.getString("date_string"));
        this.dateLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.dateLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.ddField = new WholeNumField(-1, 2, 31);
        this.ddField.setMinimumSize(this.ddField.getPreferredSize());
        this.ddField.setHorizontalAlignment(4);
        this.mmField = new WholeNumField(-1, 2, 12);
        this.mmField.setMinimumSize(this.mmField.getPreferredSize());
        this.mmField.setHorizontalAlignment(4);
        this.yyyyField = new WholeNumField(-1, 4, 2037);
        this.yyyyField.setMinimumSize(this.yyyyField.getPreferredSize());
        this.yyyyField.setHorizontalAlignment(4);
        if (this.dd > -1) {
            this.ddField.setValue(this.dd);
        }
        if (this.mm > -1) {
            this.mmField.setValue(this.mm);
        }
        if (this.yyyy > -1) {
            this.yyyyField.setValue(this.yyyy);
        }
        Constraints.constrain(this.datePanel, this.mmField, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 0, 0);
        Constraints.constrain(this.datePanel, this.ddField, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this.datePanel, this.yyyyField, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this.datePanel, this.dateLabel, 3, 0, 1, 1, 0, 17, 1.0, 1.0, 0, 10, 0, 5);
        this.setLayout(new BorderLayout());
        this.add((Component)this.datePanel, "Center");
    }

    public void setEnabled(boolean bl) {
        this.dateLabel.setEnabled(bl);
        this.ddField.setEnabled(bl);
        this.ddField.setEditable(bl);
        this.mmField.setEnabled(bl);
        this.mmField.setEditable(bl);
        this.yyyyField.setEnabled(bl);
        this.yyyyField.setEditable(bl);
        this.datePanel.repaint();
    }

    public String getDateString() {
        int n = this.getDayInt();
        int n2 = this.getMonthInt();
        int n3 = this.getYearInt();
        if (n < 1 || n2 < 1 || n3 < 1) {
            this.dateString = "";
        } else {
            String string;
            String string2 = "0";
            String string3 = "0";
            String string4 = String.valueOf(n);
            if (string4.length() == 1) {
                string4 = string2.concat(string4);
            }
            if ((string = String.valueOf(n2)).length() == 1) {
                string = string3.concat(string);
            }
            String string5 = String.valueOf(n3);
            this.dateString = string4.concat(string.concat(string5));
        }
        return this.dateString;
    }

    public void setDateString(String string) {
        this.dateString = string;
        String string2 = string;
        if (string2.length() == 8) {
            String string3 = new String(string2);
            String string4 = new String(string2);
            String string5 = new String(string2);
            if ((string3 = string3.substring(0, 2)).startsWith("0")) {
                string3 = string3.substring(1, 2);
            }
            this.setDayInt(Integer.parseInt(string3));
            string4 = string4.substring(2, 4);
            if (string4.startsWith("0")) {
                string4 = string4.substring(1, 2);
            }
            this.setMonthInt(Integer.parseInt(string4));
            string5 = string5.substring(4, 8);
            this.setYearInt(Integer.parseInt(string5));
            return;
        }
        this.setDayInt(-1);
        this.setMonthInt(-1);
        this.setYearInt(-1);
    }

    public String getTraditionalDate() {
        String string = "";
        String string2 = this.getDateString();
        if (string2.length() > 0) {
            String string3 = string2.substring(0, 2);
            String string4 = string2.substring(2, 4);
            String string5 = string2.substring(4, 8);
            String string6 = "/";
            string = string4.concat(string6.concat(string3.concat(string6.concat(string5))));
        }
        return string;
    }

    public void setTraditionalDate(String string) {
        String string2 = "";
        String string3 = string;
        String string4 = string3.substring(0, 2);
        String string5 = string3.substring(3, 5);
        String string6 = string3.substring(6, 10);
        string2 = string5.concat(string4.concat(string6));
        this.setDateString(string2);
    }

    public int getDayInt() {
        this.dd = this.ddField.getValue();
        return this.dd;
    }

    public void setDayInt(int n) {
        this.dd = n;
        this.ddField.setValue(this.dd);
    }

    public int getMonthInt() {
        this.mm = this.mmField.getValue();
        return this.mm;
    }

    public void setMonthInt(int n) {
        this.mm = n;
        this.mmField.setValue(this.mm);
    }

    public int getYearInt() {
        this.yyyy = this.yyyyField.getValue();
        return this.yyyy;
    }

    public void setYearInt(int n) {
        this.yyyy = n;
        this.yyyyField.setValue(this.yyyy);
    }

    public boolean isValidDate() {
        String string = " ";
        int n = this.ddField.getValue();
        int n2 = this.mmField.getValue();
        int n3 = this.yyyyField.getValue();
        if (n == -1 && n2 == -1 && n3 == -1) {
            string = ResourceStrings.getString("er_date8");
            new ErrorDialog(this.parent, string);
            return false;
        }
        boolean bl = true;
        if (n == -1) {
            bl = false;
        } else if (n2 == -1) {
            bl = false;
        } else if (n3 == -1) {
            bl = false;
        }
        if (!bl) {
            string = ResourceStrings.getString("er_date8");
            new ErrorDialog(this.parent, string);
            return false;
        }
        if (n < 1) {
            string = ResourceStrings.getString("er_date1");
            new ErrorDialog(this.parent, string);
            return false;
        }
        if (n > 31) {
            string = ResourceStrings.getString("er_date1");
            new ErrorDialog(this.parent, string);
            return false;
        }
        if (n2 < 1) {
            string = ResourceStrings.getString("er_date2");
            new ErrorDialog(this.parent, string);
            return false;
        }
        if (n2 > 12) {
            string = ResourceStrings.getString("er_date2");
            new ErrorDialog(this.parent, string);
            return false;
        }
        if (n3 < 1999) {
            string = ResourceStrings.getString("er_year");
            new ErrorDialog(this.parent, string);
            return false;
        }
        if (n3 > 2037) {
            string = ResourceStrings.getString("er_date3");
            new ErrorDialog(this.parent, string);
            return false;
        }
        switch (n2) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (n <= 30) break;
                string = ResourceStrings.getString("er_date5");
                new ErrorDialog(this.parent, string);
                return false;
            }
            case 2: {
                if (n3 % 4 == 0) {
                    if (n <= 29) break;
                    string = ResourceStrings.getString("er_date6");
                    new ErrorDialog(this.parent, string);
                    return false;
                }
                if (n <= 28) break;
                string = ResourceStrings.getString("er_date7");
                new ErrorDialog(this.parent, string);
                return false;
            }
        }
        return true;
    }
}

