/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.client;

import com.sun.admin.cis.client.AdminClientInfo;
import com.sun.admin.cis.client.AdminContext;
import com.sun.admin.cis.client.AdminFrame;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddScopeDialog
extends AdminDialog {
    AdminDialog addScopeDialog;
    GenInfoPanel infoPanel;
    IClientComm clientComm;
    JPanel blankPanel;
    JButton propOKBtn;
    JButton propCancelBtn;
    JPanel domainPanel;
    protected JRadioButton singleMachineRB;
    protected JRadioButton nameServiceRB;
    protected JRadioButton nisRB;
    protected JRadioButton nisPlusRB;
    protected JTextField machineNameTF;
    protected JTextField domainTF;
    protected JTextField serverTF;
    protected JButton addBtn;
    protected JButton deleteBtn;
    private JLabel typeLabel;
    private JLabel serverLabel;
    private JLabel domainNameLabel;
    private Vector vScopesList;
    AdminClientInfo clientInfo;
    JList scopeJList;
    DefaultListModel model = new DefaultListModel();

    public AddScopeDialog(JFrame jFrame) {
        super(jFrame, "User Properties", false);
        this.addScopeDialog = this;
        this.addScopeDialog.setTitle(ResourceStrings.getString("add_scope"));
        this.infoPanel = this.getInfoPanel();
        this.clientComm = (IClientComm)((Object)jFrame);
        this.clientInfo = AdminContext.instance().getAdminClientInfo();
        this.createScopeList();
        this.blankPanel = this.getRightPanel();
        this.blankPanel.setLayout(new BorderLayout());
        this.blankPanel.add("Center", this.createDomainPanel());
        this.propOKBtn = this.getOKBtn();
        this.propOKBtn.addActionListener(new OKCancelButtonListener());
        this.propCancelBtn = this.getCancelBtn();
        this.propCancelBtn.addActionListener(new OKCancelButtonListener());
        this.propCancelBtn.setEnabled(false);
        this.propCancelBtn.setVisible(false);
        this.pack();
        Dimension dimension = this.getSize();
        this.setMySize(dimension);
        this.setDefaultFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "scope_add_del.html"), true);
        this.scopeJList.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "scope_managed_scopes.html"));
        this.domainTF.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "scope_nis_domain.html"));
        this.machineNameTF.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "scope_machine.html"));
        this.singleMachineRB.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "scope_choose.html"));
        this.nameServiceRB.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "scope_choose.html"));
        this.serverTF.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "scope_nis_server.html"));
        this.nisRB.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "scope_nisp_server.html"));
        this.nisPlusRB.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "scope_nisp_server.html"));
        this.addKeyListener(new EscapeKeyListener());
    }

    private void createScopeList() {
        try {
            this.vScopesList = this.clientInfo.getMgmtScopeList();
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("Can't get scopes list");
        }
        int n = 0;
        while (n < this.vScopesList.size()) {
            AdminMgmtScope adminMgmtScope = (AdminMgmtScope)this.vScopesList.elementAt(n);
            String string = adminMgmtScope.toString();
            this.model.addElement(string);
            ++n;
        }
    }

    private JPanel createDomainPanel() {
        this.domainPanel = new JPanel();
        this.domainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ResourceStrings.getString("dom_def"));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridBagLayout());
        Constraints.constrain(this.domainPanel, jPanel, 0, 0, 1, 1, 1, 10, 1.0, 0.4, 20, 16, 0, 16);
        int n = 0;
        this.singleMachineRB = new JRadioButton(ResourceStrings.getString("singleMachineRB"), true);
        this.singleMachineRB.addActionListener(new RBListener());
        Constraints.constrain(jPanel, this.singleMachineRB, 0, n, 1, 1, 0, 17, 0.0, 0.0, 5, 8, 0, 0);
        this.machineNameTF = new JTextField(13);
        this.machineNameTF.setMinimumSize(this.machineNameTF.getPreferredSize());
        this.machineNameTF.addKeyListener(new TFKeyAdapter());
        Constraints.constrain(jPanel, this.machineNameTF, 1, n, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
        this.nameServiceRB = new JRadioButton(ResourceStrings.getString("type_service"), false);
        this.nameServiceRB.addActionListener(new RBListener());
        Constraints.constrain(jPanel, this.nameServiceRB, 0, ++n, 1, 1, 0, 17, 0.0, 0.0, 5, 8, 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.singleMachineRB);
        buttonGroup.add(this.nameServiceRB);
        this.domainNameLabel = new JLabel(ResourceStrings.getString("domainName"));
        this.domainNameLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.domainNameLabel.setFont(Constants.PROPS_LABEL_FONT);
        Constraints.constrain(jPanel, this.domainNameLabel, 0, ++n, 1, 1, 0, 17, 0.0, 0.0, 5, 24, 0, 0);
        this.domainTF = new JTextField(13);
        this.domainTF.setMinimumSize(this.domainTF.getPreferredSize());
        this.domainTF.addKeyListener(new TFKeyAdapter());
        Constraints.constrain(jPanel, this.domainTF, 1, n, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
        this.serverLabel = new JLabel(ResourceStrings.getString("machineName"));
        this.serverLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.serverLabel.setFont(Constants.PROPS_LABEL_FONT);
        Constraints.constrain(jPanel, this.serverLabel, 0, ++n, 1, 1, 0, 17, 0.0, 0.0, 5, 24, 0, 0);
        this.serverTF = new JTextField(13);
        this.serverTF.setMinimumSize(this.serverTF.getPreferredSize());
        this.serverTF.addKeyListener(new TFKeyAdapter());
        Constraints.constrain(jPanel, this.serverTF, 1, n, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
        this.typeLabel = new JLabel(ResourceStrings.getString("type"));
        this.typeLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.typeLabel.setFont(Constants.PROPS_LABEL_FONT);
        Constraints.constrain(jPanel, this.typeLabel, 0, ++n, 1, 1, 0, 17, 0.0, 0.0, 5, 24, 0, 0);
        this.nisRB = new JRadioButton(ResourceStrings.getString("nisDomainRB"), true);
        Constraints.constrain(jPanel, this.nisRB, 1, n, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
        this.nisPlusRB = new JRadioButton(ResourceStrings.getString("nisPlusDomainRB"), false);
        Constraints.constrain(jPanel, this.nisPlusRB, 1, ++n, 1, 1, 0, 18, 0.0, 0.2, 0, 5, 5, 5);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.nisRB);
        buttonGroup2.add(this.nisPlusRB);
        this.addBtn = new JButton(ResourceStrings.getString("add"));
        this.addBtn.setEnabled(false);
        this.addBtn.addActionListener(new AddDelListener());
        Constraints.constrain(this.domainPanel, this.addBtn, 1, 0, 1, 1, 2, 16, 0.0, 0.0, 0, 4, 0, 5);
        JLabel jLabel = new JLabel(ResourceStrings.getString("scopesManaged"));
        Constraints.constrain(this.domainPanel, jLabel, 0, 1, 1, 1, 0, 16, 0.0, 0.0, 13, 24, 0, 0);
        this.scopeJList = new JList(this.model);
        this.scopeJList.addListSelectionListener(new ListListener());
        this.scopeJList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.scopeJList);
        Constraints.constrain(this.domainPanel, jScrollPane, 0, 2, 1, 1, 1, 16, 0.0, 0.5, 5, 16, 10, 16);
        this.deleteBtn = new JButton(ResourceStrings.getString("delete"));
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addActionListener(new AddDelListener());
        Constraints.constrain(this.domainPanel, this.deleteBtn, 1, 2, 1, 1, 0, 18, 0.0, 0.0, 5, 4, 0, 5);
        if (this.singleMachineRB.isSelected()) {
            this.enableNSFields(false);
        }
        return this.domainPanel;
    }

    private void enableNSFields(boolean bl) {
        this.serverLabel.setEnabled(bl);
        this.serverTF.setEnabled(bl);
        this.serverTF.setEditable(bl);
        this.domainNameLabel.setEnabled(bl);
        this.domainTF.setEnabled(bl);
        this.domainTF.setEditable(bl);
        this.typeLabel.setEnabled(bl);
        this.nisRB.setEnabled(bl);
        this.nisPlusRB.setEnabled(bl);
        this.machineNameTF.setEnabled(!bl);
        this.machineNameTF.setEditable(!bl);
        if (bl) {
            this.machineNameTF.setText("");
            return;
        }
        this.nisRB.setSelected(true);
        this.domainTF.setText("");
        this.serverTF.setText("");
    }

    class RBListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AddScopeDialog.this.singleMachineRB) {
                AddScopeDialog.this.enableNSFields(false);
                return;
            }
            if (actionEvent.getSource() == AddScopeDialog.this.nameServiceRB) {
                AddScopeDialog.this.enableNSFields(true);
            }
        }

        RBListener() {
            AddScopeDialog.this = AddScopeDialog.this;
        }
    }

    class OKCancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == AddScopeDialog.this.propOKBtn) {
                    AddScopeDialog.this.addScopeDialog.dispose();
                    return;
                }
                AddScopeDialog.this.addScopeDialog.dispose();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        OKCancelButtonListener() {
            AddScopeDialog.this = AddScopeDialog.this;
        }
    }

    class AddDelListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AddScopeDialog.this.addBtn) {
                if (AddScopeDialog.this.singleMachineRB.isSelected()) {
                    try {
                        AdminMgmtScope adminMgmtScope = new AdminMgmtScope("file", null, AddScopeDialog.this.machineNameTF.getText(), null);
                        AddScopeDialog.this.clientInfo.addMgmtScope(adminMgmtScope);
                        AddScopeDialog.this.vScopesList.addElement(adminMgmtScope);
                        AddScopeDialog.this.model.addElement(adminMgmtScope.toString());
                        AddScopeDialog.this.machineNameTF.setText("");
                    }
                    catch (AdminException adminException) {
                        new ErrorDialog(AdminFrame.instance(), adminException.getLocalizedMessage());
                    }
                } else if (AddScopeDialog.this.nameServiceRB.isSelected() && AddScopeDialog.this.nisRB.isSelected()) {
                    try {
                        AdminMgmtScope adminMgmtScope = new AdminMgmtScope("nis", null, AddScopeDialog.this.serverTF.getText(), AddScopeDialog.this.domainTF.getText());
                        AddScopeDialog.this.clientInfo.addMgmtScope(adminMgmtScope);
                        AddScopeDialog.this.vScopesList.addElement(adminMgmtScope);
                        AddScopeDialog.this.model.addElement(adminMgmtScope.toString());
                        AddScopeDialog.this.serverTF.setText("");
                        AddScopeDialog.this.domainTF.setText("");
                    }
                    catch (AdminException adminException) {
                        new ErrorDialog(AdminFrame.instance(), adminException.getLocalizedMessage());
                    }
                } else if (AddScopeDialog.this.nameServiceRB.isSelected() && AddScopeDialog.this.nisPlusRB.isSelected()) {
                    try {
                        AdminMgmtScope adminMgmtScope = new AdminMgmtScope("nisplus", null, AddScopeDialog.this.serverTF.getText(), AddScopeDialog.this.domainTF.getText());
                        AddScopeDialog.this.clientInfo.addMgmtScope(adminMgmtScope);
                        AddScopeDialog.this.vScopesList.addElement(adminMgmtScope);
                        AddScopeDialog.this.model.addElement(adminMgmtScope.toString());
                        AddScopeDialog.this.serverTF.setText("");
                        AddScopeDialog.this.domainTF.setText("");
                    }
                    catch (AdminException adminException) {
                        new ErrorDialog(AdminFrame.instance(), adminException.getLocalizedMessage());
                    }
                }
                AddScopeDialog.this.addBtn.setEnabled(false);
                return;
            }
            if (actionEvent.getSource() == AddScopeDialog.this.deleteBtn) {
                int n = AddScopeDialog.this.scopeJList.getSelectedIndex();
                AdminMgmtScope adminMgmtScope = (AdminMgmtScope)AddScopeDialog.this.vScopesList.elementAt(n);
                String string = adminMgmtScope.getMgmtScopeName();
                AdminCommonTools.CMN_HandleOutput("The scope name =" + string);
                AdminCommonTools.CMN_HandleOutput("Scope Index =" + n);
                try {
                    AddScopeDialog.this.clientInfo.removeMgmtScope(string);
                    AddScopeDialog.this.model.removeElementAt(n);
                }
                catch (AdminException adminException) {
                    AdminCommonTools.CMN_HandleOutput("Can't deletescopes list");
                }
                AddScopeDialog.this.deleteBtn.setEnabled(false);
            }
        }

        AddDelListener() {
            AddScopeDialog.this = AddScopeDialog.this;
        }
    }

    class EscapeKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                AddScopeDialog.this.propOKBtn.doClick();
            }
        }

        EscapeKeyListener() {
            AddScopeDialog.this = AddScopeDialog.this;
        }
    }

    class ListListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (AddScopeDialog.this.model.size() > 1) {
                AddScopeDialog.this.deleteBtn.setEnabled(true);
                return;
            }
            AddScopeDialog.this.deleteBtn.setEnabled(false);
        }

        ListListener() {
            AddScopeDialog.this = AddScopeDialog.this;
        }
    }

    class TFKeyAdapter
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            AddScopeDialog.this.addBtn.setEnabled(true);
        }

        TFKeyAdapter() {
            AddScopeDialog.this = AddScopeDialog.this;
        }
    }
}

