/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.AdminProps;
import com.sun.admin.cis.server.AdminServerImpl;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryTableConnectionException;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.DirectoryTableInvalidParameterException;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import com.sun.admin.cis.service.security.AdminSecurityUtil;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.cis.service.security.ServerSecurityContext;
import com.sun.admin.usermgr.common.SolAccountAttr;
import com.sun.admin.usermgr.common.SolPasswordAttr;
import com.sun.admin.usermgr.common.SolServerDirTableException;
import com.sun.admin.usermgr.common.SolServerException;
import com.sun.admin.usermgr.common.UserObj;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SolarisShadowTable {
    private static String tableName = "shadow";
    private String emptyString = new String("");
    private String fileType = new String("File");
    private long secondsInaDay = 86400L;
    private String GMT_TIMEZONE = "GMT";
    private String nullPassword = "";
    private String accountLockedValue = "*LK*";
    private String nameCol = "name";
    private String passwdCol = "passwd";
    private String lastchngCol = "lastchg";
    private String minCol = "min";
    private String maxCol = "max";
    private String warnCol = "warn";
    private String inactiveCol = "inactive";
    private String exCol = "expire";
    private String flagCol = "flag";
    private AdminMgmtScope scope;

    public SolarisShadowTable(AdminMgmtScope adminMgmtScope) throws SolServerException {
        this.scope = adminMgmtScope;
    }

    private String setUpExpirationDate(String string) {
        Date date;
        String string2 = "";
        if (string == null || string.equals("")) {
            return string2;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SolAccountAttr.DATE_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        simpleDateFormat.setLenient(false);
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            return string2;
        }
        long l = date.getTime();
        l /= 1000L;
        string2 = String.valueOf(l /= this.secondsInaDay);
        return string2;
    }

    private String getExpirationDate(String string) {
        long l = Long.parseLong(string);
        long l2 = l * this.secondsInaDay + 1L;
        Date date = new Date(l2 *= 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SolAccountAttr.DATE_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        simpleDateFormat.setLenient(false);
        String string2 = simpleDateFormat.format(date);
        return string2;
    }

    private boolean isCredProcessingNecessary() {
        String string = "on";
        try {
            AdminProps adminProps = new AdminProps("admin.server.properties", "AdminServer.properties", 0);
            string = adminProps.getAdminProp("admin.server.usermgr.manage.cred.table");
            if (string == null || string.trim().trim().length() == 0) {
                return true;
            }
            return string.equals("on");
        }
        catch (Exception exception) {
            return true;
        }
    }

    private void modifyCredUserName(String string, String string2) throws AdminException {
        String string3;
        String string4 = this.scope.getMgmtScopeType();
        if (!string4.equals("nisplus")) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            return;
        }
        String string5 = this.scope.getMgmtDomainName();
        String string6 = new String(String.valueOf(string2) + "." + string5);
        if (!string6.endsWith(".")) {
            string6 = string6.concat(".");
        }
        if (!(string3 = new String(String.valueOf(string) + "." + string5)).endsWith(".")) {
            string3 = string3.concat(".");
        }
        String string7 = new String("/usr/bin/nistbladm -E cname=" + string3 + " [cname=" + string6 + ",auth_type=LOCAL],cred.org_dir");
        try {
            AdminCommonTools.CMN_exec(string7, true);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("nistbladm to change principal name in cred table failed");
        }
        string7 = new String("/usr/bin/nistbladm -E cname=" + string3 + " [cname=" + string6 + ",auth_type=DES],cred.org_dir");
        try {
            AdminCommonTools.CMN_exec(string7, true);
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("nistbladm to change principal name in cred table failed");
            return;
        }
    }

    private void removeCredTableEntry(UserObj userObj) throws AdminException {
        String string = this.scope.getMgmtScopeType();
        if (!string.equals("nisplus")) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            return;
        }
        String string2 = this.scope.getMgmtDomainName();
        String string3 = userObj.getUserName();
        if (string3 == null || string3.trim().length() == 0) {
            return;
        }
        String string4 = new String(String.valueOf(string3) + "." + string2);
        if (!string4.endsWith(".")) {
            string4 = string4.concat(".");
        }
        String string5 = new String("nisaddcred -r " + string4);
        try {
            Runtime runtime = Runtime.getRuntime();
            runtime.exec(string5);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void setupCredTableEntry(UserObj userObj, String string) throws AdminException {
        Object object;
        String string2 = this.scope.getMgmtScopeType();
        if (!string2.equals("nisplus")) {
            return;
        }
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            string = "";
            return;
        }
        String string3 = this.scope.getMgmtDomainName();
        String string4 = userObj.getUserID();
        if (string4 == null || string4.trim().length() == 0) {
            return;
        }
        String string5 = userObj.getUserName();
        if (string5 == null || string5.trim().length() == 0) {
            return;
        }
        String string6 = new String(String.valueOf(string5) + "." + string3);
        if (!string6.endsWith(".")) {
            string6 = string6.concat(".");
        }
        String string7 = new String("nisaddcred -p " + string4 + " -P " + string6 + " local");
        try {
            object = Runtime.getRuntime();
            ((Runtime)object).exec(string7);
        }
        catch (Exception exception) {}
        object = new String("unix." + string4 + "@" + string3);
        string7 = new String("nisaddcred -p " + (String)object + " -P " + string6 + " -l " + string + " des");
        string = "";
        try {
            try {
                Runtime runtime = Runtime.getRuntime();
                runtime.exec(string7);
            }
            catch (Exception exception) {
            }
            Object var11_11 = null;
            string7 = "";
            return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            string7 = "";
            throw throwable;
        }
    }

    private DirectoryTable openShadowTable() throws SolServerDirTableException, DirectoryTableException {
        try {
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
            directoryTable.open(tableName);
            return directoryTable;
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw new SolServerDirTableException("LM_2170");
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw new SolServerDirTableException("LM_2171");
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw new SolServerDirTableException("LM_2174");
        }
    }

    public void deleteShadowRow(UserObj userObj) throws SolServerException, AdminException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openShadowTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), userObj.getUserName());
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow == null) {
                    this.removeCredTableEntry(userObj);
                    Object var4_10 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return;
                }
                this.removeCredTableEntry(userObj);
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2170");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2174");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var4_12 = null;
                if (directoryTable == null) break block13;
                directoryTable.close();
            }
            throw throwable;
        }
        Object var4_11 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
    }

    public void addShadowRow(UserObj userObj, AdminServerImpl adminServerImpl, SecurityToken securityToken) throws SolServerException, AdminException {
        Object object;
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        String string = this.nullPassword;
        String string2 = this.nullPassword;
        try {
            object = adminServerImpl.getAuthenticatedContext(securityToken);
            byte[] byArray = solPasswordAttr.getPasswd();
            if (byArray != null) {
                string2 = ((ServerSecurityContext)object).decryptPassword(byArray);
                string = AdminSecurityUtil.createUnixPassword(string2);
            }
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_HandleOutput("Shadow Entry " + userObj.getUserName() + " could not decrypt password");
            throw adminException;
        }
        object = null;
        try {
            object = this.openShadowTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = object.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), userObj.getUserName());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), userObj.getUserName());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.passwdCol), string);
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.minCol), solPasswordAttr.getMustChangeDays());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.maxCol), solPasswordAttr.getCannotChangeDays());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.warnCol), solPasswordAttr.getAlertChangeDays());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.inactiveCol), solPasswordAttr.getInactiveDays());
                SolAccountAttr solAccountAttr = userObj.getSolAccountAttr();
                String string3 = "";
                if (solAccountAttr != null) {
                    string3 = this.setUpExpirationDate(solAccountAttr.getAccountExpires());
                }
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.exCol), string3);
                object.addRow(directoryRow);
                this.setupCredTableEntry(userObj, string2);
                string2 = "";
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2170");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2174");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
            Object var9_20 = null;
            if (object != null) {
                object.close();
            }
            return;
        }
        catch (Throwable throwable) {
            block18: {
                Object var9_21 = null;
                if (object == null) break block18;
                object.close();
            }
            throw throwable;
        }
    }

    public UserObj getShadowRow(UserObj userObj) throws SolServerException, AdminException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openShadowTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        if (solPasswordAttr == null) {
            solPasswordAttr = new SolPasswordAttr();
            userObj.setSolPasswordAttr(solPasswordAttr);
        }
        solPasswordAttr.setChangePassword(false);
        solPasswordAttr.setPasswd(null);
        SolAccountAttr solAccountAttr = userObj.getSolAccountAttr();
        if (solAccountAttr == null) {
            solAccountAttr = new SolAccountAttr();
            userObj.setSolAccountAttr(solAccountAttr);
        }
        solAccountAttr.setAccountExpires(null);
        String string = userObj.getUserName();
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), string);
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow == null) {
                    AdminCommonTools.CMN_HandleOutput("Shadow " + string + " does not exist");
                    throw new SolServerException("EXM_SUS4", string);
                }
                solPasswordAttr.setMustChangeDays(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.minCol)));
                solPasswordAttr.setCannotChangeDays(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.maxCol)));
                solPasswordAttr.setAlertChangeDays(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.warnCol)));
                solPasswordAttr.setInactiveDays(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.inactiveCol)));
                String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.passwdCol));
                if (string2.equals(this.accountLockedValue)) {
                    solAccountAttr.setAccountIsLocked(true);
                } else {
                    solAccountAttr.setAccountIsLocked(false);
                }
                String string3 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.exCol));
                if (string3 != null && !string3.equals("")) {
                    solAccountAttr.setAccountExpires(this.getExpirationDate(string3));
                } else {
                    solAccountAttr.setAccountExpires("");
                }
                if (string2.length() != 0) {
                    solPasswordAttr.setHasPassword(true);
                } else {
                    solPasswordAttr.setHasPassword(false);
                }
                solPasswordAttr.setChangePassword(false);
                solPasswordAttr.setPasswd(null);
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2170");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2174");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
            Object var7_15 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_16 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return userObj;
    }

    public void modifyShadowRow(UserObj userObj, AdminServerImpl adminServerImpl, SecurityToken securityToken) throws SolServerException, AdminException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openShadowTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        String string = "";
        try {
            try {
                Object object;
                Object object2;
                String string2;
                SolPasswordAttr solPasswordAttr;
                DirectoryRow directoryRow;
                DirectoryRow directoryRow2;
                TableDefinitions tableDefinitions;
                block27: {
                    tableDefinitions = directoryTable.getCurrentTableDefinitions();
                    directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                    directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.nameCol), userObj.getUserName());
                    directoryRow2 = directoryTable.getFirstRow(directoryRow2);
                    if (directoryRow2 == null) {
                        try {
                            this.addShadowRow(userObj, adminServerImpl, securityToken);
                            Object var7_13 = null;
                            if (directoryTable != null) {
                                directoryTable.close();
                            }
                            string = "";
                            return;
                        }
                        catch (AdminException adminException) {
                            AdminCommonTools.CMN_HandleOutput("User " + userObj.getUserName() + " does not exist");
                            throw adminException;
                        }
                    }
                    directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                    solPasswordAttr = userObj.getSolPasswordAttr();
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), userObj.getUserName());
                    String string3 = "";
                    string2 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(this.passwdCol));
                    try {
                        string3 = adminServerImpl.getUserName(securityToken);
                        if (!solPasswordAttr.hasPasswordChanged()) break block27;
                        string2 = this.nullPassword;
                        try {
                            object2 = adminServerImpl.getAuthenticatedContext(securityToken);
                            object = solPasswordAttr.getPasswd();
                            if (object != null) {
                                string = ((ServerSecurityContext)object2).decryptPassword((byte[])object);
                                string2 = AdminSecurityUtil.createUnixPassword(string);
                            }
                        }
                        catch (AdminException adminException) {
                            AdminCommonTools.CMN_HandleOutput("Shadow Entry " + userObj.getUserName() + " could not decrypt password");
                            throw adminException;
                        }
                    }
                    catch (SolServerException solServerException) {
                        throw solServerException;
                    }
                    catch (AdminException adminException) {
                        throw adminException;
                    }
                }
                object2 = userObj.getSolAccountAttr();
                object = this.setUpExpirationDate(((SolAccountAttr)object2).getAccountExpires());
                if (((SolAccountAttr)object2).isAccountLocked()) {
                    string2 = this.accountLockedValue;
                } else if (string2.equals(this.accountLockedValue)) {
                    string2 = this.nullPassword;
                }
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.passwdCol), string2);
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.minCol), solPasswordAttr.getMustChangeDays());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.maxCol), solPasswordAttr.getCannotChangeDays());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.warnCol), solPasswordAttr.getAlertChangeDays());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.inactiveCol), solPasswordAttr.getInactiveDays());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.exCol), (String)object);
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.flagCol), directoryRow2.getColumn(tableDefinitions.getColumnNumber(this.flagCol)));
                directoryTable.modifyRow(directoryRow2, directoryRow);
                if (string.trim().length() != 0) {
                    this.setupCredTableEntry(userObj, string);
                    string = "";
                }
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2170");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2174");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            string = "";
            throw throwable;
        }
        Object var7_14 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        string = "";
    }

    public void modifyShadowUsername(String string, String string2) throws SolServerException, AdminException {
        if (string2 == null || string2.trim().length() == 0) {
            return;
        }
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openShadowTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), string2);
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow == null) {
                    try {
                        this.modifyCredUserName(string, string2);
                    }
                    catch (Exception exception) {
                    }
                    Object var5_11 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return;
                }
                DirectoryRow directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.nameCol), string2);
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), string);
                directoryTable.modifyRow(directoryRow2, directoryRow);
                this.modifyCredUserName(string, string2);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2170");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2174");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
        }
        catch (Throwable throwable) {
            block16: {
                Object var5_13 = null;
                if (directoryTable == null) break block16;
                directoryTable.close();
            }
            throw throwable;
        }
        Object var5_12 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
    }
}

