/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.directorytable;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.service.directorytable.DirectoryTableInvalidParameterException;
import com.sun.admin.cis.service.directorytable.DirectoryUtility;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import java.util.StringTokenizer;

public class NisTableDefinitions
implements TableDefinitions {
    static int NUMBER_OF_TABLES = 15;
    static int TABLE_NAME;
    static int MAPPED_TABLE_NAME;
    static int COLUMN_SEPARATORS;
    static int COMMENT_SEPARATORS;
    static int USERID;
    static int GROUPID;
    static int ACCESS;
    static int TABLE_ATTRIBUTES;
    static int NUMBER_OF_COLUMNS;
    static int USER_DEFINED;
    static String[][] definitions;
    String path_pwdir;
    String path_aliases;
    String path_dir;
    int tableIndex;
    String tableName;
    String tableType;
    String mappedTableName;
    String columnSeparators;
    String commentSeparators;
    int userId;
    int groupId;
    int access;
    int numberOfColumns;
    int tableAttributes;
    int[] columnAttributes;
    String[] columnNames;
    String[] mappedColumnNames;
    String serverName;
    String domainName;

    public NisTableDefinitions(String string, String string2) {
        this.serverName = string;
        this.domainName = string2;
        this.tableIndex = USER_DEFINED;
        this.tableName = "";
        this.tableType = "";
        this.mappedTableName = "";
        this.columnSeparators = " \t";
        this.commentSeparators = "#";
        this.tableAttributes = 0;
        this.columnNames = null;
        this.mappedColumnNames = null;
        this.columnAttributes = null;
        try {
            this.path_pwdir = DirectoryUtility.getDirectoryTableProperty("admin.directorytable.nis.pwdir");
            if (this.path_pwdir == null || this.path_pwdir.equals("")) {
                this.path_pwdir = "/etc";
            }
        }
        catch (AdminException adminException) {
            this.path_pwdir = "/etc";
        }
        try {
            this.path_dir = DirectoryUtility.getDirectoryTableProperty("admin.directorytable.nis.dir");
            if (this.path_dir == null || this.path_dir.equals("")) {
                this.path_dir = "/etc";
            }
        }
        catch (AdminException adminException) {
            this.path_dir = "/etc";
        }
        try {
            this.path_aliases = DirectoryUtility.getDirectoryTableProperty("admin.directorytable.nis.aliases");
            if (this.path_aliases == null || this.path_aliases.equals("")) {
                this.path_aliases = "/etc/mail/aliases";
            }
        }
        catch (AdminException adminException) {
            this.path_aliases = "/etc/mail/aliases";
        }
        this.userId = 0;
        this.groupId = 3;
        this.access = 273;
    }

    public void loadTableDefinitions(String string) throws DirectoryTableInvalidParameterException {
        this.tableName = string;
        int n = 0;
        while (n < NUMBER_OF_TABLES) {
            if (string.equalsIgnoreCase(definitions[n][TABLE_NAME])) {
                this.tableIndex = n;
                this.tableName = definitions[n][TABLE_NAME];
                this.tableType = String.valueOf(this.tableName) + "_tbl";
                this.mappedTableName = definitions[n][MAPPED_TABLE_NAME];
                this.columnSeparators = definitions[n][COLUMN_SEPARATORS];
                this.commentSeparators = definitions[n][COMMENT_SEPARATORS];
                this.userId = Integer.valueOf(definitions[n][USERID]);
                this.groupId = Integer.valueOf(definitions[n][GROUPID]);
                this.access = Integer.valueOf(definitions[n][ACCESS]);
                this.tableAttributes = Integer.valueOf(definitions[n][TABLE_ATTRIBUTES]);
                this.numberOfColumns = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS]);
                this.columnNames = new String[this.numberOfColumns];
                this.mappedColumnNames = new String[this.numberOfColumns];
                this.columnAttributes = new int[this.numberOfColumns];
                int n2 = 0;
                while (n2 < this.numberOfColumns) {
                    this.columnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 2 + 1];
                    this.mappedColumnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 2 + 1];
                    this.columnAttributes[n2] = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS + n2 * 2 + 2]);
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (n == NUMBER_OF_TABLES) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", string);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.columnNames[n - 1];
    }

    public String getMappedColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.mappedColumnNames[n - 1];
    }

    public int getColumnNumber(String string) throws DirectoryTableInvalidParameterException {
        int n = 0;
        while (n < this.numberOfColumns) {
            if (this.columnNames[n].equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getColumnAttributes(int n) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            return this.columnAttributes[n - 1];
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getTableAttributes() {
        return this.tableAttributes;
    }

    public String getRawMappedTableName() {
        return this.mappedTableName;
    }

    public String getMappedTableName() {
        return this.expandMacros(this.mappedTableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getCommentSeparators() {
        return this.commentSeparators;
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public int getUser() {
        return this.userId;
    }

    public int getGroup() {
        return this.groupId;
    }

    public int getAccess() {
        return this.access;
    }

    public void setNumberOfColumns(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0) {
            throw new DirectoryTableInvalidParameterException();
        }
        this.numberOfColumns = n;
        this.columnNames = new String[this.numberOfColumns];
        this.columnAttributes = new int[this.numberOfColumns];
    }

    public void setColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            this.columnNames[n - 1] = string;
            return;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public void setMappedColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            this.mappedColumnNames[n - 1] = string;
            return;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public void setColumnAttributes(int n, int n2) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            this.columnAttributes[n - 1] = n2;
            return;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public void setTableAttributes(int n) {
        this.tableAttributes = n;
    }

    public void setMappedTableName(String string) {
        this.mappedTableName = string;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setTableType(String string) {
        this.tableType = string;
    }

    public void setCommentSeparators(String string) {
        this.commentSeparators = string;
    }

    public void setColumnSeparators(String string) {
        this.columnSeparators = string;
    }

    public void setUser(int n) {
        this.userId = n;
    }

    public void setGroup(int n) {
        this.groupId = n;
    }

    public void setAccess(int n) {
        this.access = n;
    }

    private String expandMacros(String string) {
        String string2 = "";
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, "%");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            string2 = string3.compareTo("DIR") == 0 ? String.valueOf(string2) + this.path_dir : (string3.compareTo("PWDIR") == 0 ? String.valueOf(string2) + this.path_pwdir : (string3.compareTo("ALIASES") == 0 ? String.valueOf(string2) + this.path_aliases : String.valueOf(string2) + string3));
        }
        return string2;
    }

    static {
        MAPPED_TABLE_NAME = 1;
        COLUMN_SEPARATORS = 2;
        COMMENT_SEPARATORS = 3;
        USERID = 4;
        GROUPID = 5;
        ACCESS = 6;
        TABLE_ATTRIBUTES = 7;
        NUMBER_OF_COLUMNS = 8;
        USER_DEFINED = 99;
        definitions = new String[][]{{"ethers", "%DIR%/ethers", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "3", "addr", Integer.toString(3), "name", Integer.toString(9), "comment", Integer.toString(8)}, {"netmasks", "%DIR%/netmasks", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "3", "addr", Integer.toString(3), "mask", Integer.toString(3), "comment", Integer.toString(8)}, {"group", "%DIR%/group", ":", "#", "0", "3", Integer.toString(287), Integer.toString(10), "4", "name", Integer.toString(9), "passwd", Integer.toString(8), "gid", Integer.toString(5), "members", Integer.toString(8)}, {"hosts", "%DIR%/hosts", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "4", "addr", Integer.toString(3), "cname", Integer.toString(9), "aliases", Integer.toString(9), "comment", Integer.toString(8)}, {"networks", "%DIR%/networks", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "4", "cname", Integer.toString(9), "addr", Integer.toString(3), "aliases", Integer.toString(9), "comment", Integer.toString(8)}, {"passwd", "%PWDIR%/passwd", ":", "#", "0", "3", Integer.toString(287), Integer.toString(10), "7", "name", Integer.toString(9), "passwd", Integer.toString(8), "uid", Integer.toString(5), "gid", Integer.toString(4), "gcos", Integer.toString(8), "home", Integer.toString(8), "shell", Integer.toString(8)}, {"shadow", "%PWDIR%/shadow", ":", "#", "0", "3", Integer.toString(1), Integer.toString(10), "9", "name", Integer.toString(9), "passwd", Integer.toString(8), "lastchg", Integer.toString(8), "min", Integer.toString(8), "max", Integer.toString(8), "warn", Integer.toString(8), "inactive", Integer.toString(8), "expire", Integer.toString(8), "flag", Integer.toString(8)}, {"protocols", "%DIR%/protocols", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "4", "cname", Integer.toString(9), "number", Integer.toString(9), "aliases", Integer.toString(9), "comment", Integer.toString(8)}, {"services", "%DIR%/services", " \t/", "#", "0", "3", Integer.toString(273), Integer.toString(4), "5", "cname", Integer.toString(9), "port", Integer.toString(5), "proto", Integer.toString(9), "aliases", Integer.toString(9), "comment", Integer.toString(8)}, {"rpc", "%DIR%/rpc", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "4", "cname", Integer.toString(9), "number", Integer.toString(5), "aliases", Integer.toString(9), "comment", Integer.toString(8)}, {"aliases", "%ALIASES%", ":", "#", "0", "3", Integer.toString(287), Integer.toString(70), "3", "alias", Integer.toString(9), "expansion", Integer.toString(8), "comment", Integer.toString(8)}, {"auto_master", "%DIR%/auto_master", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(10), "2", "key", Integer.toString(9), "value", Integer.toString(8)}, {"auto_home", "%DIR%/auto_home", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(10), "2", "key", Integer.toString(9), "value", Integer.toString(8)}, {"user_attr", "%DIR%/user_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(26), "5", "name", Integer.toString(9), "qualifier", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "attr", Integer.toString(8)}, {"auth_attr", "%DIR%/auth_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(26), "6", "name", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "short_descr", Integer.toString(8), "long_descr", Integer.toString(8), "attr", Integer.toString(8)}};
    }
}

