/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.authorization;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.server.AdminServerLibrary;
import com.sun.admin.cis.service.authorization.KeyValue;
import com.sun.admin.cis.service.authorization.UserAttrObj;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.DirectoryTableSetup;
import com.sun.admin.cis.service.directorytable.FileDirectoryTable;
import com.sun.admin.cis.service.directorytable.NisplusDirectoryTable;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AuthLibnsl {
    private static final String NS_ORDER_TABLE_NAME = "passwd";
    private static final String USER_ATTR_TABLE_NAME = "user_attr";
    private static final String USER_ATTR_YPMAP_NAME = "user_attr.byname";
    private static final String USER_ATTR_NAME_COLUMN = "name";
    private static final String USER_ATTR_QUAL_COLUMN = "qualifier";
    private static final String USER_ATTR_RES1_COLUMN = "res1";
    private static final String USER_ATTR_RES2_COLUMN = "res2";
    private static final String USER_ATTR_ATTR_COLUMN = "attr";
    private Vector vTypes;
    private String server_name = this.getServerName();
    private String domain_name = this.getDomainName();
    private Hashtable attrSetterHash = this.getSetterHash();
    static /* synthetic */ Class array$Ljava$lang$String;

    public AuthLibnsl() {
        this.vTypes = this.getNameServiceOrder();
        if (this.vTypes == null) {
            this.vTypes = new Vector(0);
        }
    }

    public AuthLibnsl(String string) {
        this.vTypes = string == null ? this.getNameServiceOrder() : this.parseNameServiceOrder(string);
        if (this.vTypes == null) {
            this.vTypes = new Vector(0);
        }
    }

    public UserAttrObj getUserAttrEntry(String string) {
        UserAttrObj userAttrObj = null;
        int n = 0;
        while (n < this.vTypes.size()) {
            String string2 = (String)this.vTypes.elementAt(n);
            userAttrObj = this.getAuth(string, string2);
            if (userAttrObj != null) break;
            ++n;
        }
        return userAttrObj;
    }

    public UserAttrObj getUserAttrEntry(String string, String string2) {
        UserAttrObj userAttrObj = null;
        String string3 = this.checkScopeType(string2);
        if (string3 != null) {
            userAttrObj = this.getAuth(string, string3);
        }
        return userAttrObj;
    }

    private String getServerName() {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    private String getDomainName() {
        String string = "";
        try {
            string = AdminServerLibrary.getDomainName();
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    private Hashtable getSetterHash() {
        Class[] classArray = new Class[]{array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = AuthLibnsl.class$("[Ljava.lang.String;"))};
        UserAttrObj userAttrObj = new UserAttrObj();
        return KeyValue.getAttrHash(userAttrObj, classArray, UserAttrObj.knownKeys, UserAttrObj.setters);
    }

    private String checkScopeType(String string) {
        String string2 = string.equals("file") ? "files" : (string.equals("files") ? "files" : (string.equals("nis") ? "nis" : (string.equals("nisplus") ? "nisplus" : null)));
        return string2;
    }

    private Vector getNameServiceOrder() {
        Vector vector = null;
        try {
            DirectoryTableSetup directoryTableSetup = new DirectoryTableSetup();
            vector = directoryTableSetup.getNameServiceSwitchOrder(NS_ORDER_TABLE_NAME);
        }
        catch (Exception exception) {
            vector = null;
        }
        return vector;
    }

    private Vector parseNameServiceOrder(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2.trim();
            if (string2.equals("files")) {
                vector.addElement("file");
                continue;
            }
            if (string2.equals("nis")) {
                vector.addElement("nis");
                continue;
            }
            if (string2.equals("nisplus")) {
                vector.addElement("nisplus");
                continue;
            }
            if (string2.indexOf("NOTFOUND=return") != -1) break;
        }
        return vector;
    }

    private UserAttrObj getAuth(String string, String string2) {
        UserAttrObj userAttrObj = null;
        if (string2.equals("files") || string2.equals("file")) {
            userAttrObj = this.getAuthFromFiles(string);
        } else if (string2.equals("nis")) {
            userAttrObj = this.getAuthFromNis(string);
        } else if (string2.equals("nisplus")) {
            userAttrObj = this.getAuthFromNisplus(string);
        }
        return userAttrObj;
    }

    private UserAttrObj getAuthFromFiles(String string) {
        UserAttrObj userAttrObj = null;
        try {
            AdminMgmtScope adminMgmtScope = new AdminMgmtScope("file", "file", this.server_name, this.server_name);
            String string2 = adminMgmtScope.toDirectoryTableURL();
            FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)DirectoryTableFactory.getDirectoryTableInstance(string2);
            fileDirectoryTable.open(USER_ATTR_TABLE_NAME);
            userAttrObj = this.getAuthFromTable(fileDirectoryTable, string);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Auth service: exception reading user attr table from files: " + exception.getMessage());
            userAttrObj = null;
        }
        return userAttrObj;
    }

    private UserAttrObj getAuthFromNisplus(String string) {
        String string2 = "";
        if (this.domain_name != null && this.domain_name.trim().length() > 0) {
            string2 = this.domain_name;
        }
        UserAttrObj userAttrObj = null;
        try {
            AdminMgmtScope adminMgmtScope = new AdminMgmtScope("nisplus", "nisplus", this.server_name, string2);
            String string3 = adminMgmtScope.toDirectoryTableURL();
            NisplusDirectoryTable nisplusDirectoryTable = (NisplusDirectoryTable)DirectoryTableFactory.getDirectoryTableInstance(string3);
            nisplusDirectoryTable.open(USER_ATTR_TABLE_NAME);
            userAttrObj = this.getAuthFromTable(nisplusDirectoryTable, string);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Auth service: exception reading user attr table from nisplus: " + exception.getMessage());
            userAttrObj = null;
        }
        return userAttrObj;
    }

    private UserAttrObj getAuthFromNis(String string) {
        String string2 = "";
        if (this.domain_name != null && this.domain_name.trim().length() > 0 && (string2 = this.domain_name).endsWith(".")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String string3 = string;
        UserAttrObj userAttrObj = null;
        try {
            String string4 = AdminServerLibrary.ypLookup(string2, USER_ATTR_YPMAP_NAME, string3);
            if (string4 != null) {
                userAttrObj = this.getAuthFromEntry(string4, string);
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Auth service: exception reading user attr table from nis: " + exception.getMessage());
            userAttrObj = null;
        }
        return userAttrObj;
    }

    private UserAttrObj getAuthFromTable(DirectoryTable directoryTable, String string) {
        UserAttrObj userAttrObj = null;
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(USER_ATTR_NAME_COLUMN), string);
            directoryRow = directoryTable.getFirstRow(directoryRow);
            if (directoryRow != null) {
                userAttrObj = new UserAttrObj(string);
                userAttrObj.setQualifier(directoryRow.getColumn(tableDefinitions.getColumnNumber(USER_ATTR_QUAL_COLUMN)));
                String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(USER_ATTR_ATTR_COLUMN));
                KeyValue.getAttributes(userAttrObj, string2, this.attrSetterHash);
            }
        }
        catch (Exception exception) {
            userAttrObj = null;
        }
        return userAttrObj;
    }

    private UserAttrObj getAuthFromEntry(String string, String string2) {
        UserAttrObj userAttrObj;
        block14: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            try {
                String string8;
                string3 = stringTokenizer.nextToken();
                if (string3.equals(":")) {
                    string3 = "";
                } else {
                    string8 = stringTokenizer.nextToken();
                }
                string4 = stringTokenizer.nextToken();
                if (string4.equals(":")) {
                    string4 = "";
                } else {
                    string8 = stringTokenizer.nextToken();
                }
                string5 = stringTokenizer.nextToken();
                if (string5.equals(":")) {
                    string5 = "";
                } else {
                    string8 = stringTokenizer.nextToken();
                }
                string6 = stringTokenizer.nextToken();
                if (string6.equals(":")) {
                    string6 = "";
                } else {
                    string8 = stringTokenizer.nextToken();
                }
                string7 = stringTokenizer.nextToken();
                if (string7.equals(":")) {
                    string7 = null;
                }
            }
            catch (Exception exception) {}
            if (string3 == null) {
                string3 = string2;
            }
            userAttrObj = new UserAttrObj(string3);
            if (string7 == null) break block14;
            try {
                KeyValue.getAttributes(userAttrObj, string7, this.attrSetterHash);
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_Trace1("Auth service: exception parsing user attr table entry: " + exception.getMessage());
            }
        }
        return userAttrObj;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

