/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.pntadm;

import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.common.DhcpCliOptions;
import com.sun.dhcpmgr.cli.common.DhcpCliPrint;
import com.sun.dhcpmgr.cli.common.DhcpCliProgram;
import com.sun.dhcpmgr.cli.common.GetOpt;
import com.sun.dhcpmgr.cli.pntadm.AddClientEntry;
import com.sun.dhcpmgr.cli.pntadm.CreateNetworkTable;
import com.sun.dhcpmgr.cli.pntadm.DeleteClientEntry;
import com.sun.dhcpmgr.cli.pntadm.DisplayNetworkTable;
import com.sun.dhcpmgr.cli.pntadm.ListNetworkTables;
import com.sun.dhcpmgr.cli.pntadm.ModifyClientEntry;
import com.sun.dhcpmgr.cli.pntadm.PntAdmBatch;
import com.sun.dhcpmgr.cli.pntadm.PntAdmFunction;
import com.sun.dhcpmgr.cli.pntadm.RemoveNetworkTable;
import com.sun.dhcpmgr.cli.pntadm.ResourceStrings;

public class PntAdm
extends DhcpCliProgram {
    public static final String SIGNATURE = "pntadm: ";
    private static String optString = "LPCRyavxA:D:M:r:p:u:s:i:f:e:h:m:c:n:B;";
    private static final int ADD_CLIENT_ENTRY = 65;
    private static final int MODIFY_CLIENT_ENTRY = 77;
    private static final int DELETE_CLIENT_ENTRY = 68;
    private static final int CREATE_NETWORK_TABLE = 67;
    private static final int REMOVE_NETWORK_TABLE = 82;
    private static final int DISPLAY_NETWORK_TABLE = 80;
    private static final int LIST_NETWORK_TABLES = 76;
    private static final int BATCH_EXECUTION = 66;
    public static final int VERIFY_MACRO = 121;
    public static final int DELETE_HOST = 121;
    public static final int CONVERT_CLIENTID = 97;
    public static final int RAW = 120;
    public static final int VERBOSE = 118;
    public static final int RESOURCE = 114;
    public static final int RESOURCE_CONFIG = 117;
    public static final int PATH = 112;
    public static final int SERVER = 115;
    public static final int CLIENTID = 105;
    public static final int FLAGS = 102;
    public static final int LEASE_EXPIRATION = 101;
    public static final int HOST_NAME = 104;
    public static final int MACRO_NAME = 109;
    public static final int COMMENT = 99;
    public static final int NEW_IP = 110;
    private PntAdmFunction function = null;
    private DhcpCliOptions options = null;
    private String[] args = null;

    public PntAdm(String[] stringArray) {
        this.reset(stringArray);
    }

    public int execute() {
        int n = 0;
        GetOpt getOpt = new GetOpt(this.args, optString);
        try {
            int n2;
            while ((n2 = getOpt.getNextOption()) != -1) {
                this.processArg(n2, getOpt.getOptionArg());
            }
            int n3 = getOpt.getNextOptionIndex();
            String string = null;
            if (this.args.length == n3 + 1) {
                string = this.args[n3];
            } else if (this.args.length >= n3 + 1) {
                throw new IllegalArgumentException(ResourceStrings.getString("invalid_args"));
            }
            if (this.function == null) {
                String string2 = this.getString("no_function_error");
                throw new IllegalArgumentException(string2);
            }
            if (!this.function.isVersionValid(false)) {
                return 4;
            }
            if (this.function instanceof ListNetworkTables || this.function instanceof PntAdmBatch) {
                if (string != null) {
                    String string3 = this.getString("network_specified");
                    throw new IllegalArgumentException(string3);
                }
            } else if (string == null) {
                String string4 = this.getString("no_network_specified");
                throw new IllegalArgumentException(string4);
            }
            this.function.setDhcpDatastore(this.options.valueOf(114), this.options.valueOf(112), this.options.valueOf(117));
            this.function.setOptions(this.options);
            this.function.setNetworkName(string);
            n = this.function.execute();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuffer stringBuffer = new StringBuffer(SIGNATURE);
            stringBuffer.append(DhcpCliFunction.getMessage(illegalArgumentException));
            DhcpCliPrint.printErrMessage(stringBuffer.toString());
            DhcpCliPrint.printErrMessage("");
            this.usage();
            n = 4;
        }
        catch (Throwable throwable) {
            StringBuffer stringBuffer = new StringBuffer(SIGNATURE);
            stringBuffer.append(DhcpCliFunction.getMessage(throwable));
            DhcpCliPrint.printErrMessage(stringBuffer.toString());
            n = 4;
        }
        return n;
    }

    public String getManPage() {
        return "pntadm(1M)";
    }

    public String getString(String string) {
        return ResourceStrings.getString(string);
    }

    public static void main(String[] stringArray) {
        PntAdm pntAdm = new PntAdm(stringArray);
        int n = 4;
        if (pntAdm.isValidUser()) {
            n = pntAdm.execute();
        }
        System.exit(n);
    }

    public void processArg(int n, String string) throws IllegalArgumentException {
        switch (n) {
            case 65: {
                this.function = new AddClientEntry(string);
                break;
            }
            case 77: {
                this.function = new ModifyClientEntry(string);
                break;
            }
            case 68: {
                this.function = new DeleteClientEntry(string);
                break;
            }
            case 67: {
                this.function = new CreateNetworkTable();
                break;
            }
            case 82: {
                this.function = new RemoveNetworkTable();
                break;
            }
            case 80: {
                this.function = new DisplayNetworkTable();
                break;
            }
            case 76: {
                this.function = new ListNetworkTables();
                break;
            }
            case 66: {
                this.function = new PntAdmBatch(string);
                break;
            }
            default: {
                this.options.setOption(n, string);
            }
        }
    }

    public void reset(String[] stringArray) {
        this.function = null;
        this.options = new DhcpCliOptions();
        this.args = stringArray;
    }

    public void usage() {
        DhcpCliPrint.printErrMessage(this.getString("usage"));
    }
}

