/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.OptionValue;
import com.sun.dhcpmgr.data.OptionsTable;
import com.sun.dhcpmgr.data.ValidationException;
import java.util.Enumeration;
import java.util.Vector;

public class OctetOptionValue
extends OptionValue {
    private String name;
    private String value;
    private boolean valid;

    protected OctetOptionValue(String string) {
        this.name = string;
        this.value = "";
        this.valid = false;
    }

    public Object clone() {
        OctetOptionValue octetOptionValue = new OctetOptionValue(this.name);
        octetOptionValue.value = this.value;
        octetOptionValue.valid = this.valid;
        return octetOptionValue;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValue(Object object) throws ValidationException {
        Object[] objectArray;
        Option option = OptionsTable.getTable().get(this.name);
        if (option == null) {
            objectArray = new Object[]{this.name};
            this.throwException("invalid_option", objectArray);
        }
        if (object instanceof String) {
            if (((String)object).length() == 0) {
                objectArray = new Object[]{this.name, Option.getTypeDhcptabString(option.getType())};
                this.throwException("invalid_option_value", objectArray);
            }
            this.value = (String)object;
            this.valid = true;
        } else if (object instanceof Vector) {
            objectArray = new StringBuffer();
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                objectArray.append(enumeration.nextElement().toString());
            }
            this.setValue(objectArray.toString());
        } else {
            this.setValue(object.toString());
        }
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + this.getValue();
    }
}

