/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.OptionValue;
import com.sun.dhcpmgr.data.OptionsTable;
import com.sun.dhcpmgr.data.ValidationException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class IPOptionValue
extends OptionValue {
    private String name;
    private Vector addrs;
    private boolean valid;

    protected IPOptionValue(String string) {
        this.name = string;
        this.addrs = null;
        this.valid = false;
    }

    public Object clone() {
        IPOptionValue iPOptionValue = new IPOptionValue(this.name);
        if (this.addrs != null) {
            iPOptionValue.addrs = (Vector)this.addrs.clone();
        }
        iPOptionValue.valid = this.valid;
        return iPOptionValue;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.addrs == null || this.addrs.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.addrs.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (stringBuffer.length() != 0) {
                stringBuffer.append(' ');
            }
            if (e instanceof IPAddress) {
                stringBuffer.append(((IPAddress)e).getHostAddress());
                continue;
            }
            stringBuffer.append(((InetAddress)e).getHostAddress());
        }
        return stringBuffer.toString();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValue(Object object) throws ValidationException {
        Object[] objectArray;
        Object object2;
        Option option = OptionsTable.getTable().get(this.name);
        if (option == null) {
            object2 = new Object[]{this.name};
            this.throwException("invalid_option", (Object[])object2);
        }
        object2 = new Vector();
        if (object instanceof String) {
            if (((String)object).length() == 0) {
                objectArray = new Object[]{this.name, Option.getTypeDhcptabString(option.getType())};
                this.throwException("invalid_option_value", objectArray);
            }
            objectArray = new StringTokenizer((String)object, " ");
            while (objectArray.hasMoreTokens()) {
                ((Vector)object2).addElement(new IPAddress(objectArray.nextToken()));
            }
        } else if (object instanceof InetAddress) {
            ((Vector)object2).addElement(object);
        } else if (object instanceof IPAddress) {
            ((Vector)object2).addElement(object);
        } else if (!(object instanceof Vector)) {
            objectArray = new Object[]{this.name, Option.getTypeDhcptabString(option.getType())};
            this.throwException("invalid_option_value", objectArray);
        } else {
            object2 = (Vector)object;
            objectArray = ((Vector)object2).elements();
            while (objectArray.hasMoreElements()) {
                Object e = objectArray.nextElement();
                if (e instanceof InetAddress || e instanceof IPAddress) continue;
                Object[] objectArray2 = new Object[]{this.name, Option.getTypeDhcptabString(option.getType())};
                this.throwException("invalid_option_value", objectArray2);
            }
        }
        if (((Vector)object2).size() % option.getGranularity() != 0) {
            objectArray = new Object[]{this.name, Integer.toString(option.getGranularity())};
            this.throwException("invalid_option_granularity", objectArray);
        }
        if (option.getMaximum() != 0 && ((Vector)object2).size() / option.getGranularity() > option.getMaximum()) {
            objectArray = new Object[]{this.name, Integer.toString(option.getMaximum())};
            this.throwException("invalid_option_maximum", objectArray);
        }
        this.addrs = object2;
        this.valid = true;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + this.getValue();
    }
}

